/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel;

import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.channel.DefaultChannelPromise;
import com.appoptics.ext.io.netty.util.concurrent.AbstractFuture;
import com.appoptics.ext.io.netty.util.concurrent.Future;
import com.appoptics.ext.io.netty.util.concurrent.GenericFutureListener;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VoidChannelPromise
extends AbstractFuture<Void>
implements ChannelPromise {
    private final Channel channel;
    private final ChannelFutureListener fireExceptionListener;

    public VoidChannelPromise(Channel channel, boolean bl) {
        ObjectUtil.checkNotNull(channel, "channel");
        this.channel = channel;
        if (bl) {
            this.fireExceptionListener = new ChannelFutureListener(){

                public void operationComplete(ChannelFuture object) throws Exception {
                    if ((object = object.cause()) != null) {
                        VoidChannelPromise.this.fireException0((Throwable)object);
                    }
                }
            };
            return;
        }
        this.fireExceptionListener = null;
    }

    @Override
    public final VoidChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public final VoidChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        return this;
    }

    @Override
    public final VoidChannelPromise await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this;
    }

    @Override
    public final boolean await(long l2, TimeUnit timeUnit) {
        VoidChannelPromise.fail();
        return false;
    }

    @Override
    public final Channel channel() {
        return this.channel;
    }

    @Override
    public final boolean isDone() {
        return false;
    }

    @Override
    public final boolean isSuccess() {
        return false;
    }

    @Override
    public final boolean setUncancellable() {
        return true;
    }

    @Override
    public final boolean isCancelled() {
        return false;
    }

    @Override
    public final Throwable cause() {
        return null;
    }

    @Override
    public final VoidChannelPromise setFailure(Throwable throwable) {
        this.fireException0(throwable);
        return this;
    }

    @Override
    public final VoidChannelPromise setSuccess() {
        return this;
    }

    @Override
    public final boolean tryFailure(Throwable throwable) {
        this.fireException0(throwable);
        return false;
    }

    @Override
    public final boolean cancel(boolean bl) {
        return false;
    }

    @Override
    public final boolean trySuccess() {
        return false;
    }

    private static void fail() {
        throw new IllegalStateException("void future");
    }

    @Override
    public final VoidChannelPromise setSuccess(Void void_) {
        return this;
    }

    @Override
    public final boolean trySuccess(Void void_) {
        return false;
    }

    @Override
    public final Void getNow() {
        return null;
    }

    @Override
    public final ChannelPromise unvoid() {
        DefaultChannelPromise defaultChannelPromise = new DefaultChannelPromise(this.channel);
        if (this.fireExceptionListener != null) {
            defaultChannelPromise.addListener((GenericFutureListener<? extends Future<? super Void>>)this.fireExceptionListener);
        }
        return defaultChannelPromise;
    }

    @Override
    public final boolean isVoid() {
        return true;
    }

    private void fireException0(Throwable throwable) {
        if (this.fireExceptionListener != null && this.channel.isRegistered()) {
            this.channel.pipeline().fireExceptionCaught(throwable);
        }
    }
}

