/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel;

import com.appoptics.ext.io.netty.channel.ChannelHandler;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelInboundHandler;
import com.appoptics.ext.io.netty.channel.ChannelOutboundHandler;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.util.concurrent.FastThreadLocal;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ChannelHandlerMask {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelHandlerMask.class);
    private static final FastThreadLocal<Map<Class<? extends ChannelHandler>, Integer>> MASKS = new FastThreadLocal<Map<Class<? extends ChannelHandler>, Integer>>(){

        @Override
        protected final Map<Class<? extends ChannelHandler>, Integer> initialValue() {
            return new WeakHashMap<Class<? extends ChannelHandler>, Integer>(32);
        }
    };

    static int mask(Class<? extends ChannelHandler> clazz) {
        Map<Class<? extends ChannelHandler>, Integer> map = MASKS.get();
        Integer n2 = map.get(clazz);
        if (n2 == null) {
            n2 = ChannelHandlerMask.mask0(clazz);
            map.put(clazz, n2);
        }
        return n2;
    }

    private static int mask0(Class<? extends ChannelHandler> serializable) {
        int n2 = 1;
        try {
            if (ChannelInboundHandler.class.isAssignableFrom((Class<?>)serializable)) {
                n2 = 511;
                if (ChannelHandlerMask.isSkippable(serializable, "channelRegistered", new Class[]{ChannelHandlerContext.class})) {
                    n2 = 509;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "channelUnregistered", new Class[]{ChannelHandlerContext.class})) {
                    n2 &= 0xFFFFFFFB;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "channelActive", new Class[]{ChannelHandlerContext.class})) {
                    n2 &= 0xFFFFFFF7;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "channelInactive", new Class[]{ChannelHandlerContext.class})) {
                    n2 &= 0xFFFFFFEF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "channelRead", new Class[]{ChannelHandlerContext.class, Object.class})) {
                    n2 &= 0xFFFFFFDF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "channelReadComplete", new Class[]{ChannelHandlerContext.class})) {
                    n2 &= 0xFFFFFFBF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "channelWritabilityChanged", new Class[]{ChannelHandlerContext.class})) {
                    n2 &= 0xFFFFFEFF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "userEventTriggered", new Class[]{ChannelHandlerContext.class, Object.class})) {
                    n2 &= 0xFFFFFF7F;
                }
            }
            if (ChannelOutboundHandler.class.isAssignableFrom((Class<?>)serializable)) {
                n2 |= 0x1FE01;
                if (ChannelHandlerMask.isSkippable(serializable, "bind", new Class[]{ChannelHandlerContext.class, SocketAddress.class, ChannelPromise.class})) {
                    n2 &= 0xFFFFFDFF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "connect", new Class[]{ChannelHandlerContext.class, SocketAddress.class, SocketAddress.class, ChannelPromise.class})) {
                    n2 &= 0xFFFFFBFF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "disconnect", new Class[]{ChannelHandlerContext.class, ChannelPromise.class})) {
                    n2 &= 0xFFFFF7FF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "close", new Class[]{ChannelHandlerContext.class, ChannelPromise.class})) {
                    n2 &= 0xFFFFEFFF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "deregister", new Class[]{ChannelHandlerContext.class, ChannelPromise.class})) {
                    n2 &= 0xFFFFDFFF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "read", new Class[]{ChannelHandlerContext.class})) {
                    n2 &= 0xFFFFBFFF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "write", new Class[]{ChannelHandlerContext.class, Object.class, ChannelPromise.class})) {
                    n2 &= 0xFFFF7FFF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "flush", new Class[]{ChannelHandlerContext.class})) {
                    n2 &= 0xFFFEFFFF;
                }
            }
            if (ChannelHandlerMask.isSkippable(serializable, "exceptionCaught", new Class[]{ChannelHandlerContext.class, Throwable.class})) {
                n2 &= 0xFFFFFFFE;
            }
        }
        catch (Exception exception) {
            serializable = exception;
            PlatformDependent.throwException(exception);
        }
        return n2;
    }

    private static boolean isSkippable(final Class<?> clazz, final String string, final Class<?> ... classArray) throws Exception {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public final Boolean run() throws Exception {
                Method method;
                try {
                    method = clazz.getMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Class {} missing method {}, assume we can not skip execution", clazz, string, noSuchMethodException);
                    }
                    return Boolean.FALSE;
                }
                return method != null && method.isAnnotationPresent(Skip.class);
            }
        });
    }

    private ChannelHandlerMask() {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Skip {
    }
}

