/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel;

import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.channel.AbstractChannel;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelHandler;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelHandlerMask;
import com.appoptics.ext.io.netty.channel.ChannelInboundHandler;
import com.appoptics.ext.io.netty.channel.ChannelOutboundHandler;
import com.appoptics.ext.io.netty.channel.ChannelPipeline;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.channel.DefaultChannelPipeline;
import com.appoptics.ext.io.netty.channel.DefaultChannelPromise;
import com.appoptics.ext.io.netty.channel.FailedChannelFuture;
import com.appoptics.ext.io.netty.channel.SucceededChannelFuture;
import com.appoptics.ext.io.netty.channel.VoidChannelPromise;
import com.appoptics.ext.io.netty.util.Attribute;
import com.appoptics.ext.io.netty.util.AttributeKey;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import com.appoptics.ext.io.netty.util.ResourceLeakHint;
import com.appoptics.ext.io.netty.util.concurrent.AbstractEventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.OrderedEventExecutor;
import com.appoptics.ext.io.netty.util.internal.ObjectPool;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PromiseNotificationUtil;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.ThrowableUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractChannelHandlerContext
implements ChannelHandlerContext,
ResourceLeakHint {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractChannelHandlerContext.class);
    volatile AbstractChannelHandlerContext next;
    volatile AbstractChannelHandlerContext prev;
    private static final AtomicIntegerFieldUpdater<AbstractChannelHandlerContext> HANDLER_STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractChannelHandlerContext.class, "handlerState");
    private final DefaultChannelPipeline pipeline;
    private final String name;
    private final boolean ordered;
    private final int executionMask;
    final EventExecutor executor;
    private ChannelFuture succeededFuture;
    private Tasks invokeTasks;
    private volatile int handlerState = 0;

    AbstractChannelHandlerContext(DefaultChannelPipeline defaultChannelPipeline, EventExecutor eventExecutor, String string, Class<? extends ChannelHandler> clazz) {
        this.name = ObjectUtil.checkNotNull(string, "name");
        this.pipeline = defaultChannelPipeline;
        this.executor = eventExecutor;
        this.executionMask = ChannelHandlerMask.mask(clazz);
        this.ordered = eventExecutor == null || eventExecutor instanceof OrderedEventExecutor;
    }

    @Override
    public Channel channel() {
        return this.pipeline.channel();
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.channel().config().getAllocator();
    }

    @Override
    public EventExecutor executor() {
        if (this.executor == null) {
            return this.channel().eventLoop();
        }
        return this.executor;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        AbstractChannelHandlerContext.invokeChannelRegistered(this.findContextInbound(2));
        return this;
    }

    static void invokeChannelRegistered(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelRegistered();
            return;
        }
        eventExecutor.execute(new Runnable(){

            public final void run() {
                abstractChannelHandlerContext.invokeChannelRegistered();
            }
        });
    }

    private void invokeChannelRegistered() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelRegistered(this);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        }
        this.fireChannelRegistered();
    }

    @Override
    public ChannelHandlerContext fireChannelUnregistered() {
        AbstractChannelHandlerContext.invokeChannelUnregistered(this.findContextInbound(4));
        return this;
    }

    static void invokeChannelUnregistered(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelUnregistered();
            return;
        }
        eventExecutor.execute(new Runnable(){

            public final void run() {
                abstractChannelHandlerContext.invokeChannelUnregistered();
            }
        });
    }

    private void invokeChannelUnregistered() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelUnregistered(this);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        }
        this.fireChannelUnregistered();
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        AbstractChannelHandlerContext.invokeChannelActive(this.findContextInbound(8));
        return this;
    }

    static void invokeChannelActive(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelActive();
            return;
        }
        eventExecutor.execute(new Runnable(){

            public final void run() {
                abstractChannelHandlerContext.invokeChannelActive();
            }
        });
    }

    private void invokeChannelActive() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelActive(this);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        }
        this.fireChannelActive();
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        AbstractChannelHandlerContext.invokeChannelInactive(this.findContextInbound(16));
        return this;
    }

    static void invokeChannelInactive(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelInactive();
            return;
        }
        eventExecutor.execute(new Runnable(){

            public final void run() {
                abstractChannelHandlerContext.invokeChannelInactive();
            }
        });
    }

    private void invokeChannelInactive() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelInactive(this);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        }
        this.fireChannelInactive();
    }

    @Override
    public ChannelHandlerContext fireExceptionCaught(Throwable throwable) {
        AbstractChannelHandlerContext.invokeExceptionCaught(this.findContextInbound(1), throwable);
        return this;
    }

    static void invokeExceptionCaught(final AbstractChannelHandlerContext abstractChannelHandlerContext, final Throwable throwable) {
        ObjectUtil.checkNotNull(throwable, "cause");
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeExceptionCaught(throwable);
            return;
        }
        try {
            eventExecutor.execute(new Runnable(){

                public final void run() {
                    abstractChannelHandlerContext.invokeExceptionCaught(throwable);
                }
            });
            return;
        }
        catch (Throwable throwable2) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to submit an exceptionCaught() event.", throwable2);
                logger.warn("The exceptionCaught() event that was failed to submit was:", throwable);
            }
            return;
        }
    }

    private void invokeExceptionCaught(Throwable throwable) {
        block5: {
            if (this.invokeHandler()) {
                try {
                    this.handler().exceptionCaught(this, throwable);
                    return;
                }
                catch (Throwable throwable2) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception {}was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)ThrowableUtil.stackTraceToString(throwable2), (Object)throwable);
                        break block5;
                    }
                    if (logger.isWarnEnabled()) {
                        logger.warn("An exception '{}' [enable DEBUG level for full stacktrace] was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)throwable2, (Object)throwable);
                    }
                    return;
                }
            }
            this.fireExceptionCaught(throwable);
        }
    }

    @Override
    public ChannelHandlerContext fireUserEventTriggered(Object object) {
        AbstractChannelHandlerContext.invokeUserEventTriggered(this.findContextInbound(128), object);
        return this;
    }

    static void invokeUserEventTriggered(final AbstractChannelHandlerContext abstractChannelHandlerContext, final Object object) {
        ObjectUtil.checkNotNull(object, "event");
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeUserEventTriggered(object);
            return;
        }
        eventExecutor.execute(new Runnable(){

            public final void run() {
                abstractChannelHandlerContext.invokeUserEventTriggered(object);
            }
        });
    }

    private void invokeUserEventTriggered(Object object) {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).userEventTriggered(this, object);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        }
        this.fireUserEventTriggered(object);
    }

    @Override
    public ChannelHandlerContext fireChannelRead(Object object) {
        AbstractChannelHandlerContext.invokeChannelRead(this.findContextInbound(32), object);
        return this;
    }

    static void invokeChannelRead(final AbstractChannelHandlerContext abstractChannelHandlerContext, final Object object) {
        object = abstractChannelHandlerContext.pipeline.touch(ObjectUtil.checkNotNull(object, "msg"), abstractChannelHandlerContext);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelRead(object);
            return;
        }
        eventExecutor.execute(new Runnable(){

            public final void run() {
                abstractChannelHandlerContext.invokeChannelRead(object);
            }
        });
    }

    private void invokeChannelRead(Object object) {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelRead(this, object);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        }
        this.fireChannelRead(object);
    }

    @Override
    public ChannelHandlerContext fireChannelReadComplete() {
        AbstractChannelHandlerContext.invokeChannelReadComplete(this.findContextInbound(64));
        return this;
    }

    static void invokeChannelReadComplete(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelReadComplete();
            return;
        }
        Tasks tasks = abstractChannelHandlerContext.invokeTasks;
        if (tasks == null) {
            abstractChannelHandlerContext.invokeTasks = tasks = new Tasks(abstractChannelHandlerContext);
        }
        eventExecutor.execute(tasks.invokeChannelReadCompleteTask);
    }

    private void invokeChannelReadComplete() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelReadComplete(this);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        }
        this.fireChannelReadComplete();
    }

    @Override
    public ChannelHandlerContext fireChannelWritabilityChanged() {
        AbstractChannelHandlerContext.invokeChannelWritabilityChanged(this.findContextInbound(256));
        return this;
    }

    static void invokeChannelWritabilityChanged(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelWritabilityChanged();
            return;
        }
        Tasks tasks = abstractChannelHandlerContext.invokeTasks;
        if (tasks == null) {
            abstractChannelHandlerContext.invokeTasks = tasks = new Tasks(abstractChannelHandlerContext);
        }
        eventExecutor.execute(tasks.invokeChannelWritableStateChangedTask);
    }

    private void invokeChannelWritabilityChanged() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelWritabilityChanged(this);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        }
        this.fireChannelWritabilityChanged();
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress) {
        return this.connect(socketAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return this.connect(socketAddress, socketAddress2, this.newPromise());
    }

    @Override
    public ChannelFuture close() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        return abstractChannelHandlerContext.close(abstractChannelHandlerContext.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.connect(socketAddress, null, channelPromise);
    }

    @Override
    public ChannelFuture connect(final SocketAddress socketAddress, final SocketAddress socketAddress2, final ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(socketAddress, "remoteAddress");
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(1024);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeConnect(socketAddress, socketAddress2, channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                public void run() {
                    abstractChannelHandlerContext.invokeConnect(socketAddress, socketAddress2, channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeConnect(SocketAddress serializable, SocketAddress socketAddress, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ((ChannelOutboundHandler)this.handler()).connect(this, (SocketAddress)serializable, socketAddress, channelPromise);
                return;
            }
            catch (Throwable throwable) {
                serializable = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                return;
            }
        }
        this.connect((SocketAddress)serializable, socketAddress, channelPromise);
    }

    @Override
    public ChannelFuture disconnect(final ChannelPromise channelPromise) {
        if (!this.channel().metadata().hasDisconnect()) {
            return this.close(channelPromise);
        }
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(2048);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeDisconnect(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                public void run() {
                    abstractChannelHandlerContext.invokeDisconnect(channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeDisconnect(ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ((ChannelOutboundHandler)this.handler()).disconnect(this, channelPromise);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                return;
            }
        }
        this.disconnect(channelPromise);
    }

    @Override
    public ChannelFuture close(final ChannelPromise channelPromise) {
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(4096);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeClose(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                public void run() {
                    abstractChannelHandlerContext.invokeClose(channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeClose(ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ((ChannelOutboundHandler)this.handler()).close(this, channelPromise);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                return;
            }
        }
        this.close(channelPromise);
    }

    @Override
    public ChannelHandlerContext read() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(16384);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeRead();
        } else {
            Tasks tasks = abstractChannelHandlerContext.invokeTasks;
            if (tasks == null) {
                abstractChannelHandlerContext.invokeTasks = tasks = new Tasks(abstractChannelHandlerContext);
            }
            eventExecutor.execute(tasks.invokeReadTask);
        }
        return this;
    }

    private void invokeRead() {
        if (this.invokeHandler()) {
            try {
                ((ChannelOutboundHandler)this.handler()).read(this);
                return;
            }
            catch (Throwable throwable) {
                this.invokeExceptionCaught(throwable);
                return;
            }
        }
        this.read();
    }

    @Override
    public ChannelFuture write(Object object) {
        return this.write(object, this.newPromise());
    }

    @Override
    public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        this.write(object, false, channelPromise);
        return channelPromise;
    }

    void invokeWrite(Object object, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            this.invokeWrite0(object, channelPromise);
            return;
        }
        this.write(object, channelPromise);
    }

    private void invokeWrite0(Object object, ChannelPromise channelPromise) {
        try {
            ((ChannelOutboundHandler)this.handler()).write(this, object, channelPromise);
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
            return;
        }
    }

    @Override
    public ChannelHandlerContext flush() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(65536);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeFlush();
        } else {
            Tasks tasks = abstractChannelHandlerContext.invokeTasks;
            if (tasks == null) {
                abstractChannelHandlerContext.invokeTasks = tasks = new Tasks(abstractChannelHandlerContext);
            }
            AbstractChannelHandlerContext.safeExecute(eventExecutor, tasks.invokeFlushTask, this.channel().voidPromise(), null, false);
        }
        return this;
    }

    private void invokeFlush() {
        if (this.invokeHandler()) {
            this.invokeFlush0();
            return;
        }
        this.flush();
    }

    private void invokeFlush0() {
        try {
            ((ChannelOutboundHandler)this.handler()).flush(this);
            return;
        }
        catch (Throwable throwable) {
            this.invokeExceptionCaught(throwable);
            return;
        }
    }

    public ChannelFuture writeAndFlush(Object object, ChannelPromise channelPromise) {
        this.write(object, true, channelPromise);
        return channelPromise;
    }

    void invokeWriteAndFlush(Object object, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            this.invokeWrite0(object, channelPromise);
            this.invokeFlush0();
            return;
        }
        this.writeAndFlush(object, channelPromise);
    }

    private void write(Object object, boolean bl, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(object, "msg");
        try {
            if (this.isNotValidPromise(channelPromise, true)) {
                ReferenceCountUtil.release(object);
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            ReferenceCountUtil.release(object);
            throw runtimeException;
        }
        Object object2 = this.findContextOutbound(bl ? 98304 : 32768);
        object = this.pipeline.touch(object, (AbstractChannelHandlerContext)object2);
        EventExecutor eventExecutor = ((AbstractChannelHandlerContext)object2).executor();
        if (eventExecutor.inEventLoop()) {
            if (bl) {
                ((AbstractChannelHandlerContext)object2).invokeWriteAndFlush(object, channelPromise);
                return;
            }
            ((AbstractChannelHandlerContext)object2).invokeWrite(object, channelPromise);
            return;
        }
        if (!AbstractChannelHandlerContext.safeExecute(eventExecutor, (Runnable)(object2 = WriteTask.newInstance((AbstractChannelHandlerContext)object2, object, channelPromise, bl)), channelPromise, object, !bl)) {
            ((WriteTask)object2).cancel();
        }
    }

    @Override
    public ChannelFuture writeAndFlush(Object object) {
        return this.writeAndFlush(object, this.newPromise());
    }

    private static void notifyOutboundHandlerException(Throwable throwable, ChannelPromise channelPromise) {
        PromiseNotificationUtil.tryFailure(channelPromise, throwable, channelPromise instanceof VoidChannelPromise ? null : logger);
    }

    @Override
    public ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel(), this.executor());
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        ChannelFuture channelFuture = this.succeededFuture;
        if (channelFuture == null) {
            this.succeededFuture = channelFuture = new SucceededChannelFuture(this.channel(), this.executor());
        }
        return channelFuture;
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable throwable) {
        return new FailedChannelFuture(this.channel(), this.executor(), throwable);
    }

    private boolean isNotValidPromise(ChannelPromise channelPromise, boolean bl) {
        ObjectUtil.checkNotNull(channelPromise, "promise");
        if (channelPromise.isDone()) {
            if (channelPromise.isCancelled()) {
                return true;
            }
            throw new IllegalArgumentException("promise already done: " + channelPromise);
        }
        if (channelPromise.channel() != this.channel()) {
            throw new IllegalArgumentException(String.format("promise.channel does not match: %s (expected: %s)", channelPromise.channel(), this.channel()));
        }
        if (channelPromise.getClass() == DefaultChannelPromise.class) {
            return false;
        }
        if (!bl && channelPromise instanceof VoidChannelPromise) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(VoidChannelPromise.class) + " not allowed for this operation");
        }
        if (channelPromise instanceof AbstractChannel.CloseFuture) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(AbstractChannel.CloseFuture.class) + " not allowed in a pipeline");
        }
        return false;
    }

    private AbstractChannelHandlerContext findContextInbound(int n2) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        EventExecutor eventExecutor = this.executor();
        while (AbstractChannelHandlerContext.skipContext(abstractChannelHandlerContext = abstractChannelHandlerContext.next, eventExecutor, n2, 510)) {
        }
        return abstractChannelHandlerContext;
    }

    private AbstractChannelHandlerContext findContextOutbound(int n2) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        EventExecutor eventExecutor = this.executor();
        while (AbstractChannelHandlerContext.skipContext(abstractChannelHandlerContext = abstractChannelHandlerContext.prev, eventExecutor, n2, 130560)) {
        }
        return abstractChannelHandlerContext;
    }

    private static boolean skipContext(AbstractChannelHandlerContext abstractChannelHandlerContext, EventExecutor eventExecutor, int n2, int n3) {
        return (abstractChannelHandlerContext.executionMask & (n3 | n2)) == 0 || abstractChannelHandlerContext.executor() == eventExecutor && (abstractChannelHandlerContext.executionMask & n2) == 0;
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.channel().voidPromise();
    }

    final void setRemoved() {
        this.handlerState = 3;
    }

    final boolean setAddComplete() {
        int n2;
        do {
            if ((n2 = this.handlerState) != 3) continue;
            return false;
        } while (!HANDLER_STATE_UPDATER.compareAndSet(this, n2, 2));
        return true;
    }

    final void setAddPending() {
        boolean bl = HANDLER_STATE_UPDATER.compareAndSet(this, 0, 1);
        assert (bl);
    }

    final void callHandlerAdded() throws Exception {
        if (this.setAddComplete()) {
            this.handler().handlerAdded(this);
        }
    }

    final void callHandlerRemoved() throws Exception {
        try {
            if (this.handlerState == 2) {
                this.handler().handlerRemoved(this);
            }
            return;
        }
        finally {
            this.setRemoved();
        }
    }

    private boolean invokeHandler() {
        int n2 = this.handlerState;
        return n2 == 2 || !this.ordered && n2 == 1;
    }

    @Override
    public boolean isRemoved() {
        return this.handlerState == 3;
    }

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> attributeKey) {
        return this.channel().attr(attributeKey);
    }

    private static boolean safeExecute(EventExecutor eventExecutor, Runnable runnable, ChannelPromise channelPromise, Object object, boolean bl) {
        try {
            if (bl && eventExecutor instanceof AbstractEventExecutor) {
                ((AbstractEventExecutor)eventExecutor).lazyExecute(runnable);
            } else {
                eventExecutor.execute(runnable);
            }
            return true;
        }
        catch (Throwable throwable) {
            try {
                channelPromise.setFailure(throwable);
            }
            finally {
                if (object != null) {
                    ReferenceCountUtil.release(object);
                }
            }
            return false;
        }
    }

    @Override
    public String toHintString() {
        return "'" + this.name + "' will handle the message from this point.";
    }

    public String toString() {
        return StringUtil.simpleClassName(ChannelHandlerContext.class) + '(' + this.name + ", " + this.channel() + ')';
    }

    private static final class Tasks {
        private final AbstractChannelHandlerContext next;
        private final Runnable invokeChannelReadCompleteTask = new Runnable(){

            public void run() {
                Tasks.this.next.invokeChannelReadComplete();
            }
        };
        private final Runnable invokeReadTask = new Runnable(){

            public void run() {
                Tasks.this.next.invokeRead();
            }
        };
        private final Runnable invokeChannelWritableStateChangedTask = new Runnable(){

            public void run() {
                Tasks.this.next.invokeChannelWritabilityChanged();
            }
        };
        private final Runnable invokeFlushTask = new Runnable(){

            public void run() {
                Tasks.this.next.invokeFlush();
            }
        };

        Tasks(AbstractChannelHandlerContext abstractChannelHandlerContext) {
            this.next = abstractChannelHandlerContext;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WriteTask
    implements Runnable {
        private static final ObjectPool<WriteTask> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<WriteTask>(){

            @Override
            public final WriteTask newObject(ObjectPool.Handle<WriteTask> handle) {
                return new WriteTask(handle);
            }
        });
        private static final boolean ESTIMATE_TASK_SIZE_ON_SUBMIT = SystemPropertyUtil.getBoolean("com.appoptics.ext.io.netty.transport.estimateSizeOnSubmit", true);
        private static final int WRITE_TASK_OVERHEAD = SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.transport.writeTaskSizeOverhead", 32);
        private final ObjectPool.Handle<WriteTask> handle;
        private AbstractChannelHandlerContext ctx;
        private Object msg;
        private ChannelPromise promise;
        private int size;

        static WriteTask newInstance(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise, boolean bl) {
            WriteTask writeTask = RECYCLER.get();
            WriteTask.init(writeTask, abstractChannelHandlerContext, object, channelPromise, bl);
            return writeTask;
        }

        private WriteTask(ObjectPool.Handle<? extends WriteTask> handle) {
            this.handle = handle;
        }

        protected static void init(WriteTask writeTask, AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise, boolean bl) {
            writeTask.ctx = abstractChannelHandlerContext;
            writeTask.msg = object;
            writeTask.promise = channelPromise;
            if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
                writeTask.size = abstractChannelHandlerContext.pipeline.estimatorHandle().size(object) + WRITE_TASK_OVERHEAD;
                abstractChannelHandlerContext.pipeline.incrementPendingOutboundBytes(writeTask.size);
            } else {
                writeTask.size = 0;
            }
            if (bl) {
                writeTask.size |= Integer.MIN_VALUE;
            }
        }

        @Override
        public final void run() {
            try {
                this.decrementPendingOutboundBytes();
                if (this.size >= 0) {
                    this.ctx.invokeWrite(this.msg, this.promise);
                } else {
                    this.ctx.invokeWriteAndFlush(this.msg, this.promise);
                }
                return;
            }
            finally {
                this.recycle();
            }
        }

        final void cancel() {
            try {
                this.decrementPendingOutboundBytes();
                return;
            }
            finally {
                this.recycle();
            }
        }

        private void decrementPendingOutboundBytes() {
            if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
                this.ctx.pipeline.decrementPendingOutboundBytes(this.size & Integer.MAX_VALUE);
            }
        }

        private void recycle() {
            this.ctx = null;
            this.msg = null;
            this.promise = null;
            this.handle.recycle(this);
        }
    }
}

