/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel;

import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelId;
import com.appoptics.ext.io.netty.channel.ChannelOutboundBuffer;
import com.appoptics.ext.io.netty.channel.ChannelPipeline;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.channel.DefaultChannelId;
import com.appoptics.ext.io.netty.channel.DefaultChannelPipeline;
import com.appoptics.ext.io.netty.channel.DefaultChannelPromise;
import com.appoptics.ext.io.netty.channel.EventLoop;
import com.appoptics.ext.io.netty.channel.RecvByteBufAllocator;
import com.appoptics.ext.io.netty.channel.VoidChannelPromise;
import com.appoptics.ext.io.netty.channel.socket.ChannelOutputShutdownEvent;
import com.appoptics.ext.io.netty.channel.socket.ChannelOutputShutdownException;
import com.appoptics.ext.io.netty.util.DefaultAttributeMap;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import com.appoptics.ext.io.netty.util.concurrent.GenericFutureListener;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public abstract class AbstractChannel
extends DefaultAttributeMap
implements Channel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractChannel.class);
    private final Channel parent;
    private final ChannelId id;
    private final Channel.Unsafe unsafe;
    private final DefaultChannelPipeline pipeline;
    private final VoidChannelPromise unsafeVoidPromise = new VoidChannelPromise(this, false);
    private final CloseFuture closeFuture = new CloseFuture(this);
    private volatile SocketAddress localAddress;
    private volatile SocketAddress remoteAddress;
    private volatile EventLoop eventLoop;
    private volatile boolean registered;
    private boolean closeInitiated;
    private Throwable initialCloseCause;
    private boolean strValActive;
    private String strVal;

    protected AbstractChannel(Channel channel) {
        this.parent = channel;
        this.id = this.newId();
        this.unsafe = this.newUnsafe();
        this.pipeline = this.newChannelPipeline();
    }

    public final ChannelId id() {
        return this.id;
    }

    protected ChannelId newId() {
        return DefaultChannelId.newInstance();
    }

    protected DefaultChannelPipeline newChannelPipeline() {
        return new DefaultChannelPipeline(this);
    }

    public boolean isWritable() {
        ChannelOutboundBuffer channelOutboundBuffer = this.unsafe.outboundBuffer();
        return channelOutboundBuffer != null && channelOutboundBuffer.isWritable();
    }

    public long bytesBeforeUnwritable() {
        ChannelOutboundBuffer channelOutboundBuffer = this.unsafe.outboundBuffer();
        if (channelOutboundBuffer != null) {
            return channelOutboundBuffer.bytesBeforeUnwritable();
        }
        return 0L;
    }

    public Channel parent() {
        return this.parent;
    }

    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    public ByteBufAllocator alloc() {
        return this.config().getAllocator();
    }

    public EventLoop eventLoop() {
        EventLoop eventLoop = this.eventLoop;
        if (eventLoop == null) {
            throw new IllegalStateException("channel not registered to an event loop");
        }
        return eventLoop;
    }

    public SocketAddress localAddress() {
        Serializable serializable = this.localAddress;
        if (serializable == null) {
            try {
                this.localAddress = serializable = this.unsafe().localAddress();
            }
            catch (Error error) {
                serializable = error;
                throw error;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return serializable;
    }

    public SocketAddress remoteAddress() {
        Serializable serializable = this.remoteAddress;
        if (serializable == null) {
            try {
                this.remoteAddress = serializable = this.unsafe().remoteAddress();
            }
            catch (Error error) {
                serializable = error;
                throw error;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return serializable;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public ChannelFuture connect(SocketAddress socketAddress) {
        return this.pipeline.connect(socketAddress);
    }

    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return this.pipeline.connect(socketAddress, socketAddress2);
    }

    public ChannelFuture close() {
        return this.pipeline.close();
    }

    public Channel flush() {
        this.pipeline.flush();
        return this;
    }

    public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.pipeline.connect(socketAddress, channelPromise);
    }

    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        return this.pipeline.connect(socketAddress, socketAddress2, channelPromise);
    }

    public ChannelFuture disconnect(ChannelPromise channelPromise) {
        return this.pipeline.disconnect(channelPromise);
    }

    public ChannelFuture close(ChannelPromise channelPromise) {
        return this.pipeline.close(channelPromise);
    }

    public Channel read() {
        this.pipeline.read();
        return this;
    }

    public ChannelFuture write(Object object) {
        return this.pipeline.write(object);
    }

    public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        return this.pipeline.write(object, channelPromise);
    }

    public ChannelFuture writeAndFlush(Object object) {
        return this.pipeline.writeAndFlush(object);
    }

    public ChannelPromise newPromise() {
        return this.pipeline.newPromise();
    }

    public ChannelFuture newSucceededFuture() {
        return this.pipeline.newSucceededFuture();
    }

    public ChannelFuture newFailedFuture(Throwable throwable) {
        return this.pipeline.newFailedFuture(throwable);
    }

    public Channel.Unsafe unsafe() {
        return this.unsafe;
    }

    protected abstract AbstractUnsafe newUnsafe();

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int compareTo(Channel channel) {
        if (this == channel) {
            return 0;
        }
        return this.id().compareTo(channel.id());
    }

    public String toString() {
        boolean bl = this.isActive();
        if (this.strValActive == bl && this.strVal != null) {
            return this.strVal;
        }
        Serializable serializable = this.remoteAddress();
        SocketAddress socketAddress = this.localAddress();
        if (serializable != null) {
            serializable = new StringBuilder(96).append("[id: 0x").append(this.id.asShortText()).append(", L:").append(socketAddress).append(bl ? " - " : " ! ").append("R:").append(serializable).append(']');
            this.strVal = ((StringBuilder)serializable).toString();
        } else if (socketAddress != null) {
            serializable = new StringBuilder(64).append("[id: 0x").append(this.id.asShortText()).append(", L:").append(socketAddress).append(']');
            this.strVal = ((StringBuilder)serializable).toString();
        } else {
            serializable = new StringBuilder(16).append("[id: 0x").append(this.id.asShortText()).append(']');
            this.strVal = ((StringBuilder)serializable).toString();
        }
        this.strValActive = bl;
        return this.strVal;
    }

    public final ChannelPromise voidPromise() {
        return this.pipeline.voidPromise();
    }

    protected abstract boolean isCompatible(EventLoop var1);

    protected abstract SocketAddress localAddress0();

    protected abstract SocketAddress remoteAddress0();

    protected void doRegister() throws Exception {
    }

    protected abstract void doDisconnect() throws Exception;

    protected abstract void doClose() throws Exception;

    protected void doShutdownOutput() throws Exception {
        this.doClose();
    }

    protected void doDeregister() throws Exception {
    }

    protected abstract void doBeginRead() throws Exception;

    protected abstract void doWrite(ChannelOutboundBuffer var1) throws Exception;

    protected Object filterOutboundMessage(Object object) throws Exception {
        return object;
    }

    private static final class AnnotatedSocketException
    extends SocketException {
        private static final long serialVersionUID = 3896743275010454039L;

        AnnotatedSocketException(SocketException socketException, SocketAddress socketAddress) {
            super(socketException.getMessage() + ": " + socketAddress);
            this.initCause(socketException);
        }

        public final Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class AnnotatedNoRouteToHostException
    extends NoRouteToHostException {
        private static final long serialVersionUID = -6801433937592080623L;

        AnnotatedNoRouteToHostException(NoRouteToHostException noRouteToHostException, SocketAddress socketAddress) {
            super(noRouteToHostException.getMessage() + ": " + socketAddress);
            this.initCause(noRouteToHostException);
        }

        public final Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class AnnotatedConnectException
    extends ConnectException {
        private static final long serialVersionUID = 3901958112696433556L;

        AnnotatedConnectException(ConnectException connectException, SocketAddress socketAddress) {
            super(connectException.getMessage() + ": " + socketAddress);
            this.initCause(connectException);
        }

        public final Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class CloseFuture
    extends DefaultChannelPromise {
        CloseFuture(AbstractChannel abstractChannel) {
            super(abstractChannel);
        }

        public final ChannelPromise setSuccess() {
            throw new IllegalStateException();
        }

        public final ChannelPromise setFailure(Throwable throwable) {
            throw new IllegalStateException();
        }

        public final boolean trySuccess() {
            throw new IllegalStateException();
        }

        public final boolean tryFailure(Throwable throwable) {
            throw new IllegalStateException();
        }

        final boolean setClosed() {
            return super.trySuccess();
        }
    }

    protected abstract class AbstractUnsafe
    implements Channel.Unsafe {
        private volatile ChannelOutboundBuffer outboundBuffer;
        private RecvByteBufAllocator.Handle recvHandle;
        private boolean inFlush0;
        private boolean neverRegistered;

        protected AbstractUnsafe() {
            this.outboundBuffer = new ChannelOutboundBuffer(AbstractChannel.this);
            this.neverRegistered = true;
        }

        private void assertEventLoop() {
            assert (!AbstractChannel.this.registered || AbstractChannel.this.eventLoop.inEventLoop());
        }

        public RecvByteBufAllocator.Handle recvBufAllocHandle() {
            if (this.recvHandle == null) {
                this.recvHandle = AbstractChannel.this.config().getRecvByteBufAllocator().newHandle();
            }
            return this.recvHandle;
        }

        public final ChannelOutboundBuffer outboundBuffer() {
            return this.outboundBuffer;
        }

        public final SocketAddress localAddress() {
            return AbstractChannel.this.localAddress0();
        }

        public final SocketAddress remoteAddress() {
            return AbstractChannel.this.remoteAddress0();
        }

        public final void register(EventLoop eventLoop, final ChannelPromise channelPromise) {
            ObjectUtil.checkNotNull(eventLoop, "eventLoop");
            if (AbstractChannel.this.isRegistered()) {
                channelPromise.setFailure(new IllegalStateException("registered to an event loop already"));
                return;
            }
            if (!AbstractChannel.this.isCompatible(eventLoop)) {
                channelPromise.setFailure(new IllegalStateException("incompatible event loop type: " + eventLoop.getClass().getName()));
                return;
            }
            AbstractChannel.this.eventLoop = eventLoop;
            if (eventLoop.inEventLoop()) {
                this.register0(channelPromise);
                return;
            }
            try {
                eventLoop.execute(new Runnable(){

                    public void run() {
                        AbstractUnsafe.this.register0(channelPromise);
                    }
                });
                return;
            }
            catch (Throwable throwable) {
                logger.warn("Force-closing a channel whose registration task was not accepted by an event loop: {}", (Object)AbstractChannel.this, (Object)throwable);
                this.closeForcibly();
                AbstractChannel.this.closeFuture.setClosed();
                this.safeSetFailure(channelPromise, throwable);
                return;
            }
        }

        private void register0(ChannelPromise channelPromise) {
            try {
                block8: {
                    block7: {
                        if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
                            return;
                        }
                        boolean bl = this.neverRegistered;
                        AbstractChannel.this.doRegister();
                        this.neverRegistered = false;
                        AbstractChannel.this.registered = true;
                        AbstractChannel.this.pipeline.invokeHandlerAddedIfNeeded();
                        this.safeSetSuccess(channelPromise);
                        AbstractChannel.this.pipeline.fireChannelRegistered();
                        if (!AbstractChannel.this.isActive()) break block7;
                        if (bl) break block8;
                        if (AbstractChannel.this.config().isAutoRead()) {
                            this.beginRead();
                        }
                    }
                    return;
                }
                AbstractChannel.this.pipeline.fireChannelActive();
            }
            catch (Throwable throwable) {
                this.closeForcibly();
                AbstractChannel.this.closeFuture.setClosed();
                this.safeSetFailure(channelPromise, throwable);
            }
        }

        public final void disconnect(ChannelPromise channelPromise) {
            this.assertEventLoop();
            if (!channelPromise.setUncancellable()) {
                return;
            }
            boolean bl = AbstractChannel.this.isActive();
            try {
                AbstractChannel.this.doDisconnect();
                AbstractChannel.this.remoteAddress = null;
                AbstractChannel.this.localAddress = null;
            }
            catch (Throwable throwable) {
                this.safeSetFailure(channelPromise, throwable);
                this.closeIfClosed();
                return;
            }
            if (bl && !AbstractChannel.this.isActive()) {
                this.invokeLater(new Runnable(){

                    public void run() {
                        AbstractChannel.this.pipeline.fireChannelInactive();
                    }
                });
            }
            this.safeSetSuccess(channelPromise);
            this.closeIfClosed();
        }

        public final void close(ChannelPromise channelPromise) {
            ClosedChannelException closedChannelException;
            this.assertEventLoop();
            ClosedChannelException closedChannelException2 = closedChannelException = new ClosedChannelException();
            this.close(channelPromise, closedChannelException2, closedChannelException2, false);
        }

        public final void shutdownOutput(ChannelPromise channelPromise) {
            this.assertEventLoop();
            this.shutdownOutput(channelPromise, null);
        }

        private void shutdownOutput(final ChannelPromise channelPromise, final Throwable throwable) {
            if (!channelPromise.setUncancellable()) {
                return;
            }
            final ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
            if (channelOutboundBuffer == null) {
                channelPromise.setFailure(new ClosedChannelException());
                return;
            }
            this.outboundBuffer = null;
            throwable = throwable == null ? new ChannelOutputShutdownException("Channel output shutdown") : new ChannelOutputShutdownException("Channel output shutdown", throwable);
            Executor executor = this.prepareToClose();
            if (executor != null) {
                executor.execute(new Runnable(){

                    public void run() {
                        try {
                            AbstractChannel.this.doShutdownOutput();
                            channelPromise.setSuccess();
                        }
                        catch (Throwable throwable3) {
                            try {
                                channelPromise.setFailure(throwable3);
                            }
                            catch (Throwable throwable2) {
                                AbstractChannel.this.eventLoop().execute(new Runnable(){

                                    public void run() {
                                        AbstractUnsafe.this.closeOutboundBufferForShutdown(AbstractChannel.this.pipeline, channelOutboundBuffer, throwable);
                                    }
                                });
                                throw throwable2;
                            }
                            AbstractChannel.this.eventLoop().execute(new /* invalid duplicate definition of identical inner class */);
                            return;
                        }
                        AbstractChannel.this.eventLoop().execute(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                });
                return;
            }
            try {
                AbstractChannel.this.doShutdownOutput();
                channelPromise.setSuccess();
                AbstractUnsafe abstractUnsafe = this;
                abstractUnsafe.closeOutboundBufferForShutdown(abstractUnsafe.AbstractChannel.this.pipeline, channelOutboundBuffer, throwable);
                return;
            }
            catch (Throwable throwable2) {
                try {
                    channelPromise.setFailure(throwable2);
                    AbstractUnsafe abstractUnsafe = this;
                    abstractUnsafe.closeOutboundBufferForShutdown(abstractUnsafe.AbstractChannel.this.pipeline, channelOutboundBuffer, throwable);
                    return;
                }
                catch (Throwable throwable3) {
                    AbstractUnsafe abstractUnsafe = this;
                    abstractUnsafe.closeOutboundBufferForShutdown(abstractUnsafe.AbstractChannel.this.pipeline, channelOutboundBuffer, throwable);
                    throw throwable3;
                }
            }
        }

        private void closeOutboundBufferForShutdown(ChannelPipeline channelPipeline, ChannelOutboundBuffer channelOutboundBuffer, Throwable throwable) {
            channelOutboundBuffer.failFlushed(throwable, false);
            channelOutboundBuffer.close(throwable, true);
            channelPipeline.fireUserEventTriggered(ChannelOutputShutdownEvent.INSTANCE);
        }

        private void close(final ChannelPromise channelPromise, final Throwable throwable, final ClosedChannelException closedChannelException, final boolean bl) {
            if (!channelPromise.setUncancellable()) {
                return;
            }
            if (AbstractChannel.this.closeInitiated) {
                if (AbstractChannel.this.closeFuture.isDone()) {
                    this.safeSetSuccess(channelPromise);
                    return;
                }
                if (!(channelPromise instanceof VoidChannelPromise)) {
                    AbstractChannel.this.closeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            channelPromise.setSuccess();
                        }
                    });
                }
                return;
            }
            AbstractChannel.this.closeInitiated = true;
            final boolean bl2 = AbstractChannel.this.isActive();
            final ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
            this.outboundBuffer = null;
            Executor executor = this.prepareToClose();
            if (executor != null) {
                executor.execute(new Runnable(){

                    public void run() {
                        try {
                            AbstractUnsafe.this.doClose0(channelPromise);
                        }
                        catch (Throwable throwable2) {
                            AbstractUnsafe.this.invokeLater(new Runnable(){

                                public void run() {
                                    if (channelOutboundBuffer != null) {
                                        channelOutboundBuffer.failFlushed(throwable, bl);
                                        channelOutboundBuffer.close(closedChannelException);
                                    }
                                    AbstractUnsafe.this.fireChannelInactiveAndDeregister(bl2);
                                }
                            });
                            throw throwable2;
                        }
                        AbstractUnsafe.this.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                });
                return;
            }
            try {
                this.doClose0(channelPromise);
            }
            finally {
                if (channelOutboundBuffer != null) {
                    channelOutboundBuffer.failFlushed(throwable, bl);
                    channelOutboundBuffer.close(closedChannelException);
                }
            }
            if (this.inFlush0) {
                this.invokeLater(new Runnable(){

                    public void run() {
                        AbstractUnsafe.this.fireChannelInactiveAndDeregister(bl2);
                    }
                });
                return;
            }
            this.fireChannelInactiveAndDeregister(bl2);
        }

        private void doClose0(ChannelPromise channelPromise) {
            try {
                AbstractChannel.this.doClose();
                AbstractChannel.this.closeFuture.setClosed();
                this.safeSetSuccess(channelPromise);
                return;
            }
            catch (Throwable throwable) {
                AbstractChannel.this.closeFuture.setClosed();
                this.safeSetFailure(channelPromise, throwable);
                return;
            }
        }

        private void fireChannelInactiveAndDeregister(boolean bl) {
            AbstractUnsafe abstractUnsafe = this;
            abstractUnsafe.deregister(abstractUnsafe.voidPromise(), bl && !AbstractChannel.this.isActive());
        }

        public final void closeForcibly() {
            this.assertEventLoop();
            try {
                AbstractChannel.this.doClose();
                return;
            }
            catch (Exception exception) {
                logger.warn("Failed to close a channel.", exception);
                return;
            }
        }

        private void deregister(final ChannelPromise channelPromise, final boolean bl) {
            if (!channelPromise.setUncancellable()) {
                return;
            }
            if (!AbstractChannel.this.registered) {
                this.safeSetSuccess(channelPromise);
                return;
            }
            this.invokeLater(new Runnable(){

                public void run() {
                    try {
                        AbstractChannel.this.doDeregister();
                        return;
                    }
                    catch (Throwable throwable) {
                        logger.warn("Unexpected exception occurred while deregistering a channel.", throwable);
                        return;
                    }
                    finally {
                        if (bl) {
                            AbstractChannel.this.pipeline.fireChannelInactive();
                        }
                        if (AbstractChannel.this.registered) {
                            AbstractChannel.this.registered = false;
                            AbstractChannel.this.pipeline.fireChannelUnregistered();
                        }
                        AbstractUnsafe.this.safeSetSuccess(channelPromise);
                    }
                }
            });
        }

        public final void beginRead() {
            this.assertEventLoop();
            if (!AbstractChannel.this.isActive()) {
                return;
            }
            try {
                AbstractChannel.this.doBeginRead();
                return;
            }
            catch (Exception exception) {
                this.invokeLater(new Runnable(){

                    public void run() {
                        AbstractChannel.this.pipeline.fireExceptionCaught(exception);
                    }
                });
                AbstractUnsafe abstractUnsafe = this;
                abstractUnsafe.close(abstractUnsafe.voidPromise());
                return;
            }
        }

        public final void write(Object object, ChannelPromise channelPromise) {
            int n2;
            this.assertEventLoop();
            ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
            if (channelOutboundBuffer == null) {
                AbstractUnsafe abstractUnsafe = this;
                this.safeSetFailure(channelPromise, abstractUnsafe.newClosedChannelException(abstractUnsafe.AbstractChannel.this.initialCloseCause));
                ReferenceCountUtil.release(object);
                return;
            }
            try {
                object = AbstractChannel.this.filterOutboundMessage(object);
                n2 = AbstractChannel.this.pipeline.estimatorHandle().size(object);
                if (n2 < 0) {
                    n2 = 0;
                }
            }
            catch (Throwable throwable) {
                this.safeSetFailure(channelPromise, throwable);
                ReferenceCountUtil.release(object);
                return;
            }
            channelOutboundBuffer.addMessage(object, n2, channelPromise);
        }

        public final void flush() {
            this.assertEventLoop();
            ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
            if (channelOutboundBuffer == null) {
                return;
            }
            channelOutboundBuffer.addFlush();
            this.flush0();
        }

        protected void flush0() {
            if (this.inFlush0) {
                return;
            }
            Object object = this.outboundBuffer;
            if (object == null || ((ChannelOutboundBuffer)object).isEmpty()) {
                return;
            }
            this.inFlush0 = true;
            if (!AbstractChannel.this.isActive()) {
                try {
                    if (AbstractChannel.this.isOpen()) {
                        ((ChannelOutboundBuffer)object).failFlushed(new NotYetConnectedException(), true);
                    } else {
                        AbstractUnsafe abstractUnsafe = this;
                        ((ChannelOutboundBuffer)object).failFlushed(abstractUnsafe.newClosedChannelException(abstractUnsafe.AbstractChannel.this.initialCloseCause), false);
                    }
                    return;
                }
                finally {
                    this.inFlush0 = false;
                }
            }
            try {
                AbstractChannel.this.doWrite((ChannelOutboundBuffer)object);
                return;
            }
            catch (Throwable throwable) {
                object = throwable;
                if (throwable instanceof IOException && AbstractChannel.this.config().isAutoClose()) {
                    AbstractChannel.this.initialCloseCause = (Throwable)object;
                    AbstractUnsafe abstractUnsafe = this;
                    abstractUnsafe.close(abstractUnsafe.voidPromise(), (Throwable)object, this.newClosedChannelException((Throwable)object), false);
                } else {
                    try {
                        AbstractUnsafe abstractUnsafe = this;
                        abstractUnsafe.shutdownOutput(abstractUnsafe.voidPromise(), (Throwable)object);
                    }
                    catch (Throwable throwable2) {
                        AbstractChannel.this.initialCloseCause = (Throwable)object;
                        AbstractUnsafe abstractUnsafe = this;
                        abstractUnsafe.close(abstractUnsafe.voidPromise(), throwable2, this.newClosedChannelException((Throwable)object), false);
                    }
                }
                return;
            }
            finally {
                this.inFlush0 = false;
            }
        }

        private ClosedChannelException newClosedChannelException(Throwable throwable) {
            ClosedChannelException closedChannelException = new ClosedChannelException();
            if (throwable != null) {
                closedChannelException.initCause(throwable);
            }
            return closedChannelException;
        }

        public final ChannelPromise voidPromise() {
            this.assertEventLoop();
            return AbstractChannel.this.unsafeVoidPromise;
        }

        protected final boolean ensureOpen(ChannelPromise channelPromise) {
            if (AbstractChannel.this.isOpen()) {
                return true;
            }
            AbstractUnsafe abstractUnsafe = this;
            this.safeSetFailure(channelPromise, abstractUnsafe.newClosedChannelException(abstractUnsafe.AbstractChannel.this.initialCloseCause));
            return false;
        }

        protected final void safeSetSuccess(ChannelPromise channelPromise) {
            if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.trySuccess()) {
                logger.warn("Failed to mark a promise as success because it is done already: {}", (Object)channelPromise);
            }
        }

        protected final void safeSetFailure(ChannelPromise channelPromise, Throwable throwable) {
            if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.tryFailure(throwable)) {
                logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)channelPromise, (Object)throwable);
            }
        }

        protected final void closeIfClosed() {
            if (AbstractChannel.this.isOpen()) {
                return;
            }
            AbstractUnsafe abstractUnsafe = this;
            abstractUnsafe.close(abstractUnsafe.voidPromise());
        }

        private void invokeLater(Runnable runnable) {
            try {
                AbstractChannel.this.eventLoop().execute(runnable);
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                logger.warn("Can't invoke task later as EventLoop rejected it", rejectedExecutionException);
                return;
            }
        }

        protected final Throwable annotateConnectException(Throwable throwable, SocketAddress socketAddress) {
            if (throwable instanceof ConnectException) {
                return new AnnotatedConnectException((ConnectException)throwable, socketAddress);
            }
            if (throwable instanceof NoRouteToHostException) {
                return new AnnotatedNoRouteToHostException((NoRouteToHostException)throwable, socketAddress);
            }
            if (throwable instanceof SocketException) {
                return new AnnotatedSocketException((SocketException)throwable, socketAddress);
            }
            return throwable;
        }

        protected Executor prepareToClose() {
            return null;
        }
    }
}

