/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.util.ByteProcessor;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

class WrappedByteBuf
extends ByteBuf {
    protected final ByteBuf buf;

    protected WrappedByteBuf(ByteBuf byteBuf) {
        this.buf = ObjectUtil.checkNotNull(byteBuf, "buf");
    }

    public final boolean hasMemoryAddress() {
        return this.buf.hasMemoryAddress();
    }

    public boolean isContiguous() {
        return this.buf.isContiguous();
    }

    public final long memoryAddress() {
        return this.buf.memoryAddress();
    }

    public final int capacity() {
        return this.buf.capacity();
    }

    public ByteBuf capacity(int n2) {
        this.buf.capacity(n2);
        return this;
    }

    public final int maxCapacity() {
        return this.buf.maxCapacity();
    }

    public final ByteBufAllocator alloc() {
        return this.buf.alloc();
    }

    public final ByteOrder order() {
        return this.buf.order();
    }

    public ByteBuf order(ByteOrder byteOrder) {
        return this.buf.order(byteOrder);
    }

    public final ByteBuf unwrap() {
        return this.buf;
    }

    public ByteBuf asReadOnly() {
        return this.buf.asReadOnly();
    }

    public boolean isReadOnly() {
        return this.buf.isReadOnly();
    }

    public final boolean isDirect() {
        return this.buf.isDirect();
    }

    public final int readerIndex() {
        return this.buf.readerIndex();
    }

    public final ByteBuf readerIndex(int n2) {
        this.buf.readerIndex(n2);
        return this;
    }

    public final int writerIndex() {
        return this.buf.writerIndex();
    }

    public final ByteBuf writerIndex(int n2) {
        this.buf.writerIndex(n2);
        return this;
    }

    public ByteBuf setIndex(int n2, int n3) {
        this.buf.setIndex(n2, n3);
        return this;
    }

    public final int readableBytes() {
        return this.buf.readableBytes();
    }

    public final int writableBytes() {
        return this.buf.writableBytes();
    }

    public final int maxWritableBytes() {
        return this.buf.maxWritableBytes();
    }

    public int maxFastWritableBytes() {
        return this.buf.maxFastWritableBytes();
    }

    public final boolean isReadable() {
        return this.buf.isReadable();
    }

    public final ByteBuf clear() {
        this.buf.clear();
        return this;
    }

    public final ByteBuf markReaderIndex() {
        this.buf.markReaderIndex();
        return this;
    }

    public final ByteBuf resetReaderIndex() {
        this.buf.resetReaderIndex();
        return this;
    }

    public ByteBuf discardSomeReadBytes() {
        this.buf.discardSomeReadBytes();
        return this;
    }

    public ByteBuf ensureWritable(int n2) {
        this.buf.ensureWritable(n2);
        return this;
    }

    public int ensureWritable(int n2, boolean bl) {
        return this.buf.ensureWritable(n2, bl);
    }

    public byte getByte(int n2) {
        return this.buf.getByte(n2);
    }

    public short getUnsignedByte(int n2) {
        return this.buf.getUnsignedByte(n2);
    }

    public short getShort(int n2) {
        return this.buf.getShort(n2);
    }

    public short getShortLE(int n2) {
        return this.buf.getShortLE(n2);
    }

    public int getUnsignedShort(int n2) {
        return this.buf.getUnsignedShort(n2);
    }

    public int getUnsignedShortLE(int n2) {
        return this.buf.getUnsignedShortLE(n2);
    }

    public int getMedium(int n2) {
        return this.buf.getMedium(n2);
    }

    public int getUnsignedMedium(int n2) {
        return this.buf.getUnsignedMedium(n2);
    }

    public int getInt(int n2) {
        return this.buf.getInt(n2);
    }

    public int getIntLE(int n2) {
        return this.buf.getIntLE(n2);
    }

    public long getUnsignedInt(int n2) {
        return this.buf.getUnsignedInt(n2);
    }

    public long getUnsignedIntLE(int n2) {
        return this.buf.getUnsignedIntLE(n2);
    }

    public long getLong(int n2) {
        return this.buf.getLong(n2);
    }

    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.buf.getBytes(n2, byteBuf, n3, n4);
        return this;
    }

    public ByteBuf getBytes(int n2, byte[] byArray) {
        this.buf.getBytes(n2, byArray);
        return this;
    }

    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.buf.getBytes(n2, byArray, n3, n4);
        return this;
    }

    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        this.buf.getBytes(n2, byteBuffer);
        return this;
    }

    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) throws IOException {
        return this.buf.getBytes(n2, gatheringByteChannel, n3);
    }

    public ByteBuf setByte(int n2, int n3) {
        this.buf.setByte(n2, n3);
        return this;
    }

    public ByteBuf setShort(int n2, int n3) {
        this.buf.setShort(n2, n3);
        return this;
    }

    public ByteBuf setShortLE(int n2, int n3) {
        this.buf.setShortLE(n2, n3);
        return this;
    }

    public ByteBuf setMedium(int n2, int n3) {
        this.buf.setMedium(n2, n3);
        return this;
    }

    public ByteBuf setMediumLE(int n2, int n3) {
        this.buf.setMediumLE(n2, n3);
        return this;
    }

    public ByteBuf setInt(int n2, int n3) {
        this.buf.setInt(n2, n3);
        return this;
    }

    public ByteBuf setLong(int n2, long l2) {
        this.buf.setLong(n2, l2);
        return this;
    }

    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.buf.setBytes(n2, byteBuf, n3, n4);
        return this;
    }

    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.buf.setBytes(n2, byArray, n3, n4);
        return this;
    }

    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        this.buf.setBytes(n2, byteBuffer);
        return this;
    }

    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) throws IOException {
        return this.buf.setBytes(n2, scatteringByteChannel, n3);
    }

    public ByteBuf setZero(int n2, int n3) {
        this.buf.setZero(n2, n3);
        return this;
    }

    public int setCharSequence(int n2, CharSequence charSequence, Charset charset) {
        return this.buf.setCharSequence(n2, charSequence, charset);
    }

    public byte readByte() {
        return this.buf.readByte();
    }

    public short readUnsignedByte() {
        return this.buf.readUnsignedByte();
    }

    public short readShort() {
        return this.buf.readShort();
    }

    public int readUnsignedShort() {
        return this.buf.readUnsignedShort();
    }

    public int readMedium() {
        return this.buf.readMedium();
    }

    public int readUnsignedMedium() {
        return this.buf.readUnsignedMedium();
    }

    public int readInt() {
        return this.buf.readInt();
    }

    public long readUnsignedInt() {
        return this.buf.readUnsignedInt();
    }

    public long readLong() {
        return this.buf.readLong();
    }

    public ByteBuf readBytes(int n2) {
        return this.buf.readBytes(n2);
    }

    public ByteBuf readSlice(int n2) {
        return this.buf.readSlice(n2);
    }

    public ByteBuf readRetainedSlice(int n2) {
        return this.buf.readRetainedSlice(n2);
    }

    public ByteBuf readBytes(byte[] byArray) {
        this.buf.readBytes(byArray);
        return this;
    }

    public ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        this.buf.readBytes(byArray, n2, n3);
        return this;
    }

    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) throws IOException {
        return this.buf.readBytes(gatheringByteChannel, n2);
    }

    public ByteBuf skipBytes(int n2) {
        this.buf.skipBytes(n2);
        return this;
    }

    public ByteBuf writeByte(int n2) {
        this.buf.writeByte(n2);
        return this;
    }

    public ByteBuf writeShort(int n2) {
        this.buf.writeShort(n2);
        return this;
    }

    public ByteBuf writeShortLE(int n2) {
        this.buf.writeShortLE(n2);
        return this;
    }

    public ByteBuf writeMedium(int n2) {
        this.buf.writeMedium(n2);
        return this;
    }

    public ByteBuf writeMediumLE(int n2) {
        this.buf.writeMediumLE(n2);
        return this;
    }

    public ByteBuf writeInt(int n2) {
        this.buf.writeInt(n2);
        return this;
    }

    public ByteBuf writeLong(long l2) {
        this.buf.writeLong(l2);
        return this;
    }

    public ByteBuf writeChar(int n2) {
        this.buf.writeChar(n2);
        return this;
    }

    public ByteBuf writeBytes(ByteBuf byteBuf) {
        this.buf.writeBytes(byteBuf);
        return this;
    }

    public ByteBuf writeBytes(ByteBuf byteBuf, int n2) {
        this.buf.writeBytes(byteBuf, n2);
        return this;
    }

    public ByteBuf writeBytes(ByteBuf byteBuf, int n2, int n3) {
        this.buf.writeBytes(byteBuf, n2, n3);
        return this;
    }

    public ByteBuf writeBytes(byte[] byArray) {
        this.buf.writeBytes(byArray);
        return this;
    }

    public ByteBuf writeBytes(byte[] byArray, int n2, int n3) {
        this.buf.writeBytes(byArray, n2, n3);
        return this;
    }

    public ByteBuf writeBytes(ByteBuffer byteBuffer) {
        this.buf.writeBytes(byteBuffer);
        return this;
    }

    public int writeBytes(ScatteringByteChannel scatteringByteChannel, int n2) throws IOException {
        return this.buf.writeBytes(scatteringByteChannel, n2);
    }

    public ByteBuf writeZero(int n2) {
        this.buf.writeZero(n2);
        return this;
    }

    public int writeCharSequence(CharSequence charSequence, Charset charset) {
        return this.buf.writeCharSequence(charSequence, charset);
    }

    public int forEachByte(ByteProcessor byteProcessor) {
        return this.buf.forEachByte(byteProcessor);
    }

    public int forEachByte(int n2, int n3, ByteProcessor byteProcessor) {
        return this.buf.forEachByte(n2, n3, byteProcessor);
    }

    public ByteBuf slice() {
        return this.buf.slice();
    }

    public ByteBuf retainedSlice() {
        return this.buf.retainedSlice();
    }

    public ByteBuf slice(int n2, int n3) {
        return this.buf.slice(n2, n3);
    }

    public ByteBuf duplicate() {
        return this.buf.duplicate();
    }

    public ByteBuf retainedDuplicate() {
        return this.buf.retainedDuplicate();
    }

    public int nioBufferCount() {
        return this.buf.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        return this.buf.nioBuffer();
    }

    public ByteBuffer nioBuffer(int n2, int n3) {
        return this.buf.nioBuffer(n2, n3);
    }

    public ByteBuffer[] nioBuffers() {
        return this.buf.nioBuffers();
    }

    public ByteBuffer[] nioBuffers(int n2, int n3) {
        return this.buf.nioBuffers(n2, n3);
    }

    public ByteBuffer internalNioBuffer(int n2, int n3) {
        return this.buf.internalNioBuffer(n2, n3);
    }

    public boolean hasArray() {
        return this.buf.hasArray();
    }

    public byte[] array() {
        return this.buf.array();
    }

    public int arrayOffset() {
        return this.buf.arrayOffset();
    }

    public String toString(Charset charset) {
        return this.buf.toString(charset);
    }

    public String toString(int n2, int n3, Charset charset) {
        return this.buf.toString(n2, n3, charset);
    }

    public int hashCode() {
        return this.buf.hashCode();
    }

    public boolean equals(Object object) {
        return this.buf.equals(object);
    }

    public int compareTo(ByteBuf byteBuf) {
        return this.buf.compareTo(byteBuf);
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + '(' + this.buf.toString() + ')';
    }

    public ByteBuf retain() {
        this.buf.retain();
        return this;
    }

    public ByteBuf touch() {
        this.buf.touch();
        return this;
    }

    public ByteBuf touch(Object object) {
        this.buf.touch(object);
        return this;
    }

    public final boolean isWritable(int n2) {
        return this.buf.isWritable(n2);
    }

    public final int refCnt() {
        return this.buf.refCnt();
    }

    public boolean release() {
        return this.buf.release();
    }

    final boolean isAccessible() {
        return this.buf.isAccessible();
    }
}

