/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.SwappedByteBuf;
import com.appoptics.ext.io.netty.buffer.UnpooledHeapByteBuf;
import com.appoptics.ext.io.netty.buffer.UnsafeByteBufUtil;
import com.appoptics.ext.io.netty.buffer.UnsafeHeapSwappedByteBuf;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;

public class UnpooledUnsafeHeapByteBuf
extends UnpooledHeapByteBuf {
    public UnpooledUnsafeHeapByteBuf(ByteBufAllocator byteBufAllocator, int n2, int n3) {
        super(byteBufAllocator, n2, n3);
    }

    protected byte[] allocateArray(int n2) {
        return PlatformDependent.allocateUninitializedArray(n2);
    }

    public byte getByte(int n2) {
        this.checkIndex(n2);
        return this._getByte(n2);
    }

    protected byte _getByte(int n2) {
        return UnsafeByteBufUtil.getByte(this.array, n2);
    }

    public short getShort(int n2) {
        this.checkIndex(n2, 2);
        return this._getShort(n2);
    }

    protected short _getShort(int n2) {
        return UnsafeByteBufUtil.getShort(this.array, n2);
    }

    public short getShortLE(int n2) {
        this.checkIndex(n2, 2);
        return this._getShortLE(n2);
    }

    protected short _getShortLE(int n2) {
        return UnsafeByteBufUtil.getShortLE(this.array, n2);
    }

    public int getUnsignedMedium(int n2) {
        this.checkIndex(n2, 3);
        return this._getUnsignedMedium(n2);
    }

    protected int _getUnsignedMedium(int n2) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.array, n2);
    }

    public int getInt(int n2) {
        this.checkIndex(n2, 4);
        return this._getInt(n2);
    }

    protected int _getInt(int n2) {
        return UnsafeByteBufUtil.getInt(this.array, n2);
    }

    public int getIntLE(int n2) {
        this.checkIndex(n2, 4);
        return this._getIntLE(n2);
    }

    protected int _getIntLE(int n2) {
        return UnsafeByteBufUtil.getIntLE(this.array, n2);
    }

    public long getLong(int n2) {
        this.checkIndex(n2, 8);
        return this._getLong(n2);
    }

    protected long _getLong(int n2) {
        return UnsafeByteBufUtil.getLong(this.array, n2);
    }

    public ByteBuf setByte(int n2, int n3) {
        this.checkIndex(n2);
        this._setByte(n2, n3);
        return this;
    }

    protected void _setByte(int n2, int n3) {
        UnsafeByteBufUtil.setByte(this.array, n2, n3);
    }

    public ByteBuf setShort(int n2, int n3) {
        this.checkIndex(n2, 2);
        this._setShort(n2, n3);
        return this;
    }

    protected void _setShort(int n2, int n3) {
        UnsafeByteBufUtil.setShort(this.array, n2, n3);
    }

    public ByteBuf setShortLE(int n2, int n3) {
        this.checkIndex(n2, 2);
        this._setShortLE(n2, n3);
        return this;
    }

    protected void _setShortLE(int n2, int n3) {
        UnsafeByteBufUtil.setShortLE(this.array, n2, n3);
    }

    public ByteBuf setMedium(int n2, int n3) {
        this.checkIndex(n2, 3);
        this._setMedium(n2, n3);
        return this;
    }

    protected void _setMedium(int n2, int n3) {
        UnsafeByteBufUtil.setMedium(this.array, n2, n3);
    }

    public ByteBuf setMediumLE(int n2, int n3) {
        this.checkIndex(n2, 3);
        this._setMediumLE(n2, n3);
        return this;
    }

    protected void _setMediumLE(int n2, int n3) {
        UnsafeByteBufUtil.setMediumLE(this.array, n2, n3);
    }

    public ByteBuf setInt(int n2, int n3) {
        this.checkIndex(n2, 4);
        this._setInt(n2, n3);
        return this;
    }

    protected void _setInt(int n2, int n3) {
        UnsafeByteBufUtil.setInt(this.array, n2, n3);
    }

    public ByteBuf setLong(int n2, long l2) {
        this.checkIndex(n2, 8);
        this._setLong(n2, l2);
        return this;
    }

    protected void _setLong(int n2, long l2) {
        UnsafeByteBufUtil.setLong(this.array, n2, l2);
    }

    public ByteBuf setZero(int n2, int n3) {
        if (PlatformDependent.javaVersion() >= 7) {
            this.checkIndex(n2, n3);
            UnsafeByteBufUtil.setZero(this.array, n2, n3);
            return this;
        }
        return super.setZero(n2, n3);
    }

    public ByteBuf writeZero(int n2) {
        if (PlatformDependent.javaVersion() >= 7) {
            this.ensureWritable(n2);
            int n3 = this.writerIndex;
            UnsafeByteBufUtil.setZero(this.array, n3, n2);
            this.writerIndex = n3 + n2;
            return this;
        }
        return super.writeZero(n2);
    }

    @Deprecated
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeHeapSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }
}

