/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.AbstractByteBuf;
import com.appoptics.ext.io.netty.buffer.AbstractPooledDerivedByteBuf;
import com.appoptics.ext.io.netty.buffer.AbstractUnpooledSlicedByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.PooledDuplicatedByteBuf;
import com.appoptics.ext.io.netty.util.ByteProcessor;
import com.appoptics.ext.io.netty.util.internal.ObjectPool;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PooledSlicedByteBuf
extends AbstractPooledDerivedByteBuf {
    private static final ObjectPool<PooledSlicedByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<PooledSlicedByteBuf>(){

        @Override
        public final PooledSlicedByteBuf newObject(ObjectPool.Handle<PooledSlicedByteBuf> handle) {
            return new PooledSlicedByteBuf(handle);
        }
    });
    int adjustment;

    static PooledSlicedByteBuf newInstance(AbstractByteBuf abstractByteBuf, ByteBuf byteBuf, int n2, int n3) {
        AbstractUnpooledSlicedByteBuf.checkSliceOutOfBounds(n2, n3, abstractByteBuf);
        return PooledSlicedByteBuf.newInstance0(abstractByteBuf, byteBuf, n2, n3);
    }

    private static PooledSlicedByteBuf newInstance0(AbstractByteBuf abstractByteBuf, ByteBuf byteBuf, int n2, int n3) {
        PooledSlicedByteBuf pooledSlicedByteBuf = RECYCLER.get();
        int n4 = n3;
        pooledSlicedByteBuf.init(abstractByteBuf, byteBuf, 0, n4, n4);
        pooledSlicedByteBuf.discardMarks();
        pooledSlicedByteBuf.adjustment = n2;
        return pooledSlicedByteBuf;
    }

    private PooledSlicedByteBuf(ObjectPool.Handle<PooledSlicedByteBuf> handle) {
        super(handle);
    }

    @Override
    public final int capacity() {
        return this.maxCapacity();
    }

    @Override
    public final ByteBuf capacity(int n2) {
        throw new UnsupportedOperationException("sliced buffer");
    }

    @Override
    public final int arrayOffset() {
        PooledSlicedByteBuf pooledSlicedByteBuf = this;
        return pooledSlicedByteBuf.idx(pooledSlicedByteBuf.unwrap().arrayOffset());
    }

    @Override
    public final long memoryAddress() {
        return this.unwrap().memoryAddress() + (long)this.adjustment;
    }

    @Override
    public final ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex0(n2, n3);
        return this.unwrap().nioBuffer(this.idx(n2), n3);
    }

    @Override
    public final ByteBuffer[] nioBuffers(int n2, int n3) {
        this.checkIndex0(n2, n3);
        return this.unwrap().nioBuffers(this.idx(n2), n3);
    }

    @Override
    public final ByteBuf slice(int n2, int n3) {
        this.checkIndex0(n2, n3);
        PooledSlicedByteBuf pooledSlicedByteBuf = this;
        return super.slice(pooledSlicedByteBuf.idx(n2), n3);
    }

    @Override
    public final ByteBuf retainedSlice(int n2, int n3) {
        this.checkIndex0(n2, n3);
        PooledSlicedByteBuf pooledSlicedByteBuf = this;
        return PooledSlicedByteBuf.newInstance0(this.unwrap(), pooledSlicedByteBuf, pooledSlicedByteBuf.idx(n2), n3);
    }

    @Override
    public final ByteBuf duplicate() {
        PooledSlicedByteBuf pooledSlicedByteBuf = this;
        PooledSlicedByteBuf pooledSlicedByteBuf2 = this;
        return this.duplicate0().setIndex(pooledSlicedByteBuf.idx(pooledSlicedByteBuf.readerIndex()), pooledSlicedByteBuf2.idx(pooledSlicedByteBuf2.writerIndex()));
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        PooledSlicedByteBuf pooledSlicedByteBuf = this;
        PooledSlicedByteBuf pooledSlicedByteBuf2 = this;
        return PooledDuplicatedByteBuf.newInstance(this.unwrap(), pooledSlicedByteBuf, pooledSlicedByteBuf.idx(this.readerIndex()), pooledSlicedByteBuf2.idx(pooledSlicedByteBuf2.writerIndex()));
    }

    @Override
    public final byte getByte(int n2) {
        this.checkIndex0(n2, 1);
        return this.unwrap().getByte(this.idx(n2));
    }

    @Override
    protected final byte _getByte(int n2) {
        return this.unwrap()._getByte(this.idx(n2));
    }

    @Override
    public final short getShort(int n2) {
        this.checkIndex0(n2, 2);
        return this.unwrap().getShort(this.idx(n2));
    }

    @Override
    protected final short _getShort(int n2) {
        return this.unwrap()._getShort(this.idx(n2));
    }

    @Override
    public final short getShortLE(int n2) {
        this.checkIndex0(n2, 2);
        return this.unwrap().getShortLE(this.idx(n2));
    }

    @Override
    protected final short _getShortLE(int n2) {
        return this.unwrap()._getShortLE(this.idx(n2));
    }

    @Override
    public final int getUnsignedMedium(int n2) {
        this.checkIndex0(n2, 3);
        return this.unwrap().getUnsignedMedium(this.idx(n2));
    }

    @Override
    protected final int _getUnsignedMedium(int n2) {
        return this.unwrap()._getUnsignedMedium(this.idx(n2));
    }

    @Override
    public final int getInt(int n2) {
        this.checkIndex0(n2, 4);
        return this.unwrap().getInt(this.idx(n2));
    }

    @Override
    protected final int _getInt(int n2) {
        return this.unwrap()._getInt(this.idx(n2));
    }

    @Override
    public final int getIntLE(int n2) {
        this.checkIndex0(n2, 4);
        return this.unwrap().getIntLE(this.idx(n2));
    }

    @Override
    protected final int _getIntLE(int n2) {
        return this.unwrap()._getIntLE(this.idx(n2));
    }

    @Override
    public final long getLong(int n2) {
        this.checkIndex0(n2, 8);
        return this.unwrap().getLong(this.idx(n2));
    }

    @Override
    protected final long _getLong(int n2) {
        return this.unwrap()._getLong(this.idx(n2));
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkIndex0(n2, n4);
        this.unwrap().getBytes(this.idx(n2), byteBuf, n3, n4);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkIndex0(n2, n4);
        this.unwrap().getBytes(this.idx(n2), byArray, n3, n4);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        this.checkIndex0(n2, byteBuffer.remaining());
        this.unwrap().getBytes(this.idx(n2), byteBuffer);
        return this;
    }

    @Override
    public final ByteBuf setByte(int n2, int n3) {
        this.checkIndex0(n2, 1);
        this.unwrap().setByte(this.idx(n2), n3);
        return this;
    }

    @Override
    protected final void _setByte(int n2, int n3) {
        this.unwrap()._setByte(this.idx(n2), n3);
    }

    @Override
    public final ByteBuf setShort(int n2, int n3) {
        this.checkIndex0(n2, 2);
        this.unwrap().setShort(this.idx(n2), n3);
        return this;
    }

    @Override
    protected final void _setShort(int n2, int n3) {
        this.unwrap()._setShort(this.idx(n2), n3);
    }

    @Override
    public final ByteBuf setShortLE(int n2, int n3) {
        this.checkIndex0(n2, 2);
        this.unwrap().setShortLE(this.idx(n2), n3);
        return this;
    }

    @Override
    protected final void _setShortLE(int n2, int n3) {
        this.unwrap()._setShortLE(this.idx(n2), n3);
    }

    @Override
    public final ByteBuf setMedium(int n2, int n3) {
        this.checkIndex0(n2, 3);
        this.unwrap().setMedium(this.idx(n2), n3);
        return this;
    }

    @Override
    protected final void _setMedium(int n2, int n3) {
        this.unwrap()._setMedium(this.idx(n2), n3);
    }

    @Override
    public final ByteBuf setMediumLE(int n2, int n3) {
        this.checkIndex0(n2, 3);
        this.unwrap().setMediumLE(this.idx(n2), n3);
        return this;
    }

    @Override
    protected final void _setMediumLE(int n2, int n3) {
        this.unwrap()._setMediumLE(this.idx(n2), n3);
    }

    @Override
    public final ByteBuf setInt(int n2, int n3) {
        this.checkIndex0(n2, 4);
        this.unwrap().setInt(this.idx(n2), n3);
        return this;
    }

    @Override
    protected final void _setInt(int n2, int n3) {
        this.unwrap()._setInt(this.idx(n2), n3);
    }

    @Override
    public final ByteBuf setLong(int n2, long l2) {
        this.checkIndex0(n2, 8);
        this.unwrap().setLong(this.idx(n2), l2);
        return this;
    }

    @Override
    protected final void _setLong(int n2, long l2) {
        this.unwrap()._setLong(this.idx(n2), l2);
    }

    @Override
    public final ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkIndex0(n2, n4);
        this.unwrap().setBytes(this.idx(n2), byArray, n3, n4);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkIndex0(n2, n4);
        this.unwrap().setBytes(this.idx(n2), byteBuf, n3, n4);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        this.checkIndex0(n2, byteBuffer.remaining());
        this.unwrap().setBytes(this.idx(n2), byteBuffer);
        return this;
    }

    @Override
    public final int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) throws IOException {
        this.checkIndex0(n2, n3);
        return this.unwrap().getBytes(this.idx(n2), gatheringByteChannel, n3);
    }

    @Override
    public final int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) throws IOException {
        this.checkIndex0(n2, n3);
        return this.unwrap().setBytes(this.idx(n2), scatteringByteChannel, n3);
    }

    @Override
    public final int forEachByte(int n2, int n3, ByteProcessor byteProcessor) {
        this.checkIndex0(n2, n3);
        n2 = this.unwrap().forEachByte(this.idx(n2), n3, byteProcessor);
        if (n2 < this.adjustment) {
            return -1;
        }
        return n2 - this.adjustment;
    }

    private int idx(int n2) {
        return n2 + this.adjustment;
    }
}

