/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.PoolArena;
import com.appoptics.ext.io.netty.buffer.PoolChunk;
import com.appoptics.ext.io.netty.buffer.PooledByteBuf;
import com.appoptics.ext.io.netty.util.internal.MathUtil;
import com.appoptics.ext.io.netty.util.internal.ObjectPool;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PoolThreadCache {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PoolThreadCache.class);
    final PoolArena<byte[]> heapArena;
    final PoolArena<ByteBuffer> directArena;
    private final MemoryRegionCache<byte[]>[] tinySubPageHeapCaches;
    private final MemoryRegionCache<byte[]>[] smallSubPageHeapCaches;
    private final MemoryRegionCache<ByteBuffer>[] tinySubPageDirectCaches;
    private final MemoryRegionCache<ByteBuffer>[] smallSubPageDirectCaches;
    private final MemoryRegionCache<byte[]>[] normalHeapCaches;
    private final MemoryRegionCache<ByteBuffer>[] normalDirectCaches;
    private final int numShiftsNormalDirect;
    private final int numShiftsNormalHeap;
    private final int freeSweepAllocationThreshold;
    private final AtomicBoolean freed = new AtomicBoolean();
    private int allocations;

    PoolThreadCache(PoolArena<byte[]> poolArena, PoolArena<ByteBuffer> poolArena2, int n2, int n3, int n4, int n5, int n6) {
        ObjectUtil.checkPositiveOrZero(n5, "maxCachedBufferCapacity");
        this.freeSweepAllocationThreshold = n6;
        this.heapArena = poolArena;
        this.directArena = poolArena2;
        if (poolArena2 != null) {
            this.tinySubPageDirectCaches = PoolThreadCache.createSubPageCaches(n2, 32, PoolArena.SizeClass.Tiny);
            this.smallSubPageDirectCaches = PoolThreadCache.createSubPageCaches(n3, poolArena2.numSmallSubpagePools, PoolArena.SizeClass.Small);
            this.numShiftsNormalDirect = PoolThreadCache.log2(poolArena2.pageSize);
            this.normalDirectCaches = PoolThreadCache.createNormalCaches(n4, n5, poolArena2);
            poolArena2.numThreadCaches.getAndIncrement();
        } else {
            this.tinySubPageDirectCaches = null;
            this.smallSubPageDirectCaches = null;
            this.normalDirectCaches = null;
            this.numShiftsNormalDirect = -1;
        }
        if (poolArena != null) {
            this.tinySubPageHeapCaches = PoolThreadCache.createSubPageCaches(n2, 32, PoolArena.SizeClass.Tiny);
            this.smallSubPageHeapCaches = PoolThreadCache.createSubPageCaches(n3, poolArena.numSmallSubpagePools, PoolArena.SizeClass.Small);
            this.numShiftsNormalHeap = PoolThreadCache.log2(poolArena.pageSize);
            this.normalHeapCaches = PoolThreadCache.createNormalCaches(n4, n5, poolArena);
            poolArena.numThreadCaches.getAndIncrement();
        } else {
            this.tinySubPageHeapCaches = null;
            this.smallSubPageHeapCaches = null;
            this.normalHeapCaches = null;
            this.numShiftsNormalHeap = -1;
        }
        if ((this.tinySubPageDirectCaches != null || this.smallSubPageDirectCaches != null || this.normalDirectCaches != null || this.tinySubPageHeapCaches != null || this.smallSubPageHeapCaches != null || this.normalHeapCaches != null) && n6 <= 0) {
            throw new IllegalArgumentException("freeSweepAllocationThreshold: " + n6 + " (expected: > 0)");
        }
    }

    private static <T> MemoryRegionCache<T>[] createSubPageCaches(int n2, int n3, PoolArena.SizeClass sizeClass) {
        if (n2 > 0 && n3 > 0) {
            MemoryRegionCache[] memoryRegionCacheArray = new MemoryRegionCache[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                memoryRegionCacheArray[i2] = new SubPageMemoryRegionCache(n2, sizeClass);
            }
            return memoryRegionCacheArray;
        }
        return null;
    }

    private static <T> MemoryRegionCache<T>[] createNormalCaches(int n2, int n3, PoolArena<T> memoryRegionCacheArray) {
        if (n2 > 0 && n3 > 0) {
            n3 = Math.min(memoryRegionCacheArray.chunkSize, n3);
            n3 = Math.max(1, PoolThreadCache.log2(n3 / memoryRegionCacheArray.pageSize) + 1);
            memoryRegionCacheArray = new MemoryRegionCache[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                memoryRegionCacheArray[i2] = new NormalMemoryRegionCache(n2);
            }
            return memoryRegionCacheArray;
        }
        return null;
    }

    private static int log2(int n2) {
        return 31 - Integer.numberOfLeadingZeros(n2);
    }

    final boolean allocateTiny(PoolArena<?> poolArena, PooledByteBuf<?> pooledByteBuf, int n2, int n3) {
        PoolThreadCache poolThreadCache = this;
        return poolThreadCache.allocate(poolThreadCache.cacheForTiny(poolArena, n3), pooledByteBuf, n2);
    }

    final boolean allocateSmall(PoolArena<?> poolArena, PooledByteBuf<?> pooledByteBuf, int n2, int n3) {
        PoolThreadCache poolThreadCache = this;
        return poolThreadCache.allocate(poolThreadCache.cacheForSmall(poolArena, n3), pooledByteBuf, n2);
    }

    final boolean allocateNormal(PoolArena<?> poolArena, PooledByteBuf<?> pooledByteBuf, int n2, int n3) {
        PoolThreadCache poolThreadCache = this;
        return poolThreadCache.allocate(poolThreadCache.cacheForNormal(poolArena, n3), pooledByteBuf, n2);
    }

    private boolean allocate(MemoryRegionCache<?> memoryRegionCache, PooledByteBuf pooledByteBuf, int n2) {
        if (memoryRegionCache == null) {
            return false;
        }
        boolean bl = memoryRegionCache.allocate(pooledByteBuf, n2, this);
        if (++this.allocations >= this.freeSweepAllocationThreshold) {
            this.allocations = 0;
            this.trim();
        }
        return bl;
    }

    final boolean add(PoolArena<?> object, PoolChunk poolChunk, ByteBuffer byteBuffer, long l2, int n2, PoolArena.SizeClass sizeClass) {
        if ((object = this.cache((PoolArena<?>)object, n2, sizeClass)) == null) {
            return false;
        }
        return ((MemoryRegionCache)object).add(poolChunk, byteBuffer, l2);
    }

    private MemoryRegionCache<?> cache(PoolArena<?> poolArena, int n2, PoolArena.SizeClass sizeClass) {
        switch (sizeClass) {
            case Normal: {
                return this.cacheForNormal(poolArena, n2);
            }
            case Small: {
                return this.cacheForSmall(poolArena, n2);
            }
            case Tiny: {
                return this.cacheForTiny(poolArena, n2);
            }
        }
        throw new Error();
    }

    protected final void finalize() throws Throwable {
        try {
            super.finalize();
            return;
        }
        finally {
            this.free(true);
        }
    }

    final void free(boolean n2) {
        if (this.freed.compareAndSet(false, true)) {
            if ((n2 = PoolThreadCache.free(this.tinySubPageDirectCaches, n2 != 0) + PoolThreadCache.free(this.smallSubPageDirectCaches, n2 != 0) + PoolThreadCache.free(this.normalDirectCaches, n2 != 0) + PoolThreadCache.free(this.tinySubPageHeapCaches, n2 != 0) + PoolThreadCache.free(this.smallSubPageHeapCaches, n2 != 0) + PoolThreadCache.free(this.normalHeapCaches, n2 != 0)) > 0 && logger.isDebugEnabled()) {
                logger.debug("Freed {} thread-local buffer(s) from thread: {}", (Object)n2, (Object)Thread.currentThread().getName());
            }
            if (this.directArena != null) {
                this.directArena.numThreadCaches.getAndDecrement();
            }
            if (this.heapArena != null) {
                this.heapArena.numThreadCaches.getAndDecrement();
            }
        }
    }

    private static int free(MemoryRegionCache<?>[] memoryRegionCacheArray, boolean bl) {
        if (memoryRegionCacheArray == null) {
            return 0;
        }
        int n2 = 0;
        for (MemoryRegionCache<?> memoryRegionCache : memoryRegionCacheArray) {
            n2 += PoolThreadCache.free(memoryRegionCache, bl);
        }
        return n2;
    }

    private static int free(MemoryRegionCache<?> memoryRegionCache, boolean bl) {
        if (memoryRegionCache == null) {
            return 0;
        }
        return memoryRegionCache.free(bl);
    }

    final void trim() {
        PoolThreadCache.trim(this.tinySubPageDirectCaches);
        PoolThreadCache.trim(this.smallSubPageDirectCaches);
        PoolThreadCache.trim(this.normalDirectCaches);
        PoolThreadCache.trim(this.tinySubPageHeapCaches);
        PoolThreadCache.trim(this.smallSubPageHeapCaches);
        PoolThreadCache.trim(this.normalHeapCaches);
    }

    private static void trim(MemoryRegionCache<?>[] memoryRegionCacheArray) {
        if (memoryRegionCacheArray == null) {
            return;
        }
        for (MemoryRegionCache<?> memoryRegionCache : memoryRegionCacheArray) {
            PoolThreadCache.trim(memoryRegionCache);
        }
    }

    private static void trim(MemoryRegionCache<?> memoryRegionCache) {
        if (memoryRegionCache == null) {
            return;
        }
        memoryRegionCache.trim();
    }

    private MemoryRegionCache<?> cacheForTiny(PoolArena<?> poolArena, int n2) {
        n2 = PoolArena.tinyIdx(n2);
        if (poolArena.isDirect()) {
            return PoolThreadCache.cache(this.tinySubPageDirectCaches, n2);
        }
        return PoolThreadCache.cache(this.tinySubPageHeapCaches, n2);
    }

    private MemoryRegionCache<?> cacheForSmall(PoolArena<?> poolArena, int n2) {
        n2 = PoolArena.smallIdx(n2);
        if (poolArena.isDirect()) {
            return PoolThreadCache.cache(this.smallSubPageDirectCaches, n2);
        }
        return PoolThreadCache.cache(this.smallSubPageHeapCaches, n2);
    }

    private MemoryRegionCache<?> cacheForNormal(PoolArena<?> poolArena, int n2) {
        if (poolArena.isDirect()) {
            int n3 = PoolThreadCache.log2(n2 >> this.numShiftsNormalDirect);
            return PoolThreadCache.cache(this.normalDirectCaches, n3);
        }
        int n4 = PoolThreadCache.log2(n2 >> this.numShiftsNormalHeap);
        return PoolThreadCache.cache(this.normalHeapCaches, n4);
    }

    private static <T> MemoryRegionCache<T> cache(MemoryRegionCache<T>[] memoryRegionCacheArray, int n2) {
        if (memoryRegionCacheArray == null || n2 > memoryRegionCacheArray.length - 1) {
            return null;
        }
        return memoryRegionCacheArray[n2];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MemoryRegionCache<T> {
        private final int size;
        private final Queue<Entry<T>> queue;
        private final PoolArena.SizeClass sizeClass;
        private int allocations;
        private static final ObjectPool<Entry> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<Entry>(){

            @Override
            public final Entry newObject(ObjectPool.Handle<Entry> handle) {
                return new Entry(handle);
            }
        });

        MemoryRegionCache(int n2, PoolArena.SizeClass sizeClass) {
            this.size = MathUtil.safeFindNextPositivePowerOfTwo(n2);
            this.queue = PlatformDependent.newFixedMpscQueue(this.size);
            this.sizeClass = sizeClass;
        }

        protected abstract void initBuf(PoolChunk<T> var1, ByteBuffer var2, long var3, PooledByteBuf<T> var5, int var6, PoolThreadCache var7);

        public final boolean add(PoolChunk<T> object, ByteBuffer byteBuffer, long l2) {
            boolean bl = this.queue.offer((Entry<T>)(object = MemoryRegionCache.newEntry(object, byteBuffer, l2)));
            if (!bl) {
                ((Entry)object).recycle();
            }
            return bl;
        }

        public final boolean allocate(PooledByteBuf<T> pooledByteBuf, int n2, PoolThreadCache poolThreadCache) {
            Entry<T> entry = this.queue.poll();
            if (entry == null) {
                return false;
            }
            this.initBuf(entry.chunk, entry.nioBuffer, entry.handle, pooledByteBuf, n2, poolThreadCache);
            entry.recycle();
            ++this.allocations;
            return true;
        }

        public final int free(boolean bl) {
            return this.free(Integer.MAX_VALUE, bl);
        }

        private int free(int n2, boolean bl) {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                Entry<T> entry = this.queue.poll();
                if (entry == null) {
                    return n3;
                }
                this.freeEntry(entry, bl);
            }
            return n3;
        }

        public final void trim() {
            int n2 = this.size - this.allocations;
            this.allocations = 0;
            if (n2 > 0) {
                this.free(n2, false);
            }
        }

        private void freeEntry(Entry entry, boolean bl) {
            PoolChunk poolChunk = entry.chunk;
            long l2 = entry.handle;
            ByteBuffer byteBuffer = entry.nioBuffer;
            if (!bl) {
                entry.recycle();
            }
            poolChunk.arena.freeChunk(poolChunk, l2, this.sizeClass, byteBuffer, bl);
        }

        private static Entry newEntry(PoolChunk<?> poolChunk, ByteBuffer byteBuffer, long l2) {
            Entry entry = RECYCLER.get();
            RECYCLER.get().chunk = poolChunk;
            entry.nioBuffer = byteBuffer;
            entry.handle = l2;
            return entry;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class Entry<T> {
            final ObjectPool.Handle<Entry<?>> recyclerHandle;
            PoolChunk<T> chunk;
            ByteBuffer nioBuffer;
            long handle = -1L;

            Entry(ObjectPool.Handle<Entry<?>> handle) {
                this.recyclerHandle = handle;
            }

            final void recycle() {
                this.chunk = null;
                this.nioBuffer = null;
                this.handle = -1L;
                this.recyclerHandle.recycle(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NormalMemoryRegionCache<T>
    extends MemoryRegionCache<T> {
        NormalMemoryRegionCache(int n2) {
            super(n2, PoolArena.SizeClass.Normal);
        }

        @Override
        protected final void initBuf(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l2, PooledByteBuf<T> pooledByteBuf, int n2, PoolThreadCache poolThreadCache) {
            poolChunk.initBuf(pooledByteBuf, byteBuffer, l2, n2, poolThreadCache);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SubPageMemoryRegionCache<T>
    extends MemoryRegionCache<T> {
        SubPageMemoryRegionCache(int n2, PoolArena.SizeClass sizeClass) {
            super(n2, sizeClass);
        }

        @Override
        protected final void initBuf(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l2, PooledByteBuf<T> pooledByteBuf, int n2, PoolThreadCache poolThreadCache) {
            poolChunk.initBufWithSubpage(pooledByteBuf, byteBuffer, l2, n2, poolThreadCache);
        }
    }
}

