/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.PoolChunk;
import com.appoptics.ext.io.netty.buffer.PoolChunkList;
import com.appoptics.ext.io.netty.buffer.PoolChunkListMetric;
import com.appoptics.ext.io.netty.buffer.PoolChunkMetric;
import com.appoptics.ext.io.netty.buffer.PoolSubpage;
import com.appoptics.ext.io.netty.buffer.PoolThreadCache;
import com.appoptics.ext.io.netty.buffer.PooledByteBuf;
import com.appoptics.ext.io.netty.buffer.PooledByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.PooledDirectByteBuf;
import com.appoptics.ext.io.netty.buffer.PooledHeapByteBuf;
import com.appoptics.ext.io.netty.buffer.PooledUnsafeDirectByteBuf;
import com.appoptics.ext.io.netty.buffer.PooledUnsafeHeapByteBuf;
import com.appoptics.ext.io.netty.util.internal.LongCounter;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PoolArena<T> {
    static final boolean HAS_UNSAFE = PlatformDependent.hasUnsafe();
    final PooledByteBufAllocator parent;
    private final int maxOrder;
    final int pageSize;
    final int pageShifts;
    final int chunkSize;
    final int subpageOverflowMask;
    final int numSmallSubpagePools;
    final int directMemoryCacheAlignment;
    final int directMemoryCacheAlignmentMask;
    private final PoolSubpage<T>[] tinySubpagePools;
    private final PoolSubpage<T>[] smallSubpagePools;
    private final PoolChunkList<T> q050;
    private final PoolChunkList<T> q025;
    private final PoolChunkList<T> q000;
    private final PoolChunkList<T> qInit;
    private final PoolChunkList<T> q075;
    private final PoolChunkList<T> q100;
    private final List<PoolChunkListMetric> chunkListMetrics;
    private long allocationsNormal;
    private final LongCounter allocationsTiny = PlatformDependent.newLongCounter();
    private final LongCounter allocationsSmall = PlatformDependent.newLongCounter();
    private final LongCounter allocationsHuge = PlatformDependent.newLongCounter();
    private final LongCounter activeBytesHuge = PlatformDependent.newLongCounter();
    private long deallocationsTiny;
    private long deallocationsSmall;
    private long deallocationsNormal;
    private final LongCounter deallocationsHuge = PlatformDependent.newLongCounter();
    final AtomicInteger numThreadCaches = new AtomicInteger();

    protected PoolArena(PooledByteBufAllocator pooledByteBufAllocator, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        this.parent = pooledByteBufAllocator;
        this.pageSize = n2;
        this.maxOrder = n3;
        this.pageShifts = n4;
        this.chunkSize = n5;
        this.directMemoryCacheAlignment = n6;
        this.directMemoryCacheAlignmentMask = n6 - 1;
        this.subpageOverflowMask = ~(n2 - 1);
        this.tinySubpagePools = this.newSubpagePoolArray(32);
        for (n7 = 0; n7 < this.tinySubpagePools.length; ++n7) {
            this.tinySubpagePools[n7] = this.newSubpagePoolHead(n2);
        }
        this.numSmallSubpagePools = n4 - 9;
        this.smallSubpagePools = this.newSubpagePoolArray(this.numSmallSubpagePools);
        for (n7 = 0; n7 < this.smallSubpagePools.length; ++n7) {
            this.smallSubpagePools[n7] = this.newSubpagePoolHead(n2);
        }
        this.q100 = new PoolChunkList(this, null, 100, Integer.MAX_VALUE, n5);
        PoolArena poolArena = this;
        this.q075 = new PoolChunkList<T>(poolArena, poolArena.q100, 75, 100, n5);
        PoolArena poolArena2 = this;
        this.q050 = new PoolChunkList<T>(poolArena2, poolArena2.q075, 50, 100, n5);
        PoolArena poolArena3 = this;
        this.q025 = new PoolChunkList<T>(poolArena3, poolArena3.q050, 25, 75, n5);
        PoolArena poolArena4 = this;
        this.q000 = new PoolChunkList<T>(poolArena4, poolArena4.q025, 1, 50, n5);
        PoolArena poolArena5 = this;
        this.qInit = new PoolChunkList<T>(poolArena5, poolArena5.q000, Integer.MIN_VALUE, 25, n5);
        this.q100.prevList(this.q075);
        this.q075.prevList(this.q050);
        this.q050.prevList(this.q025);
        this.q025.prevList(this.q000);
        this.q000.prevList(null);
        this.qInit.prevList(this.qInit);
        ArrayList<PoolChunkList<T>> arrayList = new ArrayList<PoolChunkList<T>>(6);
        arrayList.add(this.qInit);
        arrayList.add(this.q000);
        arrayList.add(this.q025);
        arrayList.add(this.q050);
        arrayList.add(this.q075);
        arrayList.add(this.q100);
        this.chunkListMetrics = Collections.unmodifiableList(arrayList);
    }

    private PoolSubpage<T> newSubpagePoolHead(int n2) {
        PoolSubpage poolSubpage = new PoolSubpage(n2);
        new PoolSubpage(n2).prev = poolSubpage;
        poolSubpage.next = poolSubpage;
        return poolSubpage;
    }

    private PoolSubpage<T>[] newSubpagePoolArray(int n2) {
        return new PoolSubpage[n2];
    }

    abstract boolean isDirect();

    PooledByteBuf<T> allocate(PoolThreadCache poolThreadCache, int n2, int n3) {
        PooledByteBuf<T> pooledByteBuf = this.newByteBuf(n3);
        this.allocate(poolThreadCache, pooledByteBuf, n2);
        return pooledByteBuf;
    }

    static int tinyIdx(int n2) {
        return n2 >>> 4;
    }

    static int smallIdx(int n2) {
        int n3 = 0;
        n2 >>>= 10;
        while (n2 != 0) {
            n2 >>>= 1;
            ++n3;
        }
        return n3;
    }

    boolean isTinyOrSmall(int n2) {
        return (n2 & this.subpageOverflowMask) == 0;
    }

    static boolean isTiny(int n2) {
        return (n2 & 0xFFFFFE00) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocate(PoolThreadCache poolThreadCache, PooledByteBuf<T> pooledByteBuf, int n2) {
        int n3 = this.normalizeCapacity(n2);
        if (this.isTinyOrSmall(n3)) {
            Object object;
            int n4;
            boolean bl = PoolArena.isTiny(n3);
            if (bl) {
                if (poolThreadCache.allocateTiny(this, pooledByteBuf, n2, n3)) {
                    return;
                }
                n4 = PoolArena.tinyIdx(n3);
                object = this.tinySubpagePools;
            } else {
                if (poolThreadCache.allocateSmall(this, pooledByteBuf, n2, n3)) {
                    return;
                }
                n4 = PoolArena.smallIdx(n3);
                object = this.smallSubpagePools;
            }
            PoolSubpage<T> poolSubpage = object[n4];
            object = poolSubpage;
            synchronized (poolSubpage) {
                PoolSubpage poolSubpage2 = poolSubpage.next;
                if (poolSubpage2 != poolSubpage) {
                    assert (poolSubpage2.doNotDestroy && poolSubpage2.elemSize == n3);
                    long l2 = poolSubpage2.allocate();
                    assert (l2 >= 0L);
                    poolSubpage2.chunk.initBufWithSubpage(pooledByteBuf, null, l2, n2, poolThreadCache);
                    this.incTinySmallAllocation(bl);
                    // ** MonitorExit[var6_12 /* !! */ ] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var6_12 /* !! */ ] (shouldn't be in output)
                object = this;
                synchronized (object) {
                    this.allocateNormal(pooledByteBuf, n2, n3, poolThreadCache);
                }
                this.incTinySmallAllocation(bl);
                return;
            }
        }
        if (n3 <= this.chunkSize) {
            if (poolThreadCache.allocateNormal(this, pooledByteBuf, n2, n3)) {
                return;
            }
            PoolArena poolArena = this;
            synchronized (poolArena) {
                this.allocateNormal(pooledByteBuf, n2, n3, poolThreadCache);
                ++this.allocationsNormal;
            }
        } else {
            this.allocateHuge(pooledByteBuf, n2);
        }
    }

    private void allocateNormal(PooledByteBuf<T> pooledByteBuf, int n2, int n3, PoolThreadCache poolThreadCache) {
        if (this.q050.allocate(pooledByteBuf, n2, n3, poolThreadCache) || this.q025.allocate(pooledByteBuf, n2, n3, poolThreadCache) || this.q000.allocate(pooledByteBuf, n2, n3, poolThreadCache) || this.qInit.allocate(pooledByteBuf, n2, n3, poolThreadCache) || this.q075.allocate(pooledByteBuf, n2, n3, poolThreadCache)) {
            return;
        }
        PoolArena poolArena = this;
        PoolChunk<T> poolChunk = poolArena.newChunk(poolArena.pageSize, this.maxOrder, this.pageShifts, this.chunkSize);
        boolean bl = poolChunk.allocate(pooledByteBuf, n2, n3, poolThreadCache);
        assert (bl);
        this.qInit.add(poolChunk);
    }

    private void incTinySmallAllocation(boolean bl) {
        if (bl) {
            this.allocationsTiny.increment();
            return;
        }
        this.allocationsSmall.increment();
    }

    private void allocateHuge(PooledByteBuf<T> pooledByteBuf, int n2) {
        PoolChunk<T> poolChunk = this.newUnpooledChunk(n2);
        this.activeBytesHuge.add(poolChunk.chunkSize());
        pooledByteBuf.initUnpooled(poolChunk, n2);
        this.allocationsHuge.increment();
    }

    void free(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l2, int n2, PoolThreadCache poolThreadCache) {
        if (poolChunk.unpooled) {
            int n3 = poolChunk.chunkSize();
            this.destroyChunk(poolChunk);
            this.activeBytesHuge.add(-n3);
            this.deallocationsHuge.increment();
            return;
        }
        SizeClass sizeClass = this.sizeClass(n2);
        if (poolThreadCache != null && poolThreadCache.add(this, poolChunk, byteBuffer, l2, n2, sizeClass)) {
            return;
        }
        this.freeChunk(poolChunk, l2, sizeClass, byteBuffer, false);
    }

    private SizeClass sizeClass(int n2) {
        if (!this.isTinyOrSmall(n2)) {
            return SizeClass.Normal;
        }
        if (PoolArena.isTiny(n2)) {
            return SizeClass.Tiny;
        }
        return SizeClass.Small;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeChunk(PoolChunk<T> poolChunk, long l2, SizeClass sizeClass, ByteBuffer byteBuffer, boolean bl) {
        boolean bl2;
        PoolArena poolArena = this;
        synchronized (poolArena) {
            if (!bl) {
                switch (sizeClass) {
                    case Normal: {
                        ++this.deallocationsNormal;
                        break;
                    }
                    case Small: {
                        ++this.deallocationsSmall;
                        break;
                    }
                    case Tiny: {
                        ++this.deallocationsTiny;
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            bl2 = !poolChunk.parent.free(poolChunk, l2, byteBuffer);
        }
        if (bl2) {
            this.destroyChunk(poolChunk);
        }
    }

    PoolSubpage<T> findSubpagePoolHead(int n2) {
        PoolSubpage<T>[] poolSubpageArray;
        if (PoolArena.isTiny(n2)) {
            n2 = PoolArena.tinyIdx(n2);
            poolSubpageArray = this.tinySubpagePools;
        } else {
            n2 = PoolArena.smallIdx(n2);
            poolSubpageArray = this.smallSubpagePools;
        }
        return poolSubpageArray[n2];
    }

    int normalizeCapacity(int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "reqCapacity");
        if (n2 >= this.chunkSize) {
            if (this.directMemoryCacheAlignment == 0) {
                return n2;
            }
            return this.alignCapacity(n2);
        }
        if (!PoolArena.isTiny(n2)) {
            int n3 = --n2;
            n2 = n3 | n3 >>> 1;
            n2 |= n2 >>> 2;
            n2 |= n2 >>> 4;
            n2 |= n2 >>> 8;
            n2 |= n2 >>> 16;
            if (++n2 < 0) {
                n2 >>>= 1;
            }
            assert (this.directMemoryCacheAlignment == 0 || (n2 & this.directMemoryCacheAlignmentMask) == 0);
            return n2;
        }
        if (this.directMemoryCacheAlignment > 0) {
            return this.alignCapacity(n2);
        }
        if ((n2 & 0xF) == 0) {
            return n2;
        }
        return (n2 & 0xFFFFFFF0) + 16;
    }

    int alignCapacity(int n2) {
        int n3 = n2 & this.directMemoryCacheAlignmentMask;
        if (n3 == 0) {
            return n2;
        }
        return n2 + this.directMemoryCacheAlignment - n3;
    }

    void reallocate(PooledByteBuf<T> pooledByteBuf, int n2, boolean bl) {
        assert (n2 >= 0 && n2 <= pooledByteBuf.maxCapacity());
        int n3 = pooledByteBuf.length;
        if (n3 == n2) {
            return;
        }
        PoolChunk poolChunk = pooledByteBuf.chunk;
        ByteBuffer byteBuffer = pooledByteBuf.tmpNioBuf;
        long l2 = pooledByteBuf.handle;
        Object t2 = pooledByteBuf.memory;
        int n4 = pooledByteBuf.offset;
        int n5 = pooledByteBuf.maxLength;
        PoolArena poolArena = this;
        poolArena.allocate(poolArena.parent.threadCache(), pooledByteBuf, n2);
        if (n2 > n3) {
            n2 = n3;
        } else {
            pooledByteBuf.trimIndicesToCapacity(n2);
        }
        this.memoryCopy(t2, n4, pooledByteBuf, n2);
        if (bl) {
            this.free(poolChunk, byteBuffer, l2, n5, pooledByteBuf.cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long numActiveBytes() {
        long l2 = this.activeBytesHuge.value();
        PoolArena poolArena = this;
        synchronized (poolArena) {
            for (int i2 = 0; i2 < this.chunkListMetrics.size(); ++i2) {
                for (PoolChunkMetric poolChunkMetric : this.chunkListMetrics.get(i2)) {
                    l2 += (long)poolChunkMetric.chunkSize();
                }
            }
        }
        return Math.max(0L, l2);
    }

    protected abstract PoolChunk<T> newChunk(int var1, int var2, int var3, int var4);

    protected abstract PoolChunk<T> newUnpooledChunk(int var1);

    protected abstract PooledByteBuf<T> newByteBuf(int var1);

    protected abstract void memoryCopy(T var1, int var2, PooledByteBuf<T> var3, int var4);

    protected abstract void destroyChunk(PoolChunk<T> var1);

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder("Chunk(s) at 0~25%:").append(StringUtil.NEWLINE).append(this.qInit).append(StringUtil.NEWLINE).append("Chunk(s) at 0~50%:").append(StringUtil.NEWLINE).append(this.q000).append(StringUtil.NEWLINE).append("Chunk(s) at 25~75%:").append(StringUtil.NEWLINE).append(this.q025).append(StringUtil.NEWLINE).append("Chunk(s) at 50~100%:").append(StringUtil.NEWLINE).append(this.q050).append(StringUtil.NEWLINE).append("Chunk(s) at 75~100%:").append(StringUtil.NEWLINE).append(this.q075).append(StringUtil.NEWLINE).append("Chunk(s) at 100%:").append(StringUtil.NEWLINE).append(this.q100).append(StringUtil.NEWLINE).append("tiny subpages:");
        PoolArena.appendPoolSubPages(stringBuilder, this.tinySubpagePools);
        stringBuilder.append(StringUtil.NEWLINE).append("small subpages:");
        PoolArena.appendPoolSubPages(stringBuilder, this.smallSubpagePools);
        stringBuilder.append(StringUtil.NEWLINE);
        return stringBuilder.toString();
    }

    private static void appendPoolSubPages(StringBuilder stringBuilder, PoolSubpage<?>[] poolSubpageArray) {
        for (int i2 = 0; i2 < poolSubpageArray.length; ++i2) {
            PoolSubpage<?> poolSubpage = poolSubpageArray[i2];
            if (poolSubpage.next == poolSubpage) continue;
            stringBuilder.append(StringUtil.NEWLINE).append(i2).append(": ");
            PoolSubpage poolSubpage2 = poolSubpage.next;
            do {
                stringBuilder.append(poolSubpage2);
            } while ((poolSubpage2 = poolSubpage2.next) != poolSubpage);
        }
    }

    protected final void finalize() throws Throwable {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            PoolArena.destroyPoolSubPages(this.smallSubpagePools);
            PoolArena.destroyPoolSubPages(this.tinySubpagePools);
            this.destroyPoolChunkLists(this.qInit, this.q000, this.q025, this.q050, this.q075, this.q100);
            throw throwable;
        }
        PoolArena.destroyPoolSubPages(this.smallSubpagePools);
        PoolArena.destroyPoolSubPages(this.tinySubpagePools);
        this.destroyPoolChunkLists(this.qInit, this.q000, this.q025, this.q050, this.q075, this.q100);
    }

    private static void destroyPoolSubPages(PoolSubpage<?>[] poolSubpageArray) {
        for (PoolSubpage<?> poolSubpage : poolSubpageArray) {
            poolSubpage.destroy();
        }
    }

    private void destroyPoolChunkLists(PoolChunkList<T> ... poolChunkListArray) {
        for (PoolChunkList<T> poolChunkList : poolChunkListArray) {
            poolChunkList.destroy(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DirectArena
    extends PoolArena<ByteBuffer> {
        DirectArena(PooledByteBufAllocator pooledByteBufAllocator, int n2, int n3, int n4, int n5, int n6) {
            super(pooledByteBufAllocator, n2, n3, n4, n5, n6);
        }

        @Override
        final boolean isDirect() {
            return true;
        }

        final int offsetCacheLine(ByteBuffer byteBuffer) {
            int n2 = HAS_UNSAFE ? (int)(PlatformDependent.directBufferAddress(byteBuffer) & (long)this.directMemoryCacheAlignmentMask) : 0;
            return this.directMemoryCacheAlignment - n2;
        }

        @Override
        protected final PoolChunk<ByteBuffer> newChunk(int n2, int n3, int n4, int n5) {
            if (this.directMemoryCacheAlignment == 0) {
                return new PoolChunk<ByteBuffer>(this, DirectArena.allocateDirect(n5), n2, n3, n4, n5, 0);
            }
            ByteBuffer byteBuffer = DirectArena.allocateDirect(n5 + this.directMemoryCacheAlignment);
            return new PoolChunk<ByteBuffer>(this, byteBuffer, n2, n3, n4, n5, this.offsetCacheLine(byteBuffer));
        }

        @Override
        protected final PoolChunk<ByteBuffer> newUnpooledChunk(int n2) {
            if (this.directMemoryCacheAlignment == 0) {
                return new PoolChunk<ByteBuffer>(this, DirectArena.allocateDirect(n2), n2, 0);
            }
            ByteBuffer byteBuffer = DirectArena.allocateDirect(n2 + this.directMemoryCacheAlignment);
            return new PoolChunk<ByteBuffer>(this, byteBuffer, n2, this.offsetCacheLine(byteBuffer));
        }

        private static ByteBuffer allocateDirect(int n2) {
            if (PlatformDependent.useDirectBufferNoCleaner()) {
                return PlatformDependent.allocateDirectNoCleaner(n2);
            }
            return ByteBuffer.allocateDirect(n2);
        }

        @Override
        protected final void destroyChunk(PoolChunk<ByteBuffer> poolChunk) {
            if (PlatformDependent.useDirectBufferNoCleaner()) {
                PlatformDependent.freeDirectNoCleaner((ByteBuffer)poolChunk.memory);
                return;
            }
            PlatformDependent.freeDirectBuffer((ByteBuffer)poolChunk.memory);
        }

        @Override
        protected final PooledByteBuf<ByteBuffer> newByteBuf(int n2) {
            if (HAS_UNSAFE) {
                return PooledUnsafeDirectByteBuf.newInstance(n2);
            }
            return PooledDirectByteBuf.newInstance(n2);
        }

        @Override
        protected final void memoryCopy(ByteBuffer byteBuffer, int n2, PooledByteBuf<ByteBuffer> pooledByteBuf, int n3) {
            if (n3 == 0) {
                return;
            }
            if (HAS_UNSAFE) {
                PlatformDependent.copyMemory(PlatformDependent.directBufferAddress(byteBuffer) + (long)n2, PlatformDependent.directBufferAddress((ByteBuffer)pooledByteBuf.memory) + (long)pooledByteBuf.offset, n3);
                return;
            }
            byteBuffer = byteBuffer.duplicate();
            ByteBuffer byteBuffer2 = pooledByteBuf.internalNioBuffer();
            byteBuffer.position(n2).limit(n2 + n3);
            byteBuffer2.position(pooledByteBuf.offset);
            byteBuffer2.put(byteBuffer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class HeapArena
    extends PoolArena<byte[]> {
        HeapArena(PooledByteBufAllocator pooledByteBufAllocator, int n2, int n3, int n4, int n5, int n6) {
            super(pooledByteBufAllocator, n2, n3, n4, n5, n6);
        }

        private static byte[] newByteArray(int n2) {
            return PlatformDependent.allocateUninitializedArray(n2);
        }

        @Override
        final boolean isDirect() {
            return false;
        }

        @Override
        protected final PoolChunk<byte[]> newChunk(int n2, int n3, int n4, int n5) {
            return new PoolChunk<byte[]>(this, HeapArena.newByteArray(n5), n2, n3, n4, n5, 0);
        }

        @Override
        protected final PoolChunk<byte[]> newUnpooledChunk(int n2) {
            return new PoolChunk<byte[]>(this, HeapArena.newByteArray(n2), n2, 0);
        }

        @Override
        protected final void destroyChunk(PoolChunk<byte[]> poolChunk) {
        }

        @Override
        protected final PooledByteBuf<byte[]> newByteBuf(int n2) {
            if (HAS_UNSAFE) {
                return PooledUnsafeHeapByteBuf.newUnsafeInstance(n2);
            }
            return PooledHeapByteBuf.newInstance(n2);
        }

        @Override
        protected final void memoryCopy(byte[] byArray, int n2, PooledByteBuf<byte[]> pooledByteBuf, int n3) {
            if (n3 == 0) {
                return;
            }
            System.arraycopy(byArray, n2, pooledByteBuf.memory, pooledByteBuf.offset, n3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SizeClass {
        Tiny,
        Small,
        Normal;

    }
}

