/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufHolder;
import com.appoptics.ext.io.netty.util.IllegalReferenceCountException;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.StringUtil;

public class DefaultByteBufHolder
implements ByteBufHolder {
    private final ByteBuf data;

    public DefaultByteBufHolder(ByteBuf byteBuf) {
        this.data = ObjectUtil.checkNotNull(byteBuf, "data");
    }

    public ByteBuf content() {
        if (this.data.refCnt() <= 0) {
            throw new IllegalReferenceCountException(this.data.refCnt());
        }
        return this.data;
    }

    public ByteBufHolder retainedDuplicate() {
        DefaultByteBufHolder defaultByteBufHolder = this;
        return defaultByteBufHolder.replace(defaultByteBufHolder.data.retainedDuplicate());
    }

    public ByteBufHolder replace(ByteBuf byteBuf) {
        return new DefaultByteBufHolder(byteBuf);
    }

    public int refCnt() {
        return this.data.refCnt();
    }

    public ByteBufHolder retain() {
        this.data.retain();
        return this;
    }

    public ByteBufHolder touch() {
        this.data.touch();
        return this;
    }

    public ByteBufHolder touch(Object object) {
        this.data.touch(object);
        return this;
    }

    public boolean release() {
        return this.data.release();
    }

    protected final String contentToString() {
        return this.data.toString();
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + '(' + this.contentToString() + ')';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            return this.data.equals(((DefaultByteBufHolder)object).data);
        }
        return false;
    }

    public int hashCode() {
        return this.data.hashCode();
    }
}

