/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.bootstrap;

import com.appoptics.ext.io.netty.bootstrap.AbstractBootstrap;
import com.appoptics.ext.io.netty.bootstrap.BootstrapConfig;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelPipeline;
import com.appoptics.ext.io.netty.resolver.AddressResolverGroup;
import com.appoptics.ext.io.netty.resolver.DefaultAddressResolverGroup;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bootstrap
extends AbstractBootstrap<Bootstrap, Channel> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Bootstrap.class);
    private static final AddressResolverGroup<?> DEFAULT_RESOLVER = DefaultAddressResolverGroup.INSTANCE;
    private final BootstrapConfig config = new BootstrapConfig(this);
    private volatile AddressResolverGroup<SocketAddress> resolver = DEFAULT_RESOLVER;
    private volatile SocketAddress remoteAddress;

    public Bootstrap() {
    }

    private Bootstrap(Bootstrap bootstrap) {
        super(bootstrap);
        this.resolver = bootstrap.resolver;
        this.remoteAddress = bootstrap.remoteAddress;
    }

    @Override
    void init(Channel channel) {
        ChannelPipeline channelPipeline = channel.pipeline();
        channelPipeline.addLast(this.config.handler());
        Bootstrap.setChannelOptions(channel, this.newOptionsArray(), logger);
        Bootstrap.setAttributes(channel, this.attrs0().entrySet().toArray(EMPTY_ATTRIBUTE_ARRAY));
    }

    @Override
    public Bootstrap validate() {
        super.validate();
        if (this.config.handler() == null) {
            throw new IllegalStateException("handler not set");
        }
        return this;
    }

    @Override
    public Bootstrap clone() {
        return new Bootstrap(this);
    }

    public final BootstrapConfig config() {
        return this.config;
    }

    final SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    final AddressResolverGroup<?> resolver() {
        return this.resolver;
    }
}

