/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.util;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.Attributes;
import com.appoptics.ext.io.grpc.ConnectivityState;
import com.appoptics.ext.io.grpc.ConnectivityStateInfo;
import com.appoptics.ext.io.grpc.EquivalentAddressGroup;
import com.appoptics.ext.io.grpc.LoadBalancer;
import com.appoptics.ext.io.grpc.Status;
import com.tracelytics.a.d.a.a.d;
import com.tracelytics.a.d.a.a.g;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RoundRobinLoadBalancer
extends LoadBalancer {
    static final Attributes.Key<Ref<ConnectivityStateInfo>> STATE_INFO = Attributes.Key.create("state-info");
    private final LoadBalancer.Helper helper;
    private final Map<EquivalentAddressGroup, LoadBalancer.Subchannel> subchannels = new HashMap<EquivalentAddressGroup, LoadBalancer.Subchannel>();
    private final Random random;
    private ConnectivityState currentState;
    private RoundRobinPicker currentPicker = new EmptyPicker(EMPTY_OK);
    private static final Status EMPTY_OK = Status.OK.withDescription("no subchannels ready");

    RoundRobinLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = b.a(helper, (Object)"helper");
        this.random = new Random();
    }

    @Override
    public final void handleResolvedAddresses(LoadBalancer.ResolvedAddresses arrayList) {
        arrayList = ((LoadBalancer.ResolvedAddresses)arrayList).getAddresses();
        Set<EquivalentAddressGroup> set = this.subchannels.keySet();
        arrayList = RoundRobinLoadBalancer.stripAttrs(arrayList);
        set = RoundRobinLoadBalancer.setsDifference(set, arrayList.keySet());
        for (Map.Entry entry : arrayList.entrySet()) {
            EquivalentAddressGroup equivalentAddressGroup = (EquivalentAddressGroup)entry.getKey();
            EquivalentAddressGroup equivalentAddressGroup2 = (EquivalentAddressGroup)entry.getValue();
            Object object = this.subchannels.get(equivalentAddressGroup);
            if (object != null) {
                ((LoadBalancer.Subchannel)object).updateAddresses(Collections.singletonList(equivalentAddressGroup2));
                continue;
            }
            object = Attributes.newBuilder().set(STATE_INFO, new Ref<ConnectivityStateInfo>(ConnectivityStateInfo.forNonError(ConnectivityState.IDLE)));
            final LoadBalancer.Subchannel subchannel = b.a(this.helper.createSubchannel(LoadBalancer.CreateSubchannelArgs.newBuilder().setAddresses(equivalentAddressGroup2).setAttributes(((Attributes.Builder)object).build()).build()), (Object)"subchannel");
            subchannel.start(new LoadBalancer.SubchannelStateListener(){

                public void onSubchannelState(ConnectivityStateInfo connectivityStateInfo) {
                    RoundRobinLoadBalancer.this.processSubchannelState(subchannel, connectivityStateInfo);
                }
            });
            this.subchannels.put(equivalentAddressGroup, subchannel);
            subchannel.requestConnection();
        }
        arrayList = new ArrayList();
        for (EquivalentAddressGroup equivalentAddressGroup : set) {
            ((ArrayList)arrayList).add(this.subchannels.remove(equivalentAddressGroup));
        }
        this.updateBalancingState();
        Iterator iterator = ((ArrayList)arrayList).iterator();
        while (iterator.hasNext()) {
            LoadBalancer.Subchannel subchannel = (LoadBalancer.Subchannel)iterator.next();
            this.shutdownSubchannel(subchannel);
        }
    }

    @Override
    public final void handleNameResolutionError(Status status) {
        if (this.currentState != ConnectivityState.READY) {
            this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new EmptyPicker(status));
        }
    }

    private void processSubchannelState(LoadBalancer.Subchannel object, ConnectivityStateInfo connectivityStateInfo) {
        if (this.subchannels.get(RoundRobinLoadBalancer.stripAttrs(((LoadBalancer.Subchannel)object).getAddresses())) != object) {
            return;
        }
        if (connectivityStateInfo.getState() == ConnectivityState.IDLE) {
            ((LoadBalancer.Subchannel)object).requestConnection();
        }
        object = RoundRobinLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)object);
        if (((ConnectivityStateInfo)((Ref)object).value).getState().equals((Object)ConnectivityState.TRANSIENT_FAILURE) && (connectivityStateInfo.getState().equals((Object)ConnectivityState.CONNECTING) || connectivityStateInfo.getState().equals((Object)ConnectivityState.IDLE))) {
            return;
        }
        ((Ref)object).value = connectivityStateInfo;
        this.updateBalancingState();
    }

    private void shutdownSubchannel(LoadBalancer.Subchannel subchannel) {
        subchannel.shutdown();
        RoundRobinLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value = ConnectivityStateInfo.forNonError(ConnectivityState.SHUTDOWN);
    }

    @Override
    public final void shutdown() {
        for (LoadBalancer.Subchannel subchannel : this.getSubchannels()) {
            this.shutdownSubchannel(subchannel);
        }
    }

    private void updateBalancingState() {
        List<LoadBalancer.Subchannel> list = RoundRobinLoadBalancer.filterNonFailingSubchannels(this.getSubchannels());
        if (list.isEmpty()) {
            boolean bl = false;
            list = EMPTY_OK;
            for (LoadBalancer.Subchannel subchannel : this.getSubchannels()) {
                ConnectivityStateInfo object = (ConnectivityStateInfo)RoundRobinLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value;
                if (object.getState() == ConnectivityState.CONNECTING || object.getState() == ConnectivityState.IDLE) {
                    bl = true;
                }
                if (list != EMPTY_OK && ((Status)((Object)list)).isOk()) continue;
                list = object.getStatus();
            }
            this.updateBalancingState(bl ? ConnectivityState.CONNECTING : ConnectivityState.TRANSIENT_FAILURE, new EmptyPicker((Status)((Object)list)));
            return;
        }
        int n2 = this.random.nextInt(list.size());
        this.updateBalancingState(ConnectivityState.READY, new ReadyPicker(list, n2));
    }

    private void updateBalancingState(ConnectivityState connectivityState, RoundRobinPicker roundRobinPicker) {
        if (connectivityState != this.currentState || !roundRobinPicker.isEquivalentTo(this.currentPicker)) {
            this.helper.updateBalancingState(connectivityState, roundRobinPicker);
            this.currentState = connectivityState;
            this.currentPicker = roundRobinPicker;
        }
    }

    private static List<LoadBalancer.Subchannel> filterNonFailingSubchannels(Collection<LoadBalancer.Subchannel> object) {
        ArrayList<LoadBalancer.Subchannel> arrayList = new ArrayList<LoadBalancer.Subchannel>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            LoadBalancer.Subchannel subchannel = (LoadBalancer.Subchannel)object.next();
            if (!RoundRobinLoadBalancer.isReady(subchannel)) continue;
            arrayList.add(subchannel);
        }
        return arrayList;
    }

    private static Map<EquivalentAddressGroup, EquivalentAddressGroup> stripAttrs(List<EquivalentAddressGroup> object) {
        HashMap<EquivalentAddressGroup, EquivalentAddressGroup> hashMap = new HashMap<EquivalentAddressGroup, EquivalentAddressGroup>(object.size() << 1);
        object = object.iterator();
        while (object.hasNext()) {
            EquivalentAddressGroup equivalentAddressGroup = (EquivalentAddressGroup)object.next();
            hashMap.put(RoundRobinLoadBalancer.stripAttrs(equivalentAddressGroup), equivalentAddressGroup);
        }
        return hashMap;
    }

    private static EquivalentAddressGroup stripAttrs(EquivalentAddressGroup equivalentAddressGroup) {
        return new EquivalentAddressGroup(equivalentAddressGroup.getAddresses());
    }

    final Collection<LoadBalancer.Subchannel> getSubchannels() {
        return this.subchannels.values();
    }

    private static Ref<ConnectivityStateInfo> getSubchannelStateInfoRef(LoadBalancer.Subchannel subchannel) {
        return b.a(subchannel.getAttributes().get(STATE_INFO), (Object)"STATE_INFO");
    }

    static boolean isReady(LoadBalancer.Subchannel subchannel) {
        return ((ConnectivityStateInfo)RoundRobinLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value).getState() == ConnectivityState.READY;
    }

    private static <T> Set<T> setsDifference(Set<T> set, Set<T> set2) {
        set = new HashSet<T>(set);
        set.removeAll(set2);
        return set;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Ref<T> {
        T value;

        Ref(T t2) {
            this.value = t2;
        }
    }

    static final class EmptyPicker
    extends RoundRobinPicker {
        private final Status status;

        EmptyPicker(Status status) {
            this.status = b.a(status, (Object)"status");
        }

        public final LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs pickSubchannelArgs) {
            if (this.status.isOk()) {
                return LoadBalancer.PickResult.withNoResult();
            }
            return LoadBalancer.PickResult.withError(this.status);
        }

        final boolean isEquivalentTo(RoundRobinPicker roundRobinPicker) {
            return roundRobinPicker instanceof EmptyPicker && (d.a(this.status, (Object)((EmptyPicker)roundRobinPicker).status) || this.status.isOk() && ((EmptyPicker)roundRobinPicker).status.isOk());
        }

        public final String toString() {
            return g.a(EmptyPicker.class).a("status", this.status).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ReadyPicker
    extends RoundRobinPicker {
        private static final AtomicIntegerFieldUpdater<ReadyPicker> indexUpdater = AtomicIntegerFieldUpdater.newUpdater(ReadyPicker.class, "index");
        private final List<LoadBalancer.Subchannel> list;
        private volatile int index;

        ReadyPicker(List<LoadBalancer.Subchannel> list, int n2) {
            b.a(!list.isEmpty(), (Object)"empty list");
            this.list = list;
            this.index = n2 - 1;
        }

        @Override
        public final LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs pickSubchannelArgs) {
            return LoadBalancer.PickResult.withSubchannel(this.nextSubchannel());
        }

        public final String toString() {
            return g.a(ReadyPicker.class).a("list", this.list).toString();
        }

        private LoadBalancer.Subchannel nextSubchannel() {
            int n2 = this.list.size();
            int n3 = indexUpdater.incrementAndGet(this);
            if (n3 >= n2) {
                int n4 = n3;
                indexUpdater.compareAndSet(this, n4, n3 %= n2);
            }
            return this.list.get(n3);
        }

        @Override
        final boolean isEquivalentTo(RoundRobinPicker roundRobinPicker) {
            if (!(roundRobinPicker instanceof ReadyPicker)) {
                return false;
            }
            return (roundRobinPicker = (ReadyPicker)roundRobinPicker) == this || this.list.size() == ((ReadyPicker)roundRobinPicker).list.size() && new HashSet<LoadBalancer.Subchannel>(this.list).containsAll(((ReadyPicker)roundRobinPicker).list);
        }
    }

    private static abstract class RoundRobinPicker
    extends LoadBalancer.SubchannelPicker {
        private RoundRobinPicker() {
        }

        abstract boolean isEquivalentTo(RoundRobinPicker var1);
    }
}

