/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.stub;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.CallOptions;
import com.appoptics.ext.io.grpc.Channel;
import com.appoptics.ext.io.grpc.ClientCall;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.MethodDescriptor;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.StatusException;
import com.appoptics.ext.io.grpc.StatusRuntimeException;
import com.tracelytics.a.d.a.a.g;
import com.tracelytics.a.d.a.g.a.a;
import com.tracelytics.a.d.a.g.a.j;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClientCalls {
    private static final Logger logger = Logger.getLogger(ClientCalls.class.getName());
    static final CallOptions.Key<StubType> STUB_TYPE_OPTION = CallOptions.Key.create("internal-stub-type");

    private ClientCalls() {
    }

    public static <ReqT, RespT> RespT blockingUnaryCall(Channel object, MethodDescriptor<ReqT, RespT> object2, CallOptions callOptions, ReqT ReqT) {
        ThreadlessExecutor threadlessExecutor = new ThreadlessExecutor();
        boolean bl = false;
        object = ((Channel)object).newCall(object2, callOptions.withOption(STUB_TYPE_OPTION, StubType.BLOCKING).withExecutor(threadlessExecutor));
        try {
            object2 = ClientCalls.futureUnaryCall(object, ReqT);
            while (!object2.isDone()) {
                try {
                    threadlessExecutor.waitAndDrain();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    ((ClientCall)object).cancel("Thread interrupted", interruptedException);
                }
            }
            callOptions = ClientCalls.getUnchecked(object2);
            return (RespT)callOptions;
        }
        catch (RuntimeException runtimeException) {
            throw ClientCalls.cancelThrow(object, runtimeException);
        }
        catch (Error error) {
            throw ClientCalls.cancelThrow(object, error);
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <ReqT, RespT> j<RespT> futureUnaryCall(ClientCall<ReqT, RespT> clientCall, ReqT ReqT) {
        GrpcFuture<RespT> grpcFuture = new GrpcFuture<RespT>(clientCall);
        ClientCalls.asyncUnaryRequestCall(clientCall, ReqT, new UnaryStreamToFuture<RespT>(grpcFuture));
        return grpcFuture;
    }

    private static <V> V getUnchecked(Future<V> object) {
        try {
            return object.get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw Status.CANCELLED.withDescription("Thread interrupted").withCause(interruptedException).asRuntimeException();
        }
        catch (ExecutionException executionException) {
            object = executionException;
            throw ClientCalls.toStatusRuntimeException(executionException.getCause());
        }
    }

    private static StatusRuntimeException toStatusRuntimeException(Throwable throwable) {
        for (Throwable throwable2 = b.a(throwable, (Object)"t"); throwable2 != null; throwable2 = throwable2.getCause()) {
            if (throwable2 instanceof StatusException) {
                throwable = (StatusException)throwable2;
                return new StatusRuntimeException(((StatusException)throwable).getStatus(), ((StatusException)throwable).getTrailers());
            }
            if (!(throwable2 instanceof StatusRuntimeException)) continue;
            throwable = (StatusRuntimeException)throwable2;
            return new StatusRuntimeException(((StatusRuntimeException)throwable).getStatus(), ((StatusRuntimeException)throwable).getTrailers());
        }
        return Status.UNKNOWN.withDescription("unexpected exception").withCause(throwable).asRuntimeException();
    }

    private static RuntimeException cancelThrow(ClientCall<?, ?> clientCall, Throwable throwable) {
        try {
            clientCall.cancel(null, throwable);
        }
        catch (Throwable throwable2) {
            assert (throwable2 instanceof RuntimeException || throwable2 instanceof Error);
            logger.log(Level.SEVERE, "RuntimeException encountered while closing call", throwable2);
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new AssertionError((Object)throwable);
    }

    private static <ReqT, RespT> void asyncUnaryRequestCall(ClientCall<ReqT, RespT> clientCall, ReqT ReqT, StartableListener<RespT> startableListener) {
        ClientCalls.startCall(clientCall, startableListener);
        try {
            clientCall.sendMessage(ReqT);
            clientCall.halfClose();
            return;
        }
        catch (RuntimeException runtimeException) {
            throw ClientCalls.cancelThrow(clientCall, runtimeException);
        }
        catch (Error error) {
            throw ClientCalls.cancelThrow(clientCall, error);
        }
    }

    private static <ReqT, RespT> void startCall(ClientCall<ReqT, RespT> clientCall, StartableListener<RespT> startableListener) {
        clientCall.start(startableListener, new Metadata());
        startableListener.onStart();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StubType {
        BLOCKING,
        FUTURE,
        ASYNC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ThreadlessExecutor
    extends ConcurrentLinkedQueue<Runnable>
    implements Executor {
        private static final Logger log = Logger.getLogger(ThreadlessExecutor.class.getName());
        private volatile Thread waiter;

        ThreadlessExecutor() {
        }

        public final void waitAndDrain() throws InterruptedException {
            ThreadlessExecutor.throwIfInterrupted();
            Runnable runnable = (Runnable)this.poll();
            if (runnable == null) {
                this.waiter = Thread.currentThread();
                try {
                    while ((runnable = (Runnable)this.poll()) == null) {
                        LockSupport.park(this);
                        ThreadlessExecutor.throwIfInterrupted();
                    }
                }
                finally {
                    this.waiter = null;
                }
            }
            do {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    log.log(Level.WARNING, "Runnable threw exception", throwable);
                }
            } while ((runnable = (Runnable)this.poll()) != null);
        }

        private static void throwIfInterrupted() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
        }

        @Override
        public final void execute(Runnable runnable) {
            this.add(runnable);
            LockSupport.unpark(this.waiter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GrpcFuture<RespT>
    extends a<RespT> {
        private final ClientCall<?, RespT> call;

        GrpcFuture(ClientCall<?, RespT> clientCall) {
            this.call = clientCall;
        }

        @Override
        protected final void interruptTask() {
            this.call.cancel("GrpcFuture was cancelled", null);
        }

        @Override
        protected final boolean set(RespT RespT) {
            return super.set(RespT);
        }

        @Override
        protected final boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }

        @Override
        protected final String pendingToString() {
            return g.a(this).a("clientCall", this.call).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnaryStreamToFuture<RespT>
    extends StartableListener<RespT> {
        private final GrpcFuture<RespT> responseFuture;
        private RespT value;

        UnaryStreamToFuture(GrpcFuture<RespT> grpcFuture) {
            this.responseFuture = grpcFuture;
        }

        @Override
        public final void onHeaders(Metadata metadata) {
        }

        @Override
        public final void onMessage(RespT RespT) {
            if (this.value != null) {
                throw Status.INTERNAL.withDescription("More than one value received for unary call").asRuntimeException();
            }
            this.value = RespT;
        }

        @Override
        public final void onClose(Status status, Metadata metadata) {
            if (status.isOk()) {
                if (this.value == null) {
                    this.responseFuture.setException(Status.INTERNAL.withDescription("No value received for unary call").asRuntimeException(metadata));
                }
                this.responseFuture.set(this.value);
                return;
            }
            this.responseFuture.setException(status.asRuntimeException(metadata));
        }

        @Override
        final void onStart() {
            ((GrpcFuture)this.responseFuture).call.request(2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class StartableListener<T>
    extends ClientCall.Listener<T> {
        private StartableListener() {
        }

        abstract void onStart();
    }
}

