/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.protobuf.lite;

import com.appoptics.ext.io.grpc.Drainable;
import com.appoptics.ext.io.grpc.KnownLength;
import com.appoptics.ext.io.grpc.protobuf.lite.ProtoLiteUtils;
import com.tracelytics.a.d.c.X;
import com.tracelytics.a.d.c.ai;
import com.tracelytics.a.d.c.i;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProtoInputStream
extends InputStream
implements Drainable,
KnownLength {
    private X message;
    private final ai<?> parser;
    private ByteArrayInputStream partial;

    ProtoInputStream(X x2, ai<?> ai2) {
        this.message = x2;
        this.parser = ai2;
    }

    @Override
    public final int drainTo(OutputStream outputStream) throws IOException {
        int n2;
        if (this.message != null) {
            n2 = this.message.m();
            this.message.a(outputStream);
            this.message = null;
        } else if (this.partial != null) {
            n2 = (int)ProtoLiteUtils.copy(this.partial, outputStream);
            this.partial = null;
        } else {
            n2 = 0;
        }
        return n2;
    }

    @Override
    public final int read() {
        if (this.message != null) {
            this.partial = new ByteArrayInputStream(this.message.C());
            this.message = null;
        }
        if (this.partial != null) {
            return this.partial.read();
        }
        return -1;
    }

    @Override
    public final int read(byte[] object, int n2, int n3) throws IOException {
        if (this.message != null) {
            int n4 = this.message.m();
            if (n4 == 0) {
                this.message = null;
                this.partial = null;
                return -1;
            }
            if (n3 >= n4) {
                object = i.b((byte[])object, n2, n4);
                this.message.a((i)object);
                ((i)object).h();
                ((i)object).j();
                this.message = null;
                this.partial = null;
                return n4;
            }
            this.partial = new ByteArrayInputStream(this.message.C());
            this.message = null;
        }
        if (this.partial != null) {
            return this.partial.read((byte[])object, n2, n3);
        }
        return -1;
    }

    @Override
    public final int available() {
        if (this.message != null) {
            return this.message.m();
        }
        if (this.partial != null) {
            return this.partial.available();
        }
        return 0;
    }

    final X message() {
        if (this.message == null) {
            throw new IllegalStateException("message not available");
        }
        return this.message;
    }

    final ai<?> parser() {
        return this.parser;
    }
}

