/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.netty;

import com.appoptics.ext.io.grpc.netty.AbstractHttp2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.tracelytics.a.d.a.a.b;
import com.tracelytics.a.d.a.d.a;
import java.util.ArrayList;
import java.util.List;

class GrpcHttp2HeadersUtils {

    static final class GrpcHttp2ResponseHeaders
    extends GrpcHttp2InboundHeaders {
        GrpcHttp2ResponseHeaders(int n2) {
            super(n2);
        }

        public final Http2Headers add(CharSequence charSequence, CharSequence charSequence2) {
            charSequence = this.validateName(GrpcHttp2ResponseHeaders.requireAsciiString(charSequence));
            charSequence2 = GrpcHttp2ResponseHeaders.requireAsciiString(charSequence2);
            return this.add((AsciiString)charSequence, (AsciiString)charSequence2);
        }

        public final CharSequence get(CharSequence charSequence) {
            charSequence = GrpcHttp2ResponseHeaders.requireAsciiString(charSequence);
            return this.get((AsciiString)charSequence);
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName()).append('[');
            stringBuilder.append(this.namesAndValuesToString()).append(']');
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class GrpcHttp2InboundHeaders
    extends AbstractHttp2Headers {
        private static final AsciiString binaryHeaderSuffix = new AsciiString("-bin".getBytes(b.a));
        private byte[][] namesAndValues;
        private AsciiString[] values;
        private int namesAndValuesIdx;

        GrpcHttp2InboundHeaders(int n2) {
            com.appoptics.ext.io.a.b.a(n2 > 0, "numHeadersGuess needs to be positive: %s", n2);
            this.namesAndValues = new byte[n2 << 1][];
            this.values = new AsciiString[n2];
        }

        @Override
        protected Http2Headers add(AsciiString object, AsciiString asciiString) {
            byte[] byArray = GrpcHttp2InboundHeaders.bytes((AsciiString)object);
            if (!((AsciiString)object).endsWith(binaryHeaderSuffix)) {
                object = GrpcHttp2InboundHeaders.bytes(asciiString);
                this.addHeader(asciiString, byArray, (byte[])object);
                return this;
            }
            int n2 = 0;
            int n3 = -1;
            while (n3 < asciiString.length()) {
                int n4 = asciiString.indexOf(',', n2);
                n3 = n4 == -1 ? asciiString.length() : n4;
                AsciiString asciiString2 = asciiString.subSequence(n2, n3, false);
                object = a.b().a(asciiString2);
                n2 = n4 + 1;
                this.addHeader(asciiString2, byArray, (byte[])object);
            }
            return this;
        }

        private void addHeader(AsciiString asciiString, byte[] byArray, byte[] byArray2) {
            if (this.namesAndValuesIdx == this.namesAndValues.length) {
                this.expandHeadersAndValues();
            }
            this.values[this.namesAndValuesIdx / 2] = asciiString;
            this.namesAndValues[this.namesAndValuesIdx] = byArray;
            ++this.namesAndValuesIdx;
            this.namesAndValues[this.namesAndValuesIdx] = byArray2;
            ++this.namesAndValuesIdx;
        }

        @Override
        protected CharSequence get(AsciiString asciiString) {
            for (int i2 = 0; i2 < this.namesAndValuesIdx; i2 += 2) {
                if (!GrpcHttp2InboundHeaders.equals(asciiString, this.namesAndValues[i2])) continue;
                return this.values[i2 / 2];
            }
            return null;
        }

        @Override
        public CharSequence status() {
            return this.get(Http2Headers.PseudoHeaderName.STATUS.value());
        }

        @Override
        public List<CharSequence> getAll(CharSequence charSequence) {
            charSequence = GrpcHttp2InboundHeaders.requireAsciiString(charSequence);
            ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(4);
            for (int i2 = 0; i2 < this.namesAndValuesIdx; i2 += 2) {
                if (!GrpcHttp2InboundHeaders.equals((AsciiString)charSequence, this.namesAndValues[i2])) continue;
                arrayList.add(this.values[i2 / 2]);
            }
            return arrayList;
        }

        byte[][] namesAndValues() {
            return this.namesAndValues;
        }

        protected int numHeaders() {
            return this.namesAndValuesIdx / 2;
        }

        protected static boolean equals(AsciiString asciiString, byte[] byArray) {
            return GrpcHttp2InboundHeaders.equals(asciiString.array(), asciiString.arrayOffset(), asciiString.length(), byArray, 0, byArray.length);
        }

        protected static boolean equals(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
            if (n3 != n5) {
                return false;
            }
            return PlatformDependent.equals(byArray, n2, byArray2, n4, n3);
        }

        protected static byte[] bytes(AsciiString asciiString) {
            if (asciiString.isEntireArrayUsed()) {
                return asciiString.array();
            }
            return asciiString.toByteArray();
        }

        protected static AsciiString requireAsciiString(CharSequence charSequence) {
            if (!(charSequence instanceof AsciiString)) {
                throw new IllegalArgumentException("AsciiString expected. Was: " + charSequence.getClass().getName());
            }
            return (AsciiString)charSequence;
        }

        protected AsciiString validateName(AsciiString asciiString) {
            int n2 = asciiString.arrayOffset();
            int n3 = asciiString.length();
            byte[] byArray = asciiString.array();
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                if (!AsciiString.isUpperCase(byArray[i2])) continue;
                PlatformDependent.throwException(Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "invalid header name '%s'", asciiString));
            }
            return asciiString;
        }

        private void expandHeadersAndValues() {
            int n2 = Math.max(2, this.values.length + this.values.length / 2);
            int n3 = n2 << 1;
            byte[][] byArrayArray = new byte[n3][];
            AsciiString[] asciiStringArray = new AsciiString[n2];
            System.arraycopy(this.namesAndValues, 0, byArrayArray, 0, this.namesAndValues.length);
            System.arraycopy(this.values, 0, asciiStringArray, 0, this.values.length);
            this.namesAndValues = byArrayArray;
            this.values = asciiStringArray;
        }

        @Override
        public int size() {
            return this.numHeaders();
        }

        protected static void appendNameAndValue(StringBuilder stringBuilder, CharSequence charSequence, CharSequence charSequence2, boolean bl) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(charSequence).append(": ").append(charSequence2);
        }

        protected final String namesAndValuesToString() {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            for (int i2 = 0; i2 < this.namesAndValuesIdx; i2 += 2) {
                String string = new String(this.namesAndValues[i2], b.a);
                AsciiString asciiString = this.values[i2 / 2];
                GrpcHttp2InboundHeaders.appendNameAndValue(stringBuilder, string, asciiString, bl);
                bl = true;
            }
            return stringBuilder.toString();
        }
    }

    static final class GrpcHttp2ClientHeadersDecoder
    extends DefaultHttp2HeadersDecoder {
        GrpcHttp2ClientHeadersDecoder(long l2) {
            super(true, l2);
        }

        protected final GrpcHttp2InboundHeaders newHeaders() {
            return new GrpcHttp2ResponseHeaders(this.numberOfHeadersGuess());
        }
    }
}

