/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.netty;

import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.internal.ManagedClientTransport;

final class ClientTransportLifecycleManager {
    private final ManagedClientTransport.Listener listener;
    private boolean transportReady;
    private boolean transportShutdown;
    private boolean transportInUse;
    private Status shutdownStatus;
    private Throwable shutdownThrowable;
    private boolean transportTerminated;

    public ClientTransportLifecycleManager(ManagedClientTransport.Listener listener) {
        this.listener = listener;
    }

    public final void notifyReady() {
        if (this.transportReady || this.transportShutdown) {
            return;
        }
        this.transportReady = true;
        this.listener.transportReady();
    }

    public final void notifyGracefulShutdown(Status status) {
        if (this.transportShutdown) {
            return;
        }
        this.transportShutdown = true;
        this.listener.transportShutdown(status);
    }

    public final boolean notifyShutdown(Status status) {
        this.notifyGracefulShutdown(status);
        if (this.shutdownStatus != null) {
            return false;
        }
        this.shutdownStatus = status;
        this.shutdownThrowable = status.asException();
        return true;
    }

    public final void notifyInUse(boolean bl) {
        if (bl == this.transportInUse) {
            return;
        }
        this.transportInUse = bl;
        this.listener.transportInUse(bl);
    }

    public final void notifyTerminated(Status status) {
        if (this.transportTerminated) {
            return;
        }
        this.transportTerminated = true;
        this.notifyShutdown(status);
        this.listener.transportTerminated();
    }

    public final Status getShutdownStatus() {
        return this.shutdownStatus;
    }

    public final Throwable getShutdownThrowable() {
        return this.shutdownThrowable;
    }
}

