/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.LoadBalancerProvider;
import com.appoptics.ext.io.grpc.LoadBalancerRegistry;
import com.appoptics.ext.io.grpc.NameResolver;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.internal.JsonUtil;
import com.appoptics.ext.io.grpc.internal.RetriableStream;
import com.tracelytics.a.d.a.a.d;
import com.tracelytics.a.d.a.a.g;
import com.tracelytics.a.d.a.a.q;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceConfigUtil {
    private ServiceConfigUtil() {
    }

    public static Map<String, ?> getHealthCheckedService(Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        return JsonUtil.getObject(map, "healthCheckConfig");
    }

    static RetriableStream.Throttle getThrottlePolicy(Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        if ((map = JsonUtil.getObject(map, "retryThrottling")) == null) {
            return null;
        }
        float f2 = JsonUtil.getNumber(map, "maxTokens").floatValue();
        float f3 = JsonUtil.getNumber(map, "tokenRatio").floatValue();
        b.b(f2 > 0.0f, "maxToken should be greater than zero");
        b.b(f3 > 0.0f, "tokenRatio should be greater than zero");
        return new RetriableStream.Throttle(f2, f3);
    }

    static Integer getMaxAttemptsFromRetryPolicy(Map<String, ?> map) {
        return JsonUtil.getNumberAsInteger(map, "maxAttempts");
    }

    static Long getInitialBackoffNanosFromRetryPolicy(Map<String, ?> map) {
        return JsonUtil.getStringAsDuration(map, "initialBackoff");
    }

    static Long getMaxBackoffNanosFromRetryPolicy(Map<String, ?> map) {
        return JsonUtil.getStringAsDuration(map, "maxBackoff");
    }

    static Double getBackoffMultiplierFromRetryPolicy(Map<String, ?> map) {
        return JsonUtil.getNumber(map, "backoffMultiplier");
    }

    private static Set<Status.Code> getListOfStatusCodesAsSet(Map<String, ?> object, String string) {
        if ((object = JsonUtil.getList(object, string)) == null) {
            return null;
        }
        return ServiceConfigUtil.getStatusCodesFromList(object);
    }

    private static Set<Status.Code> getStatusCodesFromList(List<?> object) {
        EnumSet<Status.Code> enumSet = EnumSet.noneOf(Status.Code.class);
        object = object.iterator();
        while (object.hasNext()) {
            Status.Code code;
            Object e2 = object.next();
            if (e2 instanceof Double) {
                Double d2 = (Double)e2;
                int n2 = d2.intValue();
                b.c((double)n2 == d2, "Status code %s is not integral", e2);
                code = Status.fromCodeValue(n2).getCode();
                b.c(code.value() == d2.intValue(), "Status code %s is not valid", e2);
            } else if (e2 instanceof String) {
                try {
                    code = Status.Code.valueOf((String)e2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new q("Status code " + e2 + " is not valid", illegalArgumentException);
                }
            } else {
                throw new q("Can not convert status code " + e2 + " to Status.Code, because its type is " + e2.getClass());
            }
            enumSet.add(code);
        }
        return Collections.unmodifiableSet(enumSet);
    }

    static Set<Status.Code> getRetryableStatusCodesFromRetryPolicy(Map<String, ?> object) {
        String string = "retryableStatusCodes";
        b.c((object = ServiceConfigUtil.getListOfStatusCodesAsSet(object, string)) != null, "%s is required in retry policy", string);
        b.c(!object.isEmpty(), "%s must not be empty", string);
        b.c(!object.contains((Object)Status.Code.OK), "%s must not contain OK", string);
        return object;
    }

    static Integer getMaxAttemptsFromHedgingPolicy(Map<String, ?> map) {
        return JsonUtil.getNumberAsInteger(map, "maxAttempts");
    }

    static Long getHedgingDelayNanosFromHedgingPolicy(Map<String, ?> map) {
        return JsonUtil.getStringAsDuration(map, "hedgingDelay");
    }

    static Set<Status.Code> getNonFatalStatusCodesFromHedgingPolicy(Map<String, ?> object) {
        String string = "nonFatalStatusCodes";
        if ((object = ServiceConfigUtil.getListOfStatusCodesAsSet(object, string)) == null) {
            return Collections.unmodifiableSet(EnumSet.noneOf(Status.Code.class));
        }
        b.c(!object.contains((Object)Status.Code.OK), "%s must not contain OK", string);
        return object;
    }

    static String getServiceFromName(Map<String, ?> map) {
        return JsonUtil.getString(map, "service");
    }

    static String getMethodFromName(Map<String, ?> map) {
        return JsonUtil.getString(map, "method");
    }

    static Map<String, ?> getRetryPolicyFromMethodConfig(Map<String, ?> map) {
        return JsonUtil.getObject(map, "retryPolicy");
    }

    static Map<String, ?> getHedgingPolicyFromMethodConfig(Map<String, ?> map) {
        return JsonUtil.getObject(map, "hedgingPolicy");
    }

    static List<Map<String, ?>> getNameListFromMethodConfig(Map<String, ?> map) {
        return JsonUtil.getListOfObjects(map, "name");
    }

    static Long getTimeoutFromMethodConfig(Map<String, ?> map) {
        return JsonUtil.getStringAsDuration(map, "timeout");
    }

    static Boolean getWaitForReadyFromMethodConfig(Map<String, ?> map) {
        return JsonUtil.getBoolean(map, "waitForReady");
    }

    static Integer getMaxRequestMessageBytesFromMethodConfig(Map<String, ?> map) {
        return JsonUtil.getNumberAsInteger(map, "maxRequestMessageBytes");
    }

    static Integer getMaxResponseMessageBytesFromMethodConfig(Map<String, ?> map) {
        return JsonUtil.getNumberAsInteger(map, "maxResponseMessageBytes");
    }

    static List<Map<String, ?>> getMethodConfigFromServiceConfig(Map<String, ?> map) {
        return JsonUtil.getListOfObjects(map, "methodConfig");
    }

    public static List<Map<String, ?>> getLoadBalancingConfigsFromServiceConfig(Map<String, ?> map) {
        ArrayList arrayList = new ArrayList();
        String string = "loadBalancingConfig";
        if (map.containsKey(string)) {
            arrayList.addAll(JsonUtil.getListOfObjects(map, string));
        }
        if (arrayList.isEmpty() && (map = JsonUtil.getString(map, "loadBalancingPolicy")) != null) {
            map = ((String)((Object)map)).toLowerCase(Locale.ROOT);
            map = Collections.singletonMap(map, Collections.emptyMap());
            arrayList.add(map);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static LbConfig unwrapLoadBalancingConfig(Map<String, ?> map) {
        if (map.size() != 1) {
            throw new RuntimeException("There are " + map.size() + " fields in a LoadBalancingConfig object. Exactly one is expected. Config=" + map);
        }
        String string = map.entrySet().iterator().next().getKey();
        return new LbConfig(string, JsonUtil.getObject(map, string));
    }

    public static List<LbConfig> unwrapLoadBalancingConfigList(List<Map<String, ?>> object) {
        if (object == null) {
            return null;
        }
        ArrayList<LbConfig> arrayList = new ArrayList<LbConfig>();
        object = object.iterator();
        while (object.hasNext()) {
            Map map = (Map)object.next();
            arrayList.add(ServiceConfigUtil.unwrapLoadBalancingConfig(map));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static NameResolver.ConfigOrError selectLbPolicyFromList(List<LbConfig> object, LoadBalancerRegistry loadBalancerRegistry) {
        ArrayList<String> arrayList = new ArrayList<String>();
        object = object.iterator();
        while (object.hasNext()) {
            LbConfig lbConfig = (LbConfig)object.next();
            String string = lbConfig.getPolicyName();
            LoadBalancerProvider loadBalancerProvider = loadBalancerRegistry.getProvider(string);
            if (loadBalancerProvider == null) {
                arrayList.add(string);
                continue;
            }
            if (!arrayList.isEmpty()) {
                Logger.getLogger(ServiceConfigUtil.class.getName()).log(Level.FINEST, "{0} specified by Service Config are not available", arrayList);
            }
            if (((NameResolver.ConfigOrError)(object = loadBalancerProvider.parseLoadBalancingPolicyConfig(lbConfig.getRawConfigValue()))).getError() != null) {
                return object;
            }
            return NameResolver.ConfigOrError.fromConfig(new PolicySelection(loadBalancerProvider, ((NameResolver.ConfigOrError)object).getConfig()));
        }
        return NameResolver.ConfigOrError.fromError(Status.UNKNOWN.withDescription("None of " + arrayList + " specified by Service Config are available."));
    }

    public static final class PolicySelection {
        final LoadBalancerProvider provider;
        final Object config;

        public PolicySelection(LoadBalancerProvider loadBalancerProvider, Object object) {
            this.provider = b.a(loadBalancerProvider, (Object)"provider");
            this.config = object;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            object = (PolicySelection)object;
            return d.a(this.provider, (Object)((PolicySelection)object).provider) && d.a(this.config, ((PolicySelection)object).config);
        }

        public final int hashCode() {
            Object[] objectArray = new Object[]{this.provider, this.config};
            return Arrays.hashCode(objectArray);
        }

        public final String toString() {
            return g.a(this).a("provider", this.provider).a("config", this.config).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LbConfig {
        private final String policyName;
        private final Map<String, ?> rawConfigValue;

        public LbConfig(String string, Map<String, ?> map) {
            this.policyName = b.a(string, (Object)"policyName");
            this.rawConfigValue = b.a(map, (Object)"rawConfigValue");
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final Map<String, ?> getRawConfigValue() {
            return this.rawConfigValue;
        }

        public final boolean equals(Object object) {
            if (object instanceof LbConfig) {
                object = (LbConfig)object;
                return this.policyName.equals(((LbConfig)object).policyName) && this.rawConfigValue.equals(((LbConfig)object).rawConfigValue);
            }
            return false;
        }

        public final int hashCode() {
            Object[] objectArray = new Object[]{this.policyName, this.rawConfigValue};
            return Arrays.hashCode(objectArray);
        }

        public final String toString() {
            return g.a(this).a("policyName", this.policyName).a("rawConfigValue", this.rawConfigValue).toString();
        }
    }
}

