/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.tracelytics.a.d.a.a.l;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

final class Rescheduler {
    private final ScheduledExecutorService scheduler;
    private final Executor serializingExecutor;
    private final Runnable runnable;
    private final l stopwatch;
    private long runAtNanos;
    private boolean enabled;
    private ScheduledFuture<?> wakeUp;

    Rescheduler(Runnable runnable, Executor executor, ScheduledExecutorService scheduledExecutorService, l l2) {
        this.runnable = runnable;
        this.serializingExecutor = executor;
        this.scheduler = scheduledExecutorService;
        this.stopwatch = l2;
        l2.b();
    }

    final void reschedule(long l2, TimeUnit timeUnit) {
        long l3 = timeUnit.toNanos(l2);
        long l4 = this.nanoTime() + l3;
        this.enabled = true;
        if (l4 - this.runAtNanos < 0L || this.wakeUp == null) {
            if (this.wakeUp != null) {
                this.wakeUp.cancel(false);
            }
            this.wakeUp = this.scheduler.schedule(new FutureRunnable(), l3, TimeUnit.NANOSECONDS);
        }
        this.runAtNanos = l4;
    }

    final void cancel(boolean bl) {
        this.enabled = false;
        if (bl && this.wakeUp != null) {
            this.wakeUp.cancel(false);
            this.wakeUp = null;
        }
    }

    private long nanoTime() {
        return this.stopwatch.a(TimeUnit.NANOSECONDS);
    }

    private final class ChannelFutureRunnable
    implements Runnable {
        private ChannelFutureRunnable() {
        }

        public final void run() {
            if (!Rescheduler.this.enabled) {
                Rescheduler.this.wakeUp = null;
                return;
            }
            long l2 = Rescheduler.this.nanoTime();
            if (Rescheduler.this.runAtNanos - l2 > 0L) {
                Rescheduler.this.wakeUp = Rescheduler.this.scheduler.schedule(new FutureRunnable(), Rescheduler.this.runAtNanos - l2, TimeUnit.NANOSECONDS);
                return;
            }
            Rescheduler.this.enabled = false;
            Rescheduler.this.wakeUp = null;
            Rescheduler.this.runnable.run();
        }
    }

    private final class FutureRunnable
    implements Runnable {
        private FutureRunnable() {
        }

        public final void run() {
            Rescheduler.this.serializingExecutor.execute(new ChannelFutureRunnable());
        }
    }
}

