/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.ConnectivityState;
import com.appoptics.ext.io.grpc.ConnectivityStateInfo;
import com.appoptics.ext.io.grpc.EquivalentAddressGroup;
import com.appoptics.ext.io.grpc.LoadBalancer;
import com.appoptics.ext.io.grpc.Status;
import com.tracelytics.a.d.a.a.g;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

final class PickFirstLoadBalancer
extends LoadBalancer {
    private final LoadBalancer.Helper helper;
    private LoadBalancer.Subchannel subchannel;

    PickFirstLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = b.a(helper, (Object)"helper");
    }

    public final void handleResolvedAddresses(LoadBalancer.ResolvedAddresses object) {
        object = ((LoadBalancer.ResolvedAddresses)object).getAddresses();
        if (this.subchannel == null) {
            object = this.helper.createSubchannel(LoadBalancer.CreateSubchannelArgs.newBuilder().setAddresses((List<EquivalentAddressGroup>)object).build());
            ((LoadBalancer.Subchannel)object).start(new LoadBalancer.SubchannelStateListener((LoadBalancer.Subchannel)object){
                final /* synthetic */ LoadBalancer.Subchannel val$subchannel;
                {
                    this.val$subchannel = subchannel;
                }

                public void onSubchannelState(ConnectivityStateInfo connectivityStateInfo) {
                    PickFirstLoadBalancer.this.processSubchannelState(this.val$subchannel, connectivityStateInfo);
                }
            });
            this.subchannel = object;
            this.helper.updateBalancingState(ConnectivityState.CONNECTING, new Picker(LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)object)));
            ((LoadBalancer.Subchannel)object).requestConnection();
            return;
        }
        this.subchannel.updateAddresses((List<EquivalentAddressGroup>)object);
    }

    public final void handleNameResolutionError(Status status) {
        if (this.subchannel != null) {
            this.subchannel.shutdown();
            this.subchannel = null;
        }
        this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new Picker(LoadBalancer.PickResult.withError(status)));
    }

    private void processSubchannelState(LoadBalancer.Subchannel object, ConnectivityStateInfo connectivityStateInfo) {
        ConnectivityState connectivityState = connectivityStateInfo.getState();
        if (connectivityState == ConnectivityState.SHUTDOWN) {
            return;
        }
        switch (connectivityState) {
            case IDLE: {
                object = new RequestConnectionPicker((LoadBalancer.Subchannel)object);
                break;
            }
            case CONNECTING: {
                object = new Picker(LoadBalancer.PickResult.withNoResult());
                break;
            }
            case READY: {
                object = new Picker(LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)object));
                break;
            }
            case TRANSIENT_FAILURE: {
                object = new Picker(LoadBalancer.PickResult.withError(connectivityStateInfo.getStatus()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported state:" + (Object)((Object)connectivityState));
            }
        }
        this.helper.updateBalancingState(connectivityState, (LoadBalancer.SubchannelPicker)object);
    }

    public final void shutdown() {
        if (this.subchannel != null) {
            this.subchannel.shutdown();
        }
    }

    private final class RequestConnectionPicker
    extends LoadBalancer.SubchannelPicker {
        private final LoadBalancer.Subchannel subchannel;
        private final AtomicBoolean connectionRequested = new AtomicBoolean(false);

        RequestConnectionPicker(LoadBalancer.Subchannel subchannel) {
            this.subchannel = b.a(subchannel, (Object)"subchannel");
        }

        public final LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs pickSubchannelArgs) {
            if (this.connectionRequested.compareAndSet(false, true)) {
                PickFirstLoadBalancer.this.helper.getSynchronizationContext().execute(new Runnable(){

                    public void run() {
                        RequestConnectionPicker.this.subchannel.requestConnection();
                    }
                });
            }
            return LoadBalancer.PickResult.withNoResult();
        }
    }

    private static final class Picker
    extends LoadBalancer.SubchannelPicker {
        private final LoadBalancer.PickResult result;

        Picker(LoadBalancer.PickResult pickResult) {
            this.result = b.a(pickResult, (Object)"result");
        }

        public final LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs pickSubchannelArgs) {
            return this.result;
        }

        public final String toString() {
            return g.a(Picker.class).a("result", this.result).toString();
        }
    }
}

