/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.Attributes;
import com.appoptics.ext.io.grpc.CallOptions;
import com.appoptics.ext.io.grpc.Channel;
import com.appoptics.ext.io.grpc.ChannelLogger;
import com.appoptics.ext.io.grpc.ClientCall;
import com.appoptics.ext.io.grpc.ClientInterceptor;
import com.appoptics.ext.io.grpc.ClientInterceptors;
import com.appoptics.ext.io.grpc.ClientStreamTracer;
import com.appoptics.ext.io.grpc.CompressorRegistry;
import com.appoptics.ext.io.grpc.ConnectivityState;
import com.appoptics.ext.io.grpc.ConnectivityStateInfo;
import com.appoptics.ext.io.grpc.Context;
import com.appoptics.ext.io.grpc.DecompressorRegistry;
import com.appoptics.ext.io.grpc.EquivalentAddressGroup;
import com.appoptics.ext.io.grpc.InternalChannelz;
import com.appoptics.ext.io.grpc.InternalConfigSelector;
import com.appoptics.ext.io.grpc.InternalInstrumented;
import com.appoptics.ext.io.grpc.InternalLogId;
import com.appoptics.ext.io.grpc.InternalWithLogId;
import com.appoptics.ext.io.grpc.LoadBalancer;
import com.appoptics.ext.io.grpc.ManagedChannel;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.MethodDescriptor;
import com.appoptics.ext.io.grpc.NameResolver;
import com.appoptics.ext.io.grpc.NameResolverRegistry;
import com.appoptics.ext.io.grpc.ProxyDetector;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.SynchronizationContext;
import com.appoptics.ext.io.grpc.internal.AbstractSubchannel;
import com.appoptics.ext.io.grpc.internal.AutoConfiguredLoadBalancerFactory;
import com.appoptics.ext.io.grpc.internal.BackoffPolicy;
import com.appoptics.ext.io.grpc.internal.CallCredentialsApplyingTransportFactory;
import com.appoptics.ext.io.grpc.internal.CallTracer;
import com.appoptics.ext.io.grpc.internal.ChannelLoggerImpl;
import com.appoptics.ext.io.grpc.internal.ChannelTracer;
import com.appoptics.ext.io.grpc.internal.ClientCallImpl;
import com.appoptics.ext.io.grpc.internal.ClientStream;
import com.appoptics.ext.io.grpc.internal.ClientTransport;
import com.appoptics.ext.io.grpc.internal.ClientTransportFactory;
import com.appoptics.ext.io.grpc.internal.ConnectivityStateManager;
import com.appoptics.ext.io.grpc.internal.DelayedClientCall;
import com.appoptics.ext.io.grpc.internal.DelayedClientTransport;
import com.appoptics.ext.io.grpc.internal.GrpcUtil;
import com.appoptics.ext.io.grpc.internal.HedgingPolicy;
import com.appoptics.ext.io.grpc.internal.InUseStateAggregator;
import com.appoptics.ext.io.grpc.internal.InternalSubchannel;
import com.appoptics.ext.io.grpc.internal.LogExceptionRunnable;
import com.appoptics.ext.io.grpc.internal.ManagedChannelImplBuilder;
import com.appoptics.ext.io.grpc.internal.ManagedChannelServiceConfig;
import com.appoptics.ext.io.grpc.internal.ManagedClientTransport;
import com.appoptics.ext.io.grpc.internal.ObjectPool;
import com.appoptics.ext.io.grpc.internal.OobChannel;
import com.appoptics.ext.io.grpc.internal.PickSubchannelArgsImpl;
import com.appoptics.ext.io.grpc.internal.Rescheduler;
import com.appoptics.ext.io.grpc.internal.RetriableStream;
import com.appoptics.ext.io.grpc.internal.RetryPolicy;
import com.appoptics.ext.io.grpc.internal.TimeProvider;
import com.tracelytics.a.d.a.a.g;
import com.tracelytics.a.d.a.a.l;
import com.tracelytics.a.d.a.a.m;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ManagedChannelImpl
extends ManagedChannel
implements InternalInstrumented<Object> {
    static final Logger logger = Logger.getLogger(ManagedChannelImpl.class.getName());
    static final Pattern URI_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9+.-]*:/.*");
    static final Status SHUTDOWN_NOW_STATUS = Status.UNAVAILABLE.withDescription("Channel shutdownNow invoked");
    static final Status SHUTDOWN_STATUS = Status.UNAVAILABLE.withDescription("Channel shutdown invoked");
    static final Status SUBCHANNEL_SHUTDOWN_STATUS = Status.UNAVAILABLE.withDescription("Subchannel shutdown invoked");
    private static final ManagedChannelServiceConfig EMPTY_SERVICE_CONFIG = ManagedChannelServiceConfig.empty();
    private static final InternalConfigSelector INITIAL_PENDING_SELECTOR = new InternalConfigSelector(){

        public InternalConfigSelector.Result selectConfig(LoadBalancer.PickSubchannelArgs pickSubchannelArgs) {
            throw new IllegalStateException("Resolution is pending");
        }
    };
    private final InternalLogId logId;
    private final String target;
    private final NameResolverRegistry nameResolverRegistry;
    private final NameResolver.Factory nameResolverFactory;
    private final NameResolver.Args nameResolverArgs;
    private final AutoConfiguredLoadBalancerFactory loadBalancerFactory;
    private final ClientTransportFactory originalTransportFactory;
    private final ClientTransportFactory transportFactory;
    private final ClientTransportFactory oobTransportFactory;
    private final RestrictedScheduledExecutor scheduledExecutor;
    private final Executor executor;
    private final ObjectPool<? extends Executor> executorPool;
    private final ObjectPool<? extends Executor> balancerRpcExecutorPool;
    private final ExecutorHolder balancerRpcExecutorHolder;
    private final ExecutorHolder offloadExecutorHolder;
    private final TimeProvider timeProvider;
    private final int maxTraceEvents;
    final SynchronizationContext syncContext = new SynchronizationContext(new Thread.UncaughtExceptionHandler(){

        public void uncaughtException(Thread thread, Throwable throwable) {
            logger.log(Level.SEVERE, "[" + ManagedChannelImpl.this.getLogId() + "] Uncaught exception in the SynchronizationContext. Panic!", throwable);
            ManagedChannelImpl.this.panic(throwable);
        }
    });
    private boolean fullStreamDecompression;
    private final DecompressorRegistry decompressorRegistry;
    private final CompressorRegistry compressorRegistry;
    private final m<l> stopwatchSupplier;
    private final long idleTimeoutMillis;
    private final ConnectivityStateManager channelStateManager = new ConnectivityStateManager();
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Channel interceptorChannel;
    private final String userAgent;
    private NameResolver nameResolver;
    private boolean nameResolverStarted;
    private LbHelperImpl lbHelper;
    private volatile LoadBalancer.SubchannelPicker subchannelPicker;
    private boolean panicMode;
    private final Set<InternalSubchannel> subchannels = new HashSet<InternalSubchannel>(16, 0.75f);
    private Collection<RealChannel.PendingCall<?, ?>> pendingCalls;
    private final Object pendingCallsInUseObject = new Object();
    private final Set<OobChannel> oobChannels = new HashSet<OobChannel>(1, 0.75f);
    private final DelayedClientTransport delayedTransport;
    private final UncommittedRetriableStreamsRegistry uncommittedRetriableStreamsRegistry = new UncommittedRetriableStreamsRegistry();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private boolean shutdownNowed;
    private volatile boolean terminating;
    private volatile boolean terminated;
    private final CountDownLatch terminatedLatch = new CountDownLatch(1);
    private final CallTracer.Factory callTracerFactory;
    private final CallTracer channelCallTracer;
    private final ChannelTracer channelTracer;
    private final ChannelLogger channelLogger;
    private final InternalChannelz channelz;
    private final RealChannel realChannel;
    private ResolutionState lastResolutionState = ResolutionState.NO_RESOLUTION;
    private ManagedChannelServiceConfig lastServiceConfig = EMPTY_SERVICE_CONFIG;
    private final ManagedChannelServiceConfig defaultServiceConfig;
    private boolean serviceConfigUpdated = false;
    private final boolean lookUpServiceConfig;
    private final RetriableStream.ChannelBufferMeter channelBufferUsed = new RetriableStream.ChannelBufferMeter();
    private final long perRpcBufferLimit;
    private final long channelBufferLimit;
    private final boolean retryEnabled;
    private final ManagedClientTransport.Listener delayedTransportListener = new DelayedTransportListener();
    final InUseStateAggregator<Object> inUseStateAggregator = new IdleModeStateAggregator();
    private SynchronizationContext.ScheduledHandle scheduledNameResolverRefresh;
    private BackoffPolicy nameResolverBackoffPolicy;
    private final ClientCallImpl.ClientStreamProvider transportProvider = new ChannelStreamProvider();
    private final Rescheduler idleTimer;

    private void maybeShutdownNowSubchannels() {
        if (this.shutdownNowed) {
            for (InternalSubchannel internalInstrumented : this.subchannels) {
                internalInstrumented.shutdownNow(SHUTDOWN_NOW_STATUS);
            }
            for (OobChannel oobChannel : this.oobChannels) {
                oobChannel.getInternalSubchannel().shutdownNow(SHUTDOWN_NOW_STATUS);
            }
        }
    }

    @Override
    public final InternalLogId getLogId() {
        return this.logId;
    }

    private void shutdownNameResolverAndLoadBalancer(boolean bl) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (bl) {
            b.b(this.nameResolverStarted, "nameResolver is not started");
            b.b(this.lbHelper != null, "lbHelper is null");
        }
        if (this.nameResolver != null) {
            this.cancelNameResolverBackoff();
            this.nameResolver.shutdown();
            this.nameResolverStarted = false;
            this.nameResolver = bl ? ManagedChannelImpl.getNameResolver(this.target, this.nameResolverFactory, this.nameResolverArgs) : null;
        }
        if (this.lbHelper != null) {
            this.lbHelper.lb.shutdown();
            this.lbHelper = null;
        }
        this.subchannelPicker = null;
    }

    final void exitIdleMode() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.shutdown.get() || this.panicMode) {
            return;
        }
        if (this.inUseStateAggregator.isInUse()) {
            this.cancelIdleTimer(false);
        } else {
            this.rescheduleIdleTimer();
        }
        if (this.lbHelper != null) {
            return;
        }
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Exiting idle mode");
        Object object = new LbHelperImpl();
        new LbHelperImpl().lb = this.loadBalancerFactory.newLoadBalancer((LoadBalancer.Helper)object);
        this.lbHelper = object;
        object = new NameResolverListener((LbHelperImpl)object, this.nameResolver);
        this.nameResolver.start((NameResolver.Listener2)object);
        this.nameResolverStarted = true;
    }

    private void enterIdleMode() {
        this.shutdownNameResolverAndLoadBalancer(true);
        this.delayedTransport.reprocess(null);
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Entering IDLE state");
        this.channelStateManager.gotoState(ConnectivityState.IDLE);
        if (this.inUseStateAggregator.isInUse()) {
            this.exitIdleMode();
        }
    }

    private void cancelIdleTimer(boolean bl) {
        this.idleTimer.cancel(bl);
    }

    private void rescheduleIdleTimer() {
        if (this.idleTimeoutMillis == -1L) {
            return;
        }
        this.idleTimer.reschedule(this.idleTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    private void cancelNameResolverBackoff() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.scheduledNameResolverRefresh != null) {
            this.scheduledNameResolverRefresh.cancel();
            this.scheduledNameResolverRefresh = null;
            this.nameResolverBackoffPolicy = null;
        }
    }

    private void refreshAndResetNameResolution() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        this.cancelNameResolverBackoff();
        this.refreshNameResolution();
    }

    private void refreshNameResolution() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.nameResolverStarted) {
            this.nameResolver.refresh();
        }
    }

    ManagedChannelImpl(ManagedChannelImplBuilder managedChannelImplBuilder, ClientTransportFactory object, BackoffPolicy.Provider provider, ObjectPool<? extends Executor> objectPool, m<l> m2, List<ClientInterceptor> list, final TimeProvider timeProvider) {
        this.target = b.a(managedChannelImplBuilder.target, (Object)"target");
        this.logId = InternalLogId.allocate("Channel", this.target);
        this.timeProvider = b.a(timeProvider, (Object)"timeProvider");
        this.executorPool = b.a(managedChannelImplBuilder.executorPool, (Object)"executorPool");
        this.executor = b.a(this.executorPool.getObject(), (Object)"executor");
        this.originalTransportFactory = object;
        this.transportFactory = new CallCredentialsApplyingTransportFactory((ClientTransportFactory)object, managedChannelImplBuilder.callCredentials, this.executor);
        this.oobTransportFactory = new CallCredentialsApplyingTransportFactory((ClientTransportFactory)object, null, this.executor);
        this.scheduledExecutor = new RestrictedScheduledExecutor(this.transportFactory.getScheduledExecutorService());
        this.maxTraceEvents = managedChannelImplBuilder.maxTraceEvents;
        this.channelTracer = new ChannelTracer(this.logId, managedChannelImplBuilder.maxTraceEvents, timeProvider.currentTimeNanos(), "Channel for '" + this.target + "'");
        this.channelLogger = new ChannelLoggerImpl(this.channelTracer, timeProvider);
        this.nameResolverFactory = managedChannelImplBuilder.getNameResolverFactory();
        object = managedChannelImplBuilder.proxyDetector != null ? managedChannelImplBuilder.proxyDetector : GrpcUtil.DEFAULT_PROXY_DETECTOR;
        this.retryEnabled = managedChannelImplBuilder.retryEnabled && !managedChannelImplBuilder.temporarilyDisableRetry;
        this.loadBalancerFactory = new AutoConfiguredLoadBalancerFactory(managedChannelImplBuilder.defaultLbPolicy);
        this.offloadExecutorHolder = new ExecutorHolder(b.a(managedChannelImplBuilder.offloadExecutorPool, (Object)"offloadExecutorPool"));
        this.nameResolverRegistry = managedChannelImplBuilder.nameResolverRegistry;
        ScParser scParser = new ScParser(this.retryEnabled, managedChannelImplBuilder.maxRetryAttempts, managedChannelImplBuilder.maxHedgedAttempts, this.loadBalancerFactory);
        this.nameResolverArgs = NameResolver.Args.newBuilder().setDefaultPort(managedChannelImplBuilder.getDefaultPort()).setProxyDetector((ProxyDetector)object).setSynchronizationContext(this.syncContext).setScheduledExecutorService(this.scheduledExecutor).setServiceConfigParser(scParser).setChannelLogger(this.channelLogger).setOffloadExecutor(new Executor(){

            public void execute(Runnable runnable) {
                ManagedChannelImpl.this.offloadExecutorHolder.getExecutor().execute(runnable);
            }
        }).build();
        this.nameResolver = ManagedChannelImpl.getNameResolver(this.target, this.nameResolverFactory, this.nameResolverArgs);
        this.balancerRpcExecutorPool = b.a(objectPool, (Object)"balancerRpcExecutorPool");
        this.balancerRpcExecutorHolder = new ExecutorHolder(objectPool);
        this.delayedTransport = new DelayedClientTransport(this.executor, this.syncContext);
        this.delayedTransport.start(this.delayedTransportListener);
        this.backoffPolicyProvider = provider;
        if (managedChannelImplBuilder.defaultServiceConfig != null) {
            object = scParser.parseServiceConfig(managedChannelImplBuilder.defaultServiceConfig);
            b.b(((NameResolver.ConfigOrError)object).getError() == null, "Default config is invalid: %s", ((NameResolver.ConfigOrError)object).getError());
            this.lastServiceConfig = this.defaultServiceConfig = (ManagedChannelServiceConfig)((NameResolver.ConfigOrError)object).getConfig();
        } else {
            this.defaultServiceConfig = null;
        }
        this.lookUpServiceConfig = managedChannelImplBuilder.lookUpServiceConfig;
        ManagedChannelImpl managedChannelImpl = this;
        this.realChannel = managedChannelImpl.new RealChannel(managedChannelImpl.nameResolver.getServiceAuthority());
        object = this.realChannel;
        if (managedChannelImplBuilder.binlog != null) {
            object = managedChannelImplBuilder.binlog.wrapChannel((Channel)object);
        }
        this.interceptorChannel = ClientInterceptors.intercept((Channel)object, list);
        this.stopwatchSupplier = b.a(m2, (Object)"stopwatchSupplier");
        if (managedChannelImplBuilder.idleTimeoutMillis == -1L) {
            this.idleTimeoutMillis = managedChannelImplBuilder.idleTimeoutMillis;
        } else {
            b.a(managedChannelImplBuilder.idleTimeoutMillis >= ManagedChannelImplBuilder.IDLE_MODE_MIN_TIMEOUT_MILLIS, "invalid idleTimeoutMillis %s", managedChannelImplBuilder.idleTimeoutMillis);
            this.idleTimeoutMillis = managedChannelImplBuilder.idleTimeoutMillis;
        }
        this.idleTimer = new Rescheduler(new IdleModeTimer(), this.syncContext, this.transportFactory.getScheduledExecutorService(), m2.get());
        this.fullStreamDecompression = managedChannelImplBuilder.fullStreamDecompression;
        this.decompressorRegistry = b.a(managedChannelImplBuilder.decompressorRegistry, (Object)"decompressorRegistry");
        this.compressorRegistry = b.a(managedChannelImplBuilder.compressorRegistry, (Object)"compressorRegistry");
        this.userAgent = managedChannelImplBuilder.userAgent;
        this.channelBufferLimit = managedChannelImplBuilder.retryBufferSize;
        this.perRpcBufferLimit = managedChannelImplBuilder.perRpcBufferLimit;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class ChannelCallTracerFactory
        implements CallTracer.Factory {
            ChannelCallTracerFactory() {
            }

            @Override
            public final CallTracer create() {
                return new CallTracer(timeProvider);
            }
        }
        this.callTracerFactory = new ChannelCallTracerFactory();
        this.channelCallTracer = this.callTracerFactory.create();
        this.channelz = b.a(managedChannelImplBuilder.channelz);
        this.channelz.addRootChannel(this);
        if (!this.lookUpServiceConfig) {
            if (this.defaultServiceConfig != null) {
                this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Service config look-up disabled, using default service config");
            }
            this.serviceConfigUpdated = true;
        }
    }

    static NameResolver getNameResolver(String string, NameResolver.Factory factory, NameResolver.Args args) {
        NameResolver nameResolver;
        URI uRI = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            stringBuilder.append(uRISyntaxException.getMessage());
        }
        if (uRI != null && (nameResolver = factory.newNameResolver(uRI, args)) != null) {
            return nameResolver;
        }
        if (!URI_PATTERN.matcher(string).matches()) {
            try {
                uRI = new URI(factory.getDefaultScheme(), "", "/" + string, null);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException(uRISyntaxException);
            }
            nameResolver = factory.newNameResolver(uRI, args);
            if (nameResolver != null) {
                return nameResolver;
            }
        }
        throw new IllegalArgumentException(String.format("cannot find a NameResolver for %s%s", string, stringBuilder.length() > 0 ? " (" + stringBuilder + ")" : ""));
    }

    @Override
    public final ManagedChannelImpl shutdown() {
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "shutdown() called");
        if (!this.shutdown.compareAndSet(false, true)) {
            return this;
        }
        final class Shutdown
        implements Runnable {
            Shutdown() {
            }

            public final void run() {
                ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Entering SHUTDOWN state");
                ManagedChannelImpl.this.channelStateManager.gotoState(ConnectivityState.SHUTDOWN);
            }
        }
        this.syncContext.execute(new Shutdown());
        this.realChannel.shutdown();
        final class CancelIdleTimer
        implements Runnable {
            CancelIdleTimer() {
            }

            public final void run() {
                ManagedChannelImpl.this.cancelIdleTimer(true);
            }
        }
        this.syncContext.execute(new CancelIdleTimer());
        return this;
    }

    final void panic(final Throwable throwable) {
        if (this.panicMode) {
            return;
        }
        this.panicMode = true;
        this.cancelIdleTimer(true);
        this.shutdownNameResolverAndLoadBalancer(false);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class PanicSubchannelPicker
        extends LoadBalancer.SubchannelPicker {
            private final LoadBalancer.PickResult panicPickResult;

            PanicSubchannelPicker() {
                this.panicPickResult = LoadBalancer.PickResult.withDrop(Status.INTERNAL.withDescription("Panic! This is a bug!").withCause(throwable));
            }

            @Override
            public final LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs pickSubchannelArgs) {
                return this.panicPickResult;
            }

            public final String toString() {
                return g.a(PanicSubchannelPicker.class).a("panicPickResult", this.panicPickResult).toString();
            }
        }
        this.updateSubchannelPicker(new PanicSubchannelPicker());
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.ERROR, "PANIC! Entering TRANSIENT_FAILURE");
        this.channelStateManager.gotoState(ConnectivityState.TRANSIENT_FAILURE);
    }

    private void updateSubchannelPicker(LoadBalancer.SubchannelPicker subchannelPicker) {
        this.subchannelPicker = subchannelPicker;
        this.delayedTransport.reprocess(subchannelPicker);
    }

    public final <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions) {
        return this.interceptorChannel.newCall(methodDescriptor, callOptions);
    }

    @Override
    public final String authority() {
        return this.interceptorChannel.authority();
    }

    private Executor getCallExecutor(CallOptions object) {
        if ((object = ((CallOptions)object).getExecutor()) == null) {
            object = this.executor;
        }
        return object;
    }

    private void maybeTerminateChannel() {
        if (this.terminated) {
            return;
        }
        if (this.shutdown.get() && this.subchannels.isEmpty() && this.oobChannels.isEmpty()) {
            this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Terminated");
            this.channelz.removeRootChannel(this);
            this.executorPool.returnObject(this.executor);
            this.balancerRpcExecutorHolder.release();
            this.offloadExecutorHolder.release();
            this.transportFactory.close();
            this.terminated = true;
            this.terminatedLatch.countDown();
        }
    }

    private void handleInternalSubchannelState(ConnectivityStateInfo connectivityStateInfo) {
        if (connectivityStateInfo.getState() == ConnectivityState.TRANSIENT_FAILURE || connectivityStateInfo.getState() == ConnectivityState.IDLE) {
            this.refreshAndResetNameResolution();
        }
    }

    public final String toString() {
        return g.a(this).a("logId", this.logId.getId()).a("target", this.target).toString();
    }

    private void logWarningIfNotInSyncContext(String string) {
        try {
            this.syncContext.throwIfNotInThisSynchronizationContext();
            return;
        }
        catch (IllegalStateException illegalStateException) {
            logger.log(Level.WARNING, string + " should be called from SynchronizationContext. This warning will become an exception in a future release. See https://github.com/grpc/grpc-java/issues/5015 for more details", illegalStateException);
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ResolutionState {
        NO_RESOLUTION,
        SUCCESS,
        ERROR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ScParser
    extends NameResolver.ServiceConfigParser {
        private final boolean retryEnabled;
        private final int maxRetryAttemptsLimit;
        private final int maxHedgedAttemptsLimit;
        private final AutoConfiguredLoadBalancerFactory autoLoadBalancerFactory;

        ScParser(boolean bl, int n2, int n3, AutoConfiguredLoadBalancerFactory autoConfiguredLoadBalancerFactory) {
            this.retryEnabled = bl;
            this.maxRetryAttemptsLimit = n2;
            this.maxHedgedAttemptsLimit = n3;
            this.autoLoadBalancerFactory = b.a(autoConfiguredLoadBalancerFactory, (Object)"autoLoadBalancerFactory");
        }

        @Override
        public final NameResolver.ConfigOrError parseServiceConfig(Map<String, ?> map) {
            try {
                Object object = this.autoLoadBalancerFactory.parseLoadBalancerPolicy(map);
                if (object == null) {
                    object = null;
                } else {
                    if (((NameResolver.ConfigOrError)object).getError() != null) {
                        return NameResolver.ConfigOrError.fromError(((NameResolver.ConfigOrError)object).getError());
                    }
                    object = ((NameResolver.ConfigOrError)object).getConfig();
                }
                return NameResolver.ConfigOrError.fromConfig(ManagedChannelServiceConfig.fromServiceConfig(map, this.retryEnabled, this.maxRetryAttemptsLimit, this.maxHedgedAttemptsLimit, object));
            }
            catch (RuntimeException runtimeException) {
                return NameResolver.ConfigOrError.fromError(Status.UNKNOWN.withDescription("failed to parse service config").withCause(runtimeException));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RestrictedScheduledExecutor
    implements ScheduledExecutorService {
        final ScheduledExecutorService delegate;

        private RestrictedScheduledExecutor(ScheduledExecutorService scheduledExecutorService) {
            this.delegate = b.a(scheduledExecutorService, (Object)"delegate");
        }

        @Override
        public final <V> ScheduledFuture<V> schedule(Callable<V> callable, long l2, TimeUnit timeUnit) {
            return this.delegate.schedule(callable, l2, timeUnit);
        }

        @Override
        public final ScheduledFuture<?> schedule(Runnable runnable, long l2, TimeUnit timeUnit) {
            return this.delegate.schedule(runnable, l2, timeUnit);
        }

        @Override
        public final ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
            return this.delegate.scheduleAtFixedRate(runnable, l2, l3, timeUnit);
        }

        @Override
        public final ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
            return this.delegate.scheduleWithFixedDelay(runnable, l2, l3, timeUnit);
        }

        @Override
        public final boolean awaitTermination(long l2, TimeUnit timeUnit) throws InterruptedException {
            return this.delegate.awaitTermination(l2, timeUnit);
        }

        @Override
        public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
            return this.delegate.invokeAll(collection);
        }

        @Override
        public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException {
            return this.delegate.invokeAll(collection, l2, timeUnit);
        }

        @Override
        public final <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
            return this.delegate.invokeAny(collection);
        }

        @Override
        public final <T> T invokeAny(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.invokeAny(collection, l2, timeUnit);
        }

        @Override
        public final boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public final boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public final void shutdown() {
            throw new UnsupportedOperationException("Restricted: shutdown() is not allowed");
        }

        @Override
        public final List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException("Restricted: shutdownNow() is not allowed");
        }

        @Override
        public final <T> Future<T> submit(Callable<T> callable) {
            return this.delegate.submit(callable);
        }

        @Override
        public final Future<?> submit(Runnable runnable) {
            return this.delegate.submit(runnable);
        }

        @Override
        public final <T> Future<T> submit(Runnable runnable, T t2) {
            return this.delegate.submit(runnable, t2);
        }

        @Override
        public final void execute(Runnable runnable) {
            this.delegate.execute(runnable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ExecutorHolder {
        private final ObjectPool<? extends Executor> pool;
        private Executor executor;

        ExecutorHolder(ObjectPool<? extends Executor> objectPool) {
            this.pool = b.a(objectPool, (Object)"executorPool");
        }

        final synchronized Executor getExecutor() {
            if (this.executor == null) {
                this.executor = b.a(this.pool.getObject(), "%s.getObject()", (Object)this.executor);
            }
            return this.executor;
        }

        final synchronized void release() {
            if (this.executor != null) {
                this.executor = this.pool.returnObject(this.executor);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IdleModeStateAggregator
    extends InUseStateAggregator<Object> {
        private IdleModeStateAggregator() {
        }

        @Override
        protected final void handleInUse() {
            ManagedChannelImpl.this.exitIdleMode();
        }

        @Override
        protected final void handleNotInUse() {
            if (ManagedChannelImpl.this.shutdown.get()) {
                return;
            }
            ManagedChannelImpl.this.rescheduleIdleTimer();
        }
    }

    private final class DelayedTransportListener
    implements ManagedClientTransport.Listener {
        private DelayedTransportListener() {
        }

        public final void transportShutdown(Status status) {
            b.b(ManagedChannelImpl.this.shutdown.get(), "Channel must have been shut down");
        }

        public final void transportReady() {
        }

        public final void transportInUse(boolean bl) {
            ManagedChannelImpl.this.inUseStateAggregator.updateObjectInUse(ManagedChannelImpl.this.delayedTransport, bl);
        }

        public final void transportTerminated() {
            b.b(ManagedChannelImpl.this.shutdown.get(), "Channel must have been shut down");
            ManagedChannelImpl.this.terminating = true;
            ManagedChannelImpl.this.shutdownNameResolverAndLoadBalancer(false);
            ManagedChannelImpl.this.maybeShutdownNowSubchannels();
            ManagedChannelImpl.this.maybeTerminateChannel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SubchannelImpl
    extends AbstractSubchannel {
        final LoadBalancer.CreateSubchannelArgs args;
        final LbHelperImpl helper;
        final InternalLogId subchannelLogId;
        final ChannelLoggerImpl subchannelLogger;
        final ChannelTracer subchannelTracer;
        InternalSubchannel subchannel;
        boolean started;
        boolean shutdown;
        SynchronizationContext.ScheduledHandle delayedShutdownTask;

        SubchannelImpl(LoadBalancer.CreateSubchannelArgs createSubchannelArgs, LbHelperImpl lbHelperImpl) {
            this.args = b.a(createSubchannelArgs, (Object)"args");
            this.helper = b.a(lbHelperImpl, (Object)"helper");
            this.subchannelLogId = InternalLogId.allocate("Subchannel", ManagedChannelImpl.this.authority());
            this.subchannelTracer = new ChannelTracer(this.subchannelLogId, ManagedChannelImpl.this.maxTraceEvents, ManagedChannelImpl.this.timeProvider.currentTimeNanos(), "Subchannel for " + createSubchannelArgs.getAddresses());
            this.subchannelLogger = new ChannelLoggerImpl(this.subchannelTracer, ManagedChannelImpl.this.timeProvider);
        }

        private void internalStart(LoadBalancer.SubchannelStateListener object) {
            b.b(!this.started, "already started");
            b.b(!this.shutdown, "already shutdown");
            this.started = true;
            if (ManagedChannelImpl.this.terminating) {
                ManagedChannelImpl.this.syncContext.execute(new Runnable((LoadBalancer.SubchannelStateListener)object){
                    final /* synthetic */ LoadBalancer.SubchannelStateListener val$listener;
                    {
                        this.val$listener = subchannelStateListener;
                    }

                    public void run() {
                        this.val$listener.onSubchannelState(ConnectivityStateInfo.forNonError(ConnectivityState.SHUTDOWN));
                    }
                });
                return;
            }
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            final class ManagedInternalSubchannelCallback
            extends InternalSubchannel.Callback {
                final /* synthetic */ LoadBalancer.SubchannelStateListener val$listener;

                ManagedInternalSubchannelCallback() {
                    this.val$listener = subchannelStateListener;
                }

                @Override
                final void onTerminated(InternalSubchannel internalSubchannel) {
                    ManagedChannelImpl.this.subchannels.remove(internalSubchannel);
                    ManagedChannelImpl.this.channelz.removeSubchannel(internalSubchannel);
                    ManagedChannelImpl.this.maybeTerminateChannel();
                }

                @Override
                final void onStateChange(InternalSubchannel internalSubchannel, ConnectivityStateInfo connectivityStateInfo) {
                    ManagedChannelImpl.this.handleInternalSubchannelState(connectivityStateInfo);
                    b.b(this.val$listener != null, "listener is null");
                    this.val$listener.onSubchannelState(connectivityStateInfo);
                }

                @Override
                final void onInUse(InternalSubchannel internalSubchannel) {
                    ManagedChannelImpl.this.inUseStateAggregator.updateObjectInUse(internalSubchannel, true);
                }

                @Override
                final void onNotInUse(InternalSubchannel internalSubchannel) {
                    ManagedChannelImpl.this.inUseStateAggregator.updateObjectInUse(internalSubchannel, false);
                }
            }
            object = new InternalSubchannel(this.args.getAddresses(), ManagedChannelImpl.this.authority(), ManagedChannelImpl.this.userAgent, ManagedChannelImpl.this.backoffPolicyProvider, ManagedChannelImpl.this.transportFactory, ManagedChannelImpl.this.transportFactory.getScheduledExecutorService(), ManagedChannelImpl.this.stopwatchSupplier, ManagedChannelImpl.this.syncContext, new ManagedInternalSubchannelCallback(), ManagedChannelImpl.this.channelz, ManagedChannelImpl.this.callTracerFactory.create(), this.subchannelTracer, this.subchannelLogId, this.subchannelLogger);
            ManagedChannelImpl.this.channelTracer.reportEvent(new InternalChannelz.ChannelTrace.Event.Builder().setDescription("Child Subchannel started").setSeverity(InternalChannelz.ChannelTrace.Event.Severity.CT_INFO).setTimestampNanos(ManagedChannelImpl.this.timeProvider.currentTimeNanos()).setSubchannelRef((InternalWithLogId)object).build());
            this.subchannel = object;
            ManagedChannelImpl.this.syncContext.execute(new Runnable((InternalSubchannel)object){
                final /* synthetic */ InternalSubchannel val$internalSubchannel;
                {
                    this.val$internalSubchannel = internalSubchannel;
                }

                public void run() {
                    ManagedChannelImpl.this.channelz.addSubchannel(this.val$internalSubchannel);
                    ManagedChannelImpl.this.subchannels.add(this.val$internalSubchannel);
                }
            });
        }

        @Override
        public final void start(LoadBalancer.SubchannelStateListener subchannelStateListener) {
            ManagedChannelImpl.this.syncContext.throwIfNotInThisSynchronizationContext();
            this.internalStart(subchannelStateListener);
        }

        @Override
        public final void shutdown() {
            ManagedChannelImpl.this.logWarningIfNotInSyncContext("Subchannel.shutdown()");
            ManagedChannelImpl.this.syncContext.execute(new Runnable(){

                public void run() {
                    SubchannelImpl.this.internalShutdown();
                }
            });
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void internalShutdown() {
            ManagedChannelImpl.this.syncContext.throwIfNotInThisSynchronizationContext();
            if (this.subchannel == null) {
                this.shutdown = true;
                return;
            }
            if (this.shutdown) {
                if (!ManagedChannelImpl.this.terminating || this.delayedShutdownTask == null) return;
                this.delayedShutdownTask.cancel();
                this.delayedShutdownTask = null;
            } else {
                this.shutdown = true;
            }
            if (!ManagedChannelImpl.this.terminating) {
                final class ShutdownSubchannel
                implements Runnable {
                    ShutdownSubchannel() {
                    }

                    public final void run() {
                        SubchannelImpl.this.subchannel.shutdown(SUBCHANNEL_SHUTDOWN_STATUS);
                    }
                }
                this.delayedShutdownTask = ManagedChannelImpl.this.syncContext.schedule(new LogExceptionRunnable(new ShutdownSubchannel()), 5L, TimeUnit.SECONDS, ManagedChannelImpl.this.transportFactory.getScheduledExecutorService());
                return;
            }
            this.subchannel.shutdown(SHUTDOWN_STATUS);
        }

        @Override
        public final void requestConnection() {
            ManagedChannelImpl.this.logWarningIfNotInSyncContext("Subchannel.requestConnection()");
            b.b(this.started, "not started");
            this.subchannel.obtainActiveTransport();
        }

        @Override
        public final List<EquivalentAddressGroup> getAllAddresses() {
            ManagedChannelImpl.this.logWarningIfNotInSyncContext("Subchannel.getAllAddresses()");
            b.b(this.started, "not started");
            return this.subchannel.getAddressGroups();
        }

        @Override
        public final Attributes getAttributes() {
            return this.args.getAttributes();
        }

        public final String toString() {
            return this.subchannelLogId.toString();
        }

        @Override
        public final Object getInternalSubchannel() {
            b.b(this.started, "Subchannel is not started");
            return this.subchannel;
        }

        @Override
        public final void updateAddresses(List<EquivalentAddressGroup> list) {
            ManagedChannelImpl.this.syncContext.throwIfNotInThisSynchronizationContext();
            this.subchannel.updateAddresses(list);
        }
    }

    private final class NameResolverListener
    extends NameResolver.Listener2 {
        final LbHelperImpl helper;
        final NameResolver resolver;

        NameResolverListener(LbHelperImpl lbHelperImpl, NameResolver nameResolver) {
            this.helper = b.a(lbHelperImpl, (Object)"helperImpl");
            this.resolver = b.a(nameResolver, (Object)"resolver");
        }

        public final void onResult(final NameResolver.ResolutionResult resolutionResult) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            final class NamesResolved
            implements Runnable {
                NamesResolved() {
                }

                @Override
                public final void run() {
                    Status status;
                    Object object = resolutionResult.getAddresses();
                    ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Resolved address: {0}, config={1}", object, resolutionResult.getAttributes());
                    if (ManagedChannelImpl.this.lastResolutionState != ResolutionState.SUCCESS) {
                        ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Address resolved: {0}", object);
                        ManagedChannelImpl.this.lastResolutionState = ResolutionState.SUCCESS;
                    }
                    ManagedChannelImpl.this.nameResolverBackoffPolicy = null;
                    Object object2 = resolutionResult.getServiceConfig();
                    Object object3 = resolutionResult.getAttributes().get(InternalConfigSelector.KEY);
                    Map<String, ?> map = object2 != null && ((NameResolver.ConfigOrError)object2).getConfig() != null ? (ManagedChannelServiceConfig)((NameResolver.ConfigOrError)object2).getConfig() : null;
                    Status status2 = status = object2 != null ? ((NameResolver.ConfigOrError)object2).getError() : null;
                    if (!ManagedChannelImpl.this.lookUpServiceConfig) {
                        if (map != null) {
                            ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Service config from name resolver discarded by channel settings");
                        }
                        Object object4 = object2 = ManagedChannelImpl.this.defaultServiceConfig == null ? EMPTY_SERVICE_CONFIG : ManagedChannelImpl.this.defaultServiceConfig;
                        if (object3 != null) {
                            ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Config selector from name resolver discarded by channel settings");
                        }
                        ManagedChannelImpl.this.realChannel.updateConfigSelector(((ManagedChannelServiceConfig)object2).getDefaultConfigSelector());
                    } else {
                        if (map != null) {
                            object2 = map;
                            if (object3 != null) {
                                ManagedChannelImpl.this.realChannel.updateConfigSelector((InternalConfigSelector)object3);
                                if (((ManagedChannelServiceConfig)object2).getDefaultConfigSelector() != null) {
                                    ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Method configs in service config will be discarded due to presence ofconfig-selector");
                                }
                            } else {
                                ManagedChannelImpl.this.realChannel.updateConfigSelector(((ManagedChannelServiceConfig)object2).getDefaultConfigSelector());
                            }
                        } else if (ManagedChannelImpl.this.defaultServiceConfig != null) {
                            object2 = ManagedChannelImpl.this.defaultServiceConfig;
                            ManagedChannelImpl.this.realChannel.updateConfigSelector(((ManagedChannelServiceConfig)object2).getDefaultConfigSelector());
                            ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Received no service config, using default service config");
                        } else if (status != null) {
                            if (!ManagedChannelImpl.this.serviceConfigUpdated) {
                                ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Fallback to error due to invalid first service config without default config");
                                NameResolverListener.this.onError(((NameResolver.ConfigOrError)object2).getError());
                                return;
                            }
                            object2 = ManagedChannelImpl.this.lastServiceConfig;
                        } else {
                            object2 = EMPTY_SERVICE_CONFIG;
                            ManagedChannelImpl.this.realChannel.updateConfigSelector(null);
                        }
                        if (!((ManagedChannelServiceConfig)object2).equals(ManagedChannelImpl.this.lastServiceConfig)) {
                            ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Service config changed{0}", object2 == EMPTY_SERVICE_CONFIG ? " to empty" : "");
                            ManagedChannelImpl.this.lastServiceConfig = (ManagedChannelServiceConfig)object2;
                        }
                        try {
                            ManagedChannelImpl.this.serviceConfigUpdated = true;
                        }
                        catch (RuntimeException runtimeException) {
                            logger.log(Level.WARNING, "[" + ManagedChannelImpl.this.getLogId() + "] Unexpected exception from parsing service config", runtimeException);
                        }
                    }
                    object3 = resolutionResult.getAttributes();
                    if (NameResolverListener.this.helper == ManagedChannelImpl.this.lbHelper) {
                        object3 = ((Attributes)object3).toBuilder().discard(InternalConfigSelector.KEY);
                        map = ((ManagedChannelServiceConfig)object2).getHealthCheckingConfig();
                        if (map != null) {
                            ((Attributes.Builder)object3).set(LoadBalancer.ATTR_HEALTH_CHECKING_CONFIG, map).build();
                        }
                        if (!((Status)(object = NameResolverListener.this.helper.lb.tryHandleResolvedAddresses(LoadBalancer.ResolvedAddresses.newBuilder().setAddresses((List<EquivalentAddressGroup>)object).setAttributes(((Attributes.Builder)object3).build()).setLoadBalancingPolicyConfig(((ManagedChannelServiceConfig)object2).getLoadBalancingConfig()).build()))).isOk()) {
                            NameResolverListener.this.handleErrorInSyncContext(((Status)object).augmentDescription(NameResolverListener.this.resolver + " was used"));
                        }
                    }
                }
            }
            ManagedChannelImpl.this.syncContext.execute(new NamesResolved());
        }

        public final void onError(final Status status) {
            b.a(!status.isOk(), (Object)"the error status must not be OK");
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            final class NameResolverErrorHandler
            implements Runnable {
                NameResolverErrorHandler() {
                }

                @Override
                public final void run() {
                    NameResolverListener.this.handleErrorInSyncContext(status);
                }
            }
            ManagedChannelImpl.this.syncContext.execute(new NameResolverErrorHandler());
        }

        private void handleErrorInSyncContext(Status status) {
            logger.log(Level.WARNING, "[{0}] Failed to resolve name. status={1}", new Object[]{ManagedChannelImpl.this.getLogId(), status});
            ManagedChannelImpl.this.realChannel.onConfigError();
            if (ManagedChannelImpl.this.lastResolutionState != ResolutionState.ERROR) {
                ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.WARNING, "Failed to resolve name: {0}", status);
                ManagedChannelImpl.this.lastResolutionState = ResolutionState.ERROR;
            }
            if (this.helper != ManagedChannelImpl.this.lbHelper) {
                return;
            }
            this.helper.lb.handleNameResolutionError(status);
            this.scheduleExponentialBackOffInSyncContext();
        }

        private void scheduleExponentialBackOffInSyncContext() {
            if (ManagedChannelImpl.this.scheduledNameResolverRefresh != null && ManagedChannelImpl.this.scheduledNameResolverRefresh.isPending()) {
                return;
            }
            if (ManagedChannelImpl.this.nameResolverBackoffPolicy == null) {
                ManagedChannelImpl.this.nameResolverBackoffPolicy = ManagedChannelImpl.this.backoffPolicyProvider.get();
            }
            long l2 = ManagedChannelImpl.this.nameResolverBackoffPolicy.nextBackoffNanos();
            ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Scheduling DNS resolution backoff for {0} ns", l2);
            ManagedChannelImpl.this.scheduledNameResolverRefresh = ManagedChannelImpl.this.syncContext.schedule(new DelayedNameResolverRefresh(), l2, TimeUnit.NANOSECONDS, ManagedChannelImpl.this.transportFactory.getScheduledExecutorService());
        }
    }

    private class LbHelperImpl
    extends LoadBalancer.Helper {
        AutoConfiguredLoadBalancerFactory.AutoConfiguredLoadBalancer lb;

        private LbHelperImpl() {
        }

        public AbstractSubchannel createSubchannel(LoadBalancer.CreateSubchannelArgs createSubchannelArgs) {
            ManagedChannelImpl.this.syncContext.throwIfNotInThisSynchronizationContext();
            return this.createSubchannelInternal(createSubchannelArgs);
        }

        private SubchannelImpl createSubchannelInternal(LoadBalancer.CreateSubchannelArgs createSubchannelArgs) {
            b.b(!ManagedChannelImpl.this.terminated, "Channel is terminated");
            return new SubchannelImpl(createSubchannelArgs, this);
        }

        public void updateBalancingState(final ConnectivityState connectivityState, final LoadBalancer.SubchannelPicker subchannelPicker) {
            b.a(connectivityState, (Object)"newState");
            b.a(subchannelPicker, (Object)"newPicker");
            ManagedChannelImpl.this.logWarningIfNotInSyncContext("updateBalancingState()");
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            final class UpdateBalancingState
            implements Runnable {
                UpdateBalancingState() {
                }

                @Override
                public final void run() {
                    if (LbHelperImpl.this != ManagedChannelImpl.this.lbHelper) {
                        return;
                    }
                    ManagedChannelImpl.this.updateSubchannelPicker(subchannelPicker);
                    if (connectivityState != ConnectivityState.SHUTDOWN) {
                        ManagedChannelImpl.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Entering {0} state with picker: {1}", new Object[]{connectivityState, subchannelPicker});
                        ManagedChannelImpl.this.channelStateManager.gotoState(connectivityState);
                    }
                }
            }
            ManagedChannelImpl.this.syncContext.execute(new UpdateBalancingState());
        }

        public SynchronizationContext getSynchronizationContext() {
            return ManagedChannelImpl.this.syncContext;
        }

        public ChannelLogger getChannelLogger() {
            return ManagedChannelImpl.this.channelLogger;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UncommittedRetriableStreamsRegistry {
        final Object lock = new Object();
        Collection<ClientStream> uncommittedRetriableStreams = new HashSet<ClientStream>();
        Status shutdownStatus;

        private UncommittedRetriableStreamsRegistry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void onShutdown(Status status) {
            boolean bl = false;
            Object object = this.lock;
            synchronized (object) {
                if (this.shutdownStatus != null) {
                    return;
                }
                this.shutdownStatus = status;
                if (this.uncommittedRetriableStreams.isEmpty()) {
                    bl = true;
                }
            }
            if (bl) {
                ManagedChannelImpl.this.delayedTransport.shutdown(status);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Status add(RetriableStream<?> retriableStream) {
            Object object = this.lock;
            synchronized (object) {
                if (this.shutdownStatus != null) {
                    return this.shutdownStatus;
                }
                this.uncommittedRetriableStreams.add(retriableStream);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void remove(RetriableStream<?> retriableStream) {
            Status status = null;
            Object object = this.lock;
            synchronized (object) {
                this.uncommittedRetriableStreams.remove(retriableStream);
                if (this.uncommittedRetriableStreams.isEmpty()) {
                    status = this.shutdownStatus;
                    this.uncommittedRetriableStreams = new HashSet<ClientStream>();
                }
            }
            if (status != null) {
                ManagedChannelImpl.this.delayedTransport.shutdown(status);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RealChannel
    extends Channel {
        private final AtomicReference<InternalConfigSelector> configSelector = new AtomicReference<InternalConfigSelector>(ManagedChannelImpl.access$3500());
        private final String authority;

        private RealChannel(String string) {
            this.authority = b.a(string, (Object)"authority");
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> object, CallOptions callOptions) {
            if (this.configSelector.get() != INITIAL_PENDING_SELECTOR) {
                return this.newClientCall((MethodDescriptor<ReqT, RespT>)object, callOptions);
            }
            ManagedChannelImpl.this.syncContext.execute(new Runnable(){

                public void run() {
                    ManagedChannelImpl.this.exitIdleMode();
                }
            });
            if (this.configSelector.get() != INITIAL_PENDING_SELECTOR) {
                return this.newClientCall((MethodDescriptor<ReqT, RespT>)object, callOptions);
            }
            if (ManagedChannelImpl.this.shutdown.get()) {
                return new ClientCall<ReqT, RespT>(){

                    @Override
                    public void start(ClientCall.Listener<RespT> listener, Metadata metadata) {
                        listener.onClose(SHUTDOWN_STATUS, new Metadata());
                    }

                    @Override
                    public void request(int n2) {
                    }

                    @Override
                    public void cancel(String string, Throwable throwable) {
                    }

                    @Override
                    public void halfClose() {
                    }

                    @Override
                    public void sendMessage(ReqT ReqT) {
                    }
                };
            }
            Context context = Context.current();
            object = new PendingCall<ReqT, RespT>(context, object, callOptions);
            ManagedChannelImpl.this.syncContext.execute(new Runnable((PendingCall)object){
                final /* synthetic */ PendingCall val$pendingCall;
                {
                    this.val$pendingCall = pendingCall;
                }

                public void run() {
                    if (RealChannel.this.configSelector.get() == INITIAL_PENDING_SELECTOR) {
                        if (ManagedChannelImpl.this.pendingCalls == null) {
                            ManagedChannelImpl.this.pendingCalls = new LinkedHashSet();
                            ManagedChannelImpl.this.inUseStateAggregator.updateObjectInUse(ManagedChannelImpl.this.pendingCallsInUseObject, true);
                        }
                        ManagedChannelImpl.this.pendingCalls.add(this.val$pendingCall);
                        return;
                    }
                    this.val$pendingCall.reprocess();
                }
            });
            return object;
        }

        void updateConfigSelector(InternalConfigSelector object) {
            Object object22 = this.configSelector.get();
            this.configSelector.set((InternalConfigSelector)object);
            if (object22 == INITIAL_PENDING_SELECTOR && ManagedChannelImpl.this.pendingCalls != null) {
                for (Object object22 : ManagedChannelImpl.this.pendingCalls) {
                    ((PendingCall)object22).reprocess();
                }
            }
        }

        void onConfigError() {
            if (this.configSelector.get() == INITIAL_PENDING_SELECTOR) {
                this.updateConfigSelector(null);
            }
        }

        void shutdown() {
            final class RealChannelShutdown
            implements Runnable {
                RealChannelShutdown() {
                }

                public final void run() {
                    if (ManagedChannelImpl.this.pendingCalls == null) {
                        if (RealChannel.this.configSelector.get() == INITIAL_PENDING_SELECTOR) {
                            RealChannel.this.configSelector.set(null);
                        }
                        ManagedChannelImpl.this.uncommittedRetriableStreamsRegistry.onShutdown(SHUTDOWN_STATUS);
                    }
                }
            }
            ManagedChannelImpl.this.syncContext.execute(new RealChannelShutdown());
        }

        @Override
        public String authority() {
            return this.authority;
        }

        private <ReqT, RespT> ClientCall<ReqT, RespT> newClientCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions) {
            return new ClientCallImpl<ReqT, RespT>(methodDescriptor, ManagedChannelImpl.this.getCallExecutor(callOptions), callOptions, ManagedChannelImpl.this.transportProvider, ManagedChannelImpl.this.terminated ? null : ManagedChannelImpl.this.transportFactory.getScheduledExecutorService(), ManagedChannelImpl.this.channelCallTracer, this.configSelector.get()).setFullStreamDecompression(ManagedChannelImpl.this.fullStreamDecompression).setDecompressorRegistry(ManagedChannelImpl.this.decompressorRegistry).setCompressorRegistry(ManagedChannelImpl.this.compressorRegistry);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class PendingCall<ReqT, RespT>
        extends DelayedClientCall<ReqT, RespT> {
            final Context context;
            final MethodDescriptor<ReqT, RespT> method;
            final CallOptions callOptions;

            PendingCall(Context context, MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions) {
                super(ManagedChannelImpl.this.getCallExecutor(callOptions), ManagedChannelImpl.this.scheduledExecutor, callOptions.getDeadline());
                this.context = context;
                this.method = methodDescriptor;
                this.callOptions = callOptions;
            }

            final void reprocess() {
                ManagedChannelImpl.this.getCallExecutor(this.callOptions).execute(new Runnable(){

                    public void run() {
                        ClientCall clientCall;
                        Context context = PendingCall.this.context.attach();
                        try {
                            clientCall = RealChannel.this.newClientCall(PendingCall.this.method, PendingCall.this.callOptions);
                        }
                        finally {
                            PendingCall.this.context.detach(context);
                        }
                        PendingCall.this.setCall(clientCall);
                        ManagedChannelImpl.this.syncContext.execute(new PendingCallRemoval());
                    }
                });
            }

            @Override
            protected final void callCancelled() {
                super.callCancelled();
                ManagedChannelImpl.this.syncContext.execute(new PendingCallRemoval());
            }

            final class PendingCallRemoval
            implements Runnable {
                PendingCallRemoval() {
                }

                public final void run() {
                    if (ManagedChannelImpl.this.pendingCalls != null) {
                        ManagedChannelImpl.this.pendingCalls.remove(PendingCall.this);
                        if (ManagedChannelImpl.this.pendingCalls.isEmpty()) {
                            ManagedChannelImpl.this.inUseStateAggregator.updateObjectInUse(ManagedChannelImpl.this.pendingCallsInUseObject, false);
                            ManagedChannelImpl.this.pendingCalls = null;
                            if (ManagedChannelImpl.this.shutdown.get()) {
                                ManagedChannelImpl.this.uncommittedRetriableStreamsRegistry.onShutdown(SHUTDOWN_STATUS);
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ChannelStreamProvider
    implements ClientCallImpl.ClientStreamProvider {
        private ChannelStreamProvider() {
        }

        private ClientTransport getTransport(LoadBalancer.PickSubchannelArgs object) {
            Object object2 = ManagedChannelImpl.this.subchannelPicker;
            if (ManagedChannelImpl.this.shutdown.get()) {
                return ManagedChannelImpl.this.delayedTransport;
            }
            if (object2 == null) {
                final class ExitIdleModeForTransport
                implements Runnable {
                    ExitIdleModeForTransport() {
                    }

                    public final void run() {
                        ManagedChannelImpl.this.exitIdleMode();
                    }
                }
                ManagedChannelImpl.this.syncContext.execute(new ExitIdleModeForTransport());
                return ManagedChannelImpl.this.delayedTransport;
            }
            if ((object = GrpcUtil.getTransportFromPickResult((LoadBalancer.PickResult)(object2 = ((LoadBalancer.SubchannelPicker)object2).pickSubchannel((LoadBalancer.PickSubchannelArgs)object)), ((LoadBalancer.PickSubchannelArgs)object).getCallOptions().isWaitForReady())) != null) {
                return object;
            }
            return ManagedChannelImpl.this.delayedTransport;
        }

        @Override
        public final ClientStream newStream(final MethodDescriptor<?, ?> methodDescriptor, final CallOptions callOptions, final Metadata metadata, final Context context) {
            if (!ManagedChannelImpl.this.retryEnabled) {
                ClientTransport clientTransport = this.getTransport(new PickSubchannelArgsImpl(methodDescriptor, metadata, callOptions));
                Context context2 = context.attach();
                try {
                    ClientStream clientStream = clientTransport.newStream(methodDescriptor, metadata, callOptions);
                    return clientStream;
                }
                finally {
                    context.detach(context2);
                }
            }
            final RetriableStream.Throttle throttle = ManagedChannelImpl.this.lastServiceConfig.getRetryThrottling();
            ManagedChannelServiceConfig.MethodInfo methodInfo = callOptions.getOption(ManagedChannelServiceConfig.MethodInfo.KEY);
            final RetryPolicy retryPolicy = methodInfo == null ? null : methodInfo.retryPolicy;
            final HedgingPolicy hedgingPolicy = methodInfo == null ? null : methodInfo.hedgingPolicy;
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            final class RetryStream<ReqT>
            extends RetriableStream<ReqT> {
                RetryStream() {
                    super(methodDescriptor2, metadata2, ManagedChannelImpl.this.channelBufferUsed, ManagedChannelImpl.this.perRpcBufferLimit, ManagedChannelImpl.this.channelBufferLimit, ManagedChannelImpl.this.getCallExecutor(callOptions2), ManagedChannelImpl.this.transportFactory.getScheduledExecutorService(), retryPolicy2, hedgingPolicy2, throttle2);
                }

                @Override
                final Status prestart() {
                    return ManagedChannelImpl.this.uncommittedRetriableStreamsRegistry.add(this);
                }

                @Override
                final void postCommit() {
                    ManagedChannelImpl.this.uncommittedRetriableStreamsRegistry.remove(this);
                }

                @Override
                final ClientStream newSubstream(ClientStreamTracer.Factory object, Metadata metadata2) {
                    object = callOptions.withStreamTracerFactory((ClientStreamTracer.Factory)object);
                    ClientTransport clientTransport = ChannelStreamProvider.this.getTransport(new PickSubchannelArgsImpl(methodDescriptor, metadata2, (CallOptions)object));
                    Context context2 = context.attach();
                    try {
                        object = clientTransport.newStream(methodDescriptor, metadata2, (CallOptions)object);
                        return object;
                    }
                    finally {
                        context.detach(context2);
                    }
                }
            }
            return new RetryStream();
        }
    }

    class DelayedNameResolverRefresh
    implements Runnable {
        DelayedNameResolverRefresh() {
        }

        public void run() {
            ManagedChannelImpl.this.scheduledNameResolverRefresh = null;
            ManagedChannelImpl.this.refreshNameResolution();
        }
    }

    private class IdleModeTimer
    implements Runnable {
        private IdleModeTimer() {
        }

        public void run() {
            ManagedChannelImpl.this.enterIdleMode();
        }
    }
}

