/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.tracelytics.a.d.a.e.b;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUtil {
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);

    public static List<?> getList(Map<String, ?> map, String string) {
        assert (string != null);
        if (!map.containsKey(string)) {
            return null;
        }
        Object obj = map.get(string);
        if (!(obj instanceof List)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not List", obj, string, map));
        }
        return (List)obj;
    }

    public static List<Map<String, ?>> getListOfObjects(Map<String, ?> object, String string) {
        if ((object = JsonUtil.getList(object, string)) == null) {
            return null;
        }
        return JsonUtil.checkObjectList(object);
    }

    public static List<String> getListOfStrings(Map<String, ?> object, String string) {
        if ((object = JsonUtil.getList(object, string)) == null) {
            return null;
        }
        return JsonUtil.checkStringList(object);
    }

    public static Map<String, ?> getObject(Map<String, ?> map, String string) {
        assert (string != null);
        if (!map.containsKey(string)) {
            return null;
        }
        Object obj = map.get(string);
        if (!(obj instanceof Map)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not object", obj, string, map));
        }
        return (Map)obj;
    }

    public static Double getNumber(Map<String, ?> map, String string) {
        assert (string != null);
        if (!map.containsKey(string)) {
            return null;
        }
        Object obj = map.get(string);
        if (!(obj instanceof Double)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not Double", obj, string, map));
        }
        return (Double)obj;
    }

    public static Integer getNumberAsInteger(Map<String, ?> object, String string) {
        if ((object = JsonUtil.getNumber(object, string)) == null) {
            return null;
        }
        int n2 = ((Double)object).intValue();
        if ((double)n2 != (Double)object) {
            throw new ClassCastException("Number expected to be integer: " + object);
        }
        return n2;
    }

    public static String getString(Map<String, ?> map, String string) {
        assert (string != null);
        if (!map.containsKey(string)) {
            return null;
        }
        Object obj = map.get(string);
        if (!(obj instanceof String)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not String", obj, string, map));
        }
        return (String)obj;
    }

    public static Long getStringAsDuration(Map<String, ?> object, String string) {
        if ((object = JsonUtil.getString(object, string)) == null) {
            return null;
        }
        try {
            return JsonUtil.parseDuration((String)object);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    public static Boolean getBoolean(Map<String, ?> map, String string) {
        assert (string != null);
        if (!map.containsKey(string)) {
            return null;
        }
        Object obj = map.get(string);
        if (!(obj instanceof Boolean)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not Boolean", obj, string, map));
        }
        return (Boolean)obj;
    }

    public static List<Map<String, ?>> checkObjectList(List<?> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.get(i2) instanceof Map) continue;
            throw new ClassCastException(String.format("value %s for idx %d in %s is not object", list.get(i2), i2, list));
        }
        return list;
    }

    public static List<String> checkStringList(List<?> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.get(i2) instanceof String) continue;
            throw new ClassCastException(String.format("value '%s' for idx %d in '%s' is not string", list.get(i2), i2, list));
        }
        return list;
    }

    private static long parseDuration(String string) throws ParseException {
        int n2;
        block10: {
            block9: {
                if (string.isEmpty()) break block9;
                String string2 = string;
                if (string2.charAt(string2.length() - 1) == 's') break block10;
            }
            throw new ParseException("Invalid duration string: " + string, 0);
        }
        boolean bl = false;
        if (string.charAt(0) == '-') {
            bl = true;
            string = string.substring(1);
        }
        String string3 = string.substring(0, string.length() - 1);
        String string4 = "";
        int n3 = string3.indexOf(46);
        if (n3 != -1) {
            string4 = string3.substring(n3 + 1);
            string3 = string3.substring(0, n3);
        }
        long l2 = Long.parseLong(string3);
        int n4 = n2 = string4.isEmpty() ? 0 : JsonUtil.parseNanos(string4);
        if (l2 < 0L) {
            throw new ParseException("Invalid duration string: " + string, 0);
        }
        if (bl) {
            l2 = -l2;
            n2 = -n2;
        }
        try {
            return JsonUtil.normalizedDuration(l2, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException("Duration value is out of range.", 0);
        }
    }

    private static int parseNanos(String string) throws ParseException {
        int n2 = 0;
        for (int i2 = 0; i2 < 9; ++i2) {
            n2 *= 10;
            if (i2 >= string.length()) continue;
            if (string.charAt(i2) < '0' || string.charAt(i2) > '9') {
                throw new ParseException("Invalid nanoseconds.", 0);
            }
            n2 += string.charAt(i2) - 48;
        }
        return n2;
    }

    private static long normalizedDuration(long l2, int n2) {
        if ((long)n2 <= -NANOS_PER_SECOND || (long)n2 >= NANOS_PER_SECOND) {
            l2 = b.a(l2, (long)n2 / NANOS_PER_SECOND);
            n2 = (int)((long)n2 % NANOS_PER_SECOND);
        }
        if (l2 > 0L && n2 < 0) {
            n2 = (int)((long)n2 + NANOS_PER_SECOND);
            --l2;
        }
        if (l2 < 0L && n2 > 0) {
            n2 = (int)((long)n2 - NANOS_PER_SECOND);
            ++l2;
        }
        if (!JsonUtil.durationIsValid(l2, n2)) {
            throw new IllegalArgumentException(String.format("Duration is not valid. See proto definition for valid values. Seconds (%s) must be in range [-315,576,000,000, +315,576,000,000]. Nanos (%s) must be in range [-999,999,999, +999,999,999]. Nanos must have the same sign as seconds", l2, n2));
        }
        return JsonUtil.saturatedAdd(TimeUnit.SECONDS.toNanos(l2), n2);
    }

    private static boolean durationIsValid(long l2, int n2) {
        if (l2 < -315576000000L || l2 > 315576000000L) {
            return false;
        }
        if ((long)n2 < -999999999L || (long)n2 >= NANOS_PER_SECOND) {
            return false;
        }
        return l2 >= 0L && n2 >= 0 || l2 <= 0L && n2 <= 0;
    }

    private static long saturatedAdd(long l2, long l3) {
        long l4;
        if ((l2 ^ l3) < 0L | (l2 ^ (l4 = l2 + l3)) >= 0L) {
            return l4;
        }
        return Long.MAX_VALUE + (l4 >>> 63 ^ 1L);
    }
}

