/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.Attributes;
import com.appoptics.ext.io.grpc.CallOptions;
import com.appoptics.ext.io.grpc.ChannelLogger;
import com.appoptics.ext.io.grpc.ConnectivityState;
import com.appoptics.ext.io.grpc.ConnectivityStateInfo;
import com.appoptics.ext.io.grpc.EquivalentAddressGroup;
import com.appoptics.ext.io.grpc.HttpConnectProxiedSocketAddress;
import com.appoptics.ext.io.grpc.InternalChannelz;
import com.appoptics.ext.io.grpc.InternalInstrumented;
import com.appoptics.ext.io.grpc.InternalLogId;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.MethodDescriptor;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.SynchronizationContext;
import com.appoptics.ext.io.grpc.internal.BackoffPolicy;
import com.appoptics.ext.io.grpc.internal.CallTracer;
import com.appoptics.ext.io.grpc.internal.ChannelLoggerImpl;
import com.appoptics.ext.io.grpc.internal.ChannelTracer;
import com.appoptics.ext.io.grpc.internal.ClientStream;
import com.appoptics.ext.io.grpc.internal.ClientStreamListener;
import com.appoptics.ext.io.grpc.internal.ClientTransport;
import com.appoptics.ext.io.grpc.internal.ClientTransportFactory;
import com.appoptics.ext.io.grpc.internal.ConnectionClientTransport;
import com.appoptics.ext.io.grpc.internal.ForwardingClientStream;
import com.appoptics.ext.io.grpc.internal.ForwardingClientStreamListener;
import com.appoptics.ext.io.grpc.internal.ForwardingConnectionClientTransport;
import com.appoptics.ext.io.grpc.internal.InUseStateAggregator;
import com.appoptics.ext.io.grpc.internal.ManagedClientTransport;
import com.appoptics.ext.io.grpc.internal.TransportProvider;
import com.tracelytics.a.d.a.a.g;
import com.tracelytics.a.d.a.a.l;
import com.tracelytics.a.d.a.a.m;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InternalSubchannel
implements InternalInstrumented<Object>,
TransportProvider {
    private final InternalLogId logId;
    private final String authority;
    private final String userAgent;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Callback callback;
    private final ClientTransportFactory transportFactory;
    private final ScheduledExecutorService scheduledExecutor;
    private final InternalChannelz channelz;
    private final CallTracer callsTracer;
    private final ChannelTracer channelTracer;
    private final ChannelLogger channelLogger;
    private final SynchronizationContext syncContext;
    private final Index addressIndex;
    private volatile List<EquivalentAddressGroup> addressGroups;
    private BackoffPolicy reconnectPolicy;
    private final l connectingTimer;
    private SynchronizationContext.ScheduledHandle reconnectTask;
    private SynchronizationContext.ScheduledHandle shutdownDueToUpdateTask;
    private ManagedClientTransport shutdownDueToUpdateTransport;
    private final Collection<ConnectionClientTransport> transports = new ArrayList<ConnectionClientTransport>();
    private final InUseStateAggregator<ConnectionClientTransport> inUseStateAggregator = new InUseStateAggregator<ConnectionClientTransport>(){

        @Override
        protected void handleInUse() {
            InternalSubchannel.this.callback.onInUse(InternalSubchannel.this);
        }

        @Override
        protected void handleNotInUse() {
            InternalSubchannel.this.callback.onNotInUse(InternalSubchannel.this);
        }
    };
    private ConnectionClientTransport pendingTransport;
    private volatile ManagedClientTransport activeTransport;
    private volatile ConnectivityStateInfo state = ConnectivityStateInfo.forNonError(ConnectivityState.IDLE);
    private Status shutdownReason;

    InternalSubchannel(List<EquivalentAddressGroup> list, String string, String string2, BackoffPolicy.Provider provider, ClientTransportFactory clientTransportFactory, ScheduledExecutorService scheduledExecutorService, m<l> m2, SynchronizationContext synchronizationContext, Callback callback, InternalChannelz internalChannelz, CallTracer callTracer, ChannelTracer channelTracer, InternalLogId internalLogId, ChannelLogger channelLogger) {
        b.a(list, (Object)"addressGroups");
        b.a(!list.isEmpty(), (Object)"addressGroups is empty");
        InternalSubchannel.checkListHasNoNulls(list, "addressGroups contains null entry");
        list = Collections.unmodifiableList(new ArrayList<EquivalentAddressGroup>(list));
        this.addressGroups = list;
        this.addressIndex = new Index(list);
        this.authority = string;
        this.userAgent = string2;
        this.backoffPolicyProvider = provider;
        this.transportFactory = clientTransportFactory;
        this.scheduledExecutor = scheduledExecutorService;
        this.connectingTimer = m2.get();
        this.syncContext = synchronizationContext;
        this.callback = callback;
        this.channelz = internalChannelz;
        this.callsTracer = callTracer;
        this.channelTracer = b.a(channelTracer, (Object)"channelTracer");
        this.logId = b.a(internalLogId, (Object)"logId");
        this.channelLogger = b.a(channelLogger, (Object)"channelLogger");
    }

    @Override
    public final ClientTransport obtainActiveTransport() {
        ManagedClientTransport managedClientTransport = this.activeTransport;
        if (managedClientTransport != null) {
            return managedClientTransport;
        }
        this.syncContext.execute(new Runnable(){

            public void run() {
                if (InternalSubchannel.this.state.getState() == ConnectivityState.IDLE) {
                    InternalSubchannel.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "CONNECTING as requested");
                    InternalSubchannel.this.gotoNonErrorState(ConnectivityState.CONNECTING);
                    InternalSubchannel.this.startNewTransport();
                }
            }
        });
        return null;
    }

    private void startNewTransport() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        b.b(this.reconnectTask == null, "Should have no reconnectTask scheduled");
        if (this.addressIndex.isAtBeginning()) {
            this.connectingTimer.c().b();
        }
        Object object = this.addressIndex.getCurrentAddress();
        Object object2 = null;
        if (object instanceof HttpConnectProxiedSocketAddress) {
            object2 = (HttpConnectProxiedSocketAddress)object;
            object = ((HttpConnectProxiedSocketAddress)object2).getTargetAddress();
        }
        Object object3 = this.addressIndex.getCurrentEagAttributes();
        String string = ((Attributes)object3).get(EquivalentAddressGroup.ATTR_AUTHORITY_OVERRIDE);
        object2 = new ClientTransportFactory.ClientTransportOptions().setAuthority(string != null ? string : this.authority).setEagAttributes((Attributes)object3).setUserAgent(this.userAgent).setHttpConnectProxiedSocketAddress((HttpConnectProxiedSocketAddress)object2);
        object3 = new TransportLogger();
        new TransportLogger().logId = this.getLogId();
        object2 = new CallTracingTransport(this.transportFactory.newClientTransport((SocketAddress)object, (ClientTransportFactory.ClientTransportOptions)object2, (ChannelLogger)object3), this.callsTracer);
        ((TransportLogger)object3).logId = object2.getLogId();
        this.channelz.addClientSocket((InternalInstrumented<Object>)object2);
        this.pendingTransport = object2;
        this.transports.add((ConnectionClientTransport)object2);
        object = object2.start(new TransportListener((ConnectionClientTransport)object2, (SocketAddress)object));
        if (object != null) {
            this.syncContext.executeLater((Runnable)object);
        }
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Started transport {0}", ((TransportLogger)object3).logId);
    }

    private void scheduleBackoff(Status status) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        this.gotoState(ConnectivityStateInfo.forTransientFailure(status));
        if (this.reconnectPolicy == null) {
            this.reconnectPolicy = this.backoffPolicyProvider.get();
        }
        long l2 = this.reconnectPolicy.nextBackoffNanos() - this.connectingTimer.a(TimeUnit.NANOSECONDS);
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "TRANSIENT_FAILURE ({0}). Will reconnect after {1} ns", this.printShortStatus(status), l2);
        b.b(this.reconnectTask == null, "previous reconnectTask is not done");
        class EndOfCurrentBackoff
        implements Runnable {
            EndOfCurrentBackoff() {
            }

            public void run() {
                InternalSubchannel.this.reconnectTask = null;
                InternalSubchannel.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "CONNECTING after backoff");
                InternalSubchannel.this.gotoNonErrorState(ConnectivityState.CONNECTING);
                InternalSubchannel.this.startNewTransport();
            }
        }
        this.reconnectTask = this.syncContext.schedule(new EndOfCurrentBackoff(), l2, TimeUnit.NANOSECONDS, this.scheduledExecutor);
    }

    private void gotoNonErrorState(ConnectivityState connectivityState) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        this.gotoState(ConnectivityStateInfo.forNonError(connectivityState));
    }

    private void gotoState(ConnectivityStateInfo connectivityStateInfo) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.state.getState() != connectivityStateInfo.getState()) {
            b.b(this.state.getState() != ConnectivityState.SHUTDOWN, "Cannot transition out of SHUTDOWN to " + connectivityStateInfo);
            this.state = connectivityStateInfo;
            this.callback.onStateChange(this, connectivityStateInfo);
        }
    }

    public final void updateAddresses(final List<EquivalentAddressGroup> list) {
        b.a(list, (Object)"newAddressGroups");
        InternalSubchannel.checkListHasNoNulls(list, "newAddressGroups contains null entry");
        b.a(!list.isEmpty(), (Object)"newAddressGroups is empty");
        this.syncContext.execute(new Runnable(){

            public void run() {
                List<EquivalentAddressGroup> list2 = Collections.unmodifiableList(new ArrayList(list));
                ManagedClientTransport managedClientTransport = null;
                SocketAddress socketAddress = InternalSubchannel.this.addressIndex.getCurrentAddress();
                InternalSubchannel.this.addressIndex.updateGroups(list2);
                InternalSubchannel.this.addressGroups = list2;
                if (!(InternalSubchannel.this.state.getState() != ConnectivityState.READY && InternalSubchannel.this.state.getState() != ConnectivityState.CONNECTING || InternalSubchannel.this.addressIndex.seekTo(socketAddress))) {
                    if (InternalSubchannel.this.state.getState() == ConnectivityState.READY) {
                        managedClientTransport = InternalSubchannel.this.activeTransport;
                        InternalSubchannel.this.activeTransport = null;
                        InternalSubchannel.this.addressIndex.reset();
                        InternalSubchannel.this.gotoNonErrorState(ConnectivityState.IDLE);
                    } else {
                        InternalSubchannel.this.pendingTransport.shutdown(Status.UNAVAILABLE.withDescription("InternalSubchannel closed pending transport due to address change"));
                        InternalSubchannel.this.pendingTransport = null;
                        InternalSubchannel.this.addressIndex.reset();
                        InternalSubchannel.this.startNewTransport();
                    }
                }
                if (managedClientTransport != null) {
                    if (InternalSubchannel.this.shutdownDueToUpdateTask != null) {
                        InternalSubchannel.this.shutdownDueToUpdateTransport.shutdown(Status.UNAVAILABLE.withDescription("InternalSubchannel closed transport early due to address change"));
                        InternalSubchannel.this.shutdownDueToUpdateTask.cancel();
                        InternalSubchannel.this.shutdownDueToUpdateTask = null;
                        InternalSubchannel.this.shutdownDueToUpdateTransport = null;
                    }
                    InternalSubchannel.this.shutdownDueToUpdateTransport = managedClientTransport;
                    InternalSubchannel.this.shutdownDueToUpdateTask = InternalSubchannel.this.syncContext.schedule(new Runnable(){

                        public void run() {
                            ManagedClientTransport managedClientTransport = InternalSubchannel.this.shutdownDueToUpdateTransport;
                            InternalSubchannel.this.shutdownDueToUpdateTask = null;
                            InternalSubchannel.this.shutdownDueToUpdateTransport = null;
                            managedClientTransport.shutdown(Status.UNAVAILABLE.withDescription("InternalSubchannel closed transport due to address change"));
                        }
                    }, 5L, TimeUnit.SECONDS, InternalSubchannel.this.scheduledExecutor);
                }
            }
        });
    }

    public final void shutdown(final Status status) {
        this.syncContext.execute(new Runnable(){

            public void run() {
                if (InternalSubchannel.this.state.getState() == ConnectivityState.SHUTDOWN) {
                    return;
                }
                InternalSubchannel.this.shutdownReason = status;
                ManagedClientTransport managedClientTransport = InternalSubchannel.this.activeTransport;
                ConnectionClientTransport connectionClientTransport = InternalSubchannel.this.pendingTransport;
                InternalSubchannel.this.activeTransport = null;
                InternalSubchannel.this.pendingTransport = null;
                InternalSubchannel.this.gotoNonErrorState(ConnectivityState.SHUTDOWN);
                InternalSubchannel.this.addressIndex.reset();
                if (InternalSubchannel.this.transports.isEmpty()) {
                    InternalSubchannel.this.handleTermination();
                }
                InternalSubchannel.this.cancelReconnectTask();
                if (InternalSubchannel.this.shutdownDueToUpdateTask != null) {
                    InternalSubchannel.this.shutdownDueToUpdateTask.cancel();
                    InternalSubchannel.this.shutdownDueToUpdateTransport.shutdown(status);
                    InternalSubchannel.this.shutdownDueToUpdateTask = null;
                    InternalSubchannel.this.shutdownDueToUpdateTransport = null;
                }
                if (managedClientTransport != null) {
                    managedClientTransport.shutdown(status);
                }
                if (connectionClientTransport != null) {
                    connectionClientTransport.shutdown(status);
                }
            }
        });
    }

    public final String toString() {
        return g.a(this).a("logId", this.logId.getId()).a("addressGroups", this.addressGroups).toString();
    }

    private void handleTermination() {
        this.syncContext.execute(new Runnable(){

            public void run() {
                InternalSubchannel.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Terminated");
                InternalSubchannel.this.callback.onTerminated(InternalSubchannel.this);
            }
        });
    }

    private void handleTransportInUseState(final ConnectionClientTransport connectionClientTransport, final boolean bl) {
        this.syncContext.execute(new Runnable(){

            public void run() {
                InternalSubchannel.this.inUseStateAggregator.updateObjectInUse(connectionClientTransport, bl);
            }
        });
    }

    final void shutdownNow(final Status status) {
        this.shutdown(status);
        this.syncContext.execute(new Runnable(){

            public void run() {
                Object object = new ArrayList(InternalSubchannel.this.transports);
                object = object.iterator();
                while (object.hasNext()) {
                    ManagedClientTransport managedClientTransport = (ManagedClientTransport)object.next();
                    managedClientTransport.shutdownNow(status);
                }
            }
        });
    }

    final List<EquivalentAddressGroup> getAddressGroups() {
        return this.addressGroups;
    }

    private void cancelReconnectTask() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.reconnectTask != null) {
            this.reconnectTask.cancel();
            this.reconnectTask = null;
            this.reconnectPolicy = null;
        }
    }

    @Override
    public final InternalLogId getLogId() {
        return this.logId;
    }

    private static void checkListHasNoNulls(List<?> object, String string) {
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            b.a(e2, (Object)string);
        }
    }

    private String printShortStatus(Status status) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)status.getCode());
        if (status.getDescription() != null) {
            stringBuilder.append("(").append(status.getDescription()).append(")");
        }
        return stringBuilder.toString();
    }

    static final class TransportLogger
    extends ChannelLogger {
        InternalLogId logId;

        TransportLogger() {
        }

        public final void log(ChannelLogger.ChannelLogLevel channelLogLevel, String string) {
            ChannelLoggerImpl.logOnly(this.logId, channelLogLevel, string);
        }

        public final void log(ChannelLogger.ChannelLogLevel channelLogLevel, String string, Object ... objectArray) {
            ChannelLoggerImpl.logOnly(this.logId, channelLogLevel, string, objectArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Index {
        private List<EquivalentAddressGroup> addressGroups;
        private int groupIndex;
        private int addressIndex;

        public Index(List<EquivalentAddressGroup> list) {
            this.addressGroups = list;
        }

        public final boolean isValid() {
            return this.groupIndex < this.addressGroups.size();
        }

        public final boolean isAtBeginning() {
            return this.groupIndex == 0 && this.addressIndex == 0;
        }

        public final void increment() {
            EquivalentAddressGroup equivalentAddressGroup = this.addressGroups.get(this.groupIndex);
            ++this.addressIndex;
            if (this.addressIndex >= equivalentAddressGroup.getAddresses().size()) {
                ++this.groupIndex;
                this.addressIndex = 0;
            }
        }

        public final void reset() {
            this.groupIndex = 0;
            this.addressIndex = 0;
        }

        public final SocketAddress getCurrentAddress() {
            return this.addressGroups.get(this.groupIndex).getAddresses().get(this.addressIndex);
        }

        public final Attributes getCurrentEagAttributes() {
            return this.addressGroups.get(this.groupIndex).getAttributes();
        }

        public final void updateGroups(List<EquivalentAddressGroup> list) {
            this.addressGroups = list;
            this.reset();
        }

        public final boolean seekTo(SocketAddress socketAddress) {
            for (int i2 = 0; i2 < this.addressGroups.size(); ++i2) {
                EquivalentAddressGroup equivalentAddressGroup = this.addressGroups.get(i2);
                int n2 = equivalentAddressGroup.getAddresses().indexOf(socketAddress);
                if (n2 == -1) continue;
                this.groupIndex = i2;
                this.addressIndex = n2;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CallTracingTransport
    extends ForwardingConnectionClientTransport {
        private final ConnectionClientTransport delegate;
        private final CallTracer callTracer;

        private CallTracingTransport(ConnectionClientTransport connectionClientTransport, CallTracer callTracer) {
            this.delegate = connectionClientTransport;
            this.callTracer = callTracer;
        }

        @Override
        protected final ConnectionClientTransport delegate() {
            return this.delegate;
        }

        @Override
        public final ClientStream newStream(MethodDescriptor<?, ?> object, Metadata metadata, CallOptions callOptions) {
            object = super.newStream((MethodDescriptor<?, ?>)object, metadata, callOptions);
            return new ForwardingClientStream((ClientStream)object){
                final /* synthetic */ ClientStream val$streamDelegate;
                {
                    this.val$streamDelegate = clientStream;
                }

                protected ClientStream delegate() {
                    return this.val$streamDelegate;
                }

                public void start(final ClientStreamListener clientStreamListener) {
                    CallTracingTransport.this.callTracer.reportCallStarted();
                    super.start(new ForwardingClientStreamListener(){

                        protected ClientStreamListener delegate() {
                            return clientStreamListener;
                        }

                        public void closed(Status status, Metadata metadata) {
                            CallTracingTransport.this.callTracer.reportCallEnded(status.isOk());
                            super.closed(status, metadata);
                        }

                        public void closed(Status status, ClientStreamListener.RpcProgress rpcProgress, Metadata metadata) {
                            CallTracingTransport.this.callTracer.reportCallEnded(status.isOk());
                            super.closed(status, rpcProgress, metadata);
                        }
                    });
                }
            };
        }
    }

    static abstract class Callback {
        Callback() {
        }

        void onTerminated(InternalSubchannel internalSubchannel) {
        }

        void onStateChange(InternalSubchannel internalSubchannel, ConnectivityStateInfo connectivityStateInfo) {
        }

        void onInUse(InternalSubchannel internalSubchannel) {
        }

        void onNotInUse(InternalSubchannel internalSubchannel) {
        }
    }

    private class TransportListener
    implements ManagedClientTransport.Listener {
        final ConnectionClientTransport transport;
        final SocketAddress address;
        boolean shutdownInitiated = false;

        TransportListener(ConnectionClientTransport connectionClientTransport, SocketAddress socketAddress) {
            this.transport = connectionClientTransport;
            this.address = socketAddress;
        }

        public void transportReady() {
            InternalSubchannel.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "READY");
            InternalSubchannel.this.syncContext.execute(new Runnable(){

                public void run() {
                    InternalSubchannel.this.reconnectPolicy = null;
                    if (InternalSubchannel.this.shutdownReason != null) {
                        b.b(InternalSubchannel.this.activeTransport == null, "Unexpected non-null activeTransport");
                        TransportListener.this.transport.shutdown(InternalSubchannel.this.shutdownReason);
                        return;
                    }
                    if (InternalSubchannel.this.pendingTransport == TransportListener.this.transport) {
                        InternalSubchannel.this.activeTransport = TransportListener.this.transport;
                        InternalSubchannel.this.pendingTransport = null;
                        InternalSubchannel.this.gotoNonErrorState(ConnectivityState.READY);
                    }
                }
            });
        }

        public void transportInUse(boolean bl) {
            InternalSubchannel.this.handleTransportInUseState(this.transport, bl);
        }

        public void transportShutdown(final Status status) {
            InternalSubchannel.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "{0} SHUTDOWN with {1}", this.transport.getLogId(), InternalSubchannel.this.printShortStatus(status));
            this.shutdownInitiated = true;
            InternalSubchannel.this.syncContext.execute(new Runnable(){

                public void run() {
                    if (InternalSubchannel.this.state.getState() == ConnectivityState.SHUTDOWN) {
                        return;
                    }
                    if (InternalSubchannel.this.activeTransport == TransportListener.this.transport) {
                        InternalSubchannel.this.activeTransport = null;
                        InternalSubchannel.this.addressIndex.reset();
                        InternalSubchannel.this.gotoNonErrorState(ConnectivityState.IDLE);
                        return;
                    }
                    if (InternalSubchannel.this.pendingTransport == TransportListener.this.transport) {
                        b.b(InternalSubchannel.this.state.getState() == ConnectivityState.CONNECTING, "Expected state is CONNECTING, actual state is %s", (Object)InternalSubchannel.this.state.getState());
                        InternalSubchannel.this.addressIndex.increment();
                        if (!InternalSubchannel.this.addressIndex.isValid()) {
                            InternalSubchannel.this.pendingTransport = null;
                            InternalSubchannel.this.addressIndex.reset();
                            InternalSubchannel.this.scheduleBackoff(status);
                            return;
                        }
                        InternalSubchannel.this.startNewTransport();
                    }
                }
            });
        }

        public void transportTerminated() {
            b.b(this.shutdownInitiated, "transportShutdown() must be called before transportTerminated().");
            InternalSubchannel.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "{0} Terminated", this.transport.getLogId());
            InternalSubchannel.this.channelz.removeClientSocket(this.transport);
            InternalSubchannel.this.handleTransportInUseState(this.transport, false);
            InternalSubchannel.this.syncContext.execute(new Runnable(){

                public void run() {
                    InternalSubchannel.this.transports.remove(TransportListener.this.transport);
                    if (InternalSubchannel.this.state.getState() == ConnectivityState.SHUTDOWN && InternalSubchannel.this.transports.isEmpty()) {
                        InternalSubchannel.this.handleTermination();
                    }
                }
            });
        }
    }
}

