/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.internal.CompositeReadableBuffer;
import com.appoptics.ext.io.grpc.internal.ReadableBuffer;
import java.io.Closeable;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

class GzipInflatingBuffer
implements Closeable {
    private final CompositeReadableBuffer gzippedData = new CompositeReadableBuffer();
    private final CRC32 crc = new CRC32();
    private final GzipMetadataReader gzipMetadataReader = new GzipMetadataReader();
    private final byte[] inflaterInput = new byte[512];
    private int inflaterInputStart;
    private int inflaterInputEnd;
    private Inflater inflater;
    private State state = State.HEADER;
    private boolean closed = false;
    private int gzipHeaderFlag;
    private int headerExtraToRead;
    private long expectedGzipTrailerIsize;
    private int bytesConsumed = 0;
    private int deflatedBytesConsumed = 0;
    private boolean isStalled = true;

    GzipInflatingBuffer() {
    }

    boolean isStalled() {
        b.b(!this.closed, "GzipInflatingBuffer is closed");
        return this.isStalled;
    }

    boolean hasPartialData() {
        b.b(!this.closed, "GzipInflatingBuffer is closed");
        return this.gzipMetadataReader.readableBytes() != 0 || this.state != State.HEADER;
    }

    void addGzippedBytes(ReadableBuffer readableBuffer) {
        b.b(!this.closed, "GzipInflatingBuffer is closed");
        this.gzippedData.addBuffer(readableBuffer);
        this.isStalled = false;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.gzippedData.close();
            if (this.inflater != null) {
                this.inflater.end();
                this.inflater = null;
            }
        }
    }

    int getAndResetBytesConsumed() {
        int n2 = this.bytesConsumed;
        this.bytesConsumed = 0;
        return n2;
    }

    int getAndResetDeflatedBytesConsumed() {
        int n2 = this.deflatedBytesConsumed;
        this.deflatedBytesConsumed = 0;
        return n2;
    }

    int inflateBytes(byte[] byArray, int n2, int n3) throws DataFormatException, ZipException {
        int n4;
        b.b(!this.closed, "GzipInflatingBuffer is closed");
        int n5 = 0;
        boolean bl = true;
        block12: while (bl && (n4 = n3 - n5) > 0) {
            switch (this.state) {
                case HEADER: {
                    bl = this.processHeader();
                    continue block12;
                }
                case HEADER_EXTRA_LEN: {
                    bl = this.processHeaderExtraLen();
                    continue block12;
                }
                case HEADER_EXTRA: {
                    bl = this.processHeaderExtra();
                    continue block12;
                }
                case HEADER_NAME: {
                    bl = this.processHeaderName();
                    continue block12;
                }
                case HEADER_COMMENT: {
                    bl = this.processHeaderComment();
                    continue block12;
                }
                case HEADER_CRC: {
                    bl = this.processHeaderCrc();
                    continue block12;
                }
                case INITIALIZE_INFLATER: {
                    bl = this.initializeInflater();
                    continue block12;
                }
                case INFLATING: {
                    n5 += this.inflate(byArray, n2 + n5, n4);
                    if (this.state == State.TRAILER) {
                        bl = this.processTrailer();
                        continue block12;
                    }
                    bl = true;
                    continue block12;
                }
                case INFLATER_NEEDS_INPUT: {
                    bl = this.fill();
                    continue block12;
                }
                case TRAILER: {
                    bl = this.processTrailer();
                    continue block12;
                }
            }
            throw new AssertionError((Object)("Invalid state: " + (Object)((Object)this.state)));
        }
        this.isStalled = !bl || this.state == State.HEADER && this.gzipMetadataReader.readableBytes() < 10;
        return n5;
    }

    private boolean processHeader() throws ZipException {
        if (this.gzipMetadataReader.readableBytes() < 10) {
            return false;
        }
        if (this.gzipMetadataReader.readUnsignedShort() != 35615) {
            throw new ZipException("Not in GZIP format");
        }
        if (this.gzipMetadataReader.readUnsignedByte() != 8) {
            throw new ZipException("Unsupported compression method");
        }
        this.gzipHeaderFlag = this.gzipMetadataReader.readUnsignedByte();
        this.gzipMetadataReader.skipBytes(6);
        this.state = State.HEADER_EXTRA_LEN;
        return true;
    }

    private boolean processHeaderExtraLen() {
        if ((this.gzipHeaderFlag & 4) != 4) {
            this.state = State.HEADER_NAME;
            return true;
        }
        if (this.gzipMetadataReader.readableBytes() < 2) {
            return false;
        }
        this.headerExtraToRead = this.gzipMetadataReader.readUnsignedShort();
        this.state = State.HEADER_EXTRA;
        return true;
    }

    private boolean processHeaderExtra() {
        if (this.gzipMetadataReader.readableBytes() < this.headerExtraToRead) {
            return false;
        }
        this.gzipMetadataReader.skipBytes(this.headerExtraToRead);
        this.state = State.HEADER_NAME;
        return true;
    }

    private boolean processHeaderName() {
        if ((this.gzipHeaderFlag & 8) != 8) {
            this.state = State.HEADER_COMMENT;
            return true;
        }
        if (!this.gzipMetadataReader.readBytesUntilZero()) {
            return false;
        }
        this.state = State.HEADER_COMMENT;
        return true;
    }

    private boolean processHeaderComment() {
        if ((this.gzipHeaderFlag & 0x10) != 16) {
            this.state = State.HEADER_CRC;
            return true;
        }
        if (!this.gzipMetadataReader.readBytesUntilZero()) {
            return false;
        }
        this.state = State.HEADER_CRC;
        return true;
    }

    private boolean processHeaderCrc() throws ZipException {
        if ((this.gzipHeaderFlag & 2) != 2) {
            this.state = State.INITIALIZE_INFLATER;
            return true;
        }
        if (this.gzipMetadataReader.readableBytes() < 2) {
            return false;
        }
        int n2 = (int)this.crc.getValue() & 0xFFFF;
        if (n2 != this.gzipMetadataReader.readUnsignedShort()) {
            throw new ZipException("Corrupt GZIP header");
        }
        this.state = State.INITIALIZE_INFLATER;
        return true;
    }

    private boolean initializeInflater() {
        if (this.inflater == null) {
            this.inflater = new Inflater(true);
        } else {
            this.inflater.reset();
        }
        this.crc.reset();
        int n2 = this.inflaterInputEnd - this.inflaterInputStart;
        if (n2 > 0) {
            this.inflater.setInput(this.inflaterInput, this.inflaterInputStart, n2);
            this.state = State.INFLATING;
        } else {
            this.state = State.INFLATER_NEEDS_INPUT;
        }
        return true;
    }

    private int inflate(byte[] byArray, int n2, int n3) throws DataFormatException, ZipException {
        b.b(this.inflater != null, "inflater is null");
        try {
            int n4 = this.inflater.getTotalIn();
            n3 = this.inflater.inflate(byArray, n2, n3);
            n4 = this.inflater.getTotalIn() - n4;
            this.bytesConsumed += n4;
            this.deflatedBytesConsumed += n4;
            this.inflaterInputStart += n4;
            this.crc.update(byArray, n2, n3);
            if (this.inflater.finished()) {
                this.expectedGzipTrailerIsize = this.inflater.getBytesWritten() & 0xFFFFFFFFL;
                this.state = State.TRAILER;
            } else if (this.inflater.needsInput()) {
                this.state = State.INFLATER_NEEDS_INPUT;
            }
            return n3;
        }
        catch (DataFormatException dataFormatException) {
            throw new DataFormatException("Inflater data format exception: " + dataFormatException.getMessage());
        }
    }

    private boolean fill() {
        b.b(this.inflater != null, "inflater is null");
        b.b(this.inflaterInputStart == this.inflaterInputEnd, "inflaterInput has unconsumed bytes");
        int n2 = Math.min(this.gzippedData.readableBytes(), 512);
        if (n2 == 0) {
            return false;
        }
        this.inflaterInputStart = 0;
        this.inflaterInputEnd = n2;
        this.gzippedData.readBytes(this.inflaterInput, this.inflaterInputStart, n2);
        this.inflater.setInput(this.inflaterInput, this.inflaterInputStart, n2);
        this.state = State.INFLATING;
        return true;
    }

    private boolean processTrailer() throws ZipException {
        if (this.inflater != null && this.gzipMetadataReader.readableBytes() <= 18) {
            this.inflater.end();
            this.inflater = null;
        }
        if (this.gzipMetadataReader.readableBytes() < 8) {
            return false;
        }
        if (this.crc.getValue() != this.gzipMetadataReader.readUnsignedInt() || this.expectedGzipTrailerIsize != this.gzipMetadataReader.readUnsignedInt()) {
            throw new ZipException("Corrupt GZIP trailer");
        }
        this.crc.reset();
        this.state = State.HEADER;
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        HEADER,
        HEADER_EXTRA_LEN,
        HEADER_EXTRA,
        HEADER_NAME,
        HEADER_COMMENT,
        HEADER_CRC,
        INITIALIZE_INFLATER,
        INFLATING,
        INFLATER_NEEDS_INPUT,
        TRAILER;

    }

    private class GzipMetadataReader {
        private GzipMetadataReader() {
        }

        private int readUnsignedByte() {
            int n2 = GzipInflatingBuffer.this.inflaterInputEnd - GzipInflatingBuffer.this.inflaterInputStart;
            if (n2 > 0) {
                n2 = GzipInflatingBuffer.this.inflaterInput[GzipInflatingBuffer.this.inflaterInputStart] & 0xFF;
                GzipInflatingBuffer.this.inflaterInputStart += 1;
            } else {
                n2 = GzipInflatingBuffer.this.gzippedData.readUnsignedByte();
            }
            GzipInflatingBuffer.this.crc.update(n2);
            GzipInflatingBuffer.this.bytesConsumed += 1;
            return n2;
        }

        private void skipBytes(int n2) {
            int n3 = n2;
            int n4 = GzipInflatingBuffer.this.inflaterInputEnd - GzipInflatingBuffer.this.inflaterInputStart;
            if (n4 > 0) {
                n4 = Math.min(n4, n2);
                GzipInflatingBuffer.this.crc.update(GzipInflatingBuffer.this.inflaterInput, GzipInflatingBuffer.this.inflaterInputStart, n4);
                GzipInflatingBuffer.this.inflaterInputStart += n4;
                n3 = n2 - n4;
            }
            if (n3 > 0) {
                int n5;
                byte[] byArray = new byte[512];
                for (int i2 = 0; i2 < n3; i2 += n5) {
                    n5 = Math.min(n3 - i2, 512);
                    GzipInflatingBuffer.this.gzippedData.readBytes(byArray, 0, n5);
                    GzipInflatingBuffer.this.crc.update(byArray, 0, n5);
                }
            }
            GzipInflatingBuffer.this.bytesConsumed += n2;
        }

        private int readableBytes() {
            return GzipInflatingBuffer.this.inflaterInputEnd - GzipInflatingBuffer.this.inflaterInputStart + GzipInflatingBuffer.this.gzippedData.readableBytes();
        }

        private boolean readBytesUntilZero() {
            while (this.readableBytes() > 0) {
                if (this.readUnsignedByte() != 0) continue;
                return true;
            }
            return false;
        }

        private int readUnsignedShort() {
            return this.readUnsignedByte() | this.readUnsignedByte() << 8;
        }

        private long readUnsignedInt() {
            long l2 = this.readUnsignedShort();
            return (long)this.readUnsignedShort() << 16 | l2;
        }
    }
}

