/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Provider;

public final class ConscryptLoader {
    private static final Method NEW_PROVIDER_METHOD;
    private static final Method IS_CONSCRYPT_METHOD;

    public static boolean isPresent() {
        return NEW_PROVIDER_METHOD != null;
    }

    public static boolean isConscrypt(Provider provider) {
        if (!ConscryptLoader.isPresent()) {
            return false;
        }
        try {
            return (Boolean)IS_CONSCRYPT_METHOD.invoke(null, provider);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    public static Provider newProvider() throws Throwable {
        if (!ConscryptLoader.isPresent()) {
            Class.forName("com.appoptics.ext.org.conscrypt.Conscrypt");
            throw new AssertionError((Object)"Unexpected failure referencing Conscrypt class");
        }
        return (Provider)NEW_PROVIDER_METHOD.invoke(null, new Object[0]);
    }

    static {
        Method method;
        GenericDeclaration genericDeclaration;
        try {
            genericDeclaration = Class.forName("com.appoptics.ext.org.conscrypt.Conscrypt");
            method = genericDeclaration.getMethod("newProvider", new Class[0]);
            genericDeclaration = genericDeclaration.getMethod("isConscrypt", Provider.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            method = null;
            genericDeclaration = null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        NEW_PROVIDER_METHOD = method;
        IS_CONSCRYPT_METHOD = genericDeclaration;
    }
}

