/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.grpc.internal.LongCounter;
import com.appoptics.ext.io.grpc.internal.LongCounterFactory;
import com.appoptics.ext.io.grpc.internal.TimeProvider;

final class CallTracer {
    private final TimeProvider timeProvider;
    private final LongCounter callsStarted = LongCounterFactory.create();
    private final LongCounter callsSucceeded = LongCounterFactory.create();
    private final LongCounter callsFailed = LongCounterFactory.create();
    private volatile long lastCallStartedNanos;
    static final Factory DEFAULT_FACTORY = new Factory(){

        public CallTracer create() {
            return new CallTracer(TimeProvider.SYSTEM_TIME_PROVIDER);
        }
    };

    CallTracer(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    public final void reportCallStarted() {
        this.callsStarted.add(1L);
        this.lastCallStartedNanos = this.timeProvider.currentTimeNanos();
    }

    public final void reportCallEnded(boolean bl) {
        if (bl) {
            this.callsSucceeded.add(1L);
            return;
        }
        this.callsFailed.add(1L);
    }

    public static interface Factory {
        public CallTracer create();
    }
}

