/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.Attributes;
import com.appoptics.ext.io.grpc.ChannelLogger;
import com.appoptics.ext.io.grpc.ConnectivityState;
import com.appoptics.ext.io.grpc.EquivalentAddressGroup;
import com.appoptics.ext.io.grpc.LoadBalancer;
import com.appoptics.ext.io.grpc.LoadBalancerProvider;
import com.appoptics.ext.io.grpc.LoadBalancerRegistry;
import com.appoptics.ext.io.grpc.NameResolver;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.internal.ServiceConfigUtil;
import com.tracelytics.a.d.a.a.g;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AutoConfiguredLoadBalancerFactory {
    private final LoadBalancerRegistry registry;
    private final String defaultPolicy;

    public AutoConfiguredLoadBalancerFactory(String string) {
        this(LoadBalancerRegistry.getDefaultRegistry(), string);
    }

    AutoConfiguredLoadBalancerFactory(LoadBalancerRegistry loadBalancerRegistry, String string) {
        this.registry = b.a(loadBalancerRegistry, (Object)"registry");
        this.defaultPolicy = b.a(string, (Object)"defaultPolicy");
    }

    public final AutoConfiguredLoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new AutoConfiguredLoadBalancer(helper);
    }

    private LoadBalancerProvider getProviderOrThrow(String string, String string2) throws PolicyException {
        LoadBalancerProvider loadBalancerProvider = this.registry.getProvider(string);
        if (loadBalancerProvider == null) {
            throw new PolicyException("Trying to load '" + string + "' because " + string2 + ", but it's unavailable");
        }
        return loadBalancerProvider;
    }

    final NameResolver.ConfigOrError parseLoadBalancerPolicy(Map<String, ?> object) {
        try {
            List<ServiceConfigUtil.LbConfig> list = null;
            if (object != null) {
                object = ServiceConfigUtil.getLoadBalancingConfigsFromServiceConfig(object);
                list = ServiceConfigUtil.unwrapLoadBalancingConfigList(object);
            }
            if (list != null && !list.isEmpty()) {
                return ServiceConfigUtil.selectLbPolicyFromList(list, this.registry);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return NameResolver.ConfigOrError.fromError(Status.UNKNOWN.withDescription("can't parse load balancer configuration").withCause(runtimeException));
        }
    }

    private static final class FailingPicker
    extends LoadBalancer.SubchannelPicker {
        private final Status failure;

        FailingPicker(Status status) {
            this.failure = status;
        }

        public final LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs pickSubchannelArgs) {
            return LoadBalancer.PickResult.withError(this.failure);
        }
    }

    private static final class EmptyPicker
    extends LoadBalancer.SubchannelPicker {
        private EmptyPicker() {
        }

        public final LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs pickSubchannelArgs) {
            return LoadBalancer.PickResult.withNoResult();
        }

        public final String toString() {
            return g.a(EmptyPicker.class).toString();
        }
    }

    static final class PolicyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private PolicyException(String string) {
            super(string);
        }
    }

    public final class AutoConfiguredLoadBalancer {
        private final LoadBalancer.Helper helper;
        private LoadBalancer delegate;
        private LoadBalancerProvider delegateProvider;

        AutoConfiguredLoadBalancer(LoadBalancer.Helper helper) {
            this.helper = helper;
            this.delegateProvider = AutoConfiguredLoadBalancerFactory.this.registry.getProvider(AutoConfiguredLoadBalancerFactory.this.defaultPolicy);
            if (this.delegateProvider == null) {
                throw new IllegalStateException("Could not find policy '" + AutoConfiguredLoadBalancerFactory.this.defaultPolicy + "'. Make sure its implementation is either registered to LoadBalancerRegistry or included in META-INF/services/io.grpc.LoadBalancerProvider from your jar files.");
            }
            this.delegate = this.delegateProvider.newLoadBalancer(helper);
        }

        final Status tryHandleResolvedAddresses(LoadBalancer.ResolvedAddresses object) {
            Object object2;
            List<EquivalentAddressGroup> list = ((LoadBalancer.ResolvedAddresses)object).getAddresses();
            Attributes attributes = ((LoadBalancer.ResolvedAddresses)object).getAttributes();
            Object object3 = (ServiceConfigUtil.PolicySelection)((LoadBalancer.ResolvedAddresses)object).getLoadBalancingPolicyConfig();
            if (object3 == null) {
                try {
                    object2 = AutoConfiguredLoadBalancerFactory.this.getProviderOrThrow(AutoConfiguredLoadBalancerFactory.this.defaultPolicy, "using default policy");
                }
                catch (PolicyException policyException) {
                    object = Status.INTERNAL.withDescription(policyException.getMessage());
                    this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new FailingPicker((Status)object));
                    this.delegate.shutdown();
                    this.delegateProvider = null;
                    this.delegate = new NoopLoadBalancer();
                    return Status.OK;
                }
                object3 = new ServiceConfigUtil.PolicySelection((LoadBalancerProvider)object2, null);
            }
            if (this.delegateProvider == null || !((ServiceConfigUtil.PolicySelection)object3).provider.getPolicyName().equals(this.delegateProvider.getPolicyName())) {
                this.helper.updateBalancingState(ConnectivityState.CONNECTING, new EmptyPicker());
                this.delegate.shutdown();
                this.delegateProvider = ((ServiceConfigUtil.PolicySelection)object3).provider;
                object2 = this.delegate;
                this.delegate = this.delegateProvider.newLoadBalancer(this.helper);
                this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.INFO, "Load balancer changed from {0} to {1}", object2.getClass().getSimpleName(), this.delegate.getClass().getSimpleName());
            }
            if ((object2 = ((ServiceConfigUtil.PolicySelection)object3).config) != null) {
                this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.DEBUG, "Load-balancing config: {0}", ((ServiceConfigUtil.PolicySelection)object3).config);
            }
            object3 = this.getDelegate();
            if (((LoadBalancer.ResolvedAddresses)object).getAddresses().isEmpty() && !((LoadBalancer)object3).canHandleEmptyAddressListFromNameResolution()) {
                return Status.UNAVAILABLE.withDescription("NameResolver returned no usable address. addrs=" + list + ", attrs=" + attributes);
            }
            ((LoadBalancer)object3).handleResolvedAddresses(LoadBalancer.ResolvedAddresses.newBuilder().setAddresses(((LoadBalancer.ResolvedAddresses)object).getAddresses()).setAttributes(attributes).setLoadBalancingPolicyConfig(object2).build());
            return Status.OK;
        }

        final void handleNameResolutionError(Status status) {
            this.getDelegate().handleNameResolutionError(status);
        }

        final void shutdown() {
            this.delegate.shutdown();
            this.delegate = null;
        }

        public final LoadBalancer getDelegate() {
            return this.delegate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NoopLoadBalancer
    extends LoadBalancer {
        private NoopLoadBalancer() {
        }

        @Override
        @Deprecated
        public final void handleResolvedAddressGroups(List<EquivalentAddressGroup> list, Attributes attributes) {
        }

        @Override
        public final void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        }

        @Override
        public final void handleNameResolutionError(Status status) {
        }

        @Override
        public final void shutdown() {
        }
    }
}

