/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServiceProviders {
    public static <T> List<T> loadAll(Class<T> iterable, Iterable<Class<?>> iterable2, ClassLoader classLoader22, final PriorityAccessor<T> priorityAccessor) {
        iterable = ServiceProviders.isAndroid(classLoader22) ? ServiceProviders.getCandidatesViaHardCoded(iterable, iterable2) : ServiceProviders.getCandidatesViaServiceLoader(iterable, classLoader22);
        iterable2 = new ArrayList();
        for (ClassLoader classLoader22 : iterable) {
            if (!priorityAccessor.isAvailable(classLoader22)) continue;
            iterable2.add((ClassLoader)classLoader22);
        }
        Collections.sort(iterable2, Collections.reverseOrder(new Comparator<T>(){

            @Override
            public int compare(T t2, T t3) {
                int n2 = priorityAccessor.getPriority(t2) - priorityAccessor.getPriority(t3);
                if (n2 != 0) {
                    return n2;
                }
                return t2.getClass().getName().compareTo(t3.getClass().getName());
            }
        }));
        return Collections.unmodifiableList(iterable2);
    }

    static boolean isAndroid(ClassLoader classLoader) {
        try {
            Class.forName("android.app.Application", false, classLoader);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static <T> Iterable<T> getCandidatesViaServiceLoader(Class<T> clazz, ClassLoader serviceLoader) {
        if (!(serviceLoader = ServiceLoader.load(clazz, (ClassLoader)((Object)serviceLoader))).iterator().hasNext()) {
            serviceLoader = ServiceLoader.load(clazz);
        }
        return serviceLoader;
    }

    static <T> Iterable<T> getCandidatesViaHardCoded(Class<T> clazz, Iterable<Class<?>> object) {
        ArrayList<T> arrayList = new ArrayList<T>();
        object = object.iterator();
        while (object.hasNext()) {
            Class clazz2 = (Class)object.next();
            arrayList.add(ServiceProviders.create(clazz, clazz2));
        }
        return arrayList;
    }

    static <T> T create(Class<T> clazz, Class<?> clazz2) {
        try {
            return clazz2.asSubclass(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            throw new ServiceConfigurationError(String.format("Provider %s could not be instantiated %s", clazz2.getName(), throwable), throwable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PriorityAccessor<T> {
        public boolean isAvailable(T var1);

        public int getPriority(T var1);
    }
}

