/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.NameResolver;
import com.appoptics.ext.io.grpc.NameResolverProvider;
import com.appoptics.ext.io.grpc.ServiceProviders;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NameResolverRegistry {
    private static final Logger logger = Logger.getLogger(NameResolverRegistry.class.getName());
    private static NameResolverRegistry instance;
    private final NameResolver.Factory factory = new NameResolverFactory();
    private final LinkedHashSet<NameResolverProvider> allProviders = new LinkedHashSet();
    private List<NameResolverProvider> effectiveProviders = Collections.emptyList();

    private synchronized void addProvider(NameResolverProvider nameResolverProvider) {
        b.a(nameResolverProvider.isAvailable(), (Object)"isAvailable() returned false");
        this.allProviders.add(nameResolverProvider);
    }

    private synchronized void refreshProviders() {
        ArrayList<NameResolverProvider> arrayList = new ArrayList<NameResolverProvider>(this.allProviders);
        Collections.sort(arrayList, Collections.reverseOrder(new Comparator<NameResolverProvider>(){

            @Override
            public int compare(NameResolverProvider nameResolverProvider, NameResolverProvider nameResolverProvider2) {
                return nameResolverProvider.priority() - nameResolverProvider2.priority();
            }
        }));
        this.effectiveProviders = Collections.unmodifiableList(arrayList);
    }

    public static synchronized NameResolverRegistry getDefaultRegistry() {
        if (instance == null) {
            List<NameResolverProvider> list = ServiceProviders.loadAll(NameResolverProvider.class, NameResolverRegistry.getHardCodedClasses(), NameResolverProvider.class.getClassLoader(), new NameResolverPriorityAccessor());
            if (list.isEmpty()) {
                logger.warning("No NameResolverProviders found via ServiceLoader, including for DNS. This is probably due to a broken build. If using ProGuard, check your configuration");
            }
            instance = new NameResolverRegistry();
            for (NameResolverProvider nameResolverProvider : list) {
                logger.fine("Service loader found " + nameResolverProvider);
                if (!nameResolverProvider.isAvailable()) continue;
                instance.addProvider(nameResolverProvider);
            }
            instance.refreshProviders();
        }
        return instance;
    }

    final synchronized List<NameResolverProvider> providers() {
        return this.effectiveProviders;
    }

    public final NameResolver.Factory asFactory() {
        return this.factory;
    }

    static List<Class<?>> getHardCodedClasses() {
        ArrayList arrayList = new ArrayList();
        try {
            arrayList.add(Class.forName("com.appoptics.ext.io.grpc.internal.DnsNameResolverProvider"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.FINE, "Unable to find DNS NameResolver", classNotFoundException);
        }
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NameResolverPriorityAccessor
    implements ServiceProviders.PriorityAccessor<NameResolverProvider> {
        private NameResolverPriorityAccessor() {
        }

        @Override
        public final boolean isAvailable(NameResolverProvider nameResolverProvider) {
            return nameResolverProvider.isAvailable();
        }

        @Override
        public final int getPriority(NameResolverProvider nameResolverProvider) {
            return nameResolverProvider.priority();
        }
    }

    private final class NameResolverFactory
    extends NameResolver.Factory {
        private NameResolverFactory() {
        }

        public final NameResolver newNameResolver(URI uRI, NameResolver.Args args) {
            Object object = NameResolverRegistry.this.providers();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (NameResolverProvider)object.next();
                if ((object2 = ((NameResolver.Factory)object2).newNameResolver(uRI, args)) == null) continue;
                return object2;
            }
            return null;
        }

        public final String getDefaultScheme() {
            List<NameResolverProvider> list = NameResolverRegistry.this.providers();
            if (list.isEmpty()) {
                return "unknown";
            }
            return list.get(0).getDefaultScheme();
        }
    }
}

