/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import com.appoptics.ext.io.a.b;
import com.tracelytics.a.d.a.a.g;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReferenceArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodDescriptor<ReqT, RespT> {
    private final MethodType type;
    private final String fullMethodName;
    private final String serviceName;
    private final Marshaller<ReqT> requestMarshaller;
    private final Marshaller<RespT> responseMarshaller;
    private final Object schemaDescriptor;
    private final boolean idempotent;
    private final boolean safe;
    private final boolean sampledToLocalTracing;
    private final AtomicReferenceArray<Object> rawMethodNames = new AtomicReferenceArray(2);

    final Object getRawMethodName(int n2) {
        return this.rawMethodNames.get(n2);
    }

    final void setRawMethodName(int n2, Object object) {
        this.rawMethodNames.lazySet(n2, object);
    }

    private MethodDescriptor(MethodType methodType, String string, Marshaller<ReqT> marshaller, Marshaller<RespT> marshaller2, Object object, boolean bl, boolean bl2, boolean bl3) {
        assert (!bl2 || bl) : "safe should imply idempotent";
        this.type = b.a(methodType, (Object)"type");
        this.fullMethodName = b.a(string, (Object)"fullMethodName");
        this.serviceName = MethodDescriptor.extractFullServiceName(string);
        this.requestMarshaller = b.a(marshaller, (Object)"requestMarshaller");
        this.responseMarshaller = b.a(marshaller2, (Object)"responseMarshaller");
        this.schemaDescriptor = object;
        this.idempotent = bl;
        this.safe = bl2;
        this.sampledToLocalTracing = bl3;
    }

    public final MethodType getType() {
        return this.type;
    }

    public final String getFullMethodName() {
        return this.fullMethodName;
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final RespT parseResponse(InputStream inputStream) {
        return this.responseMarshaller.parse(inputStream);
    }

    public final InputStream streamRequest(ReqT ReqT) {
        return this.requestMarshaller.stream(ReqT);
    }

    public final Marshaller<ReqT> getRequestMarshaller() {
        return this.requestMarshaller;
    }

    public final Marshaller<RespT> getResponseMarshaller() {
        return this.responseMarshaller;
    }

    public final boolean isSafe() {
        return this.safe;
    }

    public static String generateFullMethodName(String string, String string2) {
        return b.a(string, (Object)"fullServiceName") + "/" + b.a(string2, (Object)"methodName");
    }

    public static String extractFullServiceName(String string) {
        int n2 = b.a(string, (Object)"fullMethodName").lastIndexOf(47);
        if (n2 == -1) {
            return null;
        }
        return string.substring(0, n2);
    }

    public static <ReqT, RespT> Builder<ReqT, RespT> newBuilder() {
        return MethodDescriptor.newBuilder(null, null);
    }

    public static <ReqT, RespT> Builder<ReqT, RespT> newBuilder(Marshaller<ReqT> marshaller, Marshaller<RespT> marshaller2) {
        return new Builder().setRequestMarshaller(marshaller).setResponseMarshaller(marshaller2);
    }

    public final <NewReqT, NewRespT> Builder<NewReqT, NewRespT> toBuilder(Marshaller<NewReqT> marshaller, Marshaller<NewRespT> marshaller2) {
        return MethodDescriptor.newBuilder().setRequestMarshaller(marshaller).setResponseMarshaller(marshaller2).setType(this.type).setFullMethodName(this.fullMethodName).setIdempotent(this.idempotent).setSafe(this.safe).setSampledToLocalTracing(this.sampledToLocalTracing).setSchemaDescriptor(this.schemaDescriptor);
    }

    public final String toString() {
        return g.a(this).a("fullMethodName", this.fullMethodName).a("type", (Object)this.type).a("idempotent", this.idempotent).a("safe", this.safe).a("sampledToLocalTracing", this.sampledToLocalTracing).a("requestMarshaller", this.requestMarshaller).a("responseMarshaller", this.responseMarshaller).a("schemaDescriptor", this.schemaDescriptor).a().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder<ReqT, RespT> {
        private Marshaller<ReqT> requestMarshaller;
        private Marshaller<RespT> responseMarshaller;
        private MethodType type;
        private String fullMethodName;
        private boolean idempotent;
        private boolean safe;
        private Object schemaDescriptor;
        private boolean sampledToLocalTracing;

        private Builder() {
        }

        public final Builder<ReqT, RespT> setRequestMarshaller(Marshaller<ReqT> marshaller) {
            this.requestMarshaller = marshaller;
            return this;
        }

        public final Builder<ReqT, RespT> setResponseMarshaller(Marshaller<RespT> marshaller) {
            this.responseMarshaller = marshaller;
            return this;
        }

        public final Builder<ReqT, RespT> setType(MethodType methodType) {
            this.type = methodType;
            return this;
        }

        public final Builder<ReqT, RespT> setFullMethodName(String string) {
            this.fullMethodName = string;
            return this;
        }

        public final Builder<ReqT, RespT> setSchemaDescriptor(Object object) {
            this.schemaDescriptor = object;
            return this;
        }

        public final Builder<ReqT, RespT> setIdempotent(boolean bl) {
            this.idempotent = bl;
            if (!bl) {
                this.safe = false;
            }
            return this;
        }

        public final Builder<ReqT, RespT> setSafe(boolean bl) {
            this.safe = bl;
            if (bl) {
                this.idempotent = true;
            }
            return this;
        }

        public final Builder<ReqT, RespT> setSampledToLocalTracing(boolean bl) {
            this.sampledToLocalTracing = bl;
            return this;
        }

        public final MethodDescriptor<ReqT, RespT> build() {
            return new MethodDescriptor(this.type, this.fullMethodName, this.requestMarshaller, this.responseMarshaller, this.schemaDescriptor, this.idempotent, this.safe, this.sampledToLocalTracing);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Marshaller<T> {
        public InputStream stream(T var1);

        public T parse(InputStream var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MethodType {
        UNARY,
        CLIENT_STREAMING,
        SERVER_STREAMING,
        BIDI_STREAMING,
        UNKNOWN;


        public final boolean clientSendsOneMessage() {
            return this == UNARY || this == SERVER_STREAMING;
        }
    }
}

