/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.InternalInstrumented;
import com.appoptics.ext.io.grpc.InternalWithLogId;
import com.tracelytics.a.d.a.a.d;
import com.tracelytics.a.d.a.a.g;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InternalChannelz {
    private static final Logger log = Logger.getLogger(InternalChannelz.class.getName());
    private static final InternalChannelz INSTANCE = new InternalChannelz();
    private final ConcurrentNavigableMap<Long, InternalInstrumented<Object>> servers = new ConcurrentSkipListMap<Long, InternalInstrumented<Object>>();
    private final ConcurrentNavigableMap<Long, InternalInstrumented<Object>> rootChannels = new ConcurrentSkipListMap<Long, InternalInstrumented<Object>>();
    private final ConcurrentMap<Long, InternalInstrumented<Object>> subchannels = new ConcurrentHashMap<Long, InternalInstrumented<Object>>();
    private final ConcurrentMap<Long, InternalInstrumented<Object>> otherSockets = new ConcurrentHashMap<Long, InternalInstrumented<Object>>();
    private final ConcurrentMap<Long, Object> perServerSockets = new ConcurrentHashMap<Long, Object>();

    public static InternalChannelz instance() {
        return INSTANCE;
    }

    public final void addSubchannel(InternalInstrumented<Object> internalInstrumented) {
        InternalChannelz.add(this.subchannels, internalInstrumented);
    }

    public final void addRootChannel(InternalInstrumented<Object> internalInstrumented) {
        InternalChannelz.add(this.rootChannels, internalInstrumented);
    }

    public final void addClientSocket(InternalInstrumented<Object> internalInstrumented) {
        InternalChannelz.add(this.otherSockets, internalInstrumented);
    }

    public final void removeSubchannel(InternalInstrumented<Object> internalInstrumented) {
        InternalChannelz.remove(this.subchannels, internalInstrumented);
    }

    public final void removeRootChannel(InternalInstrumented<Object> internalInstrumented) {
        InternalChannelz.remove(this.rootChannels, internalInstrumented);
    }

    public final void removeClientSocket(InternalInstrumented<Object> internalInstrumented) {
        InternalChannelz.remove(this.otherSockets, internalInstrumented);
    }

    private static <T extends InternalInstrumented<?>> void add(Map<Long, T> object, T t2) {
        object = (InternalInstrumented)object.put(t2.getLogId().getId(), t2);
        assert (object == null);
    }

    private static <T extends InternalInstrumented<?>> void remove(Map<Long, T> object, T t2) {
        object = (InternalInstrumented)object.remove(InternalChannelz.id(t2));
        assert (object != null);
    }

    public static long id(InternalWithLogId internalWithLogId) {
        return internalWithLogId.getLogId().getId();
    }

    public static final class Tls {
        public final String cipherSuiteStandardName;
        public final Certificate localCert;
        public final Certificate remoteCert;

        public Tls(SSLSession sSLSession) {
            String string = sSLSession.getCipherSuite();
            Certificate certificate = null;
            Certificate certificate2 = null;
            Certificate[] certificateArray = sSLSession.getLocalCertificates();
            if (certificateArray != null) {
                certificate = certificateArray[0];
            }
            try {
                certificateArray = sSLSession.getPeerCertificates();
                if (certificateArray != null) {
                    certificate2 = certificateArray[0];
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                log.log(Level.FINE, String.format("Peer cert not available for peerHost=%s", sSLSession.getPeerHost()), sSLPeerUnverifiedException);
            }
            this.cipherSuiteStandardName = string;
            this.localCert = certificate;
            this.remoteCert = certificate2;
        }
    }

    public static final class OtherSecurity {
    }

    public static final class Security {
        public final Tls tls;
        public final OtherSecurity other;

        public Security(Tls tls) {
            this.tls = b.a(tls);
            this.other = null;
        }
    }

    public static final class ChannelTrace {

        public static final class Event {
            public final String description;
            public final Severity severity;
            public final long timestampNanos;
            public final InternalWithLogId channelRef;
            public final InternalWithLogId subchannelRef;

            private Event(String string, Severity severity, long l2, InternalWithLogId internalWithLogId, InternalWithLogId internalWithLogId2) {
                this.description = string;
                this.severity = b.a(severity, (Object)"severity");
                this.timestampNanos = l2;
                this.channelRef = internalWithLogId;
                this.subchannelRef = internalWithLogId2;
            }

            public final int hashCode() {
                Object[] objectArray = new Object[]{this.description, this.severity, this.timestampNanos, this.channelRef, this.subchannelRef};
                return Arrays.hashCode(objectArray);
            }

            public final boolean equals(Object object) {
                if (object instanceof Event) {
                    object = (Event)object;
                    return d.a((Object)this.description, (Object)((Event)object).description) && d.a((Object)this.severity, (Object)((Event)object).severity) && this.timestampNanos == ((Event)object).timestampNanos && d.a(this.channelRef, (Object)((Event)object).channelRef) && d.a(this.subchannelRef, (Object)((Event)object).subchannelRef);
                }
                return false;
            }

            public final String toString() {
                return g.a(this).a("description", this.description).a("severity", (Object)this.severity).a("timestampNanos", this.timestampNanos).a("channelRef", this.channelRef).a("subchannelRef", this.subchannelRef).toString();
            }

            public static final class Builder {
                private String description;
                private Severity severity;
                private Long timestampNanos;
                private InternalWithLogId channelRef;
                private InternalWithLogId subchannelRef;

                public final Builder setDescription(String string) {
                    this.description = string;
                    return this;
                }

                public final Builder setTimestampNanos(long l2) {
                    this.timestampNanos = l2;
                    return this;
                }

                public final Builder setSeverity(Severity severity) {
                    this.severity = severity;
                    return this;
                }

                public final Builder setSubchannelRef(InternalWithLogId internalWithLogId) {
                    this.subchannelRef = internalWithLogId;
                    return this;
                }

                public final Event build() {
                    b.a(this.description, (Object)"description");
                    b.a(this.severity, (Object)"severity");
                    b.a(this.timestampNanos, (Object)"timestampNanos");
                    b.b(this.channelRef == null || this.subchannelRef == null, "at least one of channelRef and subchannelRef must be null");
                    return new Event(this.description, this.severity, this.timestampNanos, this.channelRef, this.subchannelRef);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Severity {
                CT_UNKNOWN,
                CT_INFO,
                CT_WARNING,
                CT_ERROR;

            }
        }
    }
}

