/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.Codec;
import com.appoptics.ext.io.grpc.Decompressor;
import com.tracelytics.a.d.a.a.f;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DecompressorRegistry {
    static final f ACCEPT_ENCODING_JOINER = f.a(',');
    private static final DecompressorRegistry DEFAULT_INSTANCE = DecompressorRegistry.emptyInstance().with(new Codec.Gzip(), true).with(Codec.Identity.NONE, false);
    private final Map<String, DecompressorInfo> decompressors;
    private final byte[] advertisedDecompressors;

    public static DecompressorRegistry emptyInstance() {
        return new DecompressorRegistry();
    }

    public static DecompressorRegistry getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public final DecompressorRegistry with(Decompressor decompressor, boolean bl) {
        return new DecompressorRegistry(decompressor, bl, this);
    }

    private DecompressorRegistry(Decompressor decompressor, boolean bl, DecompressorRegistry object) {
        String string = decompressor.getMessageEncoding();
        b.a(!string.contains(","), (Object)"Comma is currently not allowed in message encoding");
        int n2 = ((DecompressorRegistry)object).decompressors.size();
        if (!((DecompressorRegistry)object).decompressors.containsKey(decompressor.getMessageEncoding())) {
            ++n2;
        }
        LinkedHashMap<String, DecompressorInfo> linkedHashMap = new LinkedHashMap<String, DecompressorInfo>(n2);
        for (DecompressorInfo decompressorInfo : ((DecompressorRegistry)object).decompressors.values()) {
            String string2 = decompressorInfo.decompressor.getMessageEncoding();
            if (string2.equals(string)) continue;
            linkedHashMap.put(string2, new DecompressorInfo(decompressorInfo.decompressor, decompressorInfo.advertised));
        }
        linkedHashMap.put(string, new DecompressorInfo(decompressor, bl));
        this.decompressors = Collections.unmodifiableMap(linkedHashMap);
        this.advertisedDecompressors = ACCEPT_ENCODING_JOINER.a(this.getAdvertisedMessageEncodings()).getBytes(Charset.forName("US-ASCII"));
    }

    private DecompressorRegistry() {
        this.decompressors = new LinkedHashMap<String, DecompressorInfo>(0);
        this.advertisedDecompressors = new byte[0];
    }

    final byte[] getRawAdvertisedMessageEncodings() {
        return this.advertisedDecompressors;
    }

    public final Set<String> getAdvertisedMessageEncodings() {
        HashSet<String> hashSet = new HashSet<String>(this.decompressors.size());
        for (Map.Entry<String, DecompressorInfo> entry : this.decompressors.entrySet()) {
            if (!entry.getValue().advertised) continue;
            hashSet.add(entry.getKey());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public final Decompressor lookupDecompressor(String object) {
        if ((object = this.decompressors.get(object)) != null) {
            return ((DecompressorInfo)object).decompressor;
        }
        return null;
    }

    private static final class DecompressorInfo {
        final Decompressor decompressor;
        final boolean advertised;

        DecompressorInfo(Decompressor decompressor, boolean bl) {
            this.decompressor = b.a(decompressor, (Object)"decompressor");
            this.advertised = bl;
        }
    }
}

