/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicommons.ApplozicService;

public class AlFlowLayout
extends ViewGroup {
    protected int lineHeightSpace;
    protected boolean alignSenderSide;
    protected boolean isRtlDirection = false;

    public AlFlowLayout(Context context) {
        super(context);
    }

    public AlFlowLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray alCustomAttrTypedArray = ApplozicService.getContext((Context)context).obtainStyledAttributes(attrs, R.styleable.AlFlowLayout, 0, 0);
        this.alignSenderSide = alCustomAttrTypedArray.getBoolean(R.styleable.AlFlowLayout_alignSenderSide, false);
        this.isRtlDirection = ApplozicService.getContext((Context)context).getResources().getConfiguration().getLayoutDirection() == 1;
        alCustomAttrTypedArray.recycle();
    }

    public AlFlowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public AlFlowLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(1, 1);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec) - (this.getPaddingStart() + this.getPaddingEnd());
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec) - this.getPaddingTop() - this.getPaddingBottom();
        int xpos = this.getPaddingStart();
        int ypos = this.getPaddingTop();
        int childHeightMeasureSpec = View.MeasureSpec.getMode((int)heightMeasureSpec) == Integer.MIN_VALUE ? View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.processPositions(width, childHeightMeasureSpec, xpos, ypos, height, heightMeasureSpec, true);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = r - l;
        int xpos = this.getPaddingStart();
        int ypos = this.getPaddingTop();
        this.processPositions(width, 0, xpos, ypos, 0, 0, false);
    }

    private void processPositions(int width, int childHeightMeasureSpec, int xpos, int ypos, int height, int heightMeasureSpec, boolean measureOnly) {
        if (this.alignAtEnd()) {
            xpos = width - (this.alignSenderSide ? this.getPaddingEnd() : this.getPaddingStart());
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            if (measureOnly) {
                child.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)Integer.MIN_VALUE), childHeightMeasureSpec);
            }
            int childw = child.getMeasuredWidth();
            int childh = child.getMeasuredHeight();
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            this.lineHeightSpace = Math.max(this.lineHeightSpace, child.getMeasuredHeight() + lp.verticalSpacing);
            if (this.alignAtEnd()) {
                if (childw > xpos) {
                    xpos = width;
                    ypos += this.lineHeightSpace;
                }
                if (!measureOnly) {
                    child.layout(xpos - childw, ypos, xpos, ypos + childh);
                }
                xpos -= childw + lp.horizontalSpacing;
                continue;
            }
            if (xpos + childw > width) {
                xpos = this.getPaddingStart();
                ypos += this.lineHeightSpace;
            }
            if (!measureOnly) {
                child.layout(xpos, ypos, xpos + childw, ypos + childh);
            }
            xpos += childw + lp.horizontalSpacing;
        }
        if (measureOnly) {
            if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0) {
                height = ypos + this.lineHeightSpace;
            } else if (View.MeasureSpec.getMode((int)heightMeasureSpec) == Integer.MIN_VALUE && ypos + this.lineHeightSpace < height) {
                height = ypos + this.lineHeightSpace;
            }
            this.setMeasuredDimension(width, height);
        }
    }

    public boolean alignAtEnd() {
        return this.alignSenderSide != this.isRtlDirection;
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public int horizontalSpacing;
        public int verticalSpacing;

        public LayoutParams(int horizontalSpacing, int verticalSpacing) {
            super(0, 0);
            this.horizontalSpacing = horizontalSpacing;
            this.verticalSpacing = verticalSpacing;
        }
    }
}

