/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.async;

import android.content.Context;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComMessageService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicommons.task.AlAsyncTask;
import java.lang.ref.WeakReference;
import java.util.Map;

public class AlMessageMetadataUpdateTask
extends AlAsyncTask<Void, ApiResponse> {
    private WeakReference<Context> context;
    private String key;
    private Map<String, String> metadata;
    private MessageMetadataListener listener;

    public AlMessageMetadataUpdateTask(Context context, String key, Map<String, String> metadata, MessageMetadataListener listener) {
        this.context = new WeakReference<Context>(context);
        this.key = key;
        this.metadata = metadata;
        this.listener = listener;
    }

    protected ApiResponse doInBackground() {
        return new MobiComMessageService((Context)this.context.get(), MessageIntentService.class).getUpdateMessageMetadata(this.key, this.metadata);
    }

    protected void onPostExecute(ApiResponse apiResponse) {
        super.onPostExecute((Object)apiResponse);
        if (apiResponse == null) {
            this.listener.onFailure((Context)this.context.get(), "Some error occurred");
        } else if (!"success".equals(apiResponse.getStatus()) && apiResponse.getErrorResponse() != null) {
            this.listener.onFailure((Context)this.context.get(), apiResponse.getErrorResponse().toString());
        } else if ("success".equals(apiResponse.getStatus())) {
            new MessageDatabaseService((Context)this.context.get()).updateMessageMetadata(this.key, this.metadata);
            this.listener.onSuccess((Context)this.context.get(), "Metadata updated successfully for messsage key : " + this.key);
        }
    }

    public static interface MessageMetadataListener {
        public void onSuccess(Context var1, String var2);

        public void onFailure(Context var1, String var2);
    }
}

