/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.payment;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.richmessaging.payment.PaymentJsInterface;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentActivity
extends AppCompatActivity {
    WebView webView;
    Toolbar toolbar;
    private Map<String, String> txnData;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_payment);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(this.toolbar);
        this.webView = (WebView)this.findViewById(R.id.paymentWebView);
        String formDataJson = this.getIntent().getStringExtra("formData");
        String baseUrl = this.getIntent().getStringExtra("formAction");
        if (formDataJson != null) {
            this.setWebViewClient();
            this.txnData = new HashMap<String, String>();
            try {
                JSONObject jsonObject = new JSONObject(formDataJson);
                Iterator iter = jsonObject.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    if (jsonObject.getString(key) == null) continue;
                    this.txnData.put(key, jsonObject.getString(key));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.webViewClientPost(this.webView, baseUrl, this.txnData.entrySet());
        } else {
            this.webView.loadUrl(baseUrl);
        }
    }

    public void webViewClientPost(WebView webView, String url, Collection<Map.Entry<String, String>> postData) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head></head>");
        sb.append("<body onload='form1.submit()'>");
        sb.append(String.format("<form id='form1' action='%s' method='%s'>", url, "post"));
        for (Map.Entry<String, String> item : postData) {
            sb.append(String.format("<input name='%s' type='hidden' value='%s' />", item.getKey(), item.getValue()));
        }
        sb.append("</form></body></html>");
        webView.loadData(sb.toString(), "text/html", "utf-8");
    }

    public void onBackPressed() {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this);
        alertDialog.setTitle((CharSequence)"Warning");
        alertDialog.setMessage((CharSequence)"Do you want to cancel this transaction?");
        alertDialog.setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                PaymentActivity.this.finish();
            }
        });
        alertDialog.setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        alertDialog.show();
    }

    public void setWebViewClient() {
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return super.shouldOverrideUrlLoading(view, url);
            }

            public void onPageFinished(WebView view, String url) {
                if (!PaymentActivity.this.txnData.isEmpty() && PaymentActivity.this.txnData.containsKey("surl") && url.equals(PaymentActivity.this.txnData.get("surl"))) {
                    PaymentActivity.this.finish();
                } else if (!PaymentActivity.this.txnData.isEmpty() && PaymentActivity.this.txnData.containsKey("furl") && url.equals(PaymentActivity.this.txnData.get("furl"))) {
                    PaymentActivity.this.finish();
                }
                super.onPageFinished(view, url);
            }
        });
        this.webView.setVisibility(0);
        this.webView.getSettings().setBuiltInZoomControls(true);
        this.webView.getSettings().setCacheMode(2);
        this.webView.getSettings().setDomStorageEnabled(true);
        this.webView.clearHistory();
        this.webView.clearCache(true);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setSupportZoom(true);
        this.webView.getSettings().setUseWideViewPort(false);
        this.webView.getSettings().setLoadWithOverviewMode(false);
        this.webView.addJavascriptInterface((Object)new PaymentJsInterface((Context)this), "PaymentScreen");
    }
}

