/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ProgressBar;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.FileProvider;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.broadcast.ConnectivityReceiver;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.TouchImageView;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import java.io.File;
import java.util.List;

public class FullScreenImageActivity
extends AppCompatActivity {
    TouchImageView mediaImageViewView;
    private Message message;
    private ConnectivityReceiver connectivityReceiver;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.mobicom_image_full_screen);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(toolbar);
        this.getSupportActionBar().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().show();
        this.showUi();
        this.mediaImageViewView = (TouchImageView)this.findViewById(R.id.full_screen_image);
        ProgressBar progressBar = (ProgressBar)this.findViewById(R.id.full_screen_progress_bar);
        progressBar.setVisibility(0);
        String messageJson = this.getIntent().getStringExtra("message_json");
        if (!TextUtils.isEmpty((CharSequence)messageJson)) {
            this.message = (Message)GsonUtils.getObjectFromJson((String)messageJson, Message.class);
        }
        if (this.message != null && this.message.getFilePaths() != null && !this.message.getFilePaths().isEmpty()) {
            try {
                Bitmap imageBitmap = ImageUtils.decodeSampledBitmapFromPath((String)((String)this.message.getFilePaths().get(0)));
                this.mediaImageViewView.setImageBitmap(imageBitmap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Build.VERSION.SDK_INT >= 11) {
            this.getWindow().getDecorView().setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(){

                public void onSystemUiVisibilityChange(int visibility) {
                    if (visibility == 0) {
                        FullScreenImageActivity.this.getSupportActionBar().show();
                    }
                }
            });
        }
        progressBar.setVisibility(8);
        this.connectivityReceiver = new ConnectivityReceiver();
        this.registerReceiver((BroadcastReceiver)this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    private void toggleActionBar() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            if (actionBar.isShowing()) {
                actionBar.hide();
                this.hideUi();
            } else {
                this.showUi();
                actionBar.show();
            }
        }
    }

    @TargetApi(value=19)
    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus) {
            this.showUi();
        } else {
            this.hideUi();
        }
    }

    private void showUi() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.getWindow().getDecorView().setSystemUiVisibility(1792);
        } else {
            if (Build.VERSION.SDK_INT >= 11) {
                this.requestWindowFeature(9);
            }
            this.getWindow().clearFlags(1024);
        }
    }

    private void hideUi() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.getWindow().getDecorView().setSystemUiVisibility(1798);
        } else {
            this.requestWindowFeature(1);
            this.getWindow().setFlags(1024, 1024);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.attachment_menu, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int i = item.getItemId();
        if (i == R.id.shareOptions) {
            Intent shareIntent = new Intent();
            shareIntent.setAction("android.intent.action.SEND");
            Uri uri = FileProvider.getUriForFile((Context)this, (String)(Utils.getMetaDataValue((Context)this, (String)"com.package.name") + ".provider"), (File)new File((String)this.message.getFilePaths().get(0)));
            if (Build.VERSION.SDK_INT >= 21) {
                shareIntent.addFlags(1);
            } else if (Build.VERSION.SDK_INT >= 16) {
                ClipData clip = ClipData.newUri((ContentResolver)this.getContentResolver(), (CharSequence)"a Photo", (Uri)uri);
                shareIntent.setClipData(clip);
                shareIntent.addFlags(2);
                shareIntent.addFlags(1);
            } else {
                List resInfoList = this.getPackageManager().queryIntentActivities(shareIntent, 65536);
                for (ResolveInfo resolveInfo : resInfoList) {
                    String packageName = resolveInfo.activityInfo.packageName;
                    this.grantUriPermission(packageName, uri, 2);
                    this.grantUriPermission(packageName, uri, 1);
                }
            }
            shareIntent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
            shareIntent.setType(FileUtils.getMimeType((File)new File((String)this.message.getFilePaths().get(0))));
            this.startActivity(Intent.createChooser((Intent)shareIntent, (CharSequence)""));
        } else if (i == R.id.forward) {
            Intent intent = new Intent();
            intent.putExtra("message_json", GsonUtils.getJsonFromObject((Object)this.message, Message.class));
            this.setResult(-1, intent);
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onDestroy() {
        super.onDestroy();
        try {
            if (this.connectivityReceiver != null) {
                this.unregisterReceiver((BroadcastReceiver)this.connectivityReceiver);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

