/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation;

import android.net.Uri;
import android.view.View;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.PopupWindow;
import androidx.fragment.app.FragmentActivity;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import com.applozic.mobicomkit.uiwidgets.uilistener.ALStoragePermission;
import com.applozic.mobicomkit.uiwidgets.uilistener.ALStoragePermissionListener;
import java.util.List;

public class MultimediaOptionsGridView {
    public PopupWindow showPopup;
    FragmentActivity context;
    GridView multimediaOptions;
    private Uri capturedImageUri;
    private ALStoragePermissionListener storagePermissionListener;

    public MultimediaOptionsGridView(FragmentActivity context, GridView multimediaOptions) {
        this.context = context;
        this.multimediaOptions = multimediaOptions;
        this.storagePermissionListener = context instanceof ALStoragePermissionListener ? (ALStoragePermissionListener)context : new ALStoragePermissionListener(){

            @Override
            public boolean isPermissionGranted() {
                return false;
            }

            @Override
            public void checkPermission(ALStoragePermission storagePermission) {
            }
        };
    }

    public void setMultimediaClickListener(final List<String> keys) {
        this.capturedImageUri = null;
        this.multimediaOptions.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                MultimediaOptionsGridView.this.executeMethod((String)keys.get(position));
            }
        });
    }

    public void executeMethod(String key) {
        if (key.equals(this.context.getResources().getString(R.string.al_location))) {
            ((ConversationActivity)this.context).processLocation();
        } else if (key.equals(this.context.getString(R.string.al_camera))) {
            if (this.storagePermissionListener.isPermissionGranted()) {
                ((ConversationActivity)this.context).isTakePhoto(true);
                ((ConversationActivity)this.context).processCameraAction();
            } else {
                this.storagePermissionListener.checkPermission(new ALStoragePermission(){

                    @Override
                    public void onAction(boolean didGrant) {
                        if (didGrant) {
                            ((ConversationActivity)MultimediaOptionsGridView.this.context).isTakePhoto(true);
                            ((ConversationActivity)MultimediaOptionsGridView.this.context).processCameraAction();
                        }
                    }
                });
            }
        } else if (key.equals(this.context.getString(R.string.al_file))) {
            if (this.storagePermissionListener.isPermissionGranted()) {
                ((ConversationActivity)this.context).isAttachment(true);
                ((ConversationActivity)this.context).processAttachment();
            } else {
                this.storagePermissionListener.checkPermission(new ALStoragePermission(){

                    @Override
                    public void onAction(boolean didGrant) {
                        if (didGrant) {
                            ((ConversationActivity)MultimediaOptionsGridView.this.context).isAttachment(true);
                            ((ConversationActivity)MultimediaOptionsGridView.this.context).processAttachment();
                        }
                    }
                });
            }
        } else if (key.equals(this.context.getString(R.string.al_audio))) {
            if (this.storagePermissionListener.isPermissionGranted()) {
                ((ConversationActivity)this.context).showAudioRecordingDialog();
            } else {
                this.storagePermissionListener.checkPermission(new ALStoragePermission(){

                    @Override
                    public void onAction(boolean didGrant) {
                        if (didGrant) {
                            ((ConversationActivity)MultimediaOptionsGridView.this.context).showAudioRecordingDialog();
                        }
                    }
                });
            }
        } else if (key.equals(this.context.getString(R.string.al_video))) {
            if (this.storagePermissionListener.isPermissionGranted()) {
                ((ConversationActivity)this.context).isTakePhoto(false);
                ((ConversationActivity)this.context).processVideoRecording();
            } else {
                this.storagePermissionListener.checkPermission(new ALStoragePermission(){

                    @Override
                    public void onAction(boolean didGrant) {
                        if (didGrant) {
                            ((ConversationActivity)MultimediaOptionsGridView.this.context).isTakePhoto(false);
                            ((ConversationActivity)MultimediaOptionsGridView.this.context).processVideoRecording();
                        }
                    }
                });
            }
        } else if (key.equals(this.context.getString(R.string.al_contact))) {
            if (this.storagePermissionListener.isPermissionGranted()) {
                ((ConversationActivity)this.context).processContact();
            } else {
                this.storagePermissionListener.checkPermission(new ALStoragePermission(){

                    @Override
                    public void onAction(boolean didGrant) {
                        if (didGrant) {
                            ((ConversationActivity)MultimediaOptionsGridView.this.context).processContact();
                        }
                    }
                });
            }
        } else if (key.equals(this.context.getString(R.string.al_price))) {
            new ConversationUIService(this.context).sendPriceMessage();
        }
        this.multimediaOptions.setVisibility(8);
    }
}

