/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ResolveInfo;
import android.database.ContentObserver;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.ContactsContract;
import android.provider.MediaStore;
import android.support.design.widget.Snackbar;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.app.NavUtils;
import android.support.v4.app.TaskStackBuilder;
import android.support.v4.content.FileProvider;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.SearchView;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.Applozic;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.account.register.RegisterUserClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.User;
import com.applozic.mobicomkit.api.account.user.UserClientService;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComMessageService;
import com.applozic.mobicomkit.api.conversation.service.ConversationService;
import com.applozic.mobicomkit.api.people.UserIntentService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.broadcast.ConnectivityReceiver;
import com.applozic.mobicomkit.channel.database.ChannelDatabaseService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.ContactsChangeObserver;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.ConversationUIService;
import com.applozic.mobicomkit.uiwidgets.conversation.MessageCommunicator;
import com.applozic.mobicomkit.uiwidgets.conversation.MobiComKitBroadcastReceiver;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ChannelCreateActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ContactSelectionActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComAttachmentSelectorActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobiComKitActivityInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.MobicomLocationActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.OnClickReplyInterface;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.AudioMessageFragment;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.ConversationFragment;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.MobiComQuickConversationFragment;
import com.applozic.mobicomkit.uiwidgets.instruction.ApplozicPermissions;
import com.applozic.mobicomkit.uiwidgets.instruction.InstructionUtil;
import com.applozic.mobicomkit.uiwidgets.people.activity.MobiComKitPeopleActivity;
import com.applozic.mobicomkit.uiwidgets.people.fragment.ProfileFragment;
import com.applozic.mobicomkit.uiwidgets.uilistener.ALStoragePermission;
import com.applozic.mobicomkit.uiwidgets.uilistener.ALStoragePermissionListener;
import com.applozic.mobicomkit.uiwidgets.uilistener.CustomToolbarListener;
import com.applozic.mobicomkit.uiwidgets.uilistener.MobicomkitUriListener;
import com.applozic.mobicommons.commons.core.utils.PermissionsUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.SearchListFragment;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.Conversation;
import com.applozic.mobicommons.people.contact.Contact;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.theartofdev.edmodo.cropper.CropImage;
import com.theartofdev.edmodo.cropper.CropImageView;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class ConversationActivity
extends AppCompatActivity
implements MessageCommunicator,
MobiComKitActivityInterface,
GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener,
ActivityCompat.OnRequestPermissionsResultCallback,
MobicomkitUriListener,
SearchView.OnQueryTextListener,
OnClickReplyInterface,
ALStoragePermissionListener,
CustomToolbarListener {
    public static final int LOCATION_SERVICE_ENABLE = 1001;
    public static final String TAKE_ORDER = "takeOrder";
    public static final String CONTACT = "contact";
    public static final String CHANNEL = "channel";
    public static final String CONVERSATION_ID = "conversationId";
    public static final String GOOGLE_API_KEY_META_DATA = "com.google.android.geo.API_KEY";
    public static final String ACTIVITY_TO_OPEN_ONCLICK_OF_CALL_BUTTON_META_DATA = "activity.open.on.call.button.click";
    protected static final long UPDATE_INTERVAL = 500L;
    protected static final long FASTEST_INTERVAL = 1L;
    private static final String LOAD_FILE = "loadFile";
    private static final int CONNECTION_FAILURE_RESOLUTION_REQUEST = 9000;
    private static final String API_KYE_STRING = "YOUR_GEO_API_KEY";
    private static final String CAPTURED_IMAGE_URI = "capturedImageUri";
    private static final String CAPTURED_VIDEO_URI = "capturedVideoUri";
    private static final String SHARE_TEXT = "share_text";
    public static final String CONTACTS_GROUP_ID = "CONTACTS_GROUP_ID";
    private static Uri capturedImageUri;
    private static String inviteMessage;
    private static int retry;
    public Contact contact;
    Integer parentGroupKey;
    String parentClientGroupKey;
    public LinearLayout layout;
    public boolean isTakePhoto;
    public boolean isAttachment;
    public Integer currentConversationId;
    public Snackbar snackbar;
    protected ConversationFragment conversation;
    protected MobiComQuickConversationFragment quickConversationFragment;
    protected MobiComKitBroadcastReceiver mobiComKitBroadcastReceiver;
    protected ActionBar mActionBar;
    protected GoogleApiClient googleApiClient;
    String geoApiKey;
    String activityToOpenOnClickOfCallButton;
    int resourceId;
    RelativeLayout childFragmentLayout;
    ProfileFragment profilefragment;
    MobiComMessageService mobiComMessageService;
    AlCustomizationSettings alCustomizationSettings;
    ConnectivityReceiver connectivityReceiver;
    File mediaFile;
    File profilePhotoFile;
    SyncAccountStatusAsyncTask accountStatusAsyncTask;
    String contactsGroupId;
    private LocationRequest locationRequest;
    private Channel channel;
    private BaseContactService baseContactService;
    private ApplozicPermissions applozicPermission;
    private Uri videoFileUri;
    private Uri imageUri;
    private ConversationUIService conversationUIService;
    private SearchView searchView;
    private String searchTerm;
    private SearchListFragment searchListFragment;
    ContactsChangeObserver observer;
    private LinearLayout serviceDisconnectionLayout;
    private ALStoragePermission alStoragePermission;
    private ImageView conversationContactPhoto;
    private TextView toolbarTitle;
    private TextView toolbarSubtitle;

    public static void addFragment(FragmentActivity fragmentActivity, Fragment fragmentToAdd, String fragmentTag) {
        FragmentManager supportFragmentManager = fragmentActivity.getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = supportFragmentManager.beginTransaction();
        fragmentTransaction.replace(R.id.layout_child_activity, fragmentToAdd, fragmentTag);
        if (supportFragmentManager.getBackStackEntryCount() > 1 && !"messageInfoFagment".equalsIgnoreCase(fragmentTag) && !"userProfilefragment".equalsIgnoreCase(fragmentTag)) {
            supportFragmentManager.popBackStackImmediate();
        }
        fragmentTransaction.addToBackStack(fragmentTag);
        fragmentTransaction.commitAllowingStateLoss();
        supportFragmentManager.executePendingTransactions();
    }

    public static Uri getCapturedImageUri() {
        return capturedImageUri;
    }

    public static void setCapturedImageUri(Uri capturedImageUri) {
        ConversationActivity.capturedImageUri = capturedImageUri;
    }

    @Override
    public void showErrorMessageView(String message) {
        try {
            this.layout.setVisibility(0);
            this.snackbar = Snackbar.make((View)this.layout, (CharSequence)message, (int)0);
            this.snackbar.setAction((CharSequence)this.getString(R.string.ok_alert), new View.OnClickListener(){

                public void onClick(View view) {
                    ConversationActivity.this.snackbar.dismiss();
                }
            });
            this.snackbar.setDuration(0);
            ViewGroup group = (ViewGroup)this.snackbar.getView();
            TextView textView = (TextView)group.findViewById(R.id.snackbar_action);
            textView.setTextColor(-256);
            group.setBackgroundColor(this.getResources().getColor(R.color.error_background_color));
            TextView txtView = (TextView)group.findViewById(R.id.snackbar_text);
            txtView.setMaxLines(5);
            this.snackbar.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void retry() {
        ++retry;
    }

    @Override
    public int getRetryCount() {
        return retry;
    }

    public void dismissErrorMessage() {
        if (this.snackbar != null) {
            this.snackbar.dismiss();
        }
    }

    protected void onStop() {
        super.onStop();
        Applozic.disconnectPublish((Context)this);
    }

    protected void onResume() {
        super.onResume();
        Applozic.connectPublish((Context)this);
        if (!Utils.isInternetAvailable((Context)this.getApplicationContext())) {
            String errorMessage = this.getResources().getString(R.string.internet_connection_not_available);
            this.showErrorMessageView(errorMessage);
        }
    }

    protected void onPause() {
        super.onPause();
    }

    protected void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putSerializable(CONTACT, (Serializable)this.contact);
        savedInstanceState.putSerializable(CHANNEL, (Serializable)this.channel);
        savedInstanceState.putSerializable(CONVERSATION_ID, (Serializable)this.currentConversationId);
        if (capturedImageUri != null) {
            savedInstanceState.putString(CAPTURED_IMAGE_URI, capturedImageUri.toString());
        }
        if (this.videoFileUri != null) {
            savedInstanceState.putString(CAPTURED_VIDEO_URI, this.videoFileUri.toString());
        }
        if (this.mediaFile != null) {
            savedInstanceState.putSerializable(LOAD_FILE, (Serializable)this.mediaFile);
        }
        super.onSaveInstanceState(savedInstanceState);
    }

    public boolean onSupportNavigateUp() {
        if (this.isFromSearch()) {
            return true;
        }
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
            if (this.getSupportFragmentManager().getBackStackEntryCount() == 1) {
                Intent upIntent = NavUtils.getParentActivityIntent((Activity)this);
                if (upIntent != null && this.isTaskRoot()) {
                    TaskStackBuilder.create((Context)this).addNextIntentWithParentStack(upIntent).startActivities();
                }
                this.finish();
                return true;
            }
            Boolean takeOrder = this.getIntent().getBooleanExtra(TAKE_ORDER, false);
            if (takeOrder.booleanValue() && this.getSupportFragmentManager().getBackStackEntryCount() == 2) {
                Intent upIntent = NavUtils.getParentActivityIntent((Activity)this);
                if (upIntent != null && this.isTaskRoot()) {
                    TaskStackBuilder.create((Context)this).addNextIntentWithParentStack(upIntent).startActivities();
                }
                this.finish();
                return true;
            }
            this.getSupportFragmentManager().popBackStack();
            Utils.toggleSoftKeyBoard((Activity)this, (boolean)true);
            return true;
        }
        super.onSupportNavigateUp();
        return false;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String jsonString = FileUtils.loadSettingsJsonFile((Context)this.getApplicationContext());
        this.alCustomizationSettings = !TextUtils.isEmpty((CharSequence)jsonString) ? (AlCustomizationSettings)((Object)GsonUtils.getObjectFromJson((String)jsonString, AlCustomizationSettings.class)) : new AlCustomizationSettings();
        if (!TextUtils.isEmpty((CharSequence)this.alCustomizationSettings.getChatBackgroundImageName())) {
            this.resourceId = this.getResources().getIdentifier(this.alCustomizationSettings.getChatBackgroundImageName(), "drawable", this.getPackageName());
        }
        if (this.resourceId != 0) {
            this.getWindow().setBackgroundDrawableResource(this.resourceId);
        }
        this.setContentView(R.layout.quickconversion_activity);
        Toolbar myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.conversationContactPhoto = (ImageView)myToolbar.findViewById(R.id.conversation_contact_photo);
        this.toolbarTitle = (TextView)myToolbar.findViewById(R.id.toolbar_title);
        this.toolbarSubtitle = (TextView)myToolbar.findViewById(R.id.toolbar_subtitle);
        this.setSupportActionBar(myToolbar);
        this.baseContactService = new AppContactService((Context)this);
        this.conversationUIService = new ConversationUIService((FragmentActivity)this);
        this.mobiComMessageService = new MobiComMessageService((Context)this, MessageIntentService.class);
        this.quickConversationFragment = new MobiComQuickConversationFragment();
        this.connectivityReceiver = new ConnectivityReceiver();
        this.geoApiKey = Utils.getMetaDataValue((Context)this.getApplicationContext(), (String)GOOGLE_API_KEY_META_DATA);
        this.activityToOpenOnClickOfCallButton = Utils.getMetaDataValue((Context)this.getApplicationContext(), (String)ACTIVITY_TO_OPEN_ONCLICK_OF_CALL_BUTTON_META_DATA);
        this.layout = (LinearLayout)this.findViewById(R.id.footerAd);
        this.applozicPermission = new ApplozicPermissions((Activity)this, this.layout);
        this.childFragmentLayout = (RelativeLayout)this.findViewById(R.id.layout_child_activity);
        this.profilefragment = new ProfileFragment();
        this.profilefragment.setAlCustomizationSettings(this.alCustomizationSettings);
        this.contactsGroupId = MobiComUserPreference.getInstance((Context)this).getContactsGroupId();
        this.serviceDisconnectionLayout = (LinearLayout)this.findViewById(R.id.serviceDisconnectionLayout);
        if (Utils.hasMarshmallow() && !this.alCustomizationSettings.isGlobalStoagePermissionDisabled()) {
            this.applozicPermission.checkRuntimePermissionForStorage();
        }
        this.mActionBar = this.getSupportActionBar();
        if (!TextUtils.isEmpty((CharSequence)this.alCustomizationSettings.getThemeColorPrimary()) && !TextUtils.isEmpty((CharSequence)this.alCustomizationSettings.getThemeColorPrimaryDark())) {
            this.mActionBar.setBackgroundDrawable((Drawable)new ColorDrawable(Color.parseColor((String)this.alCustomizationSettings.getThemeColorPrimary())));
            if (Build.VERSION.SDK_INT >= 21) {
                this.getWindow().setStatusBarColor(Color.parseColor((String)this.alCustomizationSettings.getThemeColorPrimaryDark()));
            }
        }
        inviteMessage = Utils.getMetaDataValue((Context)this.getApplicationContext(), (String)SHARE_TEXT);
        retry = 0;
        if (this.getIntent() != null) {
            this.parentClientGroupKey = this.getIntent().getStringExtra("parentClientGroupId");
            this.parentGroupKey = !TextUtils.isEmpty((CharSequence)this.parentClientGroupKey) ? ChannelService.getInstance((Context)this).getParentGroupKeyByClientGroupKey(this.parentClientGroupKey) : Integer.valueOf(this.getIntent().getIntExtra("parentGroupKey", 0));
            if (this.parentGroupKey != null && this.parentGroupKey != 0) {
                BroadcastService.parentGroupKey = this.parentGroupKey;
                MobiComUserPreference.getInstance((Context)this).setParentGroupKey(this.parentGroupKey);
            }
        }
        if (ApplozicClient.getInstance((Context)this).isServiceDisconnected()) {
            this.serviceDisconnectionLayout.setVisibility(0);
        } else if (savedInstanceState != null) {
            capturedImageUri = savedInstanceState.getString(CAPTURED_IMAGE_URI) != null ? Uri.parse((String)savedInstanceState.getString(CAPTURED_IMAGE_URI)) : null;
            this.videoFileUri = savedInstanceState.getString(CAPTURED_VIDEO_URI) != null ? Uri.parse((String)savedInstanceState.getString(CAPTURED_VIDEO_URI)) : null;
            this.mediaFile = savedInstanceState.getSerializable(LOAD_FILE) != null ? (File)savedInstanceState.getSerializable(LOAD_FILE) : null;
            this.contact = (Contact)savedInstanceState.getSerializable(CONTACT);
            this.channel = (Channel)savedInstanceState.getSerializable(CHANNEL);
            this.currentConversationId = savedInstanceState.getInt(CONVERSATION_ID);
            if (this.contact != null || this.channel != null) {
                this.conversation = this.channel != null ? ConversationFragment.newInstance(null, this.channel, this.currentConversationId, null) : ConversationFragment.newInstance(this.contact, null, this.currentConversationId, null);
                ConversationActivity.addFragment((FragmentActivity)this, this.conversation, "ConversationFragment");
            }
        } else {
            this.setSearchListFragment(this.quickConversationFragment);
            ConversationActivity.addFragment((FragmentActivity)this, this.quickConversationFragment, "QuickConversationFragment");
        }
        this.mobiComKitBroadcastReceiver = new MobiComKitBroadcastReceiver((FragmentActivity)this);
        InstructionUtil.showInfo((Context)this, R.string.info_message_sync, BroadcastService.INTENT_ACTIONS.INSTRUCTION.toString());
        this.setToolbarTitle(this.getString(R.string.conversations));
        this.mActionBar.setDisplayHomeAsUpEnabled(true);
        this.mActionBar.setHomeButtonEnabled(true);
        this.googleApiClient = new GoogleApiClient.Builder(this.getApplicationContext()).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        this.onNewIntent(this.getIntent());
        Boolean takeOrder = this.getIntent().getBooleanExtra(TAKE_ORDER, false);
        if (!takeOrder.booleanValue()) {
            Intent lastSeenStatusIntent = new Intent((Context)this, UserIntentService.class);
            lastSeenStatusIntent.putExtra("USER_LAST_SEEN_AT_STATUS", true);
            UserIntentService.enqueueWork((Context)this, (Intent)lastSeenStatusIntent);
        }
        if (ApplozicClient.getInstance((Context)this).isAccountClosed() || ApplozicClient.getInstance((Context)this).isNotAllowed()) {
            this.accountStatusAsyncTask = new SyncAccountStatusAsyncTask((Context)this, this.layout, this.snackbar);
            this.accountStatusAsyncTask.execute(new Void[0]);
        }
        this.registerReceiver((BroadcastReceiver)this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        if (this.getIntent() != null) {
            HashSet userIdLists = new HashSet();
            if (this.getIntent().getStringArrayListExtra("groupIdNameContacts") != null) {
                MobiComUserPreference.getInstance((Context)this).setIsContactGroupNameList(true);
                userIdLists.addAll(this.getIntent().getStringArrayListExtra("groupIdNameContacts"));
            } else if (this.getIntent().getStringArrayListExtra("groupIdListContacts") != null) {
                MobiComUserPreference.getInstance((Context)this).setIsContactGroupNameList(false);
                userIdLists.addAll(this.getIntent().getStringArrayListExtra("groupIdListContacts"));
            }
            if (!userIdLists.isEmpty()) {
                MobiComUserPreference.getInstance((Context)this).setContactGroupIdList(userIdLists);
            }
        }
        LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.mobiComKitBroadcastReceiver, BroadcastService.getIntentFilter());
        if (Applozic.getInstance((Context)this).isDeviceContactSync()) {
            this.observer = new ContactsChangeObserver(null, (Context)this);
            this.getApplicationContext().getContentResolver().registerContentObserver(ContactsContract.Contacts.CONTENT_URI, true, (ContentObserver)this.observer);
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (!MobiComUserPreference.getInstance((Context)this).isLoggedIn()) {
            Utils.printLog((Context)this, (String)"AL", (String)"user is not logged in yet.");
            return;
        }
        try {
            if (ApplozicClient.getInstance((Context)this).isServiceDisconnected()) {
                this.serviceDisconnectionLayout.setVisibility(0);
            } else if (intent.getExtras() != null) {
                BroadcastService.setContextBasedChat((boolean)intent.getExtras().getBoolean("contextBasedChat"));
                if (BroadcastService.isIndividual() && intent.getExtras().getBoolean("QUICK_LIST")) {
                    this.setSearchListFragment(this.quickConversationFragment);
                    ConversationActivity.addFragment((FragmentActivity)this, this.quickConversationFragment, "QuickConversationFragment");
                } else {
                    this.conversationUIService.checkForStartNewConversation(intent);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setToolbarTitle(String title) {
        this.toolbarSubtitle.setVisibility(8);
        this.conversationContactPhoto.setVisibility(8);
        this.toolbarTitle.setText((CharSequence)title);
        ObjectAnimator animation = ObjectAnimator.ofFloat((Object)this.toolbarTitle, (String)"translationX", (float[])new float[]{0.0f});
        animation.setDuration(0L);
        animation.start();
    }

    @Override
    public void setToolbarSubtitle(String subtitle) {
        this.toolbarSubtitle.setVisibility(0);
        this.toolbarSubtitle.setText((CharSequence)subtitle);
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        ObjectAnimator translationX = ObjectAnimator.ofFloat((Object)this.toolbarTitle, (String)"x", (float[])new float[]{metrics.widthPixels / 3 - this.toolbarTitle.getWidth() / 2});
        translationX.setDuration(500L);
        translationX.start();
        ObjectAnimator animationSub = ObjectAnimator.ofFloat((Object)this.toolbarSubtitle, (String)"translationX", (float[])new float[]{-20.0f});
        animationSub.setDuration(0L);
        animationSub.start();
    }

    @Override
    public void setToolbarImage(Contact contact, Channel channel) {
        if (ApplozicSetting.getInstance((Context)this).isShowImageOnToolbar() || this.alCustomizationSettings.isShowImageOnToolbar()) {
            this.conversationContactPhoto.setVisibility(0);
            if (contact != null) {
                Glide.with((FragmentActivity)this).load(contact.getImageURL()).apply(new RequestOptions().placeholder(R.drawable.applozic_ic_contact_picture_holo_light)).into(this.conversationContactPhoto);
            } else if (channel != null) {
                Glide.with((FragmentActivity)this).load(channel.getImageUrl()).apply(new RequestOptions().placeholder(R.drawable.applozic_group_icon)).into(this.conversationContactPhoto);
            } else {
                this.conversationContactPhoto.setImageResource(R.drawable.applozic_ic_contact_picture_holo_light);
            }
        }
    }

    private void showActionBar() {
        this.mActionBar.setDisplayShowTitleEnabled(true);
    }

    @SuppressLint(value={"NewApi"})
    public boolean onCreateOptionsMenu(Menu menu2) {
        this.showActionBar();
        this.getMenuInflater().inflate(R.menu.mobicom_basic_menu_for_normal_message, menu2);
        MenuItem searchItem = menu2.findItem(R.id.menu_search);
        this.searchView = (SearchView)MenuItemCompat.getActionView((MenuItem)searchItem);
        this.searchView.setQueryHint((CharSequence)this.getResources().getString(R.string.search_hint));
        if (Utils.hasICS()) {
            searchItem.collapseActionView();
        }
        this.searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        this.searchView.setSubmitButtonEnabled(true);
        this.searchView.setIconifiedByDefault(true);
        if (this.quickConversationFragment != null && !TextUtils.isEmpty((CharSequence)this.quickConversationFragment.getSearchString())) {
            this.searchView.setIconified(false);
            this.searchView.setQuery((CharSequence)this.quickConversationFragment.getSearchString(), false);
        }
        return super.onCreateOptionsMenu(menu2);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        try {
            this.conversationUIService.onActivityResult(requestCode, resultCode, data);
            this.handleOnActivityResult(requestCode, data);
            if (requestCode == 203) {
                CropImage.ActivityResult result = CropImage.getActivityResult((Intent)data);
                if (resultCode == -1) {
                    if (data == null) {
                        return;
                    }
                    if (this.imageUri != null) {
                        this.imageUri = result.getUri();
                        if (this.imageUri != null && this.profilefragment != null) {
                            this.profilefragment.handleProfileimageUpload(true, this.imageUri, this.profilePhotoFile);
                        }
                    } else {
                        this.imageUri = result.getUri();
                        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                        String imageFileName = "JPEG_" + timeStamp + "_.jpeg";
                        this.profilePhotoFile = FileClientService.getFilePath((String)imageFileName, (Context)this, (String)"image/jpeg");
                        if (this.imageUri != null && this.profilefragment != null) {
                            this.profilefragment.handleProfileimageUpload(true, this.imageUri, this.profilePhotoFile);
                        }
                    }
                } else if (resultCode == 204) {
                    Utils.printLog((Context)this, (String)ConversationActivity.class.getName(), (String)("Cropping failed:" + result.getError()));
                }
            }
            if (requestCode == 1001) {
                if (((LocationManager)this.getSystemService("location")).isProviderEnabled("gps")) {
                    this.googleApiClient.connect();
                } else {
                    Toast.makeText((Context)this, (int)R.string.unable_to_fetch_location, (int)1).show();
                }
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleOnActivityResult(int requestCode, Intent intent) {
        switch (requestCode) {
            case 101: {
                Uri selectedFileUri = intent == null ? null : intent.getData();
                this.imageUri = null;
                this.beginCrop(selectedFileUri);
                break;
            }
            case 102: {
                this.beginCrop(this.imageUri);
            }
        }
    }

    void beginCrop(Uri imageUri) {
        try {
            CropImage.activity((Uri)imageUri).setGuidelines(CropImageView.Guidelines.OFF).setMultiTouchEnabled(true).start((Activity)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 0) {
            if (this.alStoragePermission != null) {
                this.alStoragePermission.onAction(PermissionsUtils.verifyPermissions((int[])grantResults));
            }
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                this.showSnackBar(R.string.storage_permission_granted);
                if (this.isAttachment) {
                    this.isAttachment = false;
                    this.processAttachment();
                }
            } else {
                this.showSnackBar(R.string.storage_permission_not_granted);
            }
        } else if (requestCode == 1) {
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                this.showSnackBar(R.string.location_permission_granted);
                this.processingLocation();
            } else {
                this.showSnackBar(R.string.location_permission_not_granted);
            }
        } else if (requestCode == 2) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.showSnackBar(R.string.phone_state_permission_granted);
            } else {
                this.showSnackBar(R.string.phone_state_permission_not_granted);
            }
        } else if (requestCode == 4) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.showSnackBar(R.string.phone_call_permission_granted);
                this.processCall(this.contact, this.currentConversationId);
            } else {
                this.showSnackBar(R.string.phone_call_permission_not_granted);
            }
        } else if (requestCode == 3) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.showSnackBar(R.string.record_audio_permission_granted);
                this.showAudioRecordingDialog();
            } else {
                this.showSnackBar(R.string.record_audio_permission_not_granted);
            }
        } else if (requestCode == 5) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.showSnackBar(R.string.phone_camera_permission_granted);
                if (this.isTakePhoto) {
                    this.processCameraAction();
                } else {
                    this.processVideoRecording();
                }
            } else {
                this.showSnackBar(R.string.phone_camera_permission_not_granted);
            }
        } else if (requestCode == 6) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.showSnackBar(R.string.contact_permission_granted);
                this.processContact();
            } else {
                this.showSnackBar(R.string.contact_permission_not_granted);
            }
        } else if (requestCode == 7) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.showSnackBar(R.string.phone_camera_permission_granted);
                if (this.profilefragment != null) {
                    this.profilefragment.processPhotoOption();
                }
            } else {
                this.showSnackBar(R.string.phone_camera_permission_not_granted);
            }
        } else if (requestCode == 8) {
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                this.showSnackBar(R.string.storage_permission_granted);
                if (this.profilefragment != null) {
                    this.profilefragment.processPhotoOption();
                }
            } else {
                this.showSnackBar(R.string.storage_permission_not_granted);
            }
        } else if (requestCode == 9) {
            if (PermissionsUtils.verifyPermissions((int[])grantResults)) {
                this.showSnackBar(R.string.phone_camera_and_audio_permission_granted);
            } else {
                this.showSnackBar(R.string.audio_or_camera_permission_not_granted);
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    public void processingLocation() {
        if (this.alCustomizationSettings.isLocationShareViaMap() && !TextUtils.isEmpty((CharSequence)this.geoApiKey) && !API_KYE_STRING.equals(this.geoApiKey)) {
            Intent toMapActivity = new Intent((Context)this, MobicomLocationActivity.class);
            this.startActivityForResult(toMapActivity, 10);
        } else if (!((LocationManager)this.getSystemService("location")).isProviderEnabled("gps")) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setTitle(R.string.location_services_disabled_title).setMessage(R.string.location_services_disabled_message).setCancelable(false).setPositiveButton(R.string.location_service_settings, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                    ConversationActivity.this.startActivityForResult(intent, 1001);
                }
            }).setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    dialog.cancel();
                    Toast.makeText((Context)ConversationActivity.this, (int)R.string.location_sending_cancelled, (int)1).show();
                }
            });
            AlertDialog alert = builder.create();
            alert.show();
        } else {
            this.googleApiClient.disconnect();
            this.googleApiClient.connect();
        }
    }

    public void processLocation() {
        if (Utils.hasMarshmallow()) {
            new ApplozicPermissions((Activity)this, this.layout).checkRuntimePermissionForLocation();
        } else {
            this.processingLocation();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.start_new) {
            if (!TextUtils.isEmpty((CharSequence)this.contactsGroupId)) {
                if (Utils.isInternetAvailable((Context)this)) {
                    this.conversationUIService.startContactActivityForResult();
                } else {
                    Intent intent = new Intent((Context)this, MobiComKitPeopleActivity.class);
                    ChannelDatabaseService channelDatabaseService = ChannelDatabaseService.getInstance((Context)this);
                    String[] userIdArray = channelDatabaseService.getChannelMemberByName(this.contactsGroupId, null);
                    if (userIdArray != null) {
                        this.conversationUIService.startContactActivityForResult(intent, null, null, userIdArray);
                    }
                }
            } else {
                this.conversationUIService.startContactActivityForResult();
            }
        } else if (id2 == R.id.conversations) {
            Intent intent = new Intent((Context)this, ChannelCreateActivity.class);
            intent.putExtra(ChannelCreateActivity.GROUP_TYPE, Channel.GroupType.PUBLIC.getValue().intValue());
            this.startActivity(intent);
        } else if (id2 == R.id.broadcast) {
            Intent intent = new Intent((Context)this, ContactSelectionActivity.class);
            intent.putExtra("GROUP_TYPE", Channel.GroupType.BROADCAST.getValue().intValue());
            this.startActivity(intent);
        } else if (id2 == R.id.refresh) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.info_message_sync), (int)1).show();
            new SyncMessagesAsyncTask((Context)this).execute(new Boolean[0]);
        } else {
            if (id2 == R.id.shareOptions) {
                Intent intent = new Intent("android.intent.action.SEND");
                intent.setAction("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", inviteMessage);
                this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Share Via"));
                return super.onOptionsItemSelected(item);
            }
            if (id2 == R.id.applozicUserProfile) {
                this.profilefragment.setApplozicPermissions(this.applozicPermission);
                ConversationActivity.addFragment((FragmentActivity)this, this.profilefragment, "ProfileFragment");
            } else if (id2 == R.id.logout) {
                try {
                    Class<?> loginActivity;
                    if (!TextUtils.isEmpty((CharSequence)this.alCustomizationSettings.getLogoutPackage()) && (loginActivity = Class.forName(this.alCustomizationSettings.getLogoutPackage().trim())) != null) {
                        new UserClientService((Context)this).logout();
                        Toast.makeText((Context)this.getBaseContext(), (CharSequence)this.getString(R.string.user_logout_info), (int)0).show();
                        Intent intent = new Intent((Context)this, loginActivity);
                        intent.setFlags(0x30008000);
                        this.startActivity(intent);
                        this.finish();
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    @Override
    public void onQuickConversationFragmentItemClick(View view, Contact contact, Channel channel, Integer conversationId, String searchString) {
        this.conversation = ConversationFragment.newInstance(contact, channel, conversationId, searchString);
        ConversationActivity.addFragment((FragmentActivity)this, this.conversation, "ConversationFragment");
        this.channel = channel;
        this.contact = contact;
        this.currentConversationId = conversationId;
    }

    @Override
    public void startContactActivityForResult() {
        this.conversationUIService.startContactActivityForResult();
    }

    @Override
    public void addFragment(ConversationFragment conversationFragment) {
        ConversationActivity.addFragment((FragmentActivity)this, conversationFragment, "ConversationFragment");
        this.conversation = conversationFragment;
    }

    public void onBackPressed() {
        if (this.isFromSearch()) {
            return;
        }
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 1) {
            try {
                Intent upIntent = NavUtils.getParentActivityIntent((Activity)this);
                if (upIntent != null && this.isTaskRoot()) {
                    TaskStackBuilder.create((Context)this).addNextIntentWithParentStack(upIntent).startActivities();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.finish();
            return;
        }
        Boolean takeOrder = this.getIntent().getBooleanExtra(TAKE_ORDER, false);
        ConversationFragment conversationFragment = (ConversationFragment)this.getSupportFragmentManager().findFragmentByTag("ConversationFragment");
        if (conversationFragment != null && conversationFragment.isVisible() && conversationFragment.multimediaPopupGrid.getVisibility() == 0) {
            conversationFragment.hideMultimediaOptionGrid();
            return;
        }
        if (takeOrder.booleanValue() && this.getSupportFragmentManager().getBackStackEntryCount() == 2) {
            Intent upIntent = NavUtils.getParentActivityIntent((Activity)this);
            if (upIntent != null && this.isTaskRoot()) {
                TaskStackBuilder.create((Context)this).addNextIntentWithParentStack(upIntent).startActivities();
            }
            this.finish();
        } else if (this.getSupportFragmentManager().getBackStackEntryCount() > 1) {
            this.getSupportFragmentManager().popBackStack();
        } else {
            super.onBackPressed();
        }
    }

    public boolean isFromSearch() {
        if (!this.searchView.isIconified() && this.quickConversationFragment != null && this.quickConversationFragment.isVisible()) {
            this.quickConversationFragment.stopSearching();
            this.searchView.onActionViewCollapsed();
            return true;
        }
        return false;
    }

    @Override
    public void updateLatestMessage(Message message, String formattedContactNumber) {
        this.conversationUIService.updateLatestMessage(message, formattedContactNumber);
    }

    @Override
    public void removeConversation(Message message, String formattedContactNumber) {
        this.conversationUIService.removeConversation(message, formattedContactNumber);
    }

    public void onConnected(Bundle bundle) {
        try {
            Location mCurrentLocation = LocationServices.FusedLocationApi.getLastLocation(this.googleApiClient);
            if (mCurrentLocation == null) {
                Toast.makeText((Context)this, (int)R.string.waiting_for_current_location, (int)0).show();
                this.locationRequest = new LocationRequest();
                this.locationRequest.setPriority(100);
                this.locationRequest.setInterval(500L);
                this.locationRequest.setFastestInterval(1L);
                LocationServices.FusedLocationApi.requestLocationUpdates(this.googleApiClient, this.locationRequest, (LocationListener)this);
            }
            if (mCurrentLocation != null && this.conversation != null) {
                this.conversation.attachLocation(mCurrentLocation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onConnectionSuspended(int i) {
        Log.w((String)this.getClass().getSimpleName(), (String)"onConnectionSuspended() called.");
    }

    public void onLocationChanged(Location location) {
        try {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.googleApiClient, (LocationListener)this);
            if (this.conversation != null && location != null) {
                this.conversation.attachLocation(location);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            try {
                connectionResult.startResolutionForResult((Activity)this, 9000);
            }
            catch (IntentSender.SendIntentException e) {
                e.printStackTrace();
            }
        } else {
            this.showErrorDialog(connectionResult.getErrorCode());
        }
    }

    public void setChildFragmentLayoutBG() {
        this.childFragmentLayout.setBackgroundResource(R.color.conversation_list_all_background);
    }

    public void setChildFragmentLayoutBGToTransparent() {
        this.childFragmentLayout.setBackgroundResource(17170445);
    }

    void showErrorDialog(int code) {
        GooglePlayServicesUtil.getErrorDialog((int)code, (Activity)this, (int)9000).show();
    }

    public Contact getContact() {
        return this.contact;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Integer getConversationId() {
        return this.currentConversationId;
    }

    public void showSnackBar(int resId) {
        this.snackbar = Snackbar.make((View)this.layout, (int)resId, (int)-1);
        this.snackbar.show();
    }

    public Uri getVideoFileUri() {
        return this.videoFileUri;
    }

    public void setVideoFileUri(Uri videoFileUri) {
        this.videoFileUri = videoFileUri;
    }

    public void isTakePhoto(boolean takePhoto) {
        this.isTakePhoto = takePhoto;
    }

    public void isAttachment(boolean attachment) {
        this.isAttachment = attachment;
    }

    public File getFileObject() {
        return this.mediaFile;
    }

    public void showAudioRecordingDialog() {
        if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfPermissionForAudioRecording((Activity)this)) {
            new ApplozicPermissions((Activity)this, this.layout).requestAudio();
        } else if (PermissionsUtils.isAudioRecordingPermissionGranted((Context)this)) {
            FragmentManager supportFragmentManager = this.getSupportFragmentManager();
            AudioMessageFragment fragment = AudioMessageFragment.newInstance();
            FragmentTransaction fragmentTransaction = supportFragmentManager.beginTransaction().add((Fragment)fragment, "AudioMessageFragment");
            fragmentTransaction.addToBackStack(null);
            fragmentTransaction.commitAllowingStateLoss();
        } else if (this.alCustomizationSettings.getAudioPermissionNotFoundMsg() == null) {
            this.showSnackBar(R.string.applozic_audio_permission_missing);
        } else {
            this.snackbar = Snackbar.make((View)this.layout, (CharSequence)this.alCustomizationSettings.getAudioPermissionNotFoundMsg(), (int)-1);
            this.snackbar.show();
        }
    }

    public void processVideoCall(Contact contactObj, Integer conversationId) {
        this.contact = this.baseContactService.getContactById(contactObj.getContactIds());
        if (ApplozicClient.getInstance((Context)this.getApplicationContext()).isIPCallEnabled()) {
            try {
                if (Utils.hasMarshmallow() && !PermissionsUtils.checkPermissionForCameraAndMicrophone((Context)this)) {
                    this.applozicPermission.checkRuntimePermissionForCameraAndAudioRecording();
                    return;
                }
                String activityName = ApplozicSetting.getInstance((Context)this).getActivityCallback(ApplozicSetting.RequestCode.VIDEO_CALL);
                Class<?> activityToOpen = Class.forName(activityName);
                Intent intent = new Intent((Context)this, activityToOpen);
                intent.putExtra("CONTACT_ID", this.contact.getUserId());
                this.startActivity(intent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void processCall(Contact contactObj, Integer conversationId) {
        this.contact = this.baseContactService.getContactById(contactObj.getContactIds());
        this.currentConversationId = conversationId;
        try {
            if (ApplozicClient.getInstance((Context)this.getApplicationContext()).isIPCallEnabled()) {
                if (Utils.hasMarshmallow() && !PermissionsUtils.checkPermissionForCameraAndMicrophone((Context)this)) {
                    this.applozicPermission.checkRuntimePermissionForCameraAndAudioRecording();
                    return;
                }
                String activityName = ApplozicSetting.getInstance((Context)this).getActivityCallback(ApplozicSetting.RequestCode.AUDIO_CALL);
                Class<?> activityToOpen = Class.forName(activityName);
                Intent intent = new Intent((Context)this, activityToOpen);
                intent.putExtra("CONTACT_ID", this.contact.getUserId());
                this.startActivity(intent);
                return;
            }
            if (this.activityToOpenOnClickOfCallButton != null) {
                Intent callIntent = new Intent((Context)this, Class.forName(this.activityToOpenOnClickOfCallButton));
                if (this.currentConversationId != null) {
                    Conversation conversation = ConversationService.getInstance((Context)this).getConversationByConversationId(this.currentConversationId);
                    callIntent.putExtra("TOPIC_ID", conversation.getTopicId());
                }
                callIntent.putExtra("CONTACT", (Serializable)this.contact);
                this.startActivity(callIntent);
            } else if (this.alCustomizationSettings.isShowActionDialWithOutCalling()) {
                if (!TextUtils.isEmpty((CharSequence)this.contact.getContactNumber())) {
                    String uri = "tel:" + this.contact.getContactNumber().trim();
                    Intent callIntent = new Intent("android.intent.action.DIAL");
                    callIntent.setData(Uri.parse((String)uri));
                    this.startActivity(callIntent);
                }
            } else if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForCallPermission((Activity)this)) {
                this.applozicPermission.requestCallPermission();
            } else if (PermissionsUtils.isCallPermissionGranted((Context)this)) {
                if (!TextUtils.isEmpty((CharSequence)this.contact.getContactNumber())) {
                    String uri = "tel:" + this.contact.getContactNumber().trim();
                    Intent callIntent = new Intent("android.intent.action.CALL");
                    callIntent.setData(Uri.parse((String)uri));
                    this.startActivity(callIntent);
                }
            } else {
                this.snackbar = Snackbar.make((View)this.layout, (int)R.string.phone_call_permission_not_granted, (int)-1);
                this.snackbar.show();
            }
        }
        catch (Exception e) {
            Utils.printLog((Context)this, (String)"ConversationActivity", (String)"Call permission is not added in androidManifest");
        }
    }

    public void processCameraAction() {
        try {
            if (PermissionsUtils.isCameraPermissionGranted((Context)this)) {
                this.imageCapture();
            } else if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForCameraPermission((Activity)this)) {
                this.applozicPermission.requestCameraPermission();
            } else {
                this.imageCapture();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processVideoRecording() {
        try {
            if (PermissionsUtils.isCameraPermissionGranted((Context)this)) {
                this.showVideoCapture();
            } else if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForCameraPermission((Activity)this)) {
                this.applozicPermission.requestCameraPermission();
            } else {
                this.showVideoCapture();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processContact() {
        if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForContactPermission((Activity)this)) {
            this.applozicPermission.requestContactPermission();
        } else {
            Intent contactIntent = new Intent("android.intent.action.PICK", ContactsContract.Contacts.CONTENT_URI);
            contactIntent.setType("vnd.android.cursor.dir/contact");
            this.startActivityForResult(contactIntent, 15);
        }
    }

    public void imageCapture() {
        try {
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            String imageFileName = "JPEG_" + timeStamp + "_.jpeg";
            this.mediaFile = FileClientService.getFilePath((String)imageFileName, (Context)this.getApplicationContext(), (String)"image/jpeg");
            capturedImageUri = FileProvider.getUriForFile((Context)this, (String)(Utils.getMetaDataValue((Context)this, (String)"com.package.name") + ".provider"), (File)this.mediaFile);
            Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
            cameraIntent.putExtra("output", (Parcelable)capturedImageUri);
            if (Build.VERSION.SDK_INT >= 21) {
                cameraIntent.addFlags(2);
                cameraIntent.addFlags(1);
            } else if (Build.VERSION.SDK_INT >= 16) {
                ClipData clip = ClipData.newUri((ContentResolver)this.getContentResolver(), (CharSequence)"a Photo", (Uri)capturedImageUri);
                cameraIntent.setClipData(clip);
                cameraIntent.addFlags(2);
                cameraIntent.addFlags(1);
            } else {
                List resInfoList = this.getPackageManager().queryIntentActivities(cameraIntent, 65536);
                for (ResolveInfo resolveInfo : resInfoList) {
                    String packageName = resolveInfo.activityInfo.packageName;
                    this.grantUriPermission(packageName, capturedImageUri, 2);
                    this.grantUriPermission(packageName, capturedImageUri, 1);
                }
            }
            if (cameraIntent.resolveActivity(this.getApplicationContext().getPackageManager()) != null && this.mediaFile != null) {
                this.startActivityForResult(cameraIntent, 11);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processAttachment() {
        if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForStoragePermission((Activity)this)) {
            this.applozicPermission.requestStoragePermissions();
        } else {
            Intent intentPick = new Intent((Context)this, MobiComAttachmentSelectorActivity.class);
            this.startActivityForResult(intentPick, 16);
        }
    }

    public void showVideoCapture() {
        try {
            Intent videoIntent = new Intent("android.media.action.VIDEO_CAPTURE");
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            String imageFileName = "VID_" + timeStamp + "_.mp4";
            this.mediaFile = FileClientService.getFilePath((String)imageFileName, (Context)this.getApplicationContext(), (String)"video/mp4");
            this.videoFileUri = FileProvider.getUriForFile((Context)this, (String)(Utils.getMetaDataValue((Context)this, (String)"com.package.name") + ".provider"), (File)this.mediaFile);
            videoIntent.putExtra("output", (Parcelable)this.videoFileUri);
            if (Build.VERSION.SDK_INT >= 21) {
                videoIntent.addFlags(2);
                videoIntent.addFlags(1);
            } else if (Build.VERSION.SDK_INT >= 16) {
                ClipData clip = ClipData.newUri((ContentResolver)this.getContentResolver(), (CharSequence)"a Video", (Uri)this.videoFileUri);
                videoIntent.setClipData(clip);
                videoIntent.addFlags(2);
                videoIntent.addFlags(1);
            } else {
                List resInfoList = this.getPackageManager().queryIntentActivities(videoIntent, 65536);
                for (ResolveInfo resolveInfo : resInfoList) {
                    String packageName = resolveInfo.activityInfo.packageName;
                    this.grantUriPermission(packageName, this.videoFileUri, 2);
                    this.grantUriPermission(packageName, this.videoFileUri, 1);
                }
            }
            if (videoIntent.resolveActivity(this.getApplicationContext().getPackageManager()) != null && this.mediaFile != null) {
                videoIntent.putExtra("android.intent.extra.videoQuality", 0);
                this.startActivityForResult(videoIntent, 14);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Uri getCurrentImageUri() {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_.jpeg";
        this.profilePhotoFile = FileClientService.getFilePath((String)imageFileName, (Context)this.getApplicationContext(), (String)"image/jpeg");
        this.imageUri = FileProvider.getUriForFile((Context)this, (String)(Utils.getMetaDataValue((Context)this, (String)"com.package.name") + ".provider"), (File)this.profilePhotoFile);
        return this.imageUri;
    }

    public void processGalleryPhotoSelection() {
        if (Utils.hasMarshmallow() && PermissionsUtils.checkSelfForStoragePermission((Activity)this)) {
            this.applozicPermission.requestStoragePermissionsForProfilePhoto();
        } else {
            Intent getContentIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            this.startActivityForResult(getContentIntent, 101);
        }
    }

    public boolean onQueryTextSubmit(String query) {
        this.searchTerm = query;
        return false;
    }

    public boolean onQueryTextChange(String query) {
        this.searchTerm = query;
        if (this.getSearchListFragment() != null) {
            this.getSearchListFragment().onQueryTextChange(query);
        }
        return true;
    }

    public SearchListFragment getSearchListFragment() {
        return this.searchListFragment;
    }

    public void setSearchListFragment(SearchListFragment searchListFragment) {
        this.searchListFragment = searchListFragment;
    }

    protected void onDestroy() {
        super.onDestroy();
        try {
            if (this.mobiComKitBroadcastReceiver != null) {
                LocalBroadcastManager.getInstance((Context)this).unregisterReceiver((BroadcastReceiver)this.mobiComKitBroadcastReceiver);
            }
            if (this.connectivityReceiver != null) {
                this.unregisterReceiver((BroadcastReceiver)this.connectivityReceiver);
            }
            if (this.accountStatusAsyncTask != null) {
                this.accountStatusAsyncTask.cancel(true);
            }
            if (this.observer != null) {
                this.getApplicationContext().getContentResolver().unregisterContentObserver((ContentObserver)this.observer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onClickOnMessageReply(Message message) {
        if (message != null && this.conversation != null) {
            this.conversation.onClickOnMessageReply(message);
        }
    }

    @Override
    public boolean isPermissionGranted() {
        return !PermissionsUtils.checkSelfForStoragePermission((Activity)this);
    }

    @Override
    public void checkPermission(ALStoragePermission storagePermission) {
        PermissionsUtils.requestPermissions((Activity)this, (String[])PermissionsUtils.PERMISSIONS_STORAGE, (int)0);
        this.alStoragePermission = storagePermission;
    }

    public class SyncAccountStatusAsyncTask
    extends AsyncTask<Void, Void, Boolean> {
        Context context;
        RegisterUserClientService registerUserClientService;
        String loggedInUserId;
        ApplozicClient applozicClient;
        WeakReference<Snackbar> snackBarWeakReference;
        WeakReference<LinearLayout> linearLayoutWeakReference;

        public SyncAccountStatusAsyncTask(Context context, LinearLayout linearLayout, Snackbar snackbar) {
            this.context = context;
            this.registerUserClientService = new RegisterUserClientService(context);
            this.linearLayoutWeakReference = new WeakReference<LinearLayout>(linearLayout);
            this.snackBarWeakReference = new WeakReference<Snackbar>(snackbar);
            this.applozicClient = ApplozicClient.getInstance((Context)context);
            this.loggedInUserId = MobiComUserPreference.getInstance((Context)context).getUserId();
        }

        protected Boolean doInBackground(Void ... voids) {
            User applozicUser = new User();
            applozicUser.setUserId(this.loggedInUserId);
            try {
                this.registerUserClientService.updateRegisteredAccount(applozicUser);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }

        protected void onPostExecute(Boolean aBoolean) {
            super.onPostExecute((Object)aBoolean);
            if (this.applozicClient.isAccountClosed() || this.applozicClient.isNotAllowed()) {
                LinearLayout linearLayout = null;
                Snackbar snackbar = null;
                if (this.snackBarWeakReference != null) {
                    snackbar = (Snackbar)this.snackBarWeakReference.get();
                }
                if (this.linearLayoutWeakReference != null) {
                    linearLayout = (LinearLayout)this.linearLayoutWeakReference.get();
                }
                if (snackbar != null && linearLayout != null) {
                    snackbar = Snackbar.make((View)linearLayout, (int)(this.applozicClient.isAccountClosed() ? R.string.applozic_account_closed : R.string.applozic_free_version_not_allowed_on_release_build), (int)-2);
                    snackbar.show();
                }
            }
        }
    }

    private class SyncMessagesAsyncTask
    extends AsyncTask<Boolean, Void, Void> {
        MobiComMessageService messageService;

        public SyncMessagesAsyncTask(Context context) {
            this.messageService = new MobiComMessageService(context, MessageIntentService.class);
        }

        protected Void doInBackground(Boolean ... parms) {
            this.messageService.syncMessages();
            return null;
        }
    }
}

