/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.async;

import android.app.ProgressDialog;
import android.content.Context;
import android.os.AsyncTask;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.feed.ChannelFeed;
import com.applozic.mobicomkit.uiwidgets.R;

public class ApplozicGetMemberFromContactGroupTask
extends AsyncTask<Void, Void, String[]> {
    private final String contactGroupId;
    Context context;
    GroupMemberListener groupMemberListener;
    ProgressDialog dialog;
    private ChannelService channelService;
    private String groupType;

    public ApplozicGetMemberFromContactGroupTask(Context context, String contactGroupId, String groupType, GroupMemberListener groupMemberListener) {
        this.context = context;
        this.contactGroupId = contactGroupId;
        this.channelService = ChannelService.getInstance((Context)context);
        this.groupType = groupType;
        this.groupMemberListener = groupMemberListener;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.dialog = new ProgressDialog(this.context);
        this.dialog.setMessage((CharSequence)this.context.getResources().getString(R.string.processing_please_wait));
        this.dialog.show();
    }

    protected String[] doInBackground(Void[] params) {
        try {
            ChannelFeed channelFeed;
            if (this.contactGroupId != null && (channelFeed = this.channelService.getMembersFromContactGroup(this.contactGroupId, this.groupType)) != null && channelFeed.getContactGroupMembersId() != null) {
                String[] userIdArray = channelFeed.getContactGroupMembersId().toArray(new String[channelFeed.getContactGroupMembersId().size()]);
                for (int i = 0; i < userIdArray.length; ++i) {
                    if (!MobiComUserPreference.getInstance((Context)this.context).getUserId().equals(userIdArray[i])) continue;
                    userIdArray[i] = "";
                }
                return userIdArray;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    protected void onPostExecute(String[] userIdArray) {
        super.onPostExecute((Object)userIdArray);
        if (this.dialog.isShowing()) {
            this.dialog.dismiss();
        }
        if (userIdArray != null) {
            this.groupMemberListener.onSuccess(userIdArray, this.context);
        } else {
            this.groupMemberListener.onFailure(this.context.getString(R.string.error), this.context);
        }
    }

    public static interface GroupMemberListener {
        public void onSuccess(String[] var1, Context var2);

        public void onFailure(String var1, Context var2);
    }
}

