/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.schedule;

import android.app.Dialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import android.widget.TimePicker;
import androidx.fragment.app.DialogFragment;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.schedule.ScheduledTimeHolder;
import java.util.Calendar;

public class SelectTimeFragment
extends DialogFragment
implements DialogInterface.OnClickListener {
    final Calendar calendar = Calendar.getInstance();
    private View scheduledTimeView;
    private ScheduledTimeHolder scheduledTimeHolder;
    private String[] monthNames = new String[]{"Jan", "Feb", "Mar", "April", "May", "June", "July", "Aug", "Sept", "Oct", "Nov", "Dec"};
    public TimePickerDialog.OnTimeSetListener mTimeSetListener = new TimePickerDialog.OnTimeSetListener(){

        public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
            if (SelectTimeFragment.this.scheduledTimeHolder.getDate() == null) {
                int year = SelectTimeFragment.this.calendar.get(1);
                int monthOfYear = SelectTimeFragment.this.calendar.get(2);
                int dayOfMonth = SelectTimeFragment.this.calendar.get(5);
                SelectTimeFragment.this.scheduledTimeHolder.setDate(dayOfMonth + "-" + (monthOfYear + 1) + "-" + year);
                TextView selectedDate = (TextView)SelectTimeFragment.this.scheduledTimeView.findViewById(R.id.scheduledDate);
                selectedDate.setText((CharSequence)(dayOfMonth + "-" + SelectTimeFragment.this.monthNames[monthOfYear] + "-" + year));
            }
            TextView selectedTime = (TextView)SelectTimeFragment.this.scheduledTimeView.findViewById(R.id.scheduledTime);
            SelectTimeFragment.this.scheduledTimeHolder.setTime(hourOfDay + ":" + minute + ":00");
            selectedTime.setText((CharSequence)SelectTimeFragment.this.scheduledTimeHolder.getTime());
        }
    };

    public void setScheduledTimeView(View scheduledTimeView) {
        this.scheduledTimeView = scheduledTimeView;
    }

    public void setScheduledTimeHolder(ScheduledTimeHolder scheduledTimeHolder) {
        this.scheduledTimeHolder = scheduledTimeHolder;
    }

    public void onClick(DialogInterface dialog, int which) {
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        TimePickerDialog timePickerDialog = new TimePickerDialog((Context)this.getActivity(), this.mTimeSetListener, this.calendar.get(11), this.calendar.get(12), false);
        if (this.scheduledTimeHolder.getTimestamp() != null) {
            String scheduledTime = this.scheduledTimeHolder.getTime();
            String[] st = scheduledTime.split(":");
            timePickerDialog.updateTime(Integer.parseInt(st[0]), Integer.parseInt(st[1]));
        }
        return timePickerDialog;
    }
}

