/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.uikit;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import com.applozic.mobicomkit.Applozic;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;

public class AlMessageSenderView
extends LinearLayout {
    EditText messageEditText;
    ImageButton sendMessageButton;
    ImageButton audioRecordButton;
    ImageButton attachmentButton;
    ImageButton emoticonsButton;
    boolean typingStarted;
    private AlMessageViewEvents listener;

    public AlMessageSenderView(Context context) {
        this(context, null, 0);
    }

    public AlMessageSenderView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AlMessageSenderView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void createView(Contact contact, Channel channel, AlMessageViewEvents listener) {
        this.removeAllViews();
        this.listener = listener;
        LayoutInflater inflater = (LayoutInflater)this.getContext().getApplicationContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.al_message_sender_view, null);
        LinearLayout mainEditTextLayout = (LinearLayout)view.findViewById(R.id.main_edit_text_linear_layout);
        this.messageEditText = (EditText)mainEditTextLayout.findViewById(R.id.conversation_message);
        this.attachmentButton = (ImageButton)mainEditTextLayout.findViewById(R.id.attach_button);
        this.emoticonsButton = (ImageButton)mainEditTextLayout.findViewById(R.id.emoticons_btn);
        this.emoticonsButton.setVisibility(8);
        this.messageEditText.setHint((CharSequence)"Write a message...");
        FrameLayout actionButtonLayout = (FrameLayout)view.findViewById(R.id.actionButtonLayout);
        this.sendMessageButton = (ImageButton)actionButtonLayout.findViewById(R.id.conversation_send);
        this.audioRecordButton = (ImageButton)actionButtonLayout.findViewById(R.id.record_button);
        this.audioRecordButton.setVisibility(8);
        this.sendMessageButton.setVisibility(0);
        ((LinearLayout)view).removeAllViews();
        this.publishTypingStatus(this.messageEditText, contact, channel);
        this.attachListeners();
        this.addView((View)mainEditTextLayout);
        this.addView((View)actionButtonLayout);
    }

    public void attachListeners() {
        this.attachmentButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AlMessageSenderView.this.listener != null) {
                    AlMessageSenderView.this.listener.onAttachmentButtonClick();
                }
            }
        });
        this.sendMessageButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AlMessageSenderView.this.listener != null) {
                    AlMessageSenderView.this.listener.onSendButtonClicked(AlMessageSenderView.this.messageEditText);
                }
            }
        });
        this.audioRecordButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AlMessageSenderView.this.listener != null) {
                    AlMessageSenderView.this.listener.onRecordButtonClicked();
                }
            }
        });
    }

    public void publishTypingStatus(final EditText editText, final Contact contact, final Channel channel) {
        if (editText == null || contact == null && channel == null) {
            return;
        }
        editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                try {
                    if (!TextUtils.isEmpty((CharSequence)s.toString()) && s.toString().trim().length() > 0 && !AlMessageSenderView.this.typingStarted) {
                        AlMessageSenderView.this.typingStarted = true;
                        if (contact != null || channel != null && !Channel.GroupType.OPEN.getValue().equals(channel.getType())) {
                            Applozic.publishTypingStatus((Context)AlMessageSenderView.this.getContext(), (Channel)channel, (Contact)contact, (boolean)true);
                        }
                    } else if (s.toString().trim().length() == 0 && AlMessageSenderView.this.typingStarted) {
                        AlMessageSenderView.this.typingStarted = false;
                        if (contact != null || channel != null && !Channel.GroupType.OPEN.getValue().equals(channel.getType())) {
                            Applozic.publishTypingStatus((Context)AlMessageSenderView.this.getContext(), (Channel)channel, (Contact)contact, (boolean)false);
                        }
                    }
                    if (AlMessageSenderView.this.listener != null) {
                        AlMessageSenderView.this.listener.onTyping(editText, AlMessageSenderView.this.typingStarted);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (AlMessageSenderView.this.listener != null) {
                    AlMessageSenderView.this.listener.onFocus(editText, hasFocus);
                }
                if (hasFocus && AlMessageSenderView.this.typingStarted && (contact != null || channel != null && !Channel.GroupType.OPEN.getValue().equals(channel.getType()))) {
                    Applozic.publishTypingStatus((Context)AlMessageSenderView.this.getContext(), (Channel)channel, (Contact)contact, (boolean)AlMessageSenderView.this.typingStarted);
                }
            }
        });
        editText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AlMessageSenderView.this.listener != null) {
                    AlMessageSenderView.this.listener.onClick(editText);
                }
            }
        });
    }

    public static interface AlMessageViewEvents {
        public void onTyping(EditText var1, boolean var2);

        public void onFocus(EditText var1, boolean var2);

        public void onClick(EditText var1);

        public void onAttachmentButtonClick();

        public void onSendButtonClicked(EditText var1);

        public void onRecordButtonClicked();
    }
}

