/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.instruction;

import android.app.Activity;
import android.content.Context;
import android.support.design.widget.Snackbar;
import android.view.View;
import android.widget.LinearLayout;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicommons.commons.core.utils.PermissionsUtils;

public class ApplozicPermissions {
    private LinearLayout snackBarLayout;
    private Activity activity;

    public ApplozicPermissions(Activity activity, LinearLayout linearLayout) {
        this.activity = activity;
        this.snackBarLayout = linearLayout;
    }

    public ApplozicPermissions(Activity activity) {
        this(activity, null);
    }

    public void checkRuntimePermissionForStorage() {
        if (PermissionsUtils.checkSelfForStoragePermission((Activity)this.activity)) {
            this.requestStoragePermissions();
        }
    }

    public void requestStoragePermissions() {
        if (PermissionsUtils.shouldShowRequestForStoragePermission((Activity)this.activity)) {
            this.showSnackBar(R.string.storage_permission, PermissionsUtils.PERMISSIONS_STORAGE, 0);
        } else {
            PermissionsUtils.requestPermissions((Activity)this.activity, (String[])PermissionsUtils.PERMISSIONS_STORAGE, (int)0);
        }
    }

    public void requestAudio() {
        if (PermissionsUtils.shouldShowRequestForAudioPermission((Activity)this.activity)) {
            this.showSnackBar(R.string.record_audio, PermissionsUtils.PERMISSIONS_RECORD_AUDIO, 3);
        } else {
            PermissionsUtils.requestPermissions((Activity)this.activity, (String[])PermissionsUtils.PERMISSIONS_RECORD_AUDIO, (int)3);
        }
    }

    public void requestCameraPermission() {
        if (PermissionsUtils.shouldShowRequestForCameraPermission((Activity)this.activity)) {
            this.showSnackBar(R.string.phone_camera_permission, PermissionsUtils.PERMISSION_CAMERA, 5);
        } else {
            PermissionsUtils.requestPermissions((Activity)this.activity, (String[])PermissionsUtils.PERMISSION_CAMERA, (int)5);
        }
    }

    public void requestCameraPermissionForProfilePhoto() {
        if (PermissionsUtils.shouldShowRequestForCameraPermission((Activity)this.activity)) {
            this.showSnackBar(R.string.phone_camera_permission, PermissionsUtils.PERMISSION_CAMERA, 7);
        } else {
            PermissionsUtils.requestPermissions((Activity)this.activity, (String[])PermissionsUtils.PERMISSION_CAMERA, (int)7);
        }
    }

    public void requestStoragePermissionsForProfilePhoto() {
        if (PermissionsUtils.shouldShowRequestForStoragePermission((Activity)this.activity)) {
            this.showSnackBar(R.string.storage_permission, PermissionsUtils.PERMISSIONS_STORAGE, 8);
        } else {
            PermissionsUtils.requestPermissions((Activity)this.activity, (String[])PermissionsUtils.PERMISSIONS_STORAGE, (int)8);
        }
    }

    public void requestCameraAndRecordPermission() {
        if (PermissionsUtils.checkPermissionForCameraAndMicrophone((Context)this.activity)) {
            this.showSnackBar(!PermissionsUtils.checkPermissionForCameraAndMicrophone((Context)this.activity) ? R.string.camera_audio_permission : (!PermissionsUtils.isAudioRecordingPermissionGranted((Context)this.activity) ? R.string.record_audio : (!PermissionsUtils.isCameraPermissionGranted((Context)this.activity) ? R.string.phone_camera_permission : R.string.camera_audio_permission)), new String[]{"android.permission.CAMERA", "android.permission.RECORD_AUDIO"}, 9);
        } else {
            PermissionsUtils.requestPermissions((Activity)this.activity, (String[])new String[]{"android.permission.CAMERA", "android.permission.RECORD_AUDIO"}, (int)9);
        }
    }

    public void checkRuntimePermissionForCameraAndAudioRecording() {
        if (PermissionsUtils.checkPermissionForCameraAndMicrophone((Context)this.activity)) {
            this.requestCameraAndRecordPermission();
        }
    }

    public void showSnackBar(int resId, final String[] permissions, final int requestCode) {
        if (this.snackBarLayout != null) {
            Snackbar.make((View)this.snackBarLayout, (int)resId, (int)-2).setAction(R.string.ok_alert, new View.OnClickListener(){

                public void onClick(View view) {
                    PermissionsUtils.requestPermissions((Activity)ApplozicPermissions.this.activity, (String[])permissions, (int)requestCode);
                }
            }).show();
        }
    }
}

