/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.uikit;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;

public abstract class AlScrollListener
extends RecyclerView.OnScrollListener {
    private int mScrollThreshold = 40;
    private int scrolledDistance = 0;
    private static final int HIDE_THRESHOLD = 20;
    private int previousTotal = 0;
    private boolean loading = true;
    private int visibleThreshold = 2;
    private int firstVisibleItem;
    private int visibleItemCount;
    private int totalItemCount;
    private boolean infiniteScrollingEnabled = true;
    private boolean controlsVisible = true;

    public abstract void onScrollUp();

    public abstract void onScrollDown();

    public abstract void onLoadMore();

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        this.visibleItemCount = recyclerView.getChildCount();
        if (manager instanceof GridLayoutManager) {
            GridLayoutManager gridLayoutManager = (GridLayoutManager)manager;
            this.firstVisibleItem = gridLayoutManager.findFirstVisibleItemPosition();
            this.totalItemCount = gridLayoutManager.getItemCount();
        } else if (manager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)manager;
            this.firstVisibleItem = linearLayoutManager.findFirstVisibleItemPosition();
            this.totalItemCount = linearLayoutManager.getItemCount();
        }
        if (this.infiniteScrollingEnabled) {
            if (this.loading && this.totalItemCount > this.previousTotal) {
                this.loading = false;
                this.previousTotal = this.totalItemCount;
            }
            if (this.totalItemCount - this.visibleItemCount == 0) {
                return;
            }
            if (!this.loading && this.totalItemCount - this.visibleItemCount <= this.firstVisibleItem + this.visibleThreshold) {
                this.onLoadMore();
                this.loading = true;
            }
        }
        if (this.firstVisibleItem == 0) {
            if (!this.controlsVisible) {
                this.onScrollUp();
                this.controlsVisible = true;
            }
            return;
        }
        if (this.scrolledDistance > 20 && this.controlsVisible) {
            this.onScrollDown();
            this.controlsVisible = false;
            this.scrolledDistance = 0;
        } else if (this.scrolledDistance < -20 && !this.controlsVisible) {
            this.onScrollUp();
            this.controlsVisible = true;
            this.scrolledDistance = 0;
        }
        if (this.controlsVisible && dy > 0 || !this.controlsVisible && dy < 0) {
            this.scrolledDistance += dy;
        }
    }

    public void setScrollThreshold(int scrollThreshold) {
        this.mScrollThreshold = scrollThreshold;
    }

    public void stopInfiniteScrolling() {
        this.infiniteScrollingEnabled = false;
    }

    public void onDataCleared() {
        this.previousTotal = 0;
    }
}

