/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.ResultReceiver;
import android.support.design.widget.CollapsingToolbarLayout;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.widget.NestedScrollView;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.RegisteredUsersAsyncTask;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.broadcast.ConnectivityReceiver;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.feed.ChannelUsersFeed;
import com.applozic.mobicomkit.feed.ErrorResponseFeed;
import com.applozic.mobicomkit.feed.GroupInfoUpdate;
import com.applozic.mobicomkit.feed.RegisteredUsersApiResponse;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.alphanumbericcolor.AlphaNumberColorUtil;
import com.applozic.mobicomkit.uiwidgets.conversation.MobiComKitBroadcastReceiver;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ChannelNameActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ContactSelectionActivity;
import com.applozic.mobicomkit.uiwidgets.conversation.activity.ConversationActivity;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUserMapper;
import com.applozic.mobicommons.people.channel.ChannelUtils;
import com.applozic.mobicommons.people.contact.Contact;
import de.hdodenhof.circleimageview.CircleImageView;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ChannelInfoActivity
extends AppCompatActivity {
    public static final String GROUP_UPDTAE_INFO = "GROUP_UPDTAE_INFO";
    public static final String CHANNEL_UPDATE_RECEIVER = "CHANNEL_UPDATE_RECEIVER";
    public static final String CHANNEL_KEY = "CHANNEL_KEY";
    public static final String USERID = "USERID";
    public static final String CHANNEL_NAME = "CHANNEL_NAME";
    public static final int REQUEST_CODE_FOR_CONTACT = 1;
    public static final int REQUEST_CODE_FOR_CHANNEL_NEW_NAME = 2;
    private static final String TAG = "ChannelInfoActivity";
    private static final String SUCCESS = "success";
    protected ListView mainListView;
    protected ContactsAdapter contactsAdapter;
    CollapsingToolbarLayout collapsingToolbarLayout;
    boolean isUserPresent;
    Contact contact;
    BaseContactService baseContactService;
    MobiComKitBroadcastReceiver mobiComKitBroadcastReceiver;
    MobiComUserPreference userPreference;
    AlCustomizationSettings alCustomizationSettings;
    ConnectivityReceiver connectivityReceiver;
    private ActionBar mActionBar;
    private ImageLoader contactImageLoader;
    private ImageLoader channelImageLoader;
    public List<ChannelUserMapper> channelUserMapperList;
    public Channel channel;
    private ImageView channelImage;
    private TextView createdBy;
    private TextView groupParticipantsTexView;
    private Button exitChannelButton;
    private Button deleteChannelButton;
    private RelativeLayout channelDeleteRelativeLayout;
    private RelativeLayout channelExitRelativeLayout;
    private Integer channelKey;
    private RefreshBroadcast refreshBroadcast;
    private NestedScrollView nestedScrollView;
    private ResultReceiver channelUpdateReceiver;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.channel_info_layout);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        String jsonString = FileUtils.loadSettingsJsonFile((Context)this.getApplicationContext());
        this.alCustomizationSettings = !TextUtils.isEmpty((CharSequence)jsonString) ? (AlCustomizationSettings)((Object)GsonUtils.getObjectFromJson((String)jsonString, AlCustomizationSettings.class)) : new AlCustomizationSettings();
        this.refreshBroadcast = new RefreshBroadcast();
        this.baseContactService = new AppContactService(this.getApplicationContext());
        this.channelImage = (ImageView)this.findViewById(R.id.channelImage);
        this.userPreference = MobiComUserPreference.getInstance((Context)this);
        this.createdBy = (TextView)this.findViewById(R.id.created_by);
        this.groupParticipantsTexView = (TextView)this.findViewById(R.id.groupParticipantsTexView);
        this.exitChannelButton = (Button)this.findViewById(R.id.exit_channel);
        this.deleteChannelButton = (Button)this.findViewById(R.id.delete_channel_button);
        this.channelDeleteRelativeLayout = (RelativeLayout)this.findViewById(R.id.channel_delete_relativeLayout);
        this.channelExitRelativeLayout = (RelativeLayout)this.findViewById(R.id.channel_exit_relativeLayout);
        this.collapsingToolbarLayout = (CollapsingToolbarLayout)this.findViewById(R.id.toolbar_layout);
        this.nestedScrollView = (NestedScrollView)this.findViewById(R.id.nestedScrollView);
        this.collapsingToolbarLayout.setContentScrimColor(Color.parseColor((String)this.alCustomizationSettings.getCollapsingToolbarLayoutColor()));
        this.groupParticipantsTexView.setTextColor(Color.parseColor((String)this.alCustomizationSettings.getGroupParticipantsTextColor()));
        this.deleteChannelButton.setBackgroundColor(Color.parseColor((String)this.alCustomizationSettings.getGroupDeleteButtonBackgroundColor()));
        this.exitChannelButton.setBackgroundColor(Color.parseColor((String)this.alCustomizationSettings.getGroupExitButtonBackgroundColor()));
        this.mActionBar = this.getSupportActionBar();
        this.mActionBar.setDisplayHomeAsUpEnabled(true);
        this.mActionBar.setHomeButtonEnabled(true);
        this.mActionBar.setDisplayShowHomeEnabled(true);
        this.mainListView = (ListView)this.findViewById(R.id.mainList);
        this.mainListView.setLongClickable(true);
        this.mainListView.setSmoothScrollbarEnabled(true);
        if (Utils.hasLollipop()) {
            this.mainListView.setNestedScrollingEnabled(true);
        }
        this.nestedScrollView.post(new Runnable(){

            @Override
            public void run() {
                ChannelInfoActivity.this.nestedScrollView.scrollTo(ChannelInfoActivity.this.nestedScrollView.getLeft(), ChannelInfoActivity.this.groupParticipantsTexView.getTop());
            }
        });
        this.connectivityReceiver = new ConnectivityReceiver();
        this.mobiComKitBroadcastReceiver = new MobiComKitBroadcastReceiver((FragmentActivity)this);
        this.registerForContextMenu((View)this.mainListView);
        if (this.alCustomizationSettings.isHideGroupExitButton()) {
            this.channelExitRelativeLayout.setVisibility(8);
        }
        if (this.alCustomizationSettings.isHideGroupDeleteButton()) {
            this.channelDeleteRelativeLayout.setVisibility(8);
        }
        if (this.getIntent().getExtras() != null) {
            this.channelKey = this.getIntent().getIntExtra(CHANNEL_KEY, 0);
            this.channelUpdateReceiver = (ResultReceiver)this.getIntent().getParcelableExtra(CHANNEL_UPDATE_RECEIVER);
            this.channel = ChannelService.getInstance((Context)this).getChannelByChannelKey(this.channelKey);
            this.isUserPresent = ChannelService.getInstance((Context)this).processIsUserPresentInChannel(this.channelKey);
            if (this.channel != null) {
                String title = ChannelUtils.getChannelTitleName((Channel)this.channel, (String)this.userPreference.getUserId());
                if (!TextUtils.isEmpty((CharSequence)this.channel.getAdminKey())) {
                    this.contact = this.baseContactService.getContactById(this.channel.getAdminKey());
                    this.mActionBar.setTitle((CharSequence)title);
                    if (this.userPreference.getUserId().equals(this.contact.getUserId())) {
                        this.createdBy.setText((CharSequence)(this.getString(R.string.channel_created_by) + " " + this.getString(R.string.you_string)));
                    } else {
                        this.createdBy.setText((CharSequence)(this.getString(R.string.channel_created_by) + " " + this.contact.getDisplayName()));
                    }
                }
                if (!this.isUserPresent) {
                    this.channelExitRelativeLayout.setVisibility(8);
                    this.channelDeleteRelativeLayout.setVisibility(0);
                }
            }
        }
        if (this.channel != null && this.channel.getType() != null) {
            if (Channel.GroupType.BROADCAST.getValue().equals(this.channel.getType())) {
                this.deleteChannelButton.setText(R.string.broadcast_delete_button);
                this.exitChannelButton.setText(R.string.broadcast_exit_button);
                this.channelExitRelativeLayout.setVisibility(8);
                this.channelDeleteRelativeLayout.setVisibility(0);
            } else {
                this.deleteChannelButton.setText(R.string.channel_delete_group_button);
                this.exitChannelButton.setText(R.string.channel_exit_button);
            }
        }
        this.contactImageLoader = new ImageLoader(this.getApplicationContext(), this.getListPreferredItemHeight()){

            protected Bitmap processBitmap(Object data) {
                return ChannelInfoActivity.this.baseContactService.downloadContactImage(ChannelInfoActivity.this.getApplicationContext(), (Contact)data);
            }
        };
        this.contactImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_holo_light);
        this.contactImageLoader.addImageCache(this.getSupportFragmentManager(), 0.1f);
        this.contactImageLoader.setImageFadeIn(false);
        this.channelImageLoader = new ImageLoader(this.getApplicationContext(), this.getListPreferredItemHeight()){

            protected Bitmap processBitmap(Object data) {
                return ChannelInfoActivity.this.baseContactService.downloadGroupImage(ChannelInfoActivity.this.getApplicationContext(), (Channel)data);
            }
        };
        this.channelImageLoader.setLoadingImage(R.drawable.applozic_group_icon);
        this.channelImageLoader.addImageCache(this.getSupportFragmentManager(), 0.1f);
        this.channelImageLoader.setImageFadeIn(false);
        if (this.channelImage != null && !this.channel.isBroadcastMessage()) {
            this.channelImageLoader.loadImage((Object)this.channel, this.channelImage);
        } else {
            this.channelImage.setImageResource(R.drawable.applozic_ic_applozic_broadcast);
        }
        this.channelUserMapperList = ChannelService.getInstance((Context)this).getListOfUsersFromChannelUserMapper(this.channel.getKey());
        this.contactsAdapter = new ContactsAdapter((Context)this);
        this.mainListView.setAdapter((ListAdapter)this.contactsAdapter);
        Helper.getListViewSize(this.mainListView);
        this.mainListView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int scrollState) {
                if (scrollState == 2) {
                    ChannelInfoActivity.this.contactImageLoader.setPauseWork(true);
                } else {
                    ChannelInfoActivity.this.contactImageLoader.setPauseWork(false);
                }
            }

            public void onScroll(AbsListView absListView, int i, int i1, int i2) {
            }
        });
        this.exitChannelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelInfoActivity.this.leaveChannel(ChannelInfoActivity.this.channel);
            }
        });
        this.deleteChannelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelInfoActivity.this.deleteChannel(ChannelInfoActivity.this.channel);
            }
        });
        this.registerReceiver((BroadcastReceiver)this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    protected void onPause() {
        super.onPause();
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver((BroadcastReceiver)this.mobiComKitBroadcastReceiver);
        if (this.refreshBroadcast != null) {
            LocalBroadcastManager.getInstance((Context)this).unregisterReceiver((BroadcastReceiver)this.refreshBroadcast);
        }
        BroadcastService.currentInfoId = null;
        this.contactImageLoader.setPauseWork(false);
    }

    protected void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.mobiComKitBroadcastReceiver, BroadcastService.getIntentFilter());
        LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.refreshBroadcast, ChannelInfoActivity.getIntentFilter());
        if (this.channel != null) {
            BroadcastService.currentInfoId = String.valueOf(this.channel.getKey());
            Channel newChannel = ChannelService.getInstance((Context)this).getChannelByChannelKey(this.channel.getKey());
            if (newChannel != null && TextUtils.isEmpty((CharSequence)newChannel.getImageUrl())) {
                if (!this.channel.isBroadcastMessage()) {
                    this.channelImage.setImageResource(R.drawable.applozic_group_icon);
                } else {
                    this.channelImage.setImageResource(R.drawable.applozic_ic_applozic_broadcast);
                }
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (data != null) {
            if (requestCode == 1 && resultCode == -1) {
                boolean isUserAlreadyPresent = ChannelService.getInstance((Context)this).isUserAlreadyPresentInChannel(this.channel.getKey(), data.getExtras().getString(USERID));
                if (!isUserAlreadyPresent) {
                    this.addChannelUser(data.getExtras().getString(USERID), this.channel);
                } else {
                    Toast toast = Toast.makeText((Context)this, (CharSequence)this.getString(R.string.user_is_already_exists), (int)0);
                    toast.setGravity(17, 0, 0);
                    toast.show();
                }
            }
            if (requestCode == 2 && resultCode == -1) {
                GroupInfoUpdate groupInfoUpdate = (GroupInfoUpdate)GsonUtils.getObjectFromJson((String)data.getExtras().getString(GROUP_UPDTAE_INFO), GroupInfoUpdate.class);
                System.out.println("GroupInfoUpdate ::: " + data.getExtras().getString(GROUP_UPDTAE_INFO));
                if (this.channel.getName().equals(groupInfoUpdate.getNewName())) {
                    groupInfoUpdate.setNewName(null);
                }
                new ChannelAsync(groupInfoUpdate, (Context)this, this.channelUpdateReceiver).execute(new Void[0]);
            }
        }
    }

    public boolean onContextItemSelected(MenuItem item) {
        AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)item.getMenuInfo();
        int position = info.position;
        if (this.channelUserMapperList.size() <= position) {
            return true;
        }
        if (this.channel == null) {
            return true;
        }
        ChannelUserMapper channelUserMapper = this.channelUserMapperList.get(position);
        switch (item.getItemId()) {
            case 0: {
                Intent startConversationIntent = new Intent((Context)this, ConversationActivity.class);
                startConversationIntent.putExtra("userId", channelUserMapper.getUserKey());
                this.startActivity(startConversationIntent);
                this.finish();
                break;
            }
            case 1: {
                this.removeChannelUser(this.channel, channelUserMapper);
                break;
            }
            case 2: {
                if (Utils.isInternetAvailable((Context)this.getApplicationContext())) {
                    GroupInfoUpdate groupInfoUpdate = new GroupInfoUpdate(channelUserMapper.getKey());
                    ArrayList<ChannelUsersFeed> channelUsersFeedList = new ArrayList<ChannelUsersFeed>();
                    ChannelUsersFeed channelUsersFeed = new ChannelUsersFeed();
                    channelUsersFeed.setUserId(channelUserMapper.getUserKey());
                    channelUsersFeed.setRole(Integer.valueOf(1));
                    channelUsersFeedList.add(channelUsersFeed);
                    groupInfoUpdate.setUsers(channelUsersFeedList);
                    new ChannelUserRoleAsyncTask(channelUserMapper, groupInfoUpdate, (Context)this).execute(new Void[0]);
                    break;
                }
                Toast toast = Toast.makeText((Context)this, (CharSequence)this.getString(R.string.you_dont_have_any_network_access_info), (int)0);
                toast.setGravity(17, 0, 0);
                toast.show();
                break;
            }
            default: {
                return super.onContextItemSelected(item);
            }
        }
        return true;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.channel_menu_option, menu2);
        if (this.channel == null) {
            return true;
        }
        ChannelUserMapper loggedInUserMapper = ChannelService.getInstance((Context)this).getChannelUserMapperByUserId(this.channel.getKey(), MobiComUserPreference.getInstance((Context)this).getUserId());
        if (this.alCustomizationSettings.isHideGroupAddMembersButton() || loggedInUserMapper != null && ChannelUserMapper.UserRole.MEMBER.getValue().equals(loggedInUserMapper.getRole()) || !ChannelUtils.isAdminUserId((String)this.userPreference.getUserId(), (Channel)this.channel) && loggedInUserMapper != null && Integer.valueOf(0).equals(loggedInUserMapper.getRole())) {
            menu2.removeItem(R.id.add_member_to_channel);
        }
        if (this.alCustomizationSettings.isHideGroupNameUpdateButton() || this.channel.isBroadcastMessage()) {
            menu2.removeItem(R.id.edit_channel_name);
        }
        return true;
    }

    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)menuInfo;
        int positionInList = info.position;
        if (positionInList < 0 || this.channelUserMapperList.isEmpty()) {
            return;
        }
        ChannelUserMapper channelUserMapper = this.channelUserMapperList.get(positionInList);
        if (MobiComUserPreference.getInstance((Context)this).getUserId().equals(channelUserMapper.getUserKey())) {
            return;
        }
        boolean isHideRemove = this.alCustomizationSettings.isHideGroupRemoveMemberOption();
        ChannelUserMapper loggedInUserMapper = ChannelService.getInstance((Context)this).getChannelUserMapperByUserId(channelUserMapper.getKey(), MobiComUserPreference.getInstance((Context)this).getUserId());
        String[] menuItems = this.getResources().getStringArray(R.array.channel_users_menu_option);
        Contact contact = this.baseContactService.getContactById(channelUserMapper.getUserKey());
        for (int i = 0; i < menuItems.length; ++i) {
            if (menuItems[i].equals(this.getString(R.string.make_admin_text_info)) && loggedInUserMapper != null && ChannelUserMapper.UserRole.MEMBER.getValue().equals(loggedInUserMapper.getRole()) || menuItems[i].equals(this.getString(R.string.remove_member)) && (isHideRemove || !this.isUserPresent || !ChannelUtils.isAdminUserId((String)this.userPreference.getUserId(), (Channel)this.channel) && loggedInUserMapper != null && Integer.valueOf(0).equals(loggedInUserMapper.getRole()) || loggedInUserMapper != null && ChannelUserMapper.UserRole.MEMBER.getValue().equals(loggedInUserMapper.getRole())) || menuItems[i].equals(this.getString(R.string.make_admin_text_info)) && (!this.isUserPresent || ChannelUserMapper.UserRole.ADMIN.getValue().equals(channelUserMapper.getRole()) || this.channel != null && Channel.GroupType.BROADCAST.getValue().equals(this.channel.getType()))) continue;
            if (menuItems[i].equals(this.getString(R.string.make_admin_text_info))) {
                menu2.add(0, i, i, (CharSequence)menuItems[i]);
                continue;
            }
            menu2.add(0, i, i, (CharSequence)(menuItems[i] + " " + contact.getDisplayName()));
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        boolean isUserPresent = false;
        if (this.channel != null) {
            isUserPresent = ChannelService.getInstance((Context)this).processIsUserPresentInChannel(this.channel.getKey());
        }
        if (id2 == R.id.add_member_to_channel) {
            if (isUserPresent) {
                Utils.toggleSoftKeyBoard((Activity)this, (boolean)true);
                if (this.alCustomizationSettings.getTotalRegisteredUserToFetch() > 0 && (this.alCustomizationSettings.isRegisteredUserContactListCall() || ApplozicSetting.getInstance((Context)this).isRegisteredUsersContactCall()) && !this.userPreference.getWasContactListServerCallAlreadyDone()) {
                    this.processLoadRegisteredUsers();
                } else {
                    Intent addMemberIntent = new Intent((Context)this, ContactSelectionActivity.class);
                    addMemberIntent.putExtra("CHECK_BOX", true);
                    addMemberIntent.putExtra("CHANNEL", (Serializable)this.channel);
                    this.startActivityForResult(addMemberIntent, 1);
                }
            } else {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.channel_add_alert), (int)0).show();
            }
        } else if (id2 == R.id.edit_channel_name) {
            if (isUserPresent) {
                Intent editChannelNameIntent = new Intent((Context)this, ChannelNameActivity.class);
                GroupInfoUpdate groupInfoUpdate = new GroupInfoUpdate(this.channel);
                String groupJson = GsonUtils.getJsonFromObject((Object)groupInfoUpdate, GroupInfoUpdate.class);
                editChannelNameIntent.putExtra(GROUP_UPDTAE_INFO, groupJson);
                this.startActivityForResult(editChannelNameIntent, 2);
            } else {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.channel_edit_alert), (int)0).show();
            }
        }
        return false;
    }

    public void processLoadRegisteredUsers() {
        final ProgressDialog progressDialog = ProgressDialog.show((Context)this, (CharSequence)"", (CharSequence)this.getString(R.string.applozic_contacts_loading_info), (boolean)true);
        RegisteredUsersAsyncTask.TaskListener usersAsyncTaskTaskListener = new RegisteredUsersAsyncTask.TaskListener(){

            public void onSuccess(RegisteredUsersApiResponse registeredUsersApiResponse, String[] userIdArray) {
                if (progressDialog != null && progressDialog.isShowing()) {
                    progressDialog.dismiss();
                }
                ChannelInfoActivity.this.userPreference.setWasContactListServerCallAlreadyDone(Boolean.valueOf(true));
                Intent addMemberIntent = new Intent((Context)ChannelInfoActivity.this, ContactSelectionActivity.class);
                addMemberIntent.putExtra("CHECK_BOX", true);
                addMemberIntent.putExtra("CHANNEL", (Serializable)ChannelInfoActivity.this.channel);
                ChannelInfoActivity.this.startActivityForResult(addMemberIntent, 1);
            }

            public void onFailure(RegisteredUsersApiResponse registeredUsersApiResponse, String[] userIdArray, Exception exception) {
                if (progressDialog != null && progressDialog.isShowing()) {
                    progressDialog.dismiss();
                }
                String error = ChannelInfoActivity.this.getString(Utils.isInternetAvailable((Context)ChannelInfoActivity.this) ? R.string.applozic_server_error : R.string.you_need_network_access_for_block_or_unblock);
                Toast toast = Toast.makeText((Context)ChannelInfoActivity.this, (CharSequence)error, (int)1);
                toast.setGravity(17, 0, 0);
                toast.show();
            }

            public void onCompletion() {
            }
        };
        RegisteredUsersAsyncTask usersAsyncTask = new RegisteredUsersAsyncTask((Context)this, usersAsyncTaskTaskListener, this.alCustomizationSettings.getTotalRegisteredUserToFetch(), this.userPreference.getRegisteredUsersLastFetchTime(), null, null, true);
        usersAsyncTask.execute((Object[])new Void[]{null});
    }

    private int getListPreferredItemHeight() {
        TypedValue typedValue = new TypedValue();
        this.getTheme().resolveAttribute(16842829, typedValue, true);
        DisplayMetrics metrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return (int)typedValue.getDimension(metrics);
    }

    public void updateChannelList() {
        if (this.contactsAdapter != null && this.channel != null) {
            this.channelUserMapperList.clear();
            this.channelUserMapperList = ChannelService.getInstance((Context)this).getListOfUsersFromChannelUserMapper(this.channel.getKey());
            this.contactsAdapter.notifyDataSetChanged();
            Helper.getListViewSize(this.mainListView);
            String oldChannelName = this.channel.getName();
            this.channel = ChannelService.getInstance((Context)this).getChannelByChannelKey(this.channel.getKey());
            if (!oldChannelName.equals(this.channel.getName())) {
                this.mActionBar.setTitle((CharSequence)this.channel.getName());
                this.collapsingToolbarLayout.setTitle((CharSequence)this.channel.getName());
            }
        }
    }

    public void removeChannelUser(final Channel channel, final ChannelUserMapper channelUserMapper) {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this).setPositiveButton(R.string.remove_member, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                new ChannelMember(channelUserMapper, channel, (Context)ChannelInfoActivity.this).execute(new Void[0]);
            }
        });
        alertDialog.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        String name = "";
        String channelName = "";
        if (!TextUtils.isEmpty((CharSequence)channelUserMapper.getUserKey())) {
            Contact contact = this.baseContactService.getContactById(channelUserMapper.getUserKey());
            name = contact.getDisplayName();
            channelName = channel.getName();
        }
        alertDialog.setMessage((CharSequence)this.getString(R.string.dialog_remove_group_user).replace(this.getString(R.string.user_name_info), name).replace(this.getString(R.string.group_name_info), channelName));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    public void addChannelUser(final String userId, final Channel channel) {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this).setPositiveButton(R.string.add, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                new ChannelMemberAdd(channel, userId, (Context)ChannelInfoActivity.this).execute(new Void[0]);
            }
        });
        alertDialog.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        String name = "";
        String channelName = "";
        if (channel != null) {
            Contact contact = this.baseContactService.getContactById(userId);
            name = contact.getDisplayName();
            channelName = channel.getName();
        }
        alertDialog.setMessage((CharSequence)this.getString(R.string.dialog_add_group_user).replace(this.getString(R.string.user_name_info), name).replace(this.getString(R.string.group_name_info), channelName));
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    public void leaveChannel(final Channel channel) {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this).setPositiveButton(R.string.channel_exit, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                new ChannelAsync(channel, (Context)ChannelInfoActivity.this, ChannelInfoActivity.this.channelUpdateReceiver).execute(new Void[0]);
            }
        });
        alertDialog.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        if (channel.getType() != null) {
            alertDialog.setMessage((CharSequence)this.getString(R.string.leave_channel).replace(this.getString(R.string.groupType_info), Channel.GroupType.BROADCAST.getValue().equals(channel.getType()) ? this.getString(R.string.broadcast_string) : this.getString(R.string.group_string)));
        }
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    public void deleteChannel(final Channel channel) {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this).setPositiveButton(R.string.channel_deleting, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                new ChannelMemberAdd(channel, (Context)ChannelInfoActivity.this).execute(new Void[0]);
            }
        });
        alertDialog.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        });
        if (channel.getType() != null) {
            alertDialog.setMessage((CharSequence)this.getString(R.string.delete_channel_messages_and_channel_info).replace(this.getString(R.string.group_name_info), channel.getName()).replace(this.getString(R.string.groupType_info), Channel.GroupType.BROADCAST.getValue().equals(channel.getType()) ? this.getString(R.string.broadcast_string) : this.getString(R.string.group_string)));
        }
        alertDialog.setCancelable(true);
        alertDialog.create().show();
    }

    protected void onDestroy() {
        super.onDestroy();
        try {
            if (this.connectivityReceiver != null) {
                this.unregisterReceiver((BroadcastReceiver)this.connectivityReceiver);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static IntentFilter getIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(BroadcastService.INTENT_ACTIONS.UPDATE_GROUP_INFO.toString());
        intentFilter.addAction(BroadcastService.INTENT_ACTIONS.UPDATE_USER_DETAIL.toString());
        return intentFilter;
    }

    public class ChannelUserRoleAsyncTask
    extends AsyncTask<Void, Integer, Long> {
        private ChannelService channelService;
        private ProgressDialog progressDialog;
        private Context context;
        ChannelUserMapper channelUserMapper;
        String response;
        GroupInfoUpdate groupInfoUpdate;

        public ChannelUserRoleAsyncTask(ChannelUserMapper channelUserMapper, GroupInfoUpdate groupInfoUpdate, Context context) {
            this.channelUserMapper = channelUserMapper;
            this.context = context;
            this.groupInfoUpdate = groupInfoUpdate;
            this.channelService = ChannelService.getInstance((Context)context);
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)this.context.getString(R.string.please_wait_info), (boolean)true);
        }

        protected Long doInBackground(Void ... params) {
            if (this.groupInfoUpdate != null) {
                this.response = this.channelService.updateChannel(this.groupInfoUpdate);
                if (!TextUtils.isEmpty((CharSequence)this.response) && ChannelInfoActivity.SUCCESS.equals(this.response)) {
                    for (ChannelUsersFeed channelUsersFeed : this.groupInfoUpdate.getUsers()) {
                        this.channelUserMapper.setRole(channelUsersFeed.getRole());
                        this.channelService.updateRoleInChannelUserMapper(this.groupInfoUpdate.getGroupId(), this.channelUserMapper.getUserKey(), channelUsersFeed.getRole());
                    }
                }
            }
            return null;
        }

        protected void onPostExecute(Long aLong) {
            super.onPostExecute((Object)aLong);
            if (this.progressDialog != null && this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
            if (!TextUtils.isEmpty((CharSequence)this.response) && ChannelInfoActivity.SUCCESS.equals(this.response) && this.channelUserMapper != null && ChannelInfoActivity.this.channelUserMapperList != null) {
                try {
                    int index = ChannelInfoActivity.this.channelUserMapperList.indexOf(this.channelUserMapper);
                    ChannelInfoActivity.this.channelUserMapperList.remove(this.channelUserMapper);
                    ChannelInfoActivity.this.channelUserMapperList.add(index, this.channelUserMapper);
                    ChannelInfoActivity.this.contactsAdapter.notifyDataSetChanged();
                    Helper.getListViewSize(ChannelInfoActivity.this.mainListView);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public class RefreshBroadcast
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            ChannelInfoActivity.this.updateChannelList();
        }
    }

    public class ChannelAsync
    extends AsyncTask<Void, Integer, Long> {
        GroupInfoUpdate groupInfoUpdate;
        String responseForExit;
        String responseForChannelUpdate;
        private ChannelService channelService;
        private ProgressDialog progressDialog;
        private Context context;
        private Channel channel;
        private ResultReceiver channelUpdateReceiver;

        public ChannelAsync(Channel channel, Context context, ResultReceiver channelUpdateReceiver) {
            this.channel = channel;
            this.context = context;
            this.channelService = ChannelService.getInstance((Context)context);
            this.channelUpdateReceiver = channelUpdateReceiver;
        }

        public ChannelAsync(GroupInfoUpdate groupInfoUpdate, Context context, ResultReceiver channelUpdateReceiver) {
            this.groupInfoUpdate = groupInfoUpdate;
            this.context = context;
            this.channelService = ChannelService.getInstance((Context)context);
            this.channelUpdateReceiver = channelUpdateReceiver;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            if (this.groupInfoUpdate != null) {
                this.progressDialog = ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)this.context.getString(R.string.channel_update), (boolean)true);
            }
            if (this.channel != null) {
                this.progressDialog = ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)this.context.getString(R.string.channel_member_exit), (boolean)true);
            }
        }

        protected Long doInBackground(Void ... params) {
            if (this.groupInfoUpdate != null) {
                if (!TextUtils.isEmpty((CharSequence)this.groupInfoUpdate.getNewlocalPath())) {
                    try {
                        String response = new FileClientService(this.context).uploadProfileImage(this.groupInfoUpdate.getNewlocalPath());
                        this.groupInfoUpdate.setImageUrl(response);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.groupInfoUpdate.setImageUrl(null);
                }
                this.responseForChannelUpdate = this.channelService.updateChannel(this.groupInfoUpdate);
            }
            if (this.channel != null) {
                this.responseForExit = this.channelService.leaveMemberFromChannelProcess(this.channel.getKey(), ChannelInfoActivity.this.userPreference.getUserId());
            }
            return null;
        }

        protected void onPostExecute(Long aLong) {
            Toast toast;
            super.onPostExecute((Object)aLong);
            if (this.progressDialog != null && this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
            if (this.channel != null && !Utils.isInternetAvailable((Context)this.context)) {
                toast = Toast.makeText((Context)this.context, (CharSequence)ChannelInfoActivity.this.getString(R.string.failed_to_leave_group), (int)0);
                toast.setGravity(17, 0, 0);
                toast.show();
            }
            if (this.groupInfoUpdate != null && !Utils.isInternetAvailable((Context)this.context)) {
                toast = Toast.makeText((Context)this.context, (CharSequence)ChannelInfoActivity.this.getString(R.string.internet_connection_for_group_name_info), (int)0);
                toast.setGravity(17, 0, 0);
                toast.show();
            }
            if (!TextUtils.isEmpty((CharSequence)this.responseForExit) && ChannelInfoActivity.SUCCESS.equals(this.responseForExit)) {
                ChannelInfoActivity.this.finish();
            }
            if (!TextUtils.isEmpty((CharSequence)this.responseForChannelUpdate) && ChannelInfoActivity.SUCCESS.equals(this.responseForChannelUpdate)) {
                if (!TextUtils.isEmpty((CharSequence)this.groupInfoUpdate.getNewName())) {
                    ChannelInfoActivity.this.mActionBar.setTitle((CharSequence)this.groupInfoUpdate.getNewName());
                    ChannelInfoActivity.this.collapsingToolbarLayout.setTitle((CharSequence)this.groupInfoUpdate.getNewName());
                }
                if (!(TextUtils.isEmpty((CharSequence)this.groupInfoUpdate.getNewlocalPath()) || TextUtils.isEmpty((CharSequence)this.groupInfoUpdate.getImageUrl()) || TextUtils.isEmpty((CharSequence)this.groupInfoUpdate.getContentUri()))) {
                    File file = new File(this.groupInfoUpdate.getNewlocalPath());
                    this.channel = ChannelInfoActivity.this.channel;
                    if (!TextUtils.isEmpty((CharSequence)this.channel.getLocalImageUri())) {
                        file.renameTo(new File(this.channel.getLocalImageUri()));
                    } else {
                        file.renameTo(FileClientService.getFilePath((String)(this.channel.getKey() + "_profile.jpeg"), (Context)this.context.getApplicationContext(), (String)"image"));
                    }
                    this.channel.setLocalImageUri(file.getAbsolutePath());
                    this.channelService.updateChannel(this.channel);
                    ChannelInfoActivity.this.channelImage.setImageURI(Uri.parse((String)this.groupInfoUpdate.getContentUri()));
                }
            }
            if (this.channelUpdateReceiver != null) {
                this.channelUpdateReceiver.send(1, null);
            }
        }
    }

    public class ChannelMemberAdd
    extends AsyncTask<Void, Integer, Long> {
        ApiResponse apiResponse;
        String responseForDeleteGroup;
        String userId;
        private ChannelService channelService;
        private ProgressDialog progressDialog;
        private Context context;
        private Channel channel;

        public ChannelMemberAdd(Channel channel, String userId, Context context) {
            this.channel = channel;
            this.context = context;
            this.userId = userId;
            this.channelService = ChannelService.getInstance((Context)context);
        }

        public ChannelMemberAdd(Channel channel, Context context) {
            this.channel = channel;
            this.context = context;
            this.channelService = ChannelService.getInstance((Context)context);
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = !TextUtils.isEmpty((CharSequence)this.userId) ? ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)this.context.getString(R.string.adding_channel_user), (boolean)true) : ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)this.context.getString(R.string.deleting_channel_user), (boolean)true);
        }

        protected Long doInBackground(Void ... params) {
            if (this.channel != null && !TextUtils.isEmpty((CharSequence)this.userId)) {
                this.apiResponse = this.channelService.addMemberToChannelWithResponseProcess(this.channel.getKey(), this.userId);
            }
            if (this.channel != null && TextUtils.isEmpty((CharSequence)this.userId)) {
                this.responseForDeleteGroup = this.channelService.processChannelDeleteConversation(this.channel, this.context);
            }
            return null;
        }

        protected void onPostExecute(Long aLong) {
            super.onPostExecute((Object)aLong);
            if (this.progressDialog != null && this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
            if (!Utils.isInternetAvailable((Context)this.context)) {
                Toast toast = Toast.makeText((Context)this.context, (CharSequence)ChannelInfoActivity.this.getString(R.string.you_dont_have_any_network_access_info), (int)0);
                toast.setGravity(17, 0, 0);
                toast.show();
            }
            if (this.apiResponse != null) {
                if (this.apiResponse.isSuccess()) {
                    ChannelUserMapper channelUserMapper = new ChannelUserMapper(this.channel.getKey(), this.userId);
                    ChannelInfoActivity.this.channelUserMapperList.add(channelUserMapper);
                    ChannelInfoActivity.this.contactsAdapter.notifyDataSetChanged();
                    Helper.getListViewSize(ChannelInfoActivity.this.mainListView);
                } else {
                    ErrorResponseFeed errorResponseFeed;
                    String errorDescription;
                    List error = this.apiResponse.getErrorResponse();
                    if (error != null && error.size() > 0 && !TextUtils.isEmpty((CharSequence)(errorDescription = (errorResponseFeed = (ErrorResponseFeed)error.get(0)).getDescription()))) {
                        if ("GROUP_USER_LIMIT_EXCEED".equalsIgnoreCase(errorDescription)) {
                            Toast.makeText((Context)this.context, (int)R.string.group_members_limit_exceeds, (int)0).show();
                        } else {
                            Toast.makeText((Context)this.context, (int)R.string.applozic_server_error, (int)0).show();
                        }
                    }
                }
            }
            if (!TextUtils.isEmpty((CharSequence)this.responseForDeleteGroup) && ChannelInfoActivity.SUCCESS.equals(this.responseForDeleteGroup)) {
                try {
                    if (!TextUtils.isEmpty((CharSequence)ChannelInfoActivity.this.alCustomizationSettings.getGroupDeletePackageName())) {
                        Class<?> HomeActivity = Class.forName(ChannelInfoActivity.this.alCustomizationSettings.getGroupDeletePackageName().trim());
                        if (HomeActivity != null) {
                            ChannelInfoActivity.this.userPreference.setDeleteChannel(true);
                            Intent intent = new Intent((Context)ChannelInfoActivity.this, HomeActivity);
                            intent.setFlags(0x30008000);
                            intent.putExtra("fromGroupDelete", true);
                            ChannelInfoActivity.this.startActivity(intent);
                            ChannelInfoActivity.this.finish();
                        }
                    } else {
                        Intent intent = new Intent((Context)ChannelInfoActivity.this, ConversationActivity.class);
                        if (ApplozicClient.getInstance((Context)ChannelInfoActivity.this).isContextBasedChat()) {
                            intent.putExtra("contextBasedChat", true);
                        }
                        ChannelInfoActivity.this.startActivity(intent);
                        ChannelInfoActivity.this.userPreference.setDeleteChannel(true);
                        ChannelInfoActivity.this.finish();
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class ContactViewHolder {
        public TextView displayName;
        public TextView alphabeticImage;
        public TextView adminTextView;
        public TextView lastSeenAtTextView;
        public CircleImageView circleImageView;
    }

    public class ChannelMember
    extends AsyncTask<Void, Integer, Long> {
        String responseForRemove;
        private ChannelUserMapper channelUserMapper;
        private ChannelService channelService;
        private ProgressDialog progressDialog;
        private Context context;
        private Channel channel;

        public ChannelMember(ChannelUserMapper channelUserMapper, Channel channel, Context context) {
            this.channelUserMapper = channelUserMapper;
            this.channel = channel;
            this.context = context;
            this.channelService = ChannelService.getInstance((Context)context);
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)this.context.getString(R.string.removing_channel_user), (boolean)true);
        }

        protected Long doInBackground(Void ... params) {
            if (this.channel != null && this.channelUserMapper != null) {
                this.responseForRemove = this.channelService.removeMemberFromChannelProcess(this.channel.getKey(), this.channelUserMapper.getUserKey());
            }
            return null;
        }

        protected void onPostExecute(Long aLong) {
            super.onPostExecute((Object)aLong);
            if (this.progressDialog != null && this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
            if (!Utils.isInternetAvailable((Context)this.context)) {
                Toast toast = Toast.makeText((Context)this.context, (CharSequence)ChannelInfoActivity.this.getString(R.string.you_dont_have_any_network_access_info), (int)0);
                toast.setGravity(17, 0, 0);
                toast.show();
            }
            if (ChannelInfoActivity.SUCCESS.equals(this.responseForRemove) && ChannelInfoActivity.this.contactsAdapter != null && ChannelInfoActivity.this.channelUserMapperList != null && ChannelInfoActivity.this.channelUserMapperList.size() > 0) {
                ChannelInfoActivity.this.channelUserMapperList.remove(this.channelUserMapper);
                ChannelInfoActivity.this.contactsAdapter.notifyDataSetChanged();
                Helper.getListViewSize(ChannelInfoActivity.this.mainListView);
            }
        }
    }

    public static class Helper {
        public static void getListViewSize(ListView myListView) {
            ListAdapter myListAdapter = myListView.getAdapter();
            if (myListAdapter == null) {
                return;
            }
            int totalHeight = 0;
            if (myListAdapter.getCount() > 0) {
                View listItem = myListAdapter.getView(0, null, (ViewGroup)myListView);
                listItem.measure(0, 0);
                totalHeight = listItem.getMeasuredHeight() * myListAdapter.getCount();
                ViewGroup.LayoutParams params = myListView.getLayoutParams();
                params.height = totalHeight + myListView.getDividerHeight() * (myListAdapter.getCount() - 1);
                myListView.setLayoutParams(params);
            }
        }
    }

    private class ContactsAdapter
    extends BaseAdapter {
        Context context;
        private LayoutInflater mInflater;

        public ContactsAdapter(Context context) {
            this.context = context;
            this.mInflater = LayoutInflater.from((Context)context);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ContactViewHolder holder;
            ChannelUserMapper channelUserMapper = ChannelInfoActivity.this.channelUserMapperList.get(position);
            Contact contact = ChannelInfoActivity.this.baseContactService.getContactById(channelUserMapper.getUserKey());
            if (convertView == null) {
                convertView = this.mInflater.inflate(R.layout.contact_users_layout, parent, false);
                holder = new ContactViewHolder();
                holder.displayName = (TextView)convertView.findViewById(R.id.displayName);
                holder.alphabeticImage = (TextView)convertView.findViewById(R.id.alphabeticImage);
                holder.circleImageView = (CircleImageView)convertView.findViewById(R.id.contactImage);
                holder.adminTextView = (TextView)convertView.findViewById(R.id.adminTextView);
                holder.lastSeenAtTextView = (TextView)convertView.findViewById(R.id.lastSeenAtTextView);
                holder.displayName.setSelected(true);
                holder.displayName.requestFocus();
                convertView.setTag((Object)holder);
            } else {
                holder = (ContactViewHolder)convertView.getTag();
            }
            GradientDrawable bgShapeAdminText = (GradientDrawable)holder.adminTextView.getBackground();
            bgShapeAdminText.setColor(Color.parseColor((String)ChannelInfoActivity.this.alCustomizationSettings.getAdminBackgroundColor()));
            bgShapeAdminText.setStroke(2, Color.parseColor((String)ChannelInfoActivity.this.alCustomizationSettings.getAdminBorderColor()));
            holder.adminTextView.setTextColor(Color.parseColor((String)ChannelInfoActivity.this.alCustomizationSettings.getAdminTextColor()));
            if (ChannelInfoActivity.this.userPreference.getUserId().equals(contact.getUserId())) {
                holder.displayName.setText((CharSequence)ChannelInfoActivity.this.getString(R.string.you_string));
            } else {
                holder.displayName.setText((CharSequence)contact.getDisplayName());
            }
            if (ChannelUtils.isAdminUserId((String)channelUserMapper.getUserKey(), (Channel)ChannelInfoActivity.this.channel) && Integer.valueOf(0).equals(channelUserMapper.getRole()) || ChannelUserMapper.UserRole.ADMIN.getValue().equals(channelUserMapper.getRole())) {
                holder.adminTextView.setVisibility(0);
            } else {
                holder.adminTextView.setVisibility(8);
            }
            if (!ChannelInfoActivity.this.userPreference.getUserId().equals(contact.getUserId())) {
                if (contact.isConnected()) {
                    holder.lastSeenAtTextView.setVisibility(0);
                    holder.lastSeenAtTextView.setText((CharSequence)ChannelInfoActivity.this.getString(R.string.user_online));
                } else if (contact.getLastSeenAt() != 0L) {
                    holder.lastSeenAtTextView.setVisibility(0);
                    holder.lastSeenAtTextView.setText((CharSequence)(ChannelInfoActivity.this.getString(R.string.subtitle_last_seen_at_time) + " " + String.valueOf(DateUtils.getDateAndTimeForLastSeen((Context)ChannelInfoActivity.this, (Long)contact.getLastSeenAt(), (int)R.string.JUST_NOW, (int)R.plurals.MINUTES_AGO, (int)R.plurals.HOURS_AGO, (int)R.string.YESTERDAY))));
                } else {
                    holder.lastSeenAtTextView.setVisibility(8);
                    holder.lastSeenAtTextView.setText((CharSequence)"");
                }
            } else {
                holder.lastSeenAtTextView.setVisibility(8);
                holder.lastSeenAtTextView.setText((CharSequence)"");
            }
            if (contact != null && !TextUtils.isEmpty((CharSequence)contact.getDisplayName())) {
                String contactNumber = contact.getDisplayName().toUpperCase();
                char firstLetter = contact.getDisplayName().toUpperCase().charAt(0);
                if (firstLetter != '+') {
                    holder.alphabeticImage.setText((CharSequence)String.valueOf(firstLetter));
                } else if (contactNumber.length() >= 2) {
                    holder.alphabeticImage.setText((CharSequence)String.valueOf(contactNumber.charAt(1)));
                }
                Character colorKey = AlphaNumberColorUtil.alphabetBackgroundColorMap.containsKey(Character.valueOf(firstLetter)) ? Character.valueOf(firstLetter) : null;
                GradientDrawable bgShape = (GradientDrawable)holder.alphabeticImage.getBackground();
                bgShape.setColor(this.context.getResources().getColor(AlphaNumberColorUtil.alphabetBackgroundColorMap.get(colorKey).intValue()));
            }
            holder.alphabeticImage.setVisibility(8);
            holder.circleImageView.setVisibility(0);
            if (contact != null) {
                if (contact.isDrawableResources()) {
                    int drawableResourceId = this.context.getResources().getIdentifier(contact.getrDrawableName(), "drawable", this.context.getPackageName());
                    holder.circleImageView.setImageResource(drawableResourceId);
                } else {
                    ChannelInfoActivity.this.contactImageLoader.loadImage((Object)contact, (ImageView)holder.circleImageView, holder.alphabeticImage);
                }
            }
            return convertView;
        }

        public int getCount() {
            return ChannelInfoActivity.this.channelUserMapperList.size();
        }

        public Object getItem(int position) {
            return ChannelInfoActivity.this.channelUserMapperList.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }
    }
}

