/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.attachmentview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import com.bumptech.glide.request.RequestOptions;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class AlBitmapUtils {
    private static final int MAX_COMPRESSION_QUALITY = 90;
    private static final String TAG = "AlBitmapUtils";

    public static boolean compress(Uri uri, File file, FragmentActivity fragmentActivity) {
        return AlBitmapUtils.compress(uri, file, fragmentActivity, null);
    }

    public static boolean compress(Uri uri, File file, Context context) {
        return AlBitmapUtils.compress(uri, file, null, context);
    }

    public static boolean compress(Uri uri, File file, FragmentActivity fragmentActivity, Context context) {
        if (uri == null || file == null) {
            return false;
        }
        try {
            RequestOptions req = new RequestOptions();
            req.downsample(DownsampleStrategy.AT_MOST);
            Drawable drawable2 = null;
            if (fragmentActivity != null) {
                drawable2 = (Drawable)Glide.with((FragmentActivity)fragmentActivity).load(uri).apply(req).submit(600, 600).get();
            } else if (context != null) {
                drawable2 = (Drawable)Glide.with((Context)context).load(uri).apply(req).submit(600, 600).get();
            }
            if (drawable2 == null) {
                return false;
            }
            Bitmap scaledBitMap = ((BitmapDrawable)drawable2).getBitmap();
            if (scaledBitMap != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                scaledBitMap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)baos);
                byte[] bytes = baos.toByteArray();
                File sizeOfFile = new File(file.getAbsolutePath());
                String path = sizeOfFile.getAbsolutePath();
                if (sizeOfFile.exists()) {
                    boolean bl = sizeOfFile.delete();
                }
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(path)));
                bos.write(bytes);
                bos.flush();
                bos.close();
                return true;
            }
        }
        catch (Exception e) {
            Log.i((String)TAG, (String)("Got error in compression :" + e.getMessage()));
        }
        return false;
    }
}

