/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Point;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.WindowManager;
import com.applozic.mobicommons.commons.core.utils.Utils;

public class DimensionsUtils {
    private static float density = 1.0f;
    private static Point displaySize = new Point();
    public static DisplayMetrics displayMetrics = new DisplayMetrics();

    public static float convertPixelsToDp(float px) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        float dp = px / ((float)metrics.densityDpi / 160.0f);
        return Math.round(dp);
    }

    public static float convertDpToPixel(float dp) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return Math.round(px);
    }

    public static int dp(float dp) {
        return Math.round(dp * (float)(Resources.getSystem().getDisplayMetrics().densityDpi / 160));
    }

    public static int pxToDp(float px) {
        return Math.round(px / (Resources.getSystem().getDisplayMetrics().xdpi / 160.0f));
    }

    public static float convertSpToPixels(float sp, Context context) {
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static void checkDisplaySize(Context context, Configuration newConfiguration) {
        try {
            int newSize;
            Display display;
            WindowManager manager;
            density = context.getResources().getDisplayMetrics().density;
            Configuration configuration = newConfiguration;
            if (configuration == null) {
                configuration = context.getResources().getConfiguration();
            }
            if ((manager = (WindowManager)context.getSystemService("window")) != null && (display = manager.getDefaultDisplay()) != null) {
                display.getMetrics(displayMetrics);
                display.getSize(displaySize);
            }
            if (configuration.screenWidthDp != 0 && Math.abs(DimensionsUtils.displaySize.x - (newSize = (int)Math.ceil((float)configuration.screenWidthDp * density))) > 3) {
                DimensionsUtils.displaySize.x = newSize;
            }
            if (configuration.screenHeightDp != 0 && Math.abs(DimensionsUtils.displaySize.y - (newSize = (int)Math.ceil((float)configuration.screenHeightDp * density))) > 3) {
                DimensionsUtils.displaySize.y = newSize;
            }
            Utils.printLog((Context)context, (String)"DimensionUtils", (String)("Display size = " + DimensionsUtils.displaySize.x + " " + DimensionsUtils.displaySize.y + " " + DimensionsUtils.displayMetrics.xdpi + "x" + DimensionsUtils.displayMetrics.ydpi));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

