/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.attachmentview;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.widget.SeekBar;
import android.widget.Toast;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.attachmentview.ApplozicDocumentView;
import java.util.HashMap;
import java.util.Map;

public class ApplozicAudioManager {
    private static ApplozicAudioManager myObj;
    private final TelephonyManager mTelephonyMgr;
    public ApplozicDocumentView currentView;
    Map<String, MediaPlayer> pool = new HashMap<String, MediaPlayer>();
    Context context;
    int maxsize = 5;
    String TAG = "ApplozicAudioManager";
    String audio_duration;
    int hours;
    int minute;
    int second;
    int duration;
    PhoneStateListener mPhoneStateListener;

    private ApplozicAudioManager(Context context) {
        this.context = context;
        this.mTelephonyMgr = (TelephonyManager)context.getSystemService("phone");
        this.mTelephonyMgr.listen(this.mPhoneStateListener, 32);
    }

    public static ApplozicAudioManager getInstance(Context context) {
        try {
            if (myObj == null) {
                myObj = new ApplozicAudioManager(context.getApplicationContext());
            }
            return myObj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    void play(Uri uri, ApplozicDocumentView view) {
        final String key = view.message.getKeyString();
        MediaPlayer mp = this.pool.get(key);
        if (mp != null) {
            if (mp.isPlaying()) {
                mp.pause();
                return;
            }
            mp.seekTo(mp.getCurrentPosition());
            mp.start();
        } else {
            mp = new MediaPlayer();
            if (this.pool.size() >= this.maxsize) {
                Map.Entry<String, MediaPlayer> entry = this.pool.entrySet().iterator().next();
                String first = entry.getKey();
                this.pool.remove(first);
            }
            this.pool.put(key, mp);
        }
        this.pauseOthersifPlaying();
        mp.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                Toast.makeText((Context)ApplozicAudioManager.this.context, (int)R.string.unable_to_play_requested_audio_file, (int)1).show();
                return false;
            }
        });
        try {
            if (this.context != null) {
                mp.setDataSource(this.context, uri);
                mp.prepare();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mp.start();
        if (this.currentView != null) {
            this.currentView.setAudioIcons();
        }
        this.currentView = view;
        mp.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                mp.release();
                ApplozicAudioManager.this.pool.remove(key);
                ApplozicAudioManager.this.currentView.setAudioIcons();
            }
        });
        this.currentView.audioseekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onStopTrackingTouch(SeekBar seekBar) {
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser && ApplozicAudioManager.this.getMediaPlayer(key) != null) {
                    ApplozicAudioManager.this.getMediaPlayer(key).seekTo(progress);
                }
            }
        });
        this.mPhoneStateListener = new PhoneStateListener(){

            public void onCallStateChanged(int state, String incomingNumber) {
                super.onCallStateChanged(state, incomingNumber);
                if ((state == 1 || state == 2) && ApplozicAudioManager.this.getMediaPlayer(key) != null) {
                    ApplozicAudioManager.this.getMediaPlayer(key).pause();
                    ApplozicAudioManager.this.currentView.setAudioIcons();
                }
            }
        };
        this.mTelephonyMgr.listen(this.mPhoneStateListener, 32);
    }

    public void pauseOthersifPlaying() {
        for (Map.Entry<String, MediaPlayer> pair : this.pool.entrySet()) {
            MediaPlayer m = pair.getValue();
            if (!m.isPlaying()) continue;
            m.pause();
        }
    }

    int getAudioState(String key) {
        MediaPlayer mp = this.pool.get(key);
        if (mp != null) {
            if (mp.isPlaying()) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public MediaPlayer getMediaPlayer(String key) {
        return this.pool.get(key);
    }

    public void audiostop() {
        for (Map.Entry<String, MediaPlayer> pair : this.pool.entrySet()) {
            MediaPlayer temp = pair.getValue();
            temp.stop();
            temp.release();
        }
        this.pool.clear();
    }

    public String refreshAudioDuration(String filePath) {
        MediaPlayer mediaPlayer = new MediaPlayer();
        try {
            mediaPlayer.setDataSource(filePath);
            mediaPlayer.prepare();
            this.duration = mediaPlayer.getDuration();
            this.duration /= 1000;
            this.hours = this.duration / 3600;
            this.minute = this.duration / 60;
            this.second = this.duration % 60 + 1;
            mediaPlayer.release();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.audio_duration = String.format("%02d:%02d", this.minute, this.second);
        return this.audio_duration;
    }
}

