/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.schedule;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.schedule.ScheduledTimeHolder;
import com.applozic.mobicomkit.uiwidgets.schedule.SelectDateFragment;
import com.applozic.mobicomkit.uiwidgets.schedule.SelectTimeFragment;
import com.applozic.mobicommons.commons.core.utils.DateUtils;

public class ConversationScheduler
extends DialogFragment {
    private ScheduledTimeHolder scheduledTimeHolder;
    private LinearLayout conversationScheduler;
    private Button scheduleOption;
    private String[] monthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "June", "July", "Aug", "Sept", "Oct", "Nov", "Dec"};

    public void setScheduleOption(Button scheduleOption) {
        this.scheduleOption = scheduleOption;
    }

    public void setScheduledTimeHolder(ScheduledTimeHolder scheduledTimeHolder) {
        this.scheduledTimeHolder = scheduledTimeHolder;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        View conversationSchedulerLayout = inflater.inflate(R.layout.conversation_scheduler, null, false);
        this.conversationScheduler = (LinearLayout)conversationSchedulerLayout.findViewById(R.id.conversation_scheduler);
        final TextView scheduledDate = (TextView)this.conversationScheduler.findViewById(R.id.scheduledDate);
        final TextView scheduledTime = (TextView)this.conversationScheduler.findViewById(R.id.scheduledTime);
        if (this.scheduledTimeHolder.getTimestamp() != null) {
            String[] date = this.scheduledTimeHolder.getDate().split("-");
            scheduledDate.setText((CharSequence)(date[0] + "-" + this.monthNames[Integer.parseInt(date[1]) - 1] + "-" + date[2]));
            scheduledTime.setText((CharSequence)this.scheduledTimeHolder.getTime());
        }
        scheduledDate.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SelectDateFragment dateFragment = new SelectDateFragment();
                dateFragment.setScheduledDateView((View)ConversationScheduler.this.conversationScheduler);
                dateFragment.setScheduledTimeHolder(ConversationScheduler.this.scheduledTimeHolder);
                dateFragment.show(ConversationScheduler.this.getActivity().getSupportFragmentManager(), "DatePicker");
                ConversationScheduler.this.resetColor(scheduledDate, scheduledTime);
            }
        });
        scheduledTime.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SelectTimeFragment timeFragment = new SelectTimeFragment();
                timeFragment.setScheduledTimeView((View)ConversationScheduler.this.conversationScheduler);
                timeFragment.setScheduledTimeHolder(ConversationScheduler.this.scheduledTimeHolder);
                timeFragment.show(ConversationScheduler.this.getActivity().getSupportFragmentManager(), "TimePicker");
                ConversationScheduler.this.resetColor(scheduledDate, scheduledTime);
            }
        });
        builder.setView(conversationSchedulerLayout).setPositiveButton(R.string.ScheduleText, null).setNegativeButton(R.string.negetiveButtonText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                ConversationScheduler.this.scheduledTimeHolder.resetScheduledTimeHolder();
                ConversationScheduler.this.scheduleOption.setText(R.string.ScheduleText);
            }
        });
        final AlertDialog dialog = builder.create();
        dialog.show();
        dialog.getButton(-1).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Long timestamp = ConversationScheduler.this.scheduledTimeHolder.getTimestamp();
                if (timestamp == null) {
                    if (ConversationScheduler.this.scheduledTimeHolder.getDate() == null) {
                        scheduledDate.setTextColor(-65536);
                    }
                    if (ConversationScheduler.this.scheduledTimeHolder.getTime() == null) {
                        scheduledTime.setTextColor(-65536);
                    }
                } else {
                    ConversationScheduler.this.scheduleOption.setText((CharSequence)DateUtils.getFormattedDate((Long)timestamp));
                    dialog.dismiss();
                }
            }
        });
        return dialog;
    }

    public void resetColor(TextView scheduledDate, TextView scheduledTime) {
        scheduledDate.setTextColor(this.getResources().getColor(R.color.holo_blue));
        scheduledTime.setTextColor(this.getResources().getColor(R.color.holo_blue));
    }
}

