/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.people.fragment;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserClientService;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.fragment.PictureUploadPopUpFragment;
import com.applozic.mobicomkit.uiwidgets.instruction.ApplozicPermissions;
import com.applozic.mobicommons.commons.core.utils.PermissionsUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.people.contact.Contact;
import java.io.File;

public class ProfileFragment
extends Fragment {
    public static final int REQUEST_CODE_ATTACH_PHOTO = 101;
    public static final int REQUEST_CODE_TAKE_PHOTO = 102;
    public static final int REQUEST_REMOVE_PHOTO = 102;
    public static final String ProfileFragmentTag = "ProfileFragment";
    public static final int PROFILE_UPDATED = 1001;
    public static final int LINE_WIDTH = 2;
    public static final float LEFT_MARGIN = 7.0f;
    private static final String TAG = "ProfileFragment";
    AppContactService contactService;
    Contact userContact;
    AlCustomizationSettings alCustomizationSettings;
    private ImageView img_profile;
    private ImageView selectImageProfileIcon;
    private ImageView statusEdit;
    private Button logoutbtn;
    private TextView displayNameText;
    private TextView statusText;
    private String DEFAULT_CONATCT_IMAGE = "applozic_default_contactImg.jpeg";
    private ImageLoader mImageLoader;
    private String changedStatusString;
    private ApplozicPermissions applozicPermissions;

    public void setApplozicPermissions(ApplozicPermissions applozicPermissions) {
        this.applozicPermissions = applozicPermissions;
    }

    public void setAlCustomizationSettings(AlCustomizationSettings alCustomizationSettings) {
        this.alCustomizationSettings = alCustomizationSettings;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        View view = inflater.inflate(R.layout.al_activity_profile, container, false);
        this.img_profile = (ImageView)view.findViewById(R.id.applozic_user_profile);
        this.statusEdit = (ImageView)view.findViewById(R.id.status_edit_btn);
        this.selectImageProfileIcon = (ImageView)view.findViewById(R.id.applozic_user_profile_camera);
        this.logoutbtn = (Button)view.findViewById(R.id.applozic_profile_logout);
        this.displayNameText = (TextView)view.findViewById(R.id.applozic_profile_displayname);
        this.statusText = (TextView)view.findViewById(R.id.applozic_profile_status);
        this.setupDeviderView(view, R.id.applozic_profile_section_rl, R.id.applozic_profile_verticalline_rl);
        this.setupDeviderView(view, R.id.applozic_datausage_section_rl, R.id.applozic_datausage_verticalline_rl);
        this.setupDeviderView(view, R.id.applozic_notification_section_rl, R.id.applozic_notification_verticalline_rl);
        Toolbar toolbar = (Toolbar)this.getActivity().findViewById(R.id.my_toolbar);
        toolbar.setClickable(false);
        toolbar.setTitle((CharSequence)this.getString(R.string.applozic_user_profile_heading));
        toolbar.setSubtitle((CharSequence)"");
        this.setHasOptionsMenu(true);
        this.contactService = new AppContactService((Context)this.getActivity());
        this.userContact = this.contactService.getContactById(MobiComUserPreference.getInstance((Context)this.getActivity()).getUserId());
        this.displayNameText.setText((CharSequence)this.userContact.getDisplayName());
        if (!TextUtils.isEmpty((CharSequence)this.userContact.getStatus())) {
            this.statusText.setText((CharSequence)this.userContact.getStatus());
        }
        final Context context = this.getActivity().getApplicationContext();
        this.mImageLoader = new ImageLoader(context, this.img_profile.getHeight()){

            protected Bitmap processBitmap(Object data) {
                return ProfileFragment.this.contactService.downloadContactImage(context, (Contact)data);
            }
        };
        this.selectImageProfileIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ProfileFragment.this.processPhotoOption();
            }
        });
        this.logoutbtn.setVisibility(8);
        this.logoutbtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    String logoutActivity = ApplozicSetting.getInstance((Context)ProfileFragment.this.getActivity()).getActivityCallback(ApplozicSetting.RequestCode.USER_LOOUT);
                    if (!TextUtils.isEmpty((CharSequence)logoutActivity)) {
                        new UserClientService((Context)ProfileFragment.this.getActivity()).logout();
                        Intent intent = new Intent((Context)ProfileFragment.this.getActivity(), Class.forName(logoutActivity));
                        intent.setFlags(0x30008000);
                        ProfileFragment.this.startActivity(intent);
                        ProfileFragment.this.getActivity().finish();
                        return;
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
        this.statusEdit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlertDialog.Builder builder = new AlertDialog.Builder(ProfileFragment.this.getContext());
                builder.setTitle((CharSequence)"Status");
                final EditText input = new EditText(ProfileFragment.this.getContext());
                input.setInputType(1);
                builder.setView((View)input);
                builder.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        ProfileFragment.this.changedStatusString = input.getText().toString();
                        new ProfilePictureUpload(ProfileFragment.this.changedStatusString, (Context)ProfileFragment.this.getActivity()).execute(null);
                    }
                });
                builder.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.cancel();
                    }
                });
                builder.show();
            }
        });
        this.mImageLoader.setImageFadeIn(false);
        this.mImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_180_holo_light);
        this.mImageLoader.loadImage((Object)this.userContact, this.img_profile);
        return view;
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
        menu2.findItem(R.id.refresh).setVisible(false);
        menu2.findItem(R.id.menu_search).setVisible(false);
    }

    private void setupDeviderView(View view, int parentLayout, int childVerticalLineLayout) {
        final RelativeLayout layout2 = (RelativeLayout)view.findViewById(parentLayout);
        final RelativeLayout childLayout = (RelativeLayout)view.findViewById(childVerticalLineLayout);
        ViewTreeObserver viewTreeObserver = layout2.getViewTreeObserver();
        viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                layout2.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                int height = layout2.getMeasuredHeight();
                float marginPx = TypedValue.applyDimension((int)1, (float)7.0f, (DisplayMetrics)ProfileFragment.this.getActivity().getResources().getDisplayMetrics());
                float liineWidth = TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)ProfileFragment.this.getActivity().getResources().getDisplayMetrics());
                RelativeLayout.LayoutParams layoutPrams = new RelativeLayout.LayoutParams((int)liineWidth, height);
                layoutPrams.setMargins((int)marginPx, 0, 0, 0);
                childLayout.setLayoutParams((ViewGroup.LayoutParams)layoutPrams);
            }
        });
    }

    public void processPhotoOption() {
        try {
            if (PermissionsUtils.isCameraPermissionGranted((Context)this.getContext()) && !PermissionsUtils.checkSelfForStoragePermission((Activity)this.getActivity())) {
                new Handler().post(new Runnable(){

                    @Override
                    public void run() {
                        FragmentManager supportFragmentManager = ProfileFragment.this.getActivity().getSupportFragmentManager();
                        PictureUploadPopUpFragment fragment = new PictureUploadPopUpFragment();
                        fragment.setTargetFragment(ProfileFragment.this, 101);
                        FragmentTransaction fragmentTransaction = supportFragmentManager.beginTransaction();
                        Fragment prev = ProfileFragment.this.getFragmentManager().findFragmentByTag("PhotosAttachmentFragment");
                        if (prev != null) {
                            fragmentTransaction.remove(prev);
                        }
                        fragmentTransaction.addToBackStack(null);
                        fragment.show(fragmentTransaction, "PhotosAttachmentFragment");
                    }
                });
            } else if (Utils.hasMarshmallow()) {
                if (PermissionsUtils.checkSelfForCameraPermission((Activity)this.getActivity())) {
                    this.applozicPermissions.requestCameraPermissionForProfilePhoto();
                } else {
                    this.applozicPermissions.requestStoragePermissionsForProfilePhoto();
                }
            } else {
                this.processPhotoOption();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handleProfileimageUpload(boolean isSaveFile, Uri imageUri, File file) {
        this.img_profile.setImageDrawable(null);
        this.img_profile.setImageURI(imageUri);
        new ProfilePictureUpload(isSaveFile, imageUri, file, (Context)this.getActivity()).execute(null);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        if (resultCode == -1) {
            super.onActivityResult(requestCode, resultCode, intent);
            File file = FileClientService.getFilePath((String)this.DEFAULT_CONATCT_IMAGE, (Context)this.getContext(), (String)"image", (boolean)true);
            if (file == null || !file.exists()) {
                Log.i((String)"ProfileFragment", (String)"file not found,exporting it from drawable");
                Bitmap bm = BitmapFactory.decodeResource((Resources)this.getActivity().getResources(), (int)R.drawable.applozic_ic_contact_picture_180_holo_light);
                String filePath = ImageUtils.saveImageToInternalStorage((File)FileClientService.getFilePath((String)this.DEFAULT_CONATCT_IMAGE, (Context)this.getActivity().getApplicationContext(), (String)"image", (boolean)true), (Bitmap)bm);
                file = new File(filePath);
            }
            this.handleProfileimageUpload(false, Uri.parse((String)file.getAbsolutePath()), file);
        } else {
            Log.i((String)"ProfileFragment", (String)("Activity result failed with code: " + resultCode));
        }
    }

    class ProfilePictureUpload
    extends AsyncTask<Void, Void, Boolean> {
        Context context;
        Uri fileUri;
        String displayName;
        String status;
        File file;
        FileClientService fileClientService;
        UserService userService;
        boolean isSaveFile;
        private ProgressDialog progressDialog;

        public ProfilePictureUpload(boolean isSaveFile, Uri fileUri, File file, Context context) {
            this.context = context;
            this.fileUri = fileUri;
            this.isSaveFile = isSaveFile;
            this.file = file;
            this.fileClientService = new FileClientService((Context)ProfileFragment.this.getActivity());
            this.userService = UserService.getInstance((Context)context);
        }

        public ProfilePictureUpload(String status, Context context) {
            this.context = context;
            this.status = status;
            this.fileClientService = new FileClientService((Context)ProfileFragment.this.getActivity());
            this.userService = UserService.getInstance((Context)context);
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)this.context.getString(R.string.applozic_contacts_loading_info), (boolean)true);
        }

        protected Boolean doInBackground(Void ... params) {
            try {
                String response = null;
                String filePath = null;
                if (this.fileUri != null) {
                    if (this.isSaveFile) {
                        this.fileClientService.writeFile(this.fileUri, this.file);
                    }
                    response = this.fileClientService.uploadProfileImage(this.file.getAbsolutePath());
                    filePath = this.file.getAbsolutePath();
                }
                if (TextUtils.isEmpty((CharSequence)this.displayName)) {
                    this.displayName = ProfileFragment.this.userContact.getDisplayName();
                }
                this.userService.updateDisplayNameORImageLink(this.displayName, response, filePath, this.status);
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.i((String)ProfileFragment.class.getName(), (String)"Exception");
            }
            return true;
        }

        protected void onPostExecute(Boolean result) {
            if (!TextUtils.isEmpty((CharSequence)ProfileFragment.this.changedStatusString) && ProfileFragment.this.statusText != null) {
                ProfileFragment.this.statusText.setText((CharSequence)ProfileFragment.this.changedStatusString);
            }
            this.progressDialog.dismiss();
        }
    }
}

