/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.conversation.activity;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.applozic.mobicomkit.uiwidgets.AlCustomizationSettings;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.conversation.adapter.MobiComAttachmentGridViewAdapter;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import java.util.ArrayList;

public class MobiComAttachmentSelectorActivity
extends AppCompatActivity {
    public static final String MULTISELECT_SELECTED_FILES = "multiselect.selectedFiles";
    public static final String MULTISELECT_MESSAGE = "multiselect.message";
    private String TAG = "MultiAttActivity";
    private static int REQUEST_CODE_ATTACH_PHOTO = 10;
    private Button sendAttachment;
    private Button cancelAttachment;
    private EditText messageEditText;
    private GridView galleryImagesGridView;
    private ArrayList<Uri> attachmentFileList = new ArrayList();
    AlCustomizationSettings alCustomizationSettings;
    private MobiComAttachmentGridViewAdapter imagesAdapter;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.mobicom_multi_attachment_activity);
        String jsonString = FileUtils.loadSettingsJsonFile((Context)this.getApplicationContext());
        this.alCustomizationSettings = !TextUtils.isEmpty((CharSequence)jsonString) ? (AlCustomizationSettings)((Object)GsonUtils.getObjectFromJson((String)jsonString, AlCustomizationSettings.class)) : new AlCustomizationSettings();
        this.initViews();
        this.setUpGridView();
        Intent getContentIntent = FileUtils.createGetContentIntent();
        getContentIntent.putExtra("android.intent.extra.LOCAL_ONLY", true);
        Intent intentPick = Intent.createChooser((Intent)getContentIntent, (CharSequence)this.getString(R.string.select_file));
        this.startActivityForResult(intentPick, REQUEST_CODE_ATTACH_PHOTO);
    }

    private void initViews() {
        this.sendAttachment = (Button)this.findViewById(R.id.mobicom_attachment_send_btn);
        this.cancelAttachment = (Button)this.findViewById(R.id.mobicom_attachment_cancel_btn);
        this.galleryImagesGridView = (GridView)this.findViewById(R.id.mobicom_attachment_grid_View);
        this.messageEditText = (EditText)this.findViewById(R.id.mobicom_attachment_edit_text);
        this.cancelAttachment.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent();
                MobiComAttachmentSelectorActivity.this.setResult(0, intent);
                MobiComAttachmentSelectorActivity.this.finish();
            }
        });
        this.sendAttachment.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MobiComAttachmentSelectorActivity.this.attachmentFileList.isEmpty()) {
                    Toast.makeText((Context)MobiComAttachmentSelectorActivity.this.getApplicationContext(), (int)R.string.mobicom_select_attachment_text, (int)0).show();
                    return;
                }
                Intent intent = new Intent();
                intent.putParcelableArrayListExtra(MobiComAttachmentSelectorActivity.MULTISELECT_SELECTED_FILES, MobiComAttachmentSelectorActivity.this.attachmentFileList);
                intent.putExtra(MobiComAttachmentSelectorActivity.MULTISELECT_MESSAGE, MobiComAttachmentSelectorActivity.this.messageEditText.getText().toString());
                MobiComAttachmentSelectorActivity.this.setResult(-1, intent);
                MobiComAttachmentSelectorActivity.this.finish();
            }
        });
    }

    private void addUri(Uri uri) {
        this.attachmentFileList.add(uri);
        Log.i((String)this.TAG, (String)("attachmentFileList  :: " + this.attachmentFileList));
    }

    private void setUpGridView() {
        this.imagesAdapter = new MobiComAttachmentGridViewAdapter((Context)this, this.attachmentFileList, this.alCustomizationSettings);
        this.galleryImagesGridView.setAdapter((ListAdapter)this.imagesAdapter);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        if (resultCode == -1) {
            Uri selectedFileUri = intent == null ? null : intent.getData();
            Log.i((String)this.TAG, (String)("selectedFileUri :: " + selectedFileUri));
            if (selectedFileUri != null) {
                try {
                    int maxFileSize = this.alCustomizationSettings.getMaxAttachmentSizeAllowed() * 1024 * 1024;
                    Cursor returnCursor = this.getContentResolver().query(selectedFileUri, null, null, null, null);
                    if (returnCursor != null) {
                        int sizeIndex = returnCursor.getColumnIndex("_size");
                        returnCursor.moveToFirst();
                        Long fileSize = returnCursor.getLong(sizeIndex);
                        returnCursor.close();
                        if (fileSize > (long)maxFileSize) {
                            Toast.makeText((Context)this, (int)R.string.info_attachment_max_allowed_file_size, (int)1).show();
                            return;
                        }
                    }
                    this.addUri(selectedFileUri);
                    this.imagesAdapter.notifyDataSetChanged();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        super.onActivityResult(requestCode, resultCode, intent);
    }
}

