/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.uiwidgets.people.contact;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.ListFragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.widget.CursorAdapter;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.AlphabetIndexer;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.SectionIndexer;
import android.widget.TextView;
import android.widget.Toast;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.contact.database.ContactDatabase;
import com.applozic.mobicomkit.feed.RegisteredUsersApiResponse;
import com.applozic.mobicomkit.uiwidgets.ApplozicSetting;
import com.applozic.mobicomkit.uiwidgets.R;
import com.applozic.mobicomkit.uiwidgets.people.activity.MobiComKitPeopleActivity;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.commons.image.ImageLoader;
import com.applozic.mobicommons.people.OnContactsInteractionListener;
import com.applozic.mobicommons.people.SearchListFragment;
import com.applozic.mobicommons.people.contact.Contact;
import de.hdodenhof.circleimageview.CircleImageView;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@SuppressLint(value={"ValidFragment"})
public class AppContactFragment
extends ListFragment
implements SearchListFragment,
AdapterView.OnItemClickListener,
LoaderManager.LoaderCallbacks<Cursor> {
    private static final String TAG = "AppContactFragment";
    private static final String SHARE_TEXT = "share_text";
    private static final String STATE_PREVIOUSLY_SELECTED_KEY = "net.mobitexter.mobiframework.contact.ui.SELECTED_ITEM";
    private static String inviteMessage;
    private ContactsAdapter mAdapter;
    private ImageLoader mImageLoader;
    private String mSearchTerm;
    private OnContactsInteractionListener mOnContactSelectedListener;
    private int mPreviouslySelectedSearchItem = 0;
    private BaseContactService contactService;
    private Button shareButton;
    private TextView resultTextView;
    private List<Contact> contactList;
    private boolean syncStatus = true;
    private String[] userIdArray;
    private MobiComUserPreference userPreference;
    private boolean isScrolling = false;
    private int visibleThreshold = 0;
    private int currentPage = 0;
    private int previousTotalItemCount = 0;
    private boolean loading = true;
    private int startingPageIndex = 0;
    private ApplozicSetting applozicSetting;

    public AppContactFragment() {
    }

    public AppContactFragment(String[] userIdArray) {
        this.userIdArray = userIdArray;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.contactService = new AppContactService((Context)this.getActivity());
        this.mAdapter = new ContactsAdapter(this.getActivity().getApplicationContext());
        this.applozicSetting = ApplozicSetting.getInstance(this.getContext());
        this.userPreference = MobiComUserPreference.getInstance((Context)this.getContext());
        inviteMessage = Utils.getMetaDataValue((Context)this.getActivity().getApplicationContext(), (String)SHARE_TEXT);
        if (savedInstanceState != null) {
            this.mSearchTerm = savedInstanceState.getString("query");
            this.mPreviouslySelectedSearchItem = savedInstanceState.getInt(STATE_PREVIOUSLY_SELECTED_KEY, 0);
        }
        FragmentActivity context = this.getActivity();
        this.mImageLoader = new ImageLoader((Context)context, this.getListPreferredItemHeight(), (Context)context){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
                super(x0, x1);
            }

            protected Bitmap processBitmap(Object data) {
                return AppContactFragment.this.contactService.downloadContactImage(this.val$context, (Contact)data);
            }
        };
        this.mImageLoader.setLoadingImage(R.drawable.applozic_ic_contact_picture_holo_light);
        this.mImageLoader.addImageCache(this.getActivity().getSupportFragmentManager(), 0.1f);
        this.mImageLoader.setImageFadeIn(false);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.contact_list_fragment, container, false);
        this.shareButton = (Button)view.findViewById(R.id.actionButton);
        this.shareButton.setVisibility(ApplozicSetting.getInstance((Context)this.getActivity()).isInviteFriendsButtonVisible() ? 0 : 8);
        this.resultTextView = (TextView)view.findViewById(R.id.result);
        return view;
    }

    @SuppressLint(value={"NewApi"})
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.shareButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent();
                intent.setAction("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", inviteMessage);
                ArrayList<Intent> targetedShareIntents = new ArrayList<Intent>();
                List resInfo = AppContactFragment.this.getActivity().getPackageManager().queryIntentActivities(intent, 0);
                if (!resInfo.isEmpty()) {
                    for (ResolveInfo resolveInfo : resInfo) {
                        String packageName = resolveInfo.activityInfo.packageName;
                        Intent targetedShareIntent = new Intent("android.intent.action.SEND");
                        targetedShareIntent.setType("text/plain").setAction("android.intent.action.SEND").putExtra("android.intent.extra.TEXT", inviteMessage).setPackage(packageName);
                        targetedShareIntents.add(targetedShareIntent);
                    }
                    Intent chooserIntent = Intent.createChooser((Intent)((Intent)targetedShareIntents.remove(0)), (CharSequence)"Share Via");
                    chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", targetedShareIntents.toArray(new Parcelable[0]));
                    AppContactFragment.this.startActivity(chooserIntent);
                }
            }
        });
        this.setListAdapter((ListAdapter)this.mAdapter);
        this.getListView().setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.getListView().setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int scrollState) {
                if (scrollState == 2) {
                    AppContactFragment.this.mImageLoader.setPauseWork(true);
                    Utils.toggleSoftKeyBoard((Activity)AppContactFragment.this.getActivity(), (boolean)true);
                } else {
                    AppContactFragment.this.mImageLoader.setPauseWork(false);
                }
            }

            public void onScroll(AbsListView absListView, int firstVisibleItem, int visibleItemCount, int totalItemsCount) {
                if (AppContactFragment.this.applozicSetting.isRegisteredUsersContactCall() && Utils.isInternetAvailable((Context)AppContactFragment.this.getContext())) {
                    if (totalItemsCount < AppContactFragment.this.previousTotalItemCount) {
                        AppContactFragment.this.currentPage = AppContactFragment.this.startingPageIndex;
                        AppContactFragment.this.previousTotalItemCount = totalItemsCount;
                        if (totalItemsCount == 0) {
                            AppContactFragment.this.loading = true;
                        }
                    }
                    if (AppContactFragment.this.loading && totalItemsCount > AppContactFragment.this.previousTotalItemCount) {
                        AppContactFragment.this.loading = false;
                        AppContactFragment.this.previousTotalItemCount = totalItemsCount;
                        AppContactFragment.this.currentPage++;
                    }
                    if (!AppContactFragment.this.loading && totalItemsCount - visibleItemCount <= firstVisibleItem + AppContactFragment.this.visibleThreshold && !MobiComKitPeopleActivity.isSearching) {
                        AppContactFragment.this.loading = true;
                        new DownloadNNumberOfUserAsync(AppContactFragment.this.applozicSetting.getTotalRegisteredUsers(), AppContactFragment.this.userPreference.getRegisteredUsersLastFetchTime(), null, null, true).execute(null);
                    }
                }
            }
        });
        if (this.mPreviouslySelectedSearchItem == 0) {
            this.getLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mOnContactSelectedListener = (OnContactsInteractionListener)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement OnContactsInteractionListener");
        }
    }

    public void onPause() {
        super.onPause();
        this.mImageLoader.setPauseWork(false);
    }

    public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
        Cursor cursor = this.mAdapter.getCursor();
        cursor.moveToPosition(position);
        Contact contact = new ContactDatabase(this.getContext()).getContact(cursor, "_id");
        this.mOnContactSelectedListener.onCustomContactSelected(contact);
    }

    @SuppressLint(value={"NewApi"})
    private void onSelectionCleared() {
        this.mOnContactSelectedListener.onSelectionCleared();
        this.getListView().clearChoices();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (!TextUtils.isEmpty((CharSequence)this.mSearchTerm)) {
            outState.putString("query", this.mSearchTerm);
        }
    }

    public boolean onQueryTextChange(String newText) {
        String newFilter;
        this.mSearchTerm = newFilter = !TextUtils.isEmpty((CharSequence)newText) ? newText : null;
        this.mAdapter.indexOfSearchQuery(newFilter);
        this.getLoaderManager().restartLoader(1, null, (LoaderManager.LoaderCallbacks)this);
        return true;
    }

    private int getListPreferredItemHeight() {
        TypedValue typedValue = new TypedValue();
        this.getActivity().getTheme().resolveAttribute(16842829, typedValue, true);
        DisplayMetrics metrics = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return (int)typedValue.getDimension(metrics);
    }

    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        ContactDatabase contactDatabase = new ContactDatabase(this.getContext());
        Loader loader = contactDatabase.getSearchCursorLoader(this.mSearchTerm, this.userIdArray);
        return loader;
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
        if (loader.getId() == 1) {
            this.mAdapter.swapCursor(data);
        }
    }

    public void onLoaderReset(Loader<Cursor> loader) {
        if (loader.getId() == 1) {
            this.mAdapter.swapCursor(null);
        }
    }

    public class DownloadNNumberOfUserAsync
    extends AsyncTask<Void, Integer, Long> {
        private Message message;
        private UserService userService;
        private ProgressDialog progressDialog;
        private String messageContent;
        private int nNumberOfUsers;
        private String[] userIdArray;
        private long timeToFetch;
        boolean callForRegistered;
        private RegisteredUsersApiResponse registeredUsersApiResponse;
        private Context context;

        public DownloadNNumberOfUserAsync(int nNumberOfUsers, Message message, String messageContent) {
            this.context = AppContactFragment.this.getContext();
            this.message = message;
            this.messageContent = messageContent;
            this.nNumberOfUsers = nNumberOfUsers;
            this.userService = UserService.getInstance((Context)this.context);
        }

        public DownloadNNumberOfUserAsync(int numberOfUsersToFetch, long timeToFetch, Message message, String messageContent, boolean callForRegistered) {
            this.context = AppContactFragment.this.getContext();
            this.callForRegistered = callForRegistered;
            this.message = message;
            this.messageContent = messageContent;
            this.nNumberOfUsers = numberOfUsersToFetch;
            this.timeToFetch = timeToFetch;
            this.userService = UserService.getInstance((Context)this.context);
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = ProgressDialog.show((Context)this.context, (CharSequence)"", (CharSequence)this.context.getString(R.string.applozic_contacts_loading_info), (boolean)true);
        }

        protected Long doInBackground(Void ... params) {
            if (this.callForRegistered) {
                this.registeredUsersApiResponse = this.userService.getRegisteredUsersList(Long.valueOf(this.timeToFetch), this.nNumberOfUsers);
            } else {
                this.userIdArray = this.userService.getOnlineUsers(this.nNumberOfUsers);
            }
            return null;
        }

        protected void onPostExecute(Long aLong) {
            super.onPostExecute((Object)aLong);
            if (this.progressDialog != null && this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
            if (!Utils.isInternetAvailable((Context)this.context)) {
                Toast toast = Toast.makeText((Context)this.context, (CharSequence)this.context.getString(R.string.applozic_contacts_loading_error), (int)0);
                toast.setGravity(17, 0, 0);
                toast.show();
            }
            if (this.registeredUsersApiResponse != null) {
                AppContactFragment.this.mAdapter.changeCursor(new ContactDatabase(this.context).loadContacts());
                AppContactFragment.this.mAdapter.notifyDataSetChanged();
            }
        }
    }

    private class ContactsAdapter
    extends CursorAdapter
    implements SectionIndexer {
        Context context;
        private LayoutInflater mInflater;
        private AlphabetIndexer mAlphabetIndexer;
        private TextAppearanceSpan highlightTextSpan;

        public ContactsAdapter(Context context) {
            super(context, null, 0);
            this.context = context;
            this.mInflater = LayoutInflater.from((Context)context);
            String alphabet = context.getString(R.string.alphabet);
            this.mAlphabetIndexer = new AlphabetIndexer(null, 1, (CharSequence)alphabet);
            this.highlightTextSpan = new TextAppearanceSpan((Context)AppContactFragment.this.getActivity(), R.style.searchTextHiglight);
        }

        private int indexOfSearchQuery(String displayName) {
            if (!TextUtils.isEmpty((CharSequence)AppContactFragment.this.mSearchTerm)) {
                return displayName.toLowerCase(Locale.getDefault()).indexOf(AppContactFragment.this.mSearchTerm.toLowerCase(Locale.getDefault()));
            }
            return -1;
        }

        public View newView(Context context, Cursor cursor, ViewGroup parent) {
            View itemLayout = this.mInflater.inflate(R.layout.contact_list_item, parent, false);
            ViewHolder holder = new ViewHolder();
            holder.text1 = (TextView)itemLayout.findViewById(R.id.text1);
            holder.text2 = (TextView)itemLayout.findViewById(R.id.text2);
            holder.icon = (CircleImageView)itemLayout.findViewById(R.id.contactImage);
            itemLayout.setTag((Object)holder);
            return itemLayout;
        }

        public void bindView(View view, Context context, Cursor cursor) {
            ViewHolder holder = (ViewHolder)view.getTag();
            Contact contact = new ContactDatabase(context).getContact(cursor, "_id");
            holder.text1.setText((CharSequence)(contact.getDisplayName() == null ? contact.getUserId() : contact.getDisplayName()));
            holder.text2.setText((CharSequence)contact.getUserId());
            if (contact.isDrawableResources()) {
                int drawableResourceId = context.getResources().getIdentifier(contact.getrDrawableName(), "drawable", context.getPackageName());
                holder.icon.setImageResource(drawableResourceId);
            } else {
                AppContactFragment.this.mImageLoader.loadImage((Object)contact, (ImageView)holder.icon);
            }
            int startIndex = this.indexOfSearchQuery(contact.getDisplayName());
            if (startIndex == -1) {
                holder.text1.setText((CharSequence)contact.getDisplayName());
                if (TextUtils.isEmpty((CharSequence)AppContactFragment.this.mSearchTerm)) {
                    holder.text2.setVisibility(8);
                } else {
                    holder.text2.setVisibility(0);
                }
            } else {
                SpannableString highlightedName = new SpannableString((CharSequence)contact.getDisplayName());
                highlightedName.setSpan((Object)this.highlightTextSpan, startIndex, startIndex + AppContactFragment.this.mSearchTerm.length(), 0);
                holder.text1.setText((CharSequence)highlightedName);
                holder.text2.setVisibility(8);
            }
        }

        public Cursor swapCursor(Cursor newCursor) {
            this.mAlphabetIndexer.setCursor(newCursor);
            return super.swapCursor(newCursor);
        }

        public int getCount() {
            if (this.getCursor() == null) {
                return 0;
            }
            return super.getCount();
        }

        public Object[] getSections() {
            return this.mAlphabetIndexer.getSections();
        }

        public int getPositionForSection(int i) {
            if (this.getCursor() == null) {
                return 0;
            }
            return this.mAlphabetIndexer.getPositionForSection(i);
        }

        public int getSectionForPosition(int i) {
            if (this.getCursor() == null) {
                return 0;
            }
            return this.mAlphabetIndexer.getSectionForPosition(i);
        }

        private class ViewHolder {
            TextView text1;
            TextView text2;
            CircleImageView icon;

            private ViewHolder() {
            }
        }
    }

    public static interface ContactsQuery {
        public static final int QUERY_ID = 1;
    }
}

